/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLHandledException;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLLoadEvent;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.functions.ArtifactVersionNameFunction;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public class LoadController {
    private Loader loader;
    private EventBus masterChannel;
    private ImmutableMap<String, EventBus> eventChannels;
    private LoaderState state;
    private Multimap<String, LoaderState.ModState> modStates = ArrayListMultimap.create();
    private Multimap<String, Throwable> errors = ArrayListMultimap.create();
    private List<ModContainer> activeModList = Lists.newArrayList();
    private ModContainer activeContainer;
    private BiMap<ModContainer, Object> modObjectList;
    private ListMultimap<String, ModContainer> packageOwners;
    private FMLSecurityManager accessibleManager = new FMLSecurityManager(this);

    public LoadController(Loader loader) {
        this.loader = loader;
        this.masterChannel = new EventBus("FMLMainChannel");
        this.masterChannel.register((Object)this);
        this.state = LoaderState.NOINIT;
        this.packageOwners = ArrayListMultimap.create();
    }

    void disableMod(ModContainer mod) {
        HashMap temporary = Maps.newHashMap(this.eventChannels);
        String modId = mod.getModId();
        EventBus bus = (EventBus)temporary.remove(modId);
        bus.post((Object)new FMLModDisabledEvent());
        if (this.errors.get((Object)modId).isEmpty()) {
            this.eventChannels = ImmutableMap.copyOf((Map)temporary);
            this.modStates.put((Object)modId, (Object)LoaderState.ModState.DISABLED);
            this.modObjectList.remove((Object)mod);
            this.activeModList.remove(mod);
        }
    }

    @Subscribe
    public void buildModList(FMLLoadEvent event) {
        ImmutableMap.Builder eventBus = ImmutableMap.builder();
        for (ModContainer mod : this.loader.getModList()) {
            EventBus bus;
            boolean isActive = mod.registerBus(bus = new EventBus(mod.getModId()), this);
            if (isActive) {
                this.activeModList.add(mod);
                this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
                eventBus.put((Object)mod.getModId(), (Object)bus);
                FMLCommonHandler.instance().addModToResourcePack(mod);
                continue;
            }
            FMLLog.log((String)mod.getModId(), (Level)Level.WARN, (String)"Mod %s has been disabled through configuration", (Object[])new Object[]{mod.getModId()});
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.DISABLED);
        }
        this.eventChannels = eventBus.build();
    }

    public void distributeStateMessage(LoaderState state, Object ... eventData) {
        if (state.hasEvent()) {
            this.masterChannel.post((Object)state.getEvent(eventData));
        }
    }

    public void transition(LoaderState desiredState, boolean forceState) {
        LoaderState oldState = this.state;
        this.state = this.state.transition(!this.errors.isEmpty());
        if (this.state != desiredState && !forceState) {
            Throwable toThrow = null;
            FMLLog.severe((String)"Fatal errors were detected during the transition from %s to %s. Loading cannot continue", (Object[])new Object[]{oldState, desiredState});
            StringBuilder sb = new StringBuilder();
            this.printModStates(sb);
            FMLLog.severe((String)"%s", (Object[])new Object[]{sb.toString()});
            if (this.errors.size() > 0) {
                FMLLog.severe((String)"The following problems were captured during this phase", (Object[])new Object[0]);
                for (Map.Entry error : this.errors.entries()) {
                    FMLLog.log((Level)Level.ERROR, (Throwable)((Throwable)error.getValue()), (String)"Caught exception from %s", (Object[])new Object[]{error.getKey()});
                    if (error.getValue() instanceof IFMLHandledException) {
                        toThrow = (Throwable)error.getValue();
                        continue;
                    }
                    if (toThrow != null) continue;
                    toThrow = (Throwable)error.getValue();
                }
            } else {
                FMLLog.severe((String)"The ForgeModLoader state engine has become corrupted. Probably, a state was missed by and invalid modification to a base classForgeModLoader depends on. This is a critical error and not recoverable. Investigate any modifications to base classes outside ofForgeModLoader, especially Optifine, to see if there are fixes available.", (Object[])new Object[0]);
                throw new RuntimeException("The ForgeModLoader state engine is invalid");
            }
            if (toThrow != null && toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            throw new LoaderException(toThrow);
        }
        if (this.state != desiredState && forceState) {
            FMLLog.info((String)"The state engine was in incorrect state %s and forced into state %s. Errors may have been discarded.", (Object[])new Object[]{this.state, desiredState});
            this.forceState(desiredState);
        }
    }

    public ModContainer activeContainer() {
        return this.activeContainer != null ? this.activeContainer : this.findActiveContainerFromStack();
    }

    @Subscribe
    public void propogateStateMessage(FMLEvent stateEvent) {
        if (stateEvent instanceof FMLPreInitializationEvent) {
            this.modObjectList = this.buildModObjectList();
        }
        for (ModContainer mc : this.activeModList) {
            this.sendEventToModContainer(stateEvent, mc);
        }
    }

    private void sendEventToModContainer(FMLEvent stateEvent, ModContainer mc) {
        String modId = mc.getModId();
        Collection requirements = Collections2.transform(mc.getRequirements(), (Function)new ArtifactVersionNameFunction());
        for (ArtifactVersion av : mc.getDependencies()) {
            if (av.getLabel() == null || !requirements.contains(av.getLabel()) || !this.modStates.containsEntry((Object)av.getLabel(), (Object)LoaderState.ModState.ERRORED)) continue;
            FMLLog.log((String)modId, (Level)Level.ERROR, (String)"Skipping event %s and marking errored mod %s since required dependency %s has errored", (Object[])new Object[]{stateEvent.getEventType(), modId, av.getLabel()});
            this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
            return;
        }
        this.activeContainer = mc;
        stateEvent.applyModContainer(this.activeContainer());
        ThreadContext.put((String)"mod", (String)modId);
        FMLLog.log((String)modId, (Level)Level.TRACE, (String)"Sending event %s to mod %s", (Object[])new Object[]{stateEvent.getEventType(), modId});
        ((EventBus)this.eventChannels.get((Object)modId)).post((Object)stateEvent);
        FMLLog.log((String)modId, (Level)Level.TRACE, (String)"Sent event %s to mod %s", (Object[])new Object[]{stateEvent.getEventType(), modId});
        ThreadContext.remove((String)"mod");
        this.activeContainer = null;
        if (stateEvent instanceof FMLStateEvent) {
            if (!this.errors.containsKey((Object)modId)) {
                this.modStates.put((Object)modId, (Object)((FMLStateEvent)stateEvent).getModState());
            } else {
                this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
            }
        }
    }

    public ImmutableBiMap<ModContainer, Object> buildModObjectList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModContainer mc : this.activeModList) {
            if (!mc.isImmutable() && mc.getMod() != null) {
                builder.put((Object)mc, mc.getMod());
                List<String> packages = mc.getOwnedPackages();
                for (String pkg : packages) {
                    this.packageOwners.put((Object)pkg, (Object)mc);
                }
            }
            if (mc.getMod() != null || mc.isImmutable() || this.state == LoaderState.CONSTRUCTING) continue;
            FMLLog.severe((String)"There is a severe problem with %s - it appears not to have constructed correctly", (Object[])new Object[]{mc.getModId()});
            if (this.state == LoaderState.CONSTRUCTING) continue;
            this.errorOccurred(mc, new RuntimeException());
        }
        return builder.build();
    }

    public void errorOccurred(ModContainer modContainer, Throwable exception) {
        if (exception instanceof InvocationTargetException) {
            this.errors.put((Object)modContainer.getModId(), (Object)((InvocationTargetException)exception).getCause());
        } else {
            this.errors.put((Object)modContainer.getModId(), (Object)exception);
        }
    }

    public void printModStates(StringBuilder ret) {
        for (ModContainer mc : this.loader.getModList()) {
            ret.append("\n\t").append(mc.getModId()).append("{").append(mc.getVersion()).append("} [").append(mc.getName()).append("] (").append(mc.getSource().getName()).append(") ");
            Joiner.on((String)"->").appendTo(ret, (Iterable)this.modStates.get((Object)mc.getModId()));
        }
    }

    public List<ModContainer> getActiveModList() {
        return this.activeModList;
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return (LoaderState.ModState)Iterables.getLast((Iterable)this.modStates.get((Object)selectedMod.getModId()), (Object)LoaderState.ModState.AVAILABLE);
    }

    public void distributeStateMessage(Class<?> customEvent) {
        try {
            this.masterChannel.post(customEvent.newInstance());
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An unexpected exception", (Object[])new Object[0]);
            throw new LoaderException((Throwable)e);
        }
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        if (this.modObjectList == null) {
            FMLLog.severe((String)"Detected an attempt by a mod %s to perform game activity during mod construction. This is a serious programming error.", (Object[])new Object[]{this.activeContainer});
            return this.buildModObjectList();
        }
        return ImmutableBiMap.copyOf(this.modObjectList);
    }

    public boolean isInState(LoaderState state) {
        return this.state == state;
    }

    boolean hasReachedState(LoaderState state) {
        return this.state.ordinal() >= state.ordinal() && this.state != LoaderState.ERRORED;
    }

    void forceState(LoaderState newState) {
        this.state = newState;
    }

    private ModContainer findActiveContainerFromStack() {
        for (Class<?> c : this.getCallingStack()) {
            String pkg;
            int idx = c.getName().lastIndexOf(46);
            if (idx == -1 || !this.packageOwners.containsKey((Object)(pkg = c.getName().substring(0, idx)))) continue;
            return (ModContainer)this.packageOwners.get((Object)pkg).get(0);
        }
        return null;
    }

    Class<?>[] getCallingStack() {
        return this.accessibleManager.getStackClasses();
    }
}

