/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.jfxgl.controls;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.Graphics;
import com.sun.prism.es2.JFXGLContext;
import com.sun.prism.es2.JFXGLContexts;
import com.sun.prism.es2.OffscreenBuffer;
import cuchaz.jfxgl.CalledByEventsThread;
import cuchaz.jfxgl.CalledByMainThread;
import cuchaz.jfxgl.GLState;
import cuchaz.jfxgl.InJavaFXGLContext;
import cuchaz.jfxgl.LWJGLDebug;
import javafx.animation.AnimationTimer;
import javafx.scene.layout.Background;
import javafx.scene.layout.StackPane;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.Callback;

public class OpenGLPane
extends StackPane {
    private Initializer initializer = null;
    private Resizer resizer = null;
    private Renderer renderer = null;
    private TKPulseListener listener = new TKPulseListener(){

        public void pulse() {
            OpenGLPane.this.impl_markDirty(DirtyBits.NODE_BOUNDS);
            OpenGLPane.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
        }
    };
    private AnimationTimer animation = new AnimationTimer(){

        public void handle(long l) {
        }
    };

    public OpenGLPane() {
        Toolkit.getToolkit().addSceneTkPulseListener(this.listener);
        this.animation.start();
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("style.css").toString());
        this.getStyleClass().add((Object)"openglpane");
    }

    public OpenGLNode impl_createPeer() {
        return new OpenGLNode(this);
    }

    public OpenGLNode impl_getPeer() {
        return (OpenGLNode)super.impl_getPeer();
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }

    public void setResizer(Resizer resizer) {
        this.resizer = resizer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    @CalledByMainThread
    public OffscreenBuffer getBuffer() {
        return this.impl_getPeer().buf;
    }

    public static interface Resizer {
        public void resize(JFXGLContext var1, int var2, int var3);
    }

    public static interface Renderer {
        public void render(JFXGLContext var1);
    }

    public static interface Initializer {
        public void init(JFXGLContext var1);
    }

    public static class OpenGLNode
    extends NGRegion {
        private final OpenGLPane pane;
        private JFXGLContext context;
        private Callback debugCallback;
        private OffscreenBuffer buf;
        private GLState glstate = new GLState(GLState.Blend, GLState.BlendFunc, GLState.ShaderProgram, GLState.ActiveTexture, GLState.Texture2D[0], GLState.VertexArray, GLState.ArrayBuffer, GLState.ElementArrayBuffer);

        @CalledByEventsThread
        public OpenGLNode(OpenGLPane openGLPane) {
            this.pane = openGLPane;
            this.context = null;
            this.updateBackground(Background.EMPTY);
        }

        @CalledByEventsThread
        public void release() {
            super.release();
            Toolkit.getToolkit().addRenderJob(new RenderJob(() -> {
                if (this.buf != null) {
                    this.buf.cleanup();
                    this.buf = null;
                }
                if (this.debugCallback != null) {
                    this.debugCallback.free();
                    this.debugCallback = null;
                }
                JFXGLContexts.cleanupPane(this);
            }));
        }

        protected boolean hasVisuals() {
            return true;
        }

        @InJavaFXGLContext
        @CalledByMainThread
        protected void renderContent(Graphics graphics) {
            BaseBounds baseBounds = this.getCompleteBounds((BaseBounds)new RectBounds(), graphics.getTransformNoClone());
            if (graphics.getClipRectNoClone() != null) {
                baseBounds.intersectWith(graphics.getClipRectNoClone());
            }
            int n = (int)baseBounds.getWidth();
            int n2 = (int)baseBounds.getHeight();
            if (this.context == null) {
                this.context = JFXGLContexts.makeNewPane(this);
            }
            if (this.debugCallback == null) {
                this.debugCallback = LWJGLDebug.enableDebugging();
            }
            if (this.pane.initializer != null) {
                this.context.makeCurrent();
                this.context.updateViewportAndDepthTest(0, 0, n, n2, false);
                this.pane.initializer.init(this.context);
                JFXGLContexts.javafx.makeCurrent();
                this.pane.initializer = null;
            }
            if (this.pane.renderer != null && n > 0 && n2 > 0) {
                boolean bl;
                int n3 = (int)baseBounds.getMinX();
                int n4 = (int)baseBounds.getMinY();
                int n5 = graphics.getRenderTarget().getContentWidth();
                int n6 = graphics.getRenderTarget().getContentHeight();
                n4 = n6 - n4 - n2;
                graphics.clearQuad((float)n3, (float)n4, (float)(n3 + n5), (float)(n4 + n6));
                this.context.makeCurrent();
                if (this.buf == null) {
                    this.buf = new OffscreenBuffer(this.context, n, n2);
                    bl = true;
                } else {
                    bl = this.buf.resize(n, n2);
                }
                if (bl && this.pane.resizer != null) {
                    this.pane.resizer.resize(this.context, n, n2);
                }
                this.buf.bind();
                this.pane.renderer.render(this.context);
                JFXGLContexts.javafx.makeCurrent();
                this.glstate.backup();
                GL11.glDisable((int)3042);
                boolean bl2 = true;
                this.buf.render(n3, n4, n5, n6, bl2);
                this.glstate.restore();
            }
            super.renderContent(graphics);
        }
    }
}

