/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.jfxgl;

import com.sun.prism.es2.OffscreenBuffer;
import cuchaz.jfxgl.GLState;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL45;

public class TexTools {
    private static File makeTga(String string) {
        return new File(string + ".tga");
    }

    public static int getFramebufTexId() {
        return TexTools.getFramebufTexId(0);
    }

    public static int getFramebufTexId(int n) {
        int n2 = GL11.glGetInteger((int)(34853 + n));
        if (n2 == 0) {
            throw new Error("framebuffer has no attachment at " + n);
        }
        int n3 = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)n2, (int)36048);
        if (n3 == 0) {
            throw new Error("can't query framebuffer, attachment is GL_NONE");
        }
        if (n3 == 33304) {
            throw new Error("can't query framebuffer, attachment is GL_FRAMEBUFFER_DEFAULT");
        }
        if (n3 == 36161) {
            throw new Error("can't query framebuffer, attachment is GL_RENDERBUFFER");
        }
        if (n3 != 5890) {
            throw new Error(String.format("unknown framebuffer attachment type: 0x%x", n3));
        }
        return GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)n2, (int)36049);
    }

    public static void dumpFramebuf(String string) {
        TexTools.dumpFramebuf(TexTools.makeTga(string));
    }

    public static void dumpFramebuf(File file) {
        TexTools.dumpTexture(TexTools.getFramebufTexId(), file);
    }

    public static void dumpTexture(int n, String string) {
        TexTools.dumpTexture(n, TexTools.makeTga(string));
    }

    public static void dumpTexture(int n, int n2, int n3, String string) {
        TexTools.dumpTexture(n, n2, n3, TexTools.makeTga(string));
    }

    public static void dumpTexture(int n, File file) {
        int n2 = GL45.glGetTextureLevelParameteri((int)n, (int)0, (int)4096);
        int n3 = GL45.glGetTextureLevelParameteri((int)n, (int)0, (int)4097);
        TexTools.dumpTexture(n, n2, n3, file);
    }

    public static void dumpTexture(int n, int n2, int n3, File file) {
        int n4 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * n3 * n4);
        GLState gLState = new GLState(GLState.ActiveTexture, GLState.Texture2D[0]);
        gLState.backup();
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)n);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
        gLState.restore();
        for (int i = 0; i < byteBuffer.capacity(); i += 4) {
            byteBuffer.position(i);
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            byte by3 = byteBuffer.get();
            byte by4 = byteBuffer.get();
            byteBuffer.position(i);
            byteBuffer.put(by3);
            byteBuffer.put(by2);
            byteBuffer.put(by);
            byteBuffer.put(by4);
        }
        byteBuffer.flip();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(new byte[]{0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, (byte)(n2 % 256), (byte)(n2 / 256), (byte)(n3 % 256), (byte)(n3 / 256), (byte)(n4 * 8), 0});
            Channels.newChannel(fileOutputStream).write(byteBuffer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        System.out.println("Wrote texture " + n + " to " + file.getAbsolutePath());
    }

    public static void dumpBuffer(OffscreenBuffer offscreenBuffer, String string) {
        TexTools.dumpTexture(offscreenBuffer.getTexId(), offscreenBuffer.getWidth(), offscreenBuffer.getHeight(), string);
    }

    public static void dumpBuffer(OffscreenBuffer offscreenBuffer, File file) {
        TexTools.dumpTexture(offscreenBuffer.getTexId(), offscreenBuffer.getWidth(), offscreenBuffer.getHeight(), file);
    }
}

