/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.jfxgl;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;

public class LWJGLDebug {
    public static PrintStream stream = APIUtil.DEBUG_STREAM;
    public static Integer[] exceptionSeverities = new Integer[]{37190};
    public static Integer[] reportSeverities = new Integer[]{37190, 37191, 37192};

    public static boolean isDebuggingSupported() {
        int n = GL11.glGetInteger((int)33307);
        if (n < 4) {
            return false;
        }
        if (n > 4) {
            return true;
        }
        int n2 = GL11.glGetInteger((int)33308);
        return n2 >= 3;
    }

    public static Callback enableDebugging() {
        if (!LWJGLDebug.isDebuggingSupported()) {
            return new Callback(0L){

                public void free() {
                }
            };
        }
        PrintStream printStream = stream;
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(exceptionSeverities));
        HashSet<Integer> hashSet2 = new HashSet<Integer>(Arrays.asList(reportSeverities));
        GLDebugMessageCallback gLDebugMessageCallback = GLDebugMessageCallback.create((n, n2, n3, n4, n5, l, l2) -> {
            if (!hashSet2.contains(n4)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("OpenGL Debug Message:\n");
            stringBuilder.append(String.format("\tID:        0x%X\n", n3));
            stringBuilder.append(String.format("\tSource:    %s\n", LWJGLDebug.getDebugSource(n)));
            stringBuilder.append(String.format("\tType:      %s\n", LWJGLDebug.getDebugType(n2)));
            stringBuilder.append(String.format("\tSeverity:  %s\n", LWJGLDebug.getDebugSeverity(n4)));
            stringBuilder.append(String.format("\tMessage:   %s\n", GLDebugMessageCallback.getMessage((int)n5, (long)l)));
            boolean bl = hashSet.contains(n4);
            if (bl) {
                throw new RuntimeException(stringBuilder.toString());
            }
            printStream.print(stringBuilder.toString());
        });
        GLCapabilities gLCapabilities = GL.getCapabilities();
        if (gLCapabilities.GL_KHR_debug) {
            GL11.glEnable((int)33346);
        }
        GL43.glDebugMessageCallback((GLDebugMessageCallbackI)gLDebugMessageCallback, (long)0L);
        GL11.glEnable((int)37600);
        return gLDebugMessageCallback;
    }

    public static String getDebugSource(int n) {
        switch (n) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return "(unknown: " + n + ")";
    }

    public static String getDebugType(int n) {
        switch (n) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return "(unknown: " + n + ")";
    }

    public static String getDebugSeverity(int n) {
        switch (n) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
            case 33387: {
                return "NOTIFICATION";
            }
        }
        return "(unknown: " + n + ")";
    }

    public static void trace(String string) {
        int n = 0;
        GL43.glDebugMessageInsert((int)33354, (int)33384, (int)n, (int)33387, (CharSequence)string);
    }
}

