/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.JFXGLContext;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;

public class TexturedQuad {
    private final Shader shader;
    private final int vaoId;
    private final int vboId;
    private final int iboId;
    public int texId;

    public TexturedQuad(int n, int n2, int n3, int n4, int n5, Shader shader) {
        this.shader = shader;
        this.texId = n5;
        this.vaoId = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vaoId);
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.bytes(new byte[]{0, 1, 2, 0, 2, 3});
            this.iboId = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34963, (int)this.iboId);
            GL15.glBufferData((int)34963, (ByteBuffer)byteBuffer, (int)35044);
            FloatBuffer floatBuffer = memoryStack.floats(new float[]{n + 0, n2 + 0, 0.0f, 0.0f, n + n3, n2 + 0, 1.0f, 0.0f, n + n3, n2 + n4, 1.0f, 1.0f, n + 0, n2 + n4, 0.0f, 1.0f});
            this.vboId = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)this.vboId);
            GL15.glBufferData((int)34962, (FloatBuffer)floatBuffer, (int)35044);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)16, (long)0L);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)16, (long)8L);
        }
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
    }

    public void render() {
        this.shader.bind();
        GL30.glBindVertexArray((int)this.vaoId);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.texId);
        GL11.glDrawElements((int)4, (int)6, (int)5121, (long)0L);
        GL30.glBindVertexArray((int)0);
        GL11.glBindTexture((int)3553, (int)0);
    }

    public void cleanup() {
        GL30.glDeleteVertexArrays((int)this.vaoId);
        GL15.glDeleteBuffers((int)this.vboId);
        GL15.glDeleteBuffers((int)this.iboId);
    }

    public static class Shader {
        private final JFXGLContext context;
        private final int id;
        private final int vertexId;
        private final int fragmentId;
        public final int posLoc;
        public final int texCoordLoc;
        private final int viewSizeLoc;
        private final int viewPosLoc;
        private final int yflipLoc;

        public Shader(JFXGLContext jFXGLContext) {
            this(jFXGLContext, Shader.class.getResource("vertex.glsl"), Shader.class.getResource("fragment.glsl"));
        }

        public Shader(JFXGLContext jFXGLContext, URL uRL, URL uRL2) {
            this.context = jFXGLContext;
            this.vertexId = jFXGLContext.compileShader(uRL, true);
            this.fragmentId = jFXGLContext.compileShader(uRL2, false);
            this.posLoc = 0;
            this.texCoordLoc = 1;
            this.id = jFXGLContext.createProgram(this.vertexId, new int[]{this.fragmentId}, new String[]{"inPos", "inTexCoord"}, new int[]{this.posLoc, this.texCoordLoc});
            this.viewSizeLoc = jFXGLContext.getUniformLocation(this.id, "viewSize");
            this.viewPosLoc = jFXGLContext.getUniformLocation(this.id, "viewPos");
            this.yflipLoc = jFXGLContext.getUniformLocation(this.id, "yflip");
        }

        public void setViewPos(int n, int n2) {
            this.context.uniform2f(this.viewPosLoc, n, n2);
        }

        public void setViewSize(int n, int n2) {
            this.context.uniform2f(this.viewSizeLoc, n, n2);
        }

        public void setYFlip(boolean bl) {
            this.context.uniform1i(this.yflipLoc, bl ? 1 : 0);
        }

        public void bind() {
            this.context.setShaderProgram(this.id);
        }

        public void cleanup() {
            this.context.deleteShader(this.vertexId);
            this.context.deleteShader(this.fragmentId);
            this.context.deleteProgram(this.id);
        }
    }
}

