/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.jfxgl;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.jfxgl.JFXGLMainWindow;
import com.sun.glass.ui.jfxgl.JFXGLView;
import com.sun.glass.ui.jfxgl.JFXGLWindow;
import com.sun.prism.es2.JFXGLContext;
import com.sun.prism.es2.JFXGLContexts;
import com.sun.prism.es2.OffscreenBuffer;
import cuchaz.jfxgl.CalledByEventsThread;
import cuchaz.jfxgl.CalledByMainThread;
import cuchaz.jfxgl.GLState;
import cuchaz.jfxgl.InAppGLContext;
import cuchaz.jfxgl.InJavaFXGLContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class JFXGLPopupWindow
extends JFXGLWindow {
    public static List<JFXGLPopupWindow> windows = Collections.synchronizedList(new ArrayList());
    private JFXGLContext context = null;
    private JFXGLView view = null;
    private int renderX = 0;
    private int renderY = 0;
    private int width = 0;
    private int height = 0;
    private OffscreenBuffer buf = null;
    private GLState glstate = new GLState(GLState.Blend, GLState.BlendFunc, GLState.ShaderProgram, GLState.ActiveTexture, GLState.Texture2D[0], GLState.VertexArray, GLState.ArrayBuffer, GLState.ElementArrayBuffer, GLState.Viewport);

    protected JFXGLPopupWindow(Window window, Screen screen, int n) {
        super(window, screen, n, JFXGLWindow.Implementation.Ignore);
        this.context = JFXGLContexts.app;
        windows.add(this);
    }

    @CalledByEventsThread
    protected long _createWindow(long l, long l2, int n) {
        return JFXGLContexts.app.hwnd;
    }

    @Override
    @CalledByEventsThread
    protected boolean _setView(long l, View view) {
        this.view = (JFXGLView)view;
        return true;
    }

    @CalledByMainThread
    public JFXGLView getRenderView() {
        return this.view;
    }

    @CalledByEventsThread
    protected boolean _close(long l) {
        windows.remove((Object)this);
        this.notifyDestroy();
        return false;
    }

    @Override
    protected void _setBounds(long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f, float f2) {
        if (bl) {
            this.renderX = n - JFXGLMainWindow.instance.getX();
        }
        if (bl2) {
            this.renderY = n2 - JFXGLMainWindow.instance.getY();
        }
        if (n3 > 0) {
            this.width = n3;
        } else if (n5 > 0) {
            this.width = n5;
        }
        if (n4 > 0) {
            this.height = n4;
        } else if (n6 > 0) {
            this.height = n6;
        }
        this.notifyResize(511, this.width, this.height);
        if (this.view != null) {
            this.view.notifyResize(this.width, this.height);
        }
    }

    public int getRenderX() {
        return this.renderX;
    }

    public int getRenderY() {
        return this.renderY;
    }

    public int getRenderWidth() {
        return this.width;
    }

    public int getRenderHeight() {
        return this.height;
    }

    @Override
    @CalledByMainThread
    @InJavaFXGLContext
    public void renderBegin() {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        if (this.buf == null) {
            this.buf = new OffscreenBuffer(this.context, this.width, this.height);
        } else {
            this.buf.resize(this.width, this.height);
        }
    }

    @Override
    @CalledByMainThread
    @InJavaFXGLContext
    public void renderEnd() {
    }

    @Override
    @CalledByMainThread
    public int getFBOId() {
        if (this.buf != null) {
            return this.buf.getFboId();
        }
        return 0;
    }

    @CalledByMainThread
    @InAppGLContext
    public void renderFramebuf(int n, int n2) {
        if (this.buf != null) {
            this.glstate.backup();
            int n3 = this.renderX;
            int n4 = n2 - this.height - this.renderY;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glViewport((int)n3, (int)n4, (int)this.width, (int)this.height);
            this.buf.render(0, 0, this.width, this.height, false);
            this.glstate.restore();
        }
    }

    @Override
    public OffscreenBuffer getBuffer() {
        return this.buf;
    }
}

