/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.jfxgl;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.JFXGLScreen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.jfxgl.JFXGLView;
import com.sun.glass.ui.jfxgl.JFXGLWindow;
import com.sun.javafx.tk.quantum.JFXGLToolkit;
import com.sun.prism.es2.JFXGLContext;
import com.sun.prism.es2.JFXGLContexts;
import com.sun.prism.es2.OffscreenBuffer;
import cuchaz.jfxgl.CalledByEventsThread;
import cuchaz.jfxgl.CalledByMainThread;
import cuchaz.jfxgl.GLState;
import cuchaz.jfxgl.InAppGLContext;
import cuchaz.jfxgl.InJavaFXGLContext;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

public class JFXGLMainWindow
extends JFXGLWindow {
    public static JFXGLMainWindow instance = null;
    private JFXGLContext context = null;
    private JFXGLView view = null;
    private GLFWWindowSizeCallbackI windowSizeCallback = null;
    private GLFWWindowSizeCallbackI existingWindowSizeCallback = null;
    private GLFWWindowPosCallbackI windowPosCallback = null;
    private GLFWWindowPosCallbackI existingWindowPosCallback = null;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private OffscreenBuffer buf = null;
    private boolean fboDirty = true;
    private GLState glstate = new GLState(GLState.Blend, GLState.BlendFunc, GLState.ShaderProgram, GLState.ActiveTexture, GLState.Texture2D[0], GLState.VertexArray, GLState.ArrayBuffer, GLState.ElementArrayBuffer, GLState.Viewport);
    long hcursor = 0L;

    protected JFXGLMainWindow(Window window, Screen screen, int n3) {
        super(window, screen, n3, JFXGLWindow.Implementation.Throw);
        if (instance != null) {
            throw new IllegalStateException("can't create more than one window");
        }
        instance = this;
        this.context = JFXGLContexts.app;
        this.windowSizeCallback = (l, n, n2) -> {
            if (n != this.width || n2 != this.height) {
                this.width = n;
                this.height = n2;
                this.fboDirty = true;
            }
            JFXGLToolkit.runLater(() -> {
                this.notifyResize(511, n, n2);
                if (this.view != null) {
                    this.view.notifyResize(this.width, this.height);
                }
            });
            JFXGLScreen.update(this.x, this.y, this.width, this.height);
            if (this.existingWindowSizeCallback != null) {
                this.existingWindowSizeCallback.invoke(l, n, n2);
            }
        };
        this.existingWindowSizeCallback = GLFW.glfwSetWindowSizeCallback((long)this.context.hwnd, (GLFWWindowSizeCallbackI)this.windowSizeCallback);
        this.windowPosCallback = (l, n, n2) -> {
            JFXGLToolkit.runLater(() -> this.notifyMove(n, n2));
            if (this.view != null) {
                this.view.setScreenPos(n, n2);
            }
            this.x = n;
            this.y = n2;
            JFXGLScreen.update(this.x, this.y, this.width, this.height);
            if (this.existingWindowPosCallback != null) {
                this.existingWindowPosCallback.invoke(l, n, n2);
            }
        };
        this.existingWindowPosCallback = GLFW.glfwSetWindowPosCallback((long)this.context.hwnd, (GLFWWindowPosCallbackI)this.windowPosCallback);
    }

    @CalledByEventsThread
    protected long _createWindow(long l, long l2, int n) {
        return JFXGLContexts.app.hwnd;
    }

    protected boolean _close(long l) {
        this.notifyDestroy();
        return false;
    }

    @Override
    @CalledByEventsThread
    protected boolean _setView(long l, View view) {
        this.view = (JFXGLView)view;
        if (this.view != null) {
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                IntBuffer intBuffer = memoryStack.callocInt(1);
                IntBuffer intBuffer2 = memoryStack.callocInt(1);
                GLFW.glfwGetWindowSize((long)this.context.hwnd, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
                this.width = intBuffer.get(0);
                this.height = intBuffer2.get(0);
                GLFW.glfwGetWindowPos((long)this.context.hwnd, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
                this.x = intBuffer.get(0);
                this.y = intBuffer2.get(0);
            }
            JFXGLToolkit.runLater(() -> {
                this.notifyResize(511, this.width, this.height);
                this.view.notifyResize(this.width, this.height);
                this.view.setScreenPos(this.x, this.y);
                this.notifyMove(this.x, this.y);
            });
            JFXGLScreen.update(this.x, this.y, this.width, this.height);
        }
        return true;
    }

    @Override
    @CalledByMainThread
    @InJavaFXGLContext
    public void renderBegin() {
        if (this.buf == null) {
            this.buf = new OffscreenBuffer(this.context, this.width, this.height);
        }
        if (this.fboDirty) {
            this.fboDirty = false;
            this.buf.resize(this.width, this.height);
        }
    }

    @Override
    @CalledByMainThread
    @InJavaFXGLContext
    public void renderEnd() {
    }

    @Override
    @CalledByMainThread
    public int getFBOId() {
        if (this.buf != null) {
            return this.buf.getFboId();
        }
        return 0;
    }

    @CalledByMainThread
    @InAppGLContext
    public void renderFramebuf() {
        if (this.buf != null) {
            this.glstate.backup();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            this.buf.render();
            this.glstate.restore();
        }
    }

    @Override
    public OffscreenBuffer getBuffer() {
        return this.buf;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    protected boolean _minimize(long l, boolean bl) {
        return false;
    }

    @Override
    protected boolean _maximize(long l, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    protected void _setBounds(long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f, float f2) {
    }

    @Override
    protected boolean _setVisible(long l, boolean bl) {
        return bl;
    }

    @Override
    protected boolean _setResizable(long l, boolean bl) {
        return false;
    }

    public void handleGLFWFocus(boolean bl) {
        this.notifyFocus(bl ? 542 : 541);
    }

    @Override
    protected boolean _requestFocus(long l, int n) {
        return true;
    }

    @Override
    protected void _setFocusable(long l, boolean bl) {
    }

    @Override
    protected boolean _grabFocus(long l) {
        return true;
    }

    @Override
    protected void _ungrabFocus(long l) {
    }

    @Override
    protected boolean _setTitle(long l, String string) {
        return false;
    }

    @Override
    protected void _setLevel(long l, int n) {
    }

    @Override
    protected void _setAlpha(long l, float f) {
    }

    @Override
    protected boolean _setBackground(long l, float f, float f2, float f3) {
        return false;
    }

    @Override
    protected void _setEnabled(long l, boolean bl) {
    }

    @Override
    protected boolean _setMinimumSize(long l, int n, int n2) {
        return false;
    }

    @Override
    protected boolean _setMaximumSize(long l, int n, int n2) {
        return false;
    }

    @Override
    protected void _setIcon(long l, Pixels pixels) {
    }

    @Override
    protected void _setCursor(long l, Cursor cursor) {
        if (this.hcursor != 0L) {
            GLFW.glfwDestroyCursor((long)this.hcursor);
            this.hcursor = 0L;
        }
        this.hcursor = GLFW.glfwCreateStandardCursor((int)this.translateCursor(cursor));
        GLFW.glfwSetCursor((long)l, (long)this.hcursor);
    }

    private int translateCursor(Cursor cursor) {
        switch (cursor.getType()) {
            case -1: {
                return 221185;
            }
            case 0: {
                return 221185;
            }
            case 1: {
                return 221185;
            }
            case 2: {
                return 221186;
            }
            case 3: {
                return 221187;
            }
            case 4: {
                return 221188;
            }
            case 5: {
                return 221188;
            }
            case 6: {
                return 221188;
            }
            case 7: {
                return 221189;
            }
            case 8: {
                return 221189;
            }
            case 9: {
                return 221190;
            }
            case 10: {
                return 221190;
            }
            case 11: {
                return 221189;
            }
            case 12: {
                return 221190;
            }
            case 13: {
                return 221185;
            }
            case 14: {
                return 221185;
            }
            case 15: {
                return 221185;
            }
            case 16: {
                return 221185;
            }
            case 17: {
                return 221185;
            }
            case 18: {
                return 221185;
            }
            case 19: {
                return 221185;
            }
        }
        return 221185;
    }

    @Override
    protected void _toFront(long l) {
    }

    @Override
    protected void _toBack(long l) {
    }

    @Override
    protected void _enterModal(long l) {
    }

    @Override
    protected void _enterModalWithWindow(long l, long l2) {
    }

    @Override
    protected void _exitModal(long l) {
    }
}

