/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.jfxgl;

import com.sun.glass.ui.jfxgl.JFXGLPlatformFactory;
import com.sun.glass.ui.jfxgl.JFXGLView;
import com.sun.glass.ui.jfxgl.JFXGLWindow;
import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.JFXGLToolkit;
import com.sun.prism.es2.JFXGLContext;
import com.sun.prism.es2.JFXGLContexts;
import com.sun.prism.es2.JFXGLFactory;
import cuchaz.jfxgl.EventsThreadNotRunningException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import javafx.stage.Stage;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharModsCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.opengl.GL11;

public class JFXGL {
    private static JFXGLToolkit toolkit;
    private static Application app;
    private static PlatformImpl.FinishListener finishListener;
    private static GLFWCallbacks ourCallbacks;
    private static GLFWCallbacks existingCallbacks;

    private JFXGL() {
    }

    public static JFXGLContext start(long l, String[] stringArray, Application application) {
        JFXGLContexts.app = JFXGLContext.wrapExisting(l);
        GLFW.glfwDefaultWindowHints();
        JFXGLContexts.javafx = JFXGLContext.makeNewSharedWith(JFXGLContexts.app.hwnd);
        JFXGLContexts.javafx.makeCurrent();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        System.setProperty("prism.order", "es2");
        JFXGLPlatformFactory.install();
        JFXGLFactory.install();
        JFXGLToolkit.install();
        try {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            PlatformImpl.startup(() -> countDownLatch.countDown());
            countDownLatch.await();
            toolkit = (JFXGLToolkit)Toolkit.getToolkit();
        }
        catch (InterruptedException interruptedException) {
            throw new Error(interruptedException);
        }
        JFXGLContexts.app.makeCurrent();
        ParametersImpl.registerParameters((Application)application, (Application.Parameters)new ParametersImpl(stringArray));
        PlatformImpl.setApplicationName(application.getClass());
        try {
            application.init();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        JFXGL.runOnEventsThreadAndWait(() -> {
            Stage stage = new Stage();
            stage.impl_setPrimary(true);
            application.start(stage);
            stage.show();
        });
        app = application;
        ourCallbacks = new GLFWCallbacks();
        existingCallbacks = new GLFWCallbacks();
        JFXGL.ourCallbacks.key = (l2, n, n2, n3, n4) -> {
            if (JFXGL.existingCallbacks.key != null) {
                JFXGL.existingCallbacks.key.invoke(l, n, n2, n3, n4);
            }
            if (JFXGLWindow.mainWindow != null) {
                JFXGL.runOnEventsThread(() -> {
                    JFXGLView jFXGLView = (JFXGLView)JFXGLWindow.mainWindow.getView();
                    if (jFXGLView != null) {
                        jFXGLView.handleGLFWKey(n, n2, n3, n4);
                    }
                });
            }
        };
        JFXGL.existingCallbacks.key = GLFW.glfwSetKeyCallback((long)l, (GLFWKeyCallbackI)JFXGL.ourCallbacks.key);
        JFXGL.ourCallbacks.keyChar = (l2, n, n2) -> {
            if (JFXGL.existingCallbacks.keyChar != null) {
                JFXGL.existingCallbacks.keyChar.invoke(l, n, n2);
            }
            if (JFXGLWindow.mainWindow != null) {
                JFXGL.runOnEventsThread(() -> {
                    JFXGLView jFXGLView = (JFXGLView)JFXGLWindow.mainWindow.getView();
                    if (jFXGLView != null) {
                        jFXGLView.handleGLFWKeyChar(n, n2);
                    }
                });
            }
        };
        JFXGL.existingCallbacks.keyChar = GLFW.glfwSetCharModsCallback((long)l, (GLFWCharModsCallbackI)JFXGL.ourCallbacks.keyChar);
        JFXGL.ourCallbacks.cursorPos = (l2, d, d2) -> {
            if (JFXGL.existingCallbacks.cursorPos != null) {
                JFXGL.existingCallbacks.cursorPos.invoke(l, d, d2);
            }
            if (JFXGLWindow.mainWindow != null) {
                JFXGL.runOnEventsThread(() -> {
                    JFXGLView jFXGLView = (JFXGLView)JFXGLWindow.mainWindow.getView();
                    if (jFXGLView != null) {
                        jFXGLView.handleGLFWCursorPos(d, d2);
                    }
                });
            }
        };
        JFXGL.existingCallbacks.cursorPos = GLFW.glfwSetCursorPosCallback((long)l, (GLFWCursorPosCallbackI)JFXGL.ourCallbacks.cursorPos);
        JFXGL.ourCallbacks.mouseButton = (l2, n, n2, n3) -> {
            if (JFXGL.existingCallbacks.mouseButton != null) {
                JFXGL.existingCallbacks.mouseButton.invoke(l, n, n2, n3);
            }
            if (JFXGLWindow.mainWindow != null) {
                JFXGL.runOnEventsThread(() -> {
                    JFXGLView jFXGLView = (JFXGLView)JFXGLWindow.mainWindow.getView();
                    if (jFXGLView != null) {
                        jFXGLView.handleGLFWMouseButton(n, n2, n3);
                    }
                });
            }
        };
        JFXGL.existingCallbacks.mouseButton = GLFW.glfwSetMouseButtonCallback((long)l, (GLFWMouseButtonCallbackI)JFXGL.ourCallbacks.mouseButton);
        JFXGL.ourCallbacks.scroll = (l2, d, d2) -> {
            if (JFXGL.existingCallbacks.scroll != null) {
                JFXGL.existingCallbacks.scroll.invoke(l, d, d2);
            }
            if (JFXGLWindow.mainWindow != null) {
                JFXGL.runOnEventsThread(() -> {
                    JFXGLView jFXGLView = (JFXGLView)JFXGLWindow.mainWindow.getView();
                    if (jFXGLView != null) {
                        jFXGLView.handleGLFWScroll(d, d2);
                    }
                });
            }
        };
        JFXGL.existingCallbacks.scroll = GLFW.glfwSetScrollCallback((long)l, (GLFWScrollCallbackI)JFXGL.ourCallbacks.scroll);
        JFXGL.ourCallbacks.windowFocus = (l2, bl) -> {
            if (JFXGL.existingCallbacks.windowFocus != null) {
                JFXGL.existingCallbacks.windowFocus.invoke(l, bl);
            }
            if (JFXGLWindow.mainWindow != null) {
                JFXGL.runOnEventsThread(() -> JFXGLWindow.mainWindow.handleGLFWFocus(bl));
            }
        };
        JFXGL.existingCallbacks.windowFocus = GLFW.glfwSetWindowFocusCallback((long)l, (GLFWWindowFocusCallbackI)JFXGL.ourCallbacks.windowFocus);
        return JFXGLContexts.app;
    }

    public static void runOnEventsThread(CheckedRunnable checkedRunnable) {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        JFXGLToolkit.runLater(() -> {
            try {
                checkedRunnable.run();
            }
            catch (Throwable throwable) {
                atomicReference.set(throwable);
            }
        });
        Throwable throwable = atomicReference.get();
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
    }

    public static void runOnEventsThreadAndWait(CheckedRunnable checkedRunnable) {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        JFXGLToolkit.runAndWait(() -> {
            try {
                checkedRunnable.run();
            }
            catch (Throwable throwable) {
                atomicReference.set(throwable);
            }
        });
        Throwable throwable = atomicReference.get();
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
    }

    public static boolean runOnEventsThreadAndWait(CheckedRunnable checkedRunnable, int n, TimeUnit timeUnit) {
        boolean bl;
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        JFXGLToolkit.runLater(() -> {
            try {
                checkedRunnable.run();
                countDownLatch.countDown();
            }
            catch (Throwable throwable) {
                atomicReference.set(throwable);
            }
        });
        try {
            bl = countDownLatch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        Throwable throwable = atomicReference.get();
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
        return bl;
    }

    public static void render() {
        toolkit.postPulse();
        toolkit.render();
    }

    public static void terminate() {
        boolean bl;
        try {
            bl = JFXGL.runOnEventsThreadAndWait(() -> {}, 5, TimeUnit.SECONDS);
        }
        catch (EventsThreadNotRunningException eventsThreadNotRunningException) {
            bl = false;
        }
        if (!bl) {
            System.out.println("WARNING: JavaFX events thread not responding in a timely manner. Some event must have jammed it.");
        }
        try {
            if (app != null && bl) {
                JFXGL.runOnEventsThreadAndWait(() -> app.stop());
            }
        }
        finally {
            PlatformImpl.removeListener((PlatformImpl.FinishListener)finishListener);
            if (bl) {
                PlatformImpl.tkExit();
            }
            if (toolkit != null) {
                toolkit.disposePipeline();
            }
            JFXGLContexts.cleanup();
        }
    }

    public static void renderLoop() {
        long l = JFXGLContexts.app.hwnd;
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        while (!GLFW.glfwWindowShouldClose((long)l)) {
            GL11.glClear((int)16384);
            JFXGL.render();
            GLFW.glfwSwapBuffers((long)l);
            GLFW.glfwPollEvents();
        }
    }

    private static class GLFWCallbacks {
        public GLFWKeyCallbackI key = null;
        public GLFWCharModsCallbackI keyChar = null;
        public GLFWCursorPosCallbackI cursorPos = null;
        public GLFWMouseButtonCallbackI mouseButton = null;
        public GLFWScrollCallbackI scroll = null;
        public GLFWWindowFocusCallbackI windowFocus = null;

        private GLFWCallbacks() {
        }
    }

    public static interface CheckedRunnable {
        public void run() throws Exception;
    }
}

