/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.jfxgl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;

public class GLState {
    public static final Part.Flag Blend = new Part.Flag(3042);
    public static final Part.Flag ScissorTest = new Part.Flag(3089);
    public static final Part BlendFunc = new Part(8, dataOutputStream -> {
        dataOutputStream.writeInt(GL11.glGetInteger((int)3041));
        dataOutputStream.writeInt(GL11.glGetInteger((int)3040));
    }, dataInputStream -> GL11.glBlendFunc((int)dataInputStream.readInt(), (int)dataInputStream.readInt()));
    public static final Part.IntVal ShaderProgram = new Part.IntVal(() -> GL11.glGetInteger((int)35725), n -> GL20.glUseProgram((int)n));
    public static final Part.IntVal[] Texture2D = new Part.IntVal[]{new Texture2D(0), new Texture2D(1), new Texture2D(2), new Texture2D(3), new Texture2D(4), new Texture2D(5), new Texture2D(6), new Texture2D(7), new Texture2D(8), new Texture2D(9), new Texture2D(10), new Texture2D(11), new Texture2D(12), new Texture2D(13), new Texture2D(14), new Texture2D(15), new Texture2D(16), new Texture2D(17), new Texture2D(18), new Texture2D(19), new Texture2D(20), new Texture2D(21), new Texture2D(22), new Texture2D(23), new Texture2D(24), new Texture2D(25), new Texture2D(26), new Texture2D(27), new Texture2D(28), new Texture2D(29), new Texture2D(30), new Texture2D(31)};
    public static final Part.IntVal ActiveTexture = new Part.IntVal(() -> GL11.glGetInteger((int)34016), n -> GL13.glActiveTexture((int)n));
    public static final Part.IntVal VertexArray = new Part.IntVal(() -> GL11.glGetInteger((int)34229), n -> GL30.glBindVertexArray((int)n));
    public static final Part.IntVal ArrayBuffer = new Part.IntVal(() -> GL11.glGetInteger((int)34964), n -> GL15.glBindBuffer((int)34962, (int)n));
    public static final Part.BoolVal DepthMask = new Part.BoolVal(() -> GL11.glGetInteger((int)2930) == 1, bl -> GL11.glDepthMask((boolean)bl));
    public static final Part ClearColor = new Part.Float4Val(floatBuffer -> GL11.glGetFloatv((int)3106, (FloatBuffer)floatBuffer), (f, f2, f3, f4) -> GL11.glClearColor((float)f, (float)f2, (float)f3, (float)f4));
    public static final Part Viewport = new Part.Int4Val(intBuffer -> GL11.glGetIntegerv((int)2978, (IntBuffer)intBuffer), (n, n2, n3, n4) -> GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4));
    private List<Part> parts;
    private ByteBuffer buf;

    public GLState(Part ... partArray) {
        this.parts = Arrays.asList(partArray);
        int n = 0;
        for (Part part : this.parts) {
            n += part.size;
        }
        this.buf = ByteBuffer.allocate(n);
    }

    public void backup() {
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                GLState.this.buf.put((byte)(n & 0xFF));
            }
        };
        try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
            this.buf.clear();
            for (int i = 0; i < this.parts.size(); ++i) {
                this.parts.get((int)i).backuper.backup(dataOutputStream);
            }
            this.buf.flip();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void restore() {
        InputStream inputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return GLState.this.buf.get() & 0xFF;
            }
        };
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            int n = this.buf.limit();
            for (int i = this.parts.size() - 1; i >= 0; --i) {
                Part part = this.parts.get(i);
                this.buf.position(n -= part.size);
                part.restorer.restore(dataInputStream);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static class Part {
        public final int size;
        public final Backuper backuper;
        public final Restorer restorer;

        protected Part(int n, Backuper backuper, Restorer restorer) {
            this.size = n;
            this.backuper = backuper;
            this.restorer = restorer;
        }

        public static class Float4Val
        extends Part {
            public Float4Val(Getter getter, Setter setter) {
                super(16, dataOutputStream -> {
                    try (MemoryStack memoryStack = MemoryStack.stackPush();){
                        FloatBuffer floatBuffer = memoryStack.floats(0.0f, 0.0f, 0.0f, 0.0f);
                        getter.get(floatBuffer);
                        dataOutputStream.writeFloat(floatBuffer.get(0));
                        dataOutputStream.writeFloat(floatBuffer.get(1));
                        dataOutputStream.writeFloat(floatBuffer.get(2));
                        dataOutputStream.writeFloat(floatBuffer.get(3));
                    }
                }, dataInputStream -> setter.set(dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat()));
            }

            public static interface Setter {
                public void set(float var1, float var2, float var3, float var4);
            }

            public static interface Getter {
                public void get(FloatBuffer var1);
            }
        }

        public static class Int4Val
        extends Part {
            public Int4Val(Getter getter, Setter setter) {
                super(16, dataOutputStream -> {
                    try (MemoryStack memoryStack = MemoryStack.stackPush();){
                        IntBuffer intBuffer = memoryStack.ints(0, 0, 0, 0);
                        getter.get(intBuffer);
                        dataOutputStream.writeInt(intBuffer.get(0));
                        dataOutputStream.writeInt(intBuffer.get(1));
                        dataOutputStream.writeInt(intBuffer.get(2));
                        dataOutputStream.writeInt(intBuffer.get(3));
                    }
                }, dataInputStream -> setter.set(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt()));
            }

            public static interface Setter {
                public void set(int var1, int var2, int var3, int var4);
            }

            public static interface Getter {
                public void get(IntBuffer var1);
            }
        }

        public static class Flag
        extends BoolVal {
            public Flag(int n) {
                super(() -> GL11.glIsEnabled((int)n), bl -> {
                    if (bl) {
                        GL11.glEnable((int)n);
                    } else {
                        GL11.glDisable((int)n);
                    }
                });
            }
        }

        public static class BoolVal
        extends Part {
            private final Getter getter;
            private final Setter setter;

            public BoolVal(Getter getter, Setter setter) {
                super(1, dataOutputStream -> dataOutputStream.writeBoolean(getter.get()), dataInputStream -> setter.set(dataInputStream.readBoolean()));
                this.getter = getter;
                this.setter = setter;
            }

            public boolean get() {
                return this.getter.get();
            }

            public void setter(boolean bl) {
                this.setter.set(bl);
            }

            public static interface Setter {
                public void set(boolean var1);
            }

            public static interface Getter {
                public boolean get();
            }
        }

        public static class IntVal
        extends Part {
            private final Getter getter;
            private final Setter setter;

            public IntVal(Getter getter, Setter setter) {
                super(4, dataOutputStream -> dataOutputStream.writeInt(getter.get()), dataInputStream -> setter.set(dataInputStream.readInt()));
                this.getter = getter;
                this.setter = setter;
            }

            public int get() {
                return this.getter.get();
            }

            public void set(int n) {
                this.setter.set(n);
            }

            public static interface Setter {
                public void set(int var1);
            }

            public static interface Getter {
                public int get();
            }
        }

        public static interface Restorer {
            public void restore(DataInputStream var1) throws IOException;
        }

        public static interface Backuper {
            public void backup(DataOutputStream var1) throws IOException;
        }
    }

    protected static class Texture2D
    extends Part.IntVal {
        public Texture2D(int n) {
            super(() -> {
                GL13.glActiveTexture((int)(33984 + n));
                return GL11.glGetInteger((int)3553);
            }, n2 -> {
                GL13.glActiveTexture((int)(33984 + n));
                GL11.glBindTexture((int)3553, (int)n2);
            });
        }
    }
}

