/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.JFXGLContext;
import com.sun.prism.es2.TexturedQuad;
import org.lwjgl.opengl.GL30;

public class OffscreenBuffer {
    private JFXGLContext context;
    private int width = 0;
    private int height = 0;
    private int texId = 0;
    private int fboId = 0;
    private boolean quadDirty = true;
    private TexturedQuad quad = null;
    private TexturedQuad.Shader quadShader = null;

    public OffscreenBuffer(JFXGLContext jFXGLContext, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException(String.format("invalid size: %dx%d", n, n2));
        }
        this.context = jFXGLContext;
        this.quad = null;
        this.quadShader = null;
        this.resize(n, n2);
    }

    public boolean resize(int n, int n2) {
        if (this.width == n && this.height == n2) {
            return false;
        }
        this.width = n;
        this.height = n2;
        if (this.texId != 0) {
            this.context.deleteTexture(this.texId);
        }
        this.texId = this.context.createTexture(n, n2);
        if (this.fboId == 0) {
            this.fboId = GL30.glGenFramebuffers();
        }
        GL30.glBindFramebuffer((int)36160, (int)this.fboId);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texId, (int)0);
        this.quadDirty = true;
        return true;
    }

    public int getTexId() {
        return this.texId;
    }

    public int getFboId() {
        return this.fboId;
    }

    public int bind() {
        int n = this.context.getBoundFBO();
        this.context.bindFBO(this.fboId);
        return n;
    }

    public void render() {
        this.render(0, 0, this.width, this.height, false);
    }

    public void render(int n, int n2, int n3, int n4, boolean bl) {
        if (this.quadShader == null) {
            this.quadShader = new TexturedQuad.Shader(this.context);
        }
        this.quadShader.bind();
        this.quadShader.setViewPos(n, n2);
        this.quadShader.setViewSize(n3, n4);
        this.quadShader.setYFlip(bl);
        if (this.quadDirty) {
            this.quadDirty = false;
            if (this.quad != null) {
                this.quad.cleanup();
            }
            this.quad = new TexturedQuad(0, 0, this.width, this.height, this.texId, this.quadShader);
        }
        this.quad.render();
    }

    public void unbind(int n) {
        this.context.bindFBO(n);
    }

    public void cleanup() {
        this.context.deleteTexture(this.texId);
        if (this.fboId != 0) {
            GL30.glDeleteFramebuffers((int)this.fboId);
        }
        if (this.quad != null) {
            this.quad.cleanup();
        }
        if (this.quadShader != null) {
            this.quadShader.cleanup();
        }
    }
}

