/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.Texture;
import com.sun.prism.es2.GLContext;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.es2.JFXGLContexts;
import com.sun.prism.paint.Color;
import cuchaz.jfxgl.GLState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;
import sun.misc.IOUtils;

public class JFXGLContext
extends GLContext {
    public final long hwnd;
    private GLCapabilities caps = null;
    private int majorVersion;
    private int minorVersion;
    private GLState clearBuffersState = new GLState(GLState.DepthMask, GLState.ScissorTest);
    private GLState createFBOState = new GLState(GLState.ClearColor);
    private ByteBuffer imageBuf = null;
    private static final int PosCoordFloats = 3;
    private static final int TexCoordFloats = 2;
    private static final int PosTexBytes = 28;
    private static final int PosOffsetBytes = 0;
    private static final int Tex0OffsetBytes = 12;
    private static final int Tex1OffsetBytes = 20;
    private static final int ColorBytes = 4;
    private ByteBuffer indexedQuadsCoordsBuf = null;
    private ByteBuffer indexedQuadsColorsBuf = null;

    public static JFXGLContext wrapExisting(long l) {
        return new JFXGLContext(l);
    }

    public static JFXGLContext makeNewSharedWith(long l) {
        GLFW.glfwWindowHint((int)131076, (int)0);
        long l2 = GLFW.glfwCreateWindow((int)1, (int)1, (CharSequence)"JavaFX", (long)0L, (long)l);
        return new JFXGLContext(l2);
    }

    private JFXGLContext(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("hwnd is invalid");
        }
        this.hwnd = l;
    }

    public void cleanup() {
        GLFW.glfwDestroyWindow((long)this.hwnd);
    }

    public long getNativeHandle() {
        return this.hwnd;
    }

    public long getNativeCtxInfo() {
        return this.hwnd;
    }

    public void makeCurrent() {
        JFXGLContexts.makeCurrent(this);
        if (this.caps == null) {
            this.caps = GL.createCapabilities();
            this.majorVersion = GL11.glGetInteger((int)33307);
            this.minorVersion = GL11.glGetInteger((int)33308);
        }
    }

    public void makeCurrent(GLDrawable gLDrawable) {
        this.makeCurrent();
    }

    public boolean isExtensionSupported(String string) {
        try {
            return this.caps.getClass().getDeclaredField(string).getBoolean(this.caps);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("can't check extension", illegalAccessException);
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isForwardCompatible() {
        return this.caps.forwardCompatible;
    }

    public void activeTexture(int n) {
        GL13.glActiveTexture((int)(33984 + n));
    }

    public void bindFBO(int n) {
        GL30.glBindFramebuffer((int)36160, (int)n);
    }

    public void bindTexture(int n) {
        GL11.glBindTexture((int)3553, (int)n);
    }

    public void blendFunc(int n, int n2) {
        GL11.glBlendFunc((int)JFXGLContext.translateScaleFactor(n), (int)JFXGLContext.translateScaleFactor(n2));
    }

    public void clearBuffers(Color color, boolean bl, boolean bl2, boolean bl3) {
        this.clearBuffersState.backup();
        if (bl3) {
            GL11.glDisable((int)3089);
        }
        int n = 0;
        if (bl) {
            n |= 0x4000;
            GL11.glClearColor((float)color.getRedPremult(), (float)color.getGreenPremult(), (float)color.getBluePremult(), (float)color.getAlpha());
        }
        if (bl2) {
            GL11.glDepthMask((boolean)true);
            GL11.glClear((int)(n |= 0x100));
        } else {
            GL11.glClear((int)n);
        }
        this.clearBuffersState.restore();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compileShader(URL uRL, boolean bl) {
        try (InputStream inputStream = uRL.openStream();){
            String string = new String(IOUtils.readFully((InputStream)inputStream, (int)-1, (boolean)true));
            int n = this.compileShader(string, bl);
            return n;
        }
        catch (IOException iOException) {
            throw new RuntimeException("can't compile shader at: " + uRL, iOException);
        }
    }

    public int compileShader(String string, boolean bl) {
        boolean bl2;
        int n = bl ? 35633 : 35632;
        int n2 = GL20.glCreateShader((int)n);
        GL20.glShaderSource((int)n2, (CharSequence)string);
        GL20.glCompileShader((int)n2);
        boolean bl3 = bl2 = GL20.glGetShaderi((int)n2, (int)35713) != 0;
        if (!bl2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Shader did not compile\n");
            stringBuilder.append("\nCOMPILER LOG:\n");
            stringBuilder.append(GL20.glGetShaderInfoLog((int)n2, (int)4096));
            stringBuilder.append("\nSOURCE:\n");
            String[] stringArray = string.split("\\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(String.format("%4d: ", i + 1));
                stringBuilder.append(stringArray[i]);
                stringBuilder.append("\n");
            }
            throw new RuntimeException(stringBuilder.toString());
        }
        return n2;
    }

    public int createDepthBuffer(int n, int n2, int n3) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public int createRenderBuffer(int n, int n2, int n3) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public int createFBO(int n) {
        int n2 = GL30.glGenFramebuffers();
        this.bindFBO(n2);
        if (n != 0) {
            GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n, (int)0);
            String string = JFXGLContext.getFramebufferError();
            if (string != null) {
                System.err.println("Error creating framebuffer object with texture " + n + ": " + string);
                return 0;
            }
            this.createFBOState.backup();
            this.clearBuffers(Color.TRANSPARENT, true, false, true);
            this.createFBOState.restore();
        }
        return n2;
    }

    public int createProgram(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        int n2;
        int n3 = GL20.glCreateProgram();
        GL20.glAttachShader((int)n3, (int)n);
        for (int n4 : nArray) {
            GL20.glAttachShader((int)n3, (int)n4);
        }
        assert (stringArray.length == nArray2.length);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            GL20.glBindAttribLocation((int)n3, (int)nArray2[n2], (CharSequence)stringArray[n2]);
        }
        GL20.glLinkProgram((int)n3);
        int n5 = n2 = GL20.glGetProgrami((int)n3, (int)35714) == 1 ? 1 : 0;
        if (n2 == 0) {
            throw new RuntimeException("Shader program did not link:\n" + GL20.glGetProgramInfoLog((int)n3, (int)4096));
        }
        GL20.glValidateProgram((int)n3);
        int n6 = n2 = GL20.glGetProgrami((int)n3, (int)35715) == 1 ? 1 : 0;
        if (n2 == 0) {
            throw new RuntimeException("Shader program did not validate:\n" + GL20.glGetProgramInfoLog((int)n3, (int)4096));
        }
        return n3;
    }

    public int createTexture(int n, int n2) {
        int n3 = GL11.glGenTextures();
        if (n3 == 0) {
            return 0;
        }
        GL11.glBindTexture((int)3553, (int)n3);
        JFXGLContext.clearGLErrors();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)n, (int)n2, (int)0, (int)6408, (int)5121, (long)0L);
        if (JFXGLContext.hasGLError()) {
            GL11.glDeleteTextures((int)n3);
            return 0;
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        return n3;
    }

    public void deleteRenderBuffer(int n) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void deleteFBO(int n) {
        GL30.glDeleteFramebuffers((int)n);
    }

    public void deleteShader(int n) {
        GL20.glDeleteShader((int)n);
    }

    public void deleteProgram(int n) {
        GL20.glDeleteProgram((int)n);
    }

    public void blitFBO(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        GL30.glBindFramebuffer((int)36008, (int)n);
        GL30.glBindFramebuffer((int)36009, (int)n2);
        GL30.glBlitFramebuffer((int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (int)16384, (int)9728);
    }

    public void deleteTexture(int n) {
        GL11.glDeleteTextures((int)n);
    }

    public void disposeShaders(int n, int n2, int[] nArray) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void finish() {
    }

    public int genAndBindTexture() {
        int n = GL11.glGenTextures();
        this.setBoundTexture(n);
        return n;
    }

    public int getBoundFBO() {
        return GL11.glGetInteger((int)36006);
    }

    public int getIntParam(int n) {
        return GL11.glGetInteger((int)JFXGLContext.translatePrismToGL(n));
    }

    public int getMaxSampleSize() {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public int getUniformLocation(int n, String string) {
        return GL20.glGetUniformLocation((int)n, (CharSequence)string);
    }

    public boolean isShaderCompilerSupported() {
        return true;
    }

    public void pixelStorei(int n, int n2) {
        GL11.glPixelStorei((int)JFXGLContext.translatePixelStoreName(n), (int)n2);
    }

    public boolean readPixels(Buffer buffer, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void scissorTest(boolean bl, int n, int n2, int n3, int n4) {
        if (bl) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)n, (int)n2, (int)n3, (int)n4);
        } else {
            GL11.glDisable((int)3089);
        }
    }

    public void setShaderProgram(int n) {
        GL20.glUseProgram((int)n);
    }

    public int getShaderProgram() {
        return GL11.glGetInteger((int)35725);
    }

    public void texParamsMinMax(int n, boolean bl) {
        int n2 = n;
        int n3 = n;
        if (bl) {
            n2 = n2 == 53 ? 55 : 54;
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)JFXGLContext.translatePrismToGL(n3));
        GL11.glTexParameteri((int)3553, (int)10241, (int)JFXGLContext.translatePrismToGL(n2));
    }

    public boolean texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer, boolean bl) {
        boolean bl2;
        if (buffer != null && !(buffer instanceof ByteBuffer)) {
            throw new Error("buffer should be a " + ByteBuffer.class.getName() + ", not a " + buffer.getClass().getName());
        }
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        if (bl) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        if (byteBuffer != null && !byteBuffer.isDirect()) {
            byteBuffer = this.imageBuf = JFXGLContext.updateBuffer(this.imageBuf, byteBuffer);
        }
        JFXGLContext.clearGLErrors();
        GL11.glTexImage2D((int)JFXGLContext.translatePrismToGL(n), (int)n2, (int)JFXGLContext.translatePrismToGL(n3), (int)n4, (int)n5, (int)n6, (int)JFXGLContext.translatePrismToGL(n7), (int)JFXGLContext.translatePrismToGL(n8), (ByteBuffer)byteBuffer);
        int n9 = JFXGLContext.getGLError();
        boolean bl3 = bl2 = n9 != 0;
        if (bl2) {
            System.err.println(String.format("WARNING: couldn't upload texture. glTexImage2D failed with code: 0x%x", n9));
        }
        return !bl2;
    }

    public void texSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        if (buffer != null && !(buffer instanceof ByteBuffer)) {
            throw new Error("buffer should be a " + ByteBuffer.class.getName() + ", not a " + buffer.getClass().getName());
        }
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        if (byteBuffer != null && !byteBuffer.isDirect()) {
            byteBuffer = this.imageBuf = JFXGLContext.updateBuffer(this.imageBuf, byteBuffer);
        }
        GL11.glTexSubImage2D((int)JFXGLContext.translatePrismToGL(n), (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)JFXGLContext.translatePrismToGL(n7), (int)JFXGLContext.translatePrismToGL(n8), (ByteBuffer)byteBuffer);
    }

    public void updateViewportAndDepthTest(int n, int n2, int n3, int n4, boolean bl) {
        GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
        if (bl) {
            GL11.glEnable((int)2929);
            GL11.glDepthFunc((int)515);
            GL11.glDepthMask((boolean)true);
        } else {
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
        }
    }

    public void updateMSAAState(boolean bl) {
        if (bl) {
            GL11.glEnable((int)32925);
        } else {
            GL11.glDisable((int)32925);
        }
    }

    public void updateFilterState(int n, boolean bl) {
        if (bl) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    public void updateWrapState(int n, Texture.WrapMode wrapMode) {
        int n2;
        switch (wrapMode) {
            case REPEAT_SIMULATED: 
            case REPEAT: {
                n2 = 100;
                break;
            }
            case CLAMP_TO_ZERO_SIMULATED: 
            case CLAMP_TO_EDGE_SIMULATED: 
            case CLAMP_TO_EDGE: {
                n2 = 101;
                break;
            }
            case CLAMP_TO_ZERO: {
                n2 = 102;
                break;
            }
            case CLAMP_NOT_NEEDED: {
                return;
            }
            default: {
                throw new Error("Unrecognized wrap mode: " + wrapMode);
            }
        }
        GL11.glTexParameteri((int)3553, (int)10242, (int)JFXGLContext.translatePrismToGL(n2));
        GL11.glTexParameteri((int)3553, (int)10243, (int)JFXGLContext.translatePrismToGL(n2));
    }

    public void uniform1f(int n, float f) {
        GL20.glUniform1f((int)n, (float)f);
    }

    public void uniform2f(int n, float f, float f2) {
        GL20.glUniform2f((int)n, (float)f, (float)f2);
    }

    public void uniform3f(int n, float f, float f2, float f3) {
        GL20.glUniform3f((int)n, (float)f, (float)f2, (float)f3);
    }

    public void uniform4f(int n, float f, float f2, float f3, float f4) {
        GL20.glUniform4f((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    public void uniform4fv(int n, int n2, FloatBuffer floatBuffer) {
        GL20.glUniform4fv((int)n, (FloatBuffer)floatBuffer);
    }

    public void uniform1i(int n, int n2) {
        GL20.glUniform1i((int)n, (int)n2);
    }

    public void uniform2i(int n, int n2, int n3) {
        GL20.glUniform2i((int)n, (int)n2, (int)n3);
    }

    public void uniform3i(int n, int n2, int n3, int n4) {
        GL20.glUniform3i((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void uniform4i(int n, int n2, int n3, int n4, int n5) {
        GL20.glUniform4i((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    public void uniform4iv(int n, int n2, IntBuffer intBuffer) {
        GL20.glUniform4iv((int)n, (IntBuffer)intBuffer);
    }

    public void uniformMatrix4fv(int n, boolean bl, float[] fArray) {
        GL20.glUniformMatrix4fv((int)n, (boolean)bl, (float[])fArray);
    }

    public void enableVertexAttributes() {
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL20.glEnableVertexAttribArray((int)3);
    }

    public void disableVertexAttributes() {
        GL20.glDisableVertexAttribArray((int)0);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)3);
    }

    public void drawIndexedQuads(float[] fArray, byte[] byArray, int n) {
        int n2 = n / 4;
        int n3 = n2 * 2 * 3;
        this.indexedQuadsCoordsBuf = JFXGLContext.updateBuffer(this.indexedQuadsCoordsBuf, fArray, n * 28);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)28, (long)(MemoryUtil.memAddress((ByteBuffer)this.indexedQuadsCoordsBuf) + 0L));
        GL20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)28, (long)(MemoryUtil.memAddress((ByteBuffer)this.indexedQuadsCoordsBuf) + 12L));
        GL20.glVertexAttribPointer((int)3, (int)2, (int)5126, (boolean)false, (int)28, (long)(MemoryUtil.memAddress((ByteBuffer)this.indexedQuadsCoordsBuf) + 20L));
        this.indexedQuadsColorsBuf = JFXGLContext.updateBuffer(this.indexedQuadsColorsBuf, byArray, n * 4);
        GL20.glVertexAttribPointer((int)1, (int)4, (int)5121, (boolean)true, (int)4, (ByteBuffer)this.indexedQuadsColorsBuf);
        GL11.glDrawElements((int)4, (int)n3, (int)5123, (long)0L);
    }

    public int createIndexBuffer16(short[] sArray) {
        int n = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)n);
        GL15.glBufferData((int)34963, (short[])sArray, (int)35044);
        return n;
    }

    public void setIndexBuffer(int n) {
        GL15.glBindBuffer((int)34963, (int)n);
    }

    public void setDeviceParametersFor2D() {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setDeviceParametersFor3D() {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public long createES2Mesh() {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void releaseES2Mesh(long l) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public boolean buildNativeGeometry(long l, float[] fArray, int n, short[] sArray, int n2) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public boolean buildNativeGeometry(long l, float[] fArray, int n, int[] nArray, int n2) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public long createES2PhongMaterial() {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void releaseES2PhongMaterial(long l) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setSolidColor(long l, float f, float f2, float f3, float f4) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setMap(long l, int n, int n2) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public long createES2MeshView(long l) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void releaseES2MeshView(long l) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setCullingMode(long l, int n) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setMaterial(long l, long l2) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setWireframe(long l, boolean bl) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setAmbientLight(long l, float f, float f2, float f3) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void setPointLight(long l, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    public void renderMeshView(long l) {
        throw new UnsupportedOperationException("IMPLEMENT ME!");
    }

    private static int translatePrismToGL(int n) {
        switch (n) {
            case 20: {
                return 5126;
            }
            case 21: {
                return 5121;
            }
            case 22: {
                return 33639;
            }
            case 23: {
                return 32821;
            }
            case 24: {
                return 34234;
            }
            case 40: {
                return 6408;
            }
            case 41: {
                return 32993;
            }
            case 42: {
                return 6407;
            }
            case 43: {
                return 6409;
            }
            case 44: {
                return 6406;
            }
            case 45: {
                return 34836;
            }
            case 46: {
                return 34233;
            }
            case 50: {
                return 3553;
            }
            case 51: {
                return 32873;
            }
            case 52: {
                return 9728;
            }
            case 53: {
                return 9729;
            }
            case 54: {
                return 9984;
            }
            case 55: {
                return 9987;
            }
            case 100: {
                return 10497;
            }
            case 101: {
                return 33071;
            }
            case 102: {
                return 33069;
            }
            case 120: {
                return 35657;
            }
            case 121: {
                return 36349;
            }
            case 122: {
                return 34930;
            }
            case 123: {
                return 3379;
            }
            case 125: {
                return 35659;
            }
            case 126: {
                return 36348;
            }
            case 124: {
                return 34921;
            }
            case 128: {
                return 35658;
            }
            case 129: {
                return 36347;
            }
            case 127: {
                return 35660;
            }
        }
        return n;
    }

    private static int translateScaleFactor(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 768;
            }
            case 3: {
                return 769;
            }
            case 4: {
                return 774;
            }
            case 5: {
                return 775;
            }
            case 6: {
                return 770;
            }
            case 7: {
                return 771;
            }
            case 8: {
                return 772;
            }
            case 9: {
                return 773;
            }
            case 10: {
                return 32769;
            }
            case 11: {
                return 32770;
            }
            case 12: {
                return 32771;
            }
            case 13: {
                return 32772;
            }
            case 14: {
                return 776;
            }
        }
        return 0;
    }

    private static String getFramebufferError() {
        int n = GL30.glCheckFramebufferStatus((int)36160);
        switch (n) {
            case 36053: {
                return null;
            }
            case 36061: {
                return "GL_FRAMEBUFFER_UNSUPPORTED";
            }
            case 36054: {
                return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
            }
            case 36055: {
                return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
            }
            case 36059: {
                return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
            }
            case 36060: {
                return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
            }
            case 36182: {
                return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
            }
        }
        return "(unknown error: " + n + ")";
    }

    private static int translatePixelStoreName(int n) {
        switch (n) {
            case 60: {
                return 3317;
            }
            case 61: {
                return 3314;
            }
            case 62: {
                return 3316;
            }
            case 63: {
                return 3315;
            }
        }
        return n;
    }

    private static void clearGLErrors() {
        while (JFXGLContext.hasGLError()) {
        }
    }

    private static boolean hasGLError() {
        return JFXGLContext.getGLError() != 0;
    }

    private static int getGLError() {
        return GL11.glGetError();
    }

    private static int findPowerOf2(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < 31; ++i) {
            if (n2 >= n) {
                return n2;
            }
            n2 <<= 1;
        }
        throw new Error("argument too big for 32 bits: " + n);
    }

    private static ByteBuffer manageBufferSize(ByteBuffer byteBuffer, int n) {
        int n2 = Math.max(JFXGLContext.findPowerOf2(n), 1024);
        if (byteBuffer == null || byteBuffer.capacity() < n2) {
            byteBuffer = BufferUtils.createByteBuffer((int)n2);
        }
        return byteBuffer;
    }

    private static ByteBuffer updateBuffer(ByteBuffer byteBuffer, byte[] byArray, int n) {
        byteBuffer = JFXGLContext.manageBufferSize(byteBuffer, n);
        byteBuffer.clear();
        byteBuffer.put(byArray, 0, n);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static ByteBuffer updateBuffer(ByteBuffer byteBuffer, float[] fArray, int n) {
        byteBuffer = JFXGLContext.manageBufferSize(byteBuffer, n);
        byteBuffer.clear();
        byteBuffer.asFloatBuffer().put(fArray, 0, n / 4);
        byteBuffer.position(n);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static ByteBuffer updateBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        byteBuffer = JFXGLContext.manageBufferSize(byteBuffer, byteBuffer2.limit());
        byteBuffer2.rewind();
        byteBuffer.clear();
        byteBuffer.put(byteBuffer2);
        byteBuffer.flip();
        return byteBuffer;
    }
}

