/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.View;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.tk.AppletWindow;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.JFXGLPaintCollector;
import com.sun.javafx.tk.quantum.JFXGLRenderer;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.impl.PrismSettings;
import com.sun.scenario.DelayedRunnable;
import cuchaz.jfxgl.EventsThreadNotRunningException;
import cuchaz.jfxgl.InJavaFXGLContext;
import java.security.AccessControlContext;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class JFXGLToolkit
extends QuantumToolkit {
    private ES2Pipeline pipeline;
    private JFXGLRenderer renderer;
    private JFXGLPaintCollector paintCollector;
    private AtomicBoolean pulseRequested;
    private AtomicBoolean animationRunning;
    private DelayedRunnable animationRunnable;

    public static void install() {
        System.setProperty("javafx.toolkit", JFXGLToolkit.class.getName());
        Toolkit toolkit = Toolkit.getToolkit();
        if (toolkit == null) {
            throw new Error(JFXGLToolkit.class.getSimpleName() + " not created");
        }
        if (toolkit.getClass() != JFXGLToolkit.class) {
            throw new Error(JFXGLToolkit.class.getSimpleName() + " not create correctly, got a " + toolkit.getClass().getName() + " instead.");
        }
    }

    @InJavaFXGLContext
    public boolean init() {
        GraphicsPipeline graphicsPipeline = GraphicsPipeline.createPipeline();
        if (graphicsPipeline == null) {
            throw new RuntimeException("JavaFX render init failed to create a graphics pipeline");
        }
        if (!(graphicsPipeline instanceof ES2Pipeline)) {
            throw new RuntimeException("JavaFX render init failed to create the OpenGL graphics pipeline, instead we got a " + graphicsPipeline.getClass().getName());
        }
        this.pipeline = (ES2Pipeline)graphicsPipeline;
        Map map = this.pipeline.getDeviceDetails();
        map.put(View.Capability.kHiDPIAwareKey, PrismSettings.allowHiDPIScaling);
        Map map2 = Application.getDeviceDetails();
        if (map2 != null) {
            map.putAll(map2);
        }
        Application.setDeviceDetails((Map)map);
        this.renderer = new JFXGLRenderer();
        this.paintCollector = new JFXGLPaintCollector(this);
        this.pulseRequested = new AtomicBoolean(false);
        this.animationRunning = new AtomicBoolean(false);
        this.animationRunnable = null;
        return true;
    }

    @InJavaFXGLContext
    public void startup(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Application.run(() -> {
            JFXGLToolkit.setFxUserThread((Thread)Thread.currentThread());
            for (com.sun.glass.ui.Screen screen : com.sun.glass.ui.Screen.getScreens()) {
                screen.setAdapterOrdinal(this.pipeline.getAdapterOrdinal(screen));
            }
            Application.GetApplication().setEventHandler(new Application.EventHandler(){

                public void handleQuitAction(Application application, long l) {
                    throw new UnsupportedOperationException("implement me!");
                }

                public boolean handleThemeChanged(String string) {
                    return PlatformImpl.setAccessibilityTheme((String)string);
                }
            });
            runnable.run();
            Screen.getPrimary();
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        ES2Pipeline.getDefaultResourceFactory();
    }

    public void postPulse() {
        boolean bl;
        boolean bl2 = bl = this.paintCollector.hasDirty() || this.pulseRequested.get() || this.animationRunning.get();
        if (bl) {
            this.pulseRequested.set(false);
            if (this.animationRunnable != null) {
                this.animationRunning.set(true);
                Application.invokeLater((Runnable)this.animationRunnable);
            } else {
                this.animationRunning.set(false);
            }
            Application.invokeLater(() -> {
                this.firePulse();
                this.paintCollector.renderAll();
            });
        }
    }

    public void requestNextPulse() {
        this.pulseRequested.set(true);
    }

    public void setAnimationRunnable(DelayedRunnable delayedRunnable) {
        if (delayedRunnable != null) {
            this.animationRunning.set(true);
        }
        this.animationRunnable = delayedRunnable;
    }

    public void addRepaintSceneRenderJob(Scene scene) {
        ViewScene viewScene = (ViewScene)scene.impl_getPeer();
        viewScene.repaint();
    }

    public Future addRenderJob(RenderJob renderJob) {
        return this.renderer.submitRenderJob(renderJob);
    }

    public void render() {
        this.renderer.render();
    }

    public boolean shouldWaitForRenderingToComplete() {
        return false;
    }

    public void exit() {
        this.checkFxUserThread();
        this.notifyShutdownHooks();
        Application application = Application.GetApplication();
        application.terminate();
        JFXGLToolkit.clearFxUserThread();
    }

    public void disposePipeline() {
        this.pipeline.dispose();
    }

    public void defer(Runnable runnable) {
        JFXGLToolkit.runLater(runnable);
    }

    public static void runLater(Runnable runnable) {
        JFXGLToolkit.checkApplication();
        Application.invokeLater((Runnable)runnable);
    }

    public static void runAndWait(Runnable runnable) {
        JFXGLToolkit.checkApplication();
        Application.invokeAndWait((Runnable)runnable);
    }

    private static void checkApplication() {
        if (Application.GetApplication() == null) {
            throw new EventsThreadNotRunningException();
        }
    }

    public void checkFxUserThread() {
        if (!this.isFxUserThread()) {
            throw new IllegalStateException("Not on FX application thread; currentThread = " + Thread.currentThread().getName());
        }
    }

    public boolean canStartNestedEventLoop() {
        return false;
    }

    public Object enterNestedEventLoop(Object object) {
        throw new UnsupportedOperationException("implement me!");
    }

    public void exitNestedEventLoop(Object object, Object object2) {
        throw new UnsupportedOperationException("implement me!");
    }

    public boolean isNestedLoopRunning() {
        throw new UnsupportedOperationException("implement me!");
    }

    public TKStage createTKPopupStage(Window window, StageStyle stageStyle, TKStage tKStage, AccessControlContext accessControlContext) {
        throw new UnsupportedOperationException("implement me!");
    }

    public TKStage createTKEmbeddedStage(HostInterface hostInterface, AccessControlContext accessControlContext) {
        throw new UnsupportedOperationException("implement me!");
    }

    public AppletWindow createAppletWindow(long l, String string) {
        throw new UnsupportedOperationException("implement me!");
    }

    public void closeAppletWindow() {
        throw new UnsupportedOperationException("implement me!");
    }

    public void waitFor(Toolkit.Task task) {
        throw new UnsupportedOperationException("implement me!");
    }

    public boolean isVsyncEnabled() {
        return false;
    }
}

