/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.jfxgl;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.jfxgl.JFXGLView;
import com.sun.javafx.tk.quantum.JFXGLToolkit;
import com.sun.prism.es2.JFXGLContext;
import com.sun.prism.es2.JFXGLContexts;
import com.sun.prism.es2.OffscreenBuffer;
import cuchaz.jfxgl.CalledByEventsThread;
import cuchaz.jfxgl.CalledByMainThread;
import cuchaz.jfxgl.GLState;
import cuchaz.jfxgl.InAppGLContext;
import cuchaz.jfxgl.InJavaFXGLContext;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

public class JFXGLWindow
extends Window {
    public static JFXGLWindow mainWindow = null;
    private JFXGLContext context = null;
    private JFXGLView view = null;
    private GLFWWindowSizeCallbackI windowSizeCallback = null;
    private GLFWWindowSizeCallbackI existingWindowSizeCallback = null;
    private int width = 0;
    private int height = 0;
    private OffscreenBuffer buf = null;
    private boolean fboDirty = true;
    private GLState glstate = new GLState(GLState.Blend, GLState.BlendFunc, GLState.ShaderProgram, GLState.ActiveTexture, GLState.Texture2D[0], GLState.VertexArray, GLState.ArrayBuffer, GLState.Viewport);
    long hcursor = 0L;

    protected JFXGLWindow(Window window, Screen screen, int n3) {
        super(window, screen, n3);
        if (mainWindow != null) {
            throw new IllegalStateException("can't create more than one window");
        }
        mainWindow = this;
        this.context = JFXGLContexts.app;
        this.windowSizeCallback = (l, n, n2) -> {
            if (n != this.width || n2 != this.height) {
                this.width = n;
                this.height = n2;
                this.fboDirty = true;
            }
            JFXGLToolkit.runLater(() -> {
                this.notifyResize(511, n, n2);
                if (this.view != null) {
                    this.view.notifyResize(this.width, this.height);
                }
            });
            if (this.existingWindowSizeCallback != null) {
                this.existingWindowSizeCallback.invoke(l, n, n2);
            }
        };
        this.existingWindowSizeCallback = GLFW.glfwSetWindowSizeCallback((long)this.context.hwnd, (GLFWWindowSizeCallbackI)this.windowSizeCallback);
    }

    @CalledByEventsThread
    protected long _createWindow(long l, long l2, int n) {
        return JFXGLContexts.app.hwnd;
    }

    protected long _createChildWindow(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean _close(long l) {
        this.notifyDestroy();
        return false;
    }

    @CalledByEventsThread
    protected boolean _setView(long l, View view) {
        this.view = (JFXGLView)view;
        if (this.view != null) {
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                IntBuffer intBuffer = memoryStack.callocInt(1);
                IntBuffer intBuffer2 = memoryStack.callocInt(1);
                GLFW.glfwGetWindowSize((long)this.context.hwnd, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
                this.width = intBuffer.get(0);
                this.height = intBuffer2.get(0);
            }
            JFXGLToolkit.runLater(() -> {
                this.notifyResize(511, this.width, this.height);
                this.view.notifyResize(this.width, this.height);
            });
        }
        return true;
    }

    @CalledByMainThread
    @InJavaFXGLContext
    public void renderBegin() {
        if (this.buf == null) {
            this.buf = new OffscreenBuffer(this.context, this.width, this.height);
        }
        if (this.fboDirty) {
            this.fboDirty = false;
            this.buf.resize(this.width, this.height);
        }
    }

    @CalledByMainThread
    @InJavaFXGLContext
    public void renderEnd() {
    }

    @CalledByMainThread
    public int getFBOId() {
        if (this.buf != null) {
            return this.buf.getFboId();
        }
        return 0;
    }

    @CalledByMainThread
    @InAppGLContext
    public void renderFramebuf() {
        if (this.buf != null) {
            this.glstate.backup();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            this.buf.render();
            this.glstate.restore();
        }
    }

    public OffscreenBuffer getBuffer() {
        return this.buf;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected boolean _setMenubar(long l, long l2) {
        throw new UnsupportedOperationException();
    }

    protected boolean _minimize(long l, boolean bl) {
        return false;
    }

    protected boolean _maximize(long l, boolean bl, boolean bl2) {
        return false;
    }

    protected int _getEmbeddedX(long l) {
        throw new UnsupportedOperationException();
    }

    protected int _getEmbeddedY(long l) {
        throw new UnsupportedOperationException();
    }

    protected void _setBounds(long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f, float f2) {
    }

    protected boolean _setVisible(long l, boolean bl) {
        return bl;
    }

    protected boolean _setResizable(long l, boolean bl) {
        return false;
    }

    public void handleGLFWFocus(boolean bl) {
        this.notifyFocus(bl ? 542 : 541);
    }

    protected boolean _requestFocus(long l, int n) {
        return true;
    }

    protected void _setFocusable(long l, boolean bl) {
    }

    protected boolean _grabFocus(long l) {
        throw new UnsupportedOperationException();
    }

    protected void _ungrabFocus(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean _setTitle(long l, String string) {
        return false;
    }

    protected void _setLevel(long l, int n) {
    }

    protected void _setAlpha(long l, float f) {
    }

    protected boolean _setBackground(long l, float f, float f2, float f3) {
        return false;
    }

    protected void _setEnabled(long l, boolean bl) {
    }

    protected boolean _setMinimumSize(long l, int n, int n2) {
        return false;
    }

    protected boolean _setMaximumSize(long l, int n, int n2) {
        return false;
    }

    protected void _setIcon(long l, Pixels pixels) {
    }

    protected void _setCursor(long l, Cursor cursor) {
        if (this.hcursor != 0L) {
            GLFW.glfwDestroyCursor((long)this.hcursor);
            this.hcursor = 0L;
        }
        this.hcursor = GLFW.glfwCreateStandardCursor((int)this.translateCursor(cursor));
        GLFW.glfwSetCursor((long)l, (long)this.hcursor);
    }

    private int translateCursor(Cursor cursor) {
        switch (cursor.getType()) {
            case -1: {
                return 221185;
            }
            case 0: {
                return 221185;
            }
            case 1: {
                return 221185;
            }
            case 2: {
                return 221186;
            }
            case 3: {
                return 221187;
            }
            case 4: {
                return 221188;
            }
            case 5: {
                return 221188;
            }
            case 6: {
                return 221188;
            }
            case 7: {
                return 221189;
            }
            case 8: {
                return 221189;
            }
            case 9: {
                return 221190;
            }
            case 10: {
                return 221190;
            }
            case 11: {
                return 221189;
            }
            case 12: {
                return 221190;
            }
            case 13: {
                return 221185;
            }
            case 14: {
                return 221185;
            }
            case 15: {
                return 221185;
            }
            case 16: {
                return 221185;
            }
            case 17: {
                return 221185;
            }
            case 18: {
                return 221185;
            }
            case 19: {
                return 221185;
            }
        }
        return 221185;
    }

    protected void _toFront(long l) {
    }

    protected void _toBack(long l) {
    }

    protected void _enterModal(long l) {
    }

    protected void _enterModalWithWindow(long l, long l2) {
    }

    protected void _exitModal(long l) {
    }

    protected void _requestInput(long l, String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        throw new UnsupportedOperationException();
    }

    protected void _releaseInput(long l) {
        throw new UnsupportedOperationException();
    }
}

