/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.jfxgl;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.JFXGLScreen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.jfxgl.JFXGLCursor;
import com.sun.glass.ui.jfxgl.JFXGLView;
import com.sun.glass.ui.jfxgl.JFXGLWindow;
import cuchaz.jfxgl.EventsThreadNotRunningException;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;

public class JFXGLApplication
extends Application {
    private static final Object invokeAndWaitLock = new Object();
    private static Runnable waitingFor;
    private LinkedList<Event> eventList = new LinkedList();
    private volatile boolean isRunning = false;
    private static long multiClickTime;
    private static int multiClickMaxX;
    private static int multiClickMaxY;

    public void terminate() {
        super.terminate();
        this.isRunning = false;
    }

    protected void runLoop(Runnable runnable) {
        Thread thread = new Thread(() -> {
            runnable.run();
            this.eventLoop();
        }, "FXEvents");
        JFXGLApplication.setEventThread((Thread)thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventLoop() {
        this.isRunning = true;
        while (this.isRunning) {
            Event event = null;
            LinkedList<Event> linkedList = this.eventList;
            synchronized (linkedList) {
                event = this.eventList.poll();
            }
            if (event == null) continue;
            try {
                event.dispatch();
            }
            catch (Exception exception) {
                JFXGLApplication.reportException((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _invokeAndWait(Runnable runnable) {
        this.checkEventThreadRunning();
        Object object = invokeAndWaitLock;
        synchronized (object) {
            waitingFor = runnable;
        }
        object = this.eventList;
        synchronized (object) {
            this.eventList.addLast(new RunnableEvent(true, runnable));
            this.eventList.notify();
        }
        object = invokeAndWaitLock;
        synchronized (object) {
            while (waitingFor == runnable) {
                try {
                    invokeAndWaitLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _invokeLater(Runnable runnable) {
        this.checkEventThreadRunning();
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            this.eventList.addLast(new RunnableEvent(false, runnable));
            this.eventList.notify();
        }
    }

    private void checkEventThreadRunning() {
        if (!this.isRunning) {
            throw new EventsThreadNotRunningException();
        }
    }

    protected Object _enterNestedEventLoop() {
        throw new UnsupportedOperationException("implement me!");
    }

    protected void _leaveNestedEventLoop(Object object) {
        throw new UnsupportedOperationException("implement me!");
    }

    public Window createWindow(Window window, Screen screen, int n) {
        return new JFXGLWindow(window, screen, n);
    }

    public Window createWindow(long l) {
        throw new UnsupportedOperationException("implement me!");
    }

    public View createView() {
        return new JFXGLView();
    }

    public Cursor createCursor(int n) {
        return new JFXGLCursor(n);
    }

    public Cursor createCursor(int n, int n2, Pixels pixels) {
        throw new UnsupportedOperationException("implement me!");
    }

    protected void staticCursor_setVisible(boolean bl) {
        throw new UnsupportedOperationException("implement me!");
    }

    protected Size staticCursor_getBestSize(int n, int n2) {
        throw new UnsupportedOperationException("implement me!");
    }

    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("implement me!");
    }

    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        throw new UnsupportedOperationException("implement me!");
    }

    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f) {
        throw new UnsupportedOperationException("implement me!");
    }

    protected int staticPixels_getNativeFormat() {
        return 2;
    }

    public Robot createRobot() {
        throw new UnsupportedOperationException("implement me!");
    }

    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    protected Screen[] staticScreen_getScreens() {
        PointerBuffer pointerBuffer = GLFW.glfwGetMonitors();
        Screen[] screenArray = new Screen[pointerBuffer.limit()];
        for (int i = 0; i < pointerBuffer.limit(); ++i) {
            screenArray[i] = JFXGLScreen.make(pointerBuffer.get(i));
        }
        return screenArray;
    }

    public Timer createTimer(Runnable runnable) {
        throw new UnsupportedOperationException("implement me!");
    }

    protected int staticTimer_getMinPeriod() {
        throw new UnsupportedOperationException("implement me!");
    }

    protected int staticTimer_getMaxPeriod() {
        throw new UnsupportedOperationException("implement me!");
    }

    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n2) {
        throw new UnsupportedOperationException();
    }

    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        throw new UnsupportedOperationException();
    }

    protected long staticView_getMultiClickTime() {
        return multiClickTime;
    }

    protected int staticView_getMultiClickMaxX() {
        return multiClickMaxX;
    }

    protected int staticView_getMultiClickMaxY() {
        return multiClickMaxY;
    }

    protected boolean _supportsTransparentWindows() {
        return true;
    }

    protected boolean _supportsUnifiedWindows() {
        throw new UnsupportedOperationException("implement me!");
    }

    protected int _getKeyCodeForChar(char c) {
        throw new UnsupportedOperationException("implement me!");
    }

    static {
        multiClickTime = 500L;
        multiClickMaxX = 20;
        multiClickMaxY = 20;
    }

    private static class RunnableEvent
    extends Event {
        private boolean wait;
        private Runnable runnable;

        RunnableEvent(boolean bl, Runnable runnable) {
            this.wait = bl;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void dispatch() {
            this.runnable.run();
            if (this.wait) {
                Object object = invokeAndWaitLock;
                synchronized (object) {
                    waitingFor = null;
                    invokeAndWaitLock.notify();
                }
            }
        }

        public String toString() {
            return "RunnableEvent[runnable=" + this.runnable + ",wait=" + this.wait + "]";
        }
    }

    private static abstract class Event {
        private Event() {
        }

        abstract void dispatch();
    }
}

