/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.WeakReference;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.control.FXDialog;
import javafx.scene.control.HeavyweightDialog;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;

public class Dialog<R>
implements EventTarget {
    final FXDialog dialog = new HeavyweightDialog(this);
    private boolean isClosing;
    private ObjectProperty<DialogPane> dialogPane = new SimpleObjectProperty<DialogPane>((Object)this, "dialogPane", new DialogPane()){
        final InvalidationListener expandedListener;
        final InvalidationListener headerListener;
        WeakReference<DialogPane> dialogPaneRef;
        {
            this.expandedListener = o -> {
                DialogPane dialogPane = Dialog.this.getDialogPane();
                if (dialogPane == null) {
                    return;
                }
                Node content = dialogPane.getExpandableContent();
                boolean isExpanded = content == null ? false : content.isVisible();
                Dialog.this.setResizable(isExpanded);
                Dialog.this.dialog.sizeToScene();
            };
            this.headerListener = o -> Dialog.this.updatePseudoClassState();
            this.dialogPaneRef = new WeakReference<Object>(null);
        }

        @Override
        protected void invalidated() {
            DialogPane newDialogPane;
            DialogPane oldDialogPane = (DialogPane)this.dialogPaneRef.get();
            if (oldDialogPane != null) {
                oldDialogPane.expandedProperty().removeListener(this.expandedListener);
                oldDialogPane.headerProperty().removeListener(this.headerListener);
                oldDialogPane.headerTextProperty().removeListener(this.headerListener);
                oldDialogPane.setDialog(null);
            }
            if ((newDialogPane = Dialog.this.getDialogPane()) != null) {
                newDialogPane.setDialog(Dialog.this);
                newDialogPane.getButtonTypes().addListener((ListChangeListener.Change<? super E> c) -> newDialogPane.requestLayout());
                newDialogPane.expandedProperty().addListener(this.expandedListener);
                newDialogPane.headerProperty().addListener(this.headerListener);
                newDialogPane.headerTextProperty().addListener(this.headerListener);
                Dialog.this.updatePseudoClassState();
                newDialogPane.requestLayout();
            }
            Dialog.this.dialog.setDialogPane(newDialogPane);
            this.dialogPaneRef = new WeakReference<DialogPane>(newDialogPane);
        }
    };
    private final ObjectProperty<R> resultProperty = new SimpleObjectProperty<R>(){

        @Override
        protected void invalidated() {
            Dialog.this.close();
        }
    };
    private final ObjectProperty<Callback<ButtonType, R>> resultConverterProperty = new SimpleObjectProperty<Callback<ButtonType, R>>(this, "resultConverter");
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private ObjectProperty<EventHandler<DialogEvent>> onShowing;
    private ObjectProperty<EventHandler<DialogEvent>> onShown;
    private ObjectProperty<EventHandler<DialogEvent>> onHiding;
    private ObjectProperty<EventHandler<DialogEvent>> onHidden;
    private ObjectProperty<EventHandler<DialogEvent>> onCloseRequest;
    private static final PseudoClass HEADER_PSEUDO_CLASS = PseudoClass.getPseudoClass("header");
    private static final PseudoClass NO_HEADER_PSEUDO_CLASS = PseudoClass.getPseudoClass("no-header");

    public Dialog() {
        this.setDialogPane(new DialogPane());
        this.initModality(Modality.APPLICATION_MODAL);
    }

    public final void show() {
        Toolkit.getToolkit().checkFxUserThread();
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWING));
        if (this.getWidth() == Double.NaN && this.getHeight() == Double.NaN) {
            this.dialog.sizeToScene();
        }
        this.dialog.show();
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWN));
    }

    public final Optional<R> showAndWait() {
        Toolkit.getToolkit().checkFxUserThread();
        if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
            throw new IllegalStateException("showAndWait is not allowed during animation or layout processing");
        }
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWING));
        if (this.getWidth() == Double.NaN && this.getHeight() == Double.NaN) {
            this.dialog.sizeToScene();
        }
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWN));
        this.dialog.showAndWait();
        return Optional.ofNullable(this.getResult());
    }

    public final void close() {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        R result = this.getResult();
        if (result == null && !this.dialog.requestPermissionToClose(this)) {
            this.isClosing = false;
            return;
        }
        if (result == null) {
            ButtonType cancelButton = null;
            for (ButtonType button : this.getDialogPane().getButtonTypes()) {
                ButtonBar.ButtonData buttonData = button.getButtonData();
                if (buttonData == null) continue;
                if (buttonData == ButtonBar.ButtonData.CANCEL_CLOSE) {
                    cancelButton = button;
                    break;
                }
                if (!buttonData.isCancelButton()) continue;
                cancelButton = button;
            }
            this.impl_setResultAndClose(cancelButton, false);
        }
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_HIDING));
        DialogEvent closeRequestEvent = new DialogEvent(this, DialogEvent.DIALOG_CLOSE_REQUEST);
        Event.fireEvent(this, closeRequestEvent);
        if (closeRequestEvent.isConsumed()) {
            this.isClosing = false;
            return;
        }
        this.dialog.close();
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_HIDDEN));
        this.isClosing = false;
    }

    public final void hide() {
        this.close();
    }

    public final void initModality(Modality modality) {
        this.dialog.initModality(modality);
    }

    public final Modality getModality() {
        return this.dialog.getModality();
    }

    public final void initStyle(StageStyle style) {
        this.dialog.initStyle(style);
    }

    public final void initOwner(Window window) {
        this.dialog.initOwner(window);
    }

    public final Window getOwner() {
        return this.dialog.getOwner();
    }

    public final ObjectProperty<DialogPane> dialogPaneProperty() {
        return this.dialogPane;
    }

    public final DialogPane getDialogPane() {
        return (DialogPane)this.dialogPane.get();
    }

    public final void setDialogPane(DialogPane value) {
        this.dialogPane.set(value);
    }

    public final StringProperty contentTextProperty() {
        return this.getDialogPane().contentTextProperty();
    }

    public final String getContentText() {
        return this.getDialogPane().getContentText();
    }

    public final void setContentText(String contentText) {
        this.getDialogPane().setContentText(contentText);
    }

    public final StringProperty headerTextProperty() {
        return this.getDialogPane().headerTextProperty();
    }

    public final String getHeaderText() {
        return this.getDialogPane().getHeaderText();
    }

    public final void setHeaderText(String headerText) {
        this.getDialogPane().setHeaderText(headerText);
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.getDialogPane().graphicProperty();
    }

    public final Node getGraphic() {
        return this.getDialogPane().getGraphic();
    }

    public final void setGraphic(Node graphic) {
        this.getDialogPane().setGraphic(graphic);
    }

    public final ObjectProperty<R> resultProperty() {
        return this.resultProperty;
    }

    public final R getResult() {
        return (R)this.resultProperty().get();
    }

    public final void setResult(R value) {
        this.resultProperty().set(value);
    }

    public final ObjectProperty<Callback<ButtonType, R>> resultConverterProperty() {
        return this.resultConverterProperty;
    }

    public final Callback<ButtonType, R> getResultConverter() {
        return (Callback)this.resultConverterProperty().get();
    }

    public final void setResultConverter(Callback<ButtonType, R> value) {
        this.resultConverterProperty().set(value);
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.dialog.showingProperty();
    }

    public final boolean isShowing() {
        return this.showingProperty().get();
    }

    public final BooleanProperty resizableProperty() {
        return this.dialog.resizableProperty();
    }

    public final boolean isResizable() {
        return this.resizableProperty().get();
    }

    public final void setResizable(boolean resizable) {
        this.resizableProperty().set(resizable);
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.dialog.widthProperty();
    }

    public final double getWidth() {
        return this.widthProperty().get();
    }

    public final void setWidth(double width) {
        this.dialog.setWidth(width);
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.dialog.heightProperty();
    }

    public final double getHeight() {
        return this.heightProperty().get();
    }

    public final void setHeight(double height) {
        this.dialog.setHeight(height);
    }

    public final StringProperty titleProperty() {
        return this.dialog.titleProperty();
    }

    public final String getTitle() {
        return (String)this.dialog.titleProperty().get();
    }

    public final void setTitle(String title) {
        this.dialog.titleProperty().set(title);
    }

    public final double getX() {
        return this.dialog.getX();
    }

    public final void setX(double x) {
        this.dialog.setX(x);
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.dialog.xProperty();
    }

    public final double getY() {
        return this.dialog.getY();
    }

    public final void setY(double y) {
        this.dialog.setY(y);
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.dialog.yProperty();
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend(this.eventHandlerManager);
    }

    public final void setOnShowing(EventHandler<DialogEvent> value) {
        this.onShowingProperty().set(value);
    }

    public final EventHandler<DialogEvent> getOnShowing() {
        return this.onShowing == null ? null : (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onShowingProperty() {
        if (this.onShowing == null) {
            this.onShowing = new SimpleObjectProperty<EventHandler<DialogEvent>>((Object)this, "onShowing"){

                @Override
                protected void invalidated() {
                    Dialog.this.eventHandlerManager.setEventHandler(DialogEvent.DIALOG_SHOWING, (EventHandler)this.get());
                }
            };
        }
        return this.onShowing;
    }

    public final void setOnShown(EventHandler<DialogEvent> value) {
        this.onShownProperty().set(value);
    }

    public final EventHandler<DialogEvent> getOnShown() {
        return this.onShown == null ? null : (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onShownProperty() {
        if (this.onShown == null) {
            this.onShown = new SimpleObjectProperty<EventHandler<DialogEvent>>((Object)this, "onShown"){

                @Override
                protected void invalidated() {
                    Dialog.this.eventHandlerManager.setEventHandler(DialogEvent.DIALOG_SHOWN, (EventHandler)this.get());
                }
            };
        }
        return this.onShown;
    }

    public final void setOnHiding(EventHandler<DialogEvent> value) {
        this.onHidingProperty().set(value);
    }

    public final EventHandler<DialogEvent> getOnHiding() {
        return this.onHiding == null ? null : (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onHidingProperty() {
        if (this.onHiding == null) {
            this.onHiding = new SimpleObjectProperty<EventHandler<DialogEvent>>((Object)this, "onHiding"){

                @Override
                protected void invalidated() {
                    Dialog.this.eventHandlerManager.setEventHandler(DialogEvent.DIALOG_HIDING, (EventHandler)this.get());
                }
            };
        }
        return this.onHiding;
    }

    public final void setOnHidden(EventHandler<DialogEvent> value) {
        this.onHiddenProperty().set(value);
    }

    public final EventHandler<DialogEvent> getOnHidden() {
        return this.onHidden == null ? null : (EventHandler)this.onHidden.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onHiddenProperty() {
        if (this.onHidden == null) {
            this.onHidden = new SimpleObjectProperty<EventHandler<DialogEvent>>((Object)this, "onHidden"){

                @Override
                protected void invalidated() {
                    Dialog.this.eventHandlerManager.setEventHandler(DialogEvent.DIALOG_HIDDEN, (EventHandler)this.get());
                }
            };
        }
        return this.onHidden;
    }

    public final void setOnCloseRequest(EventHandler<DialogEvent> value) {
        this.onCloseRequestProperty().set(value);
    }

    public final EventHandler<DialogEvent> getOnCloseRequest() {
        return this.onCloseRequest != null ? (EventHandler)this.onCloseRequest.get() : null;
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new SimpleObjectProperty<EventHandler<DialogEvent>>((Object)this, "onCloseRequest"){

                @Override
                protected void invalidated() {
                    Dialog.this.eventHandlerManager.setEventHandler(DialogEvent.DIALOG_CLOSE_REQUEST, (EventHandler)this.get());
                }
            };
        }
        return this.onCloseRequest;
    }

    void impl_setResultAndClose(ButtonType cmd, boolean close) {
        Callback<ButtonType, R> resultConverter = this.getResultConverter();
        R priorResultValue = this.getResult();
        ButtonType newResultValue = null;
        newResultValue = resultConverter == null ? cmd : resultConverter.call(cmd);
        this.setResult(newResultValue);
        if (close && priorResultValue == newResultValue) {
            this.close();
        }
    }

    private void updatePseudoClassState() {
        DialogPane dialogPane = this.getDialogPane();
        if (dialogPane != null) {
            boolean hasHeader = this.getDialogPane().hasHeader();
            dialogPane.pseudoClassStateChanged(HEADER_PSEUDO_CLASS, hasHeader);
            dialogPane.pseudoClassStateChanged(NO_HEADER_PSEUDO_CLASS, !hasHeader);
        }
    }
}

