/*
 * Decompiled with CFR 0.152.
 */
package javafx.event;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javafx.event.Event;

public final class EventType<T extends Event>
implements Serializable {
    public static final EventType<Event> ROOT = new EventType("EVENT", null);
    private WeakHashMap<EventType<? extends T>, Void> subTypes;
    private final EventType<? super T> superType;
    private final String name;

    @Deprecated
    public EventType() {
        this(ROOT, null);
    }

    public EventType(String name) {
        this(ROOT, name);
    }

    public EventType(EventType<? super T> superType) {
        this(superType, null);
    }

    public EventType(EventType<? super T> superType, String name) {
        if (superType == null) {
            throw new NullPointerException("Event super type must not be null!");
        }
        this.superType = superType;
        this.name = name;
        super.register(this);
    }

    EventType(String name, EventType<? super T> superType) {
        this.superType = superType;
        this.name = name;
        if (superType != null) {
            if (superType.subTypes != null) {
                Iterator<EventType<T>> i = superType.subTypes.keySet().iterator();
                while (i.hasNext()) {
                    EventType<? extends T> t = i.next();
                    if ((name != null || t.name != null) && (name == null || !name.equals(t.name))) continue;
                    i.remove();
                }
            }
            super.register(this);
        }
    }

    public final EventType<? super T> getSuperType() {
        return this.superType;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }

    private void register(EventType<? extends T> subType) {
        if (this.subTypes == null) {
            this.subTypes = new WeakHashMap();
        }
        for (EventType<? extends T> eventType : this.subTypes.keySet()) {
            if ((eventType.name != null || subType.name != null) && (eventType.name == null || !eventType.name.equals(subType.name))) continue;
            throw new IllegalArgumentException("EventType \"" + subType + "\"with parent \"" + subType.getSuperType() + "\" already exists");
        }
        this.subTypes.put(subType, null);
    }

    private Object writeReplace() throws ObjectStreamException {
        LinkedList<String> path = new LinkedList<String>();
        EventType<? super T> t = this;
        while (t != ROOT) {
            path.addFirst(t.name);
            t = t.superType;
        }
        return new EventTypeSerialization(new ArrayList<String>(path));
    }

    static class EventTypeSerialization
    implements Serializable {
        private List<String> path;

        public EventTypeSerialization(List<String> path) {
            this.path = path;
        }

        private Object readResolve() throws ObjectStreamException {
            EventType t = ROOT;
            for (int i = 0; i < this.path.size(); ++i) {
                EventType s;
                String p = this.path.get(i);
                if (t.subTypes != null) {
                    s = this.findSubType(t.subTypes.keySet(), p);
                    if (s == null) {
                        throw new InvalidObjectException("Cannot find event type \"" + p + "\" (of " + t + ")");
                    }
                } else {
                    throw new InvalidObjectException("Cannot find event type \"" + p + "\" (of " + t + ")");
                }
                t = s;
            }
            return t;
        }

        private EventType findSubType(Set<EventType> subTypes, String name) {
            for (EventType t : subTypes) {
                if ((t.name != null || name != null) && (t.name == null || !t.name.equals(name))) continue;
                return t;
            }
            return null;
        }
    }
}

