/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.webkit.BackForwardList;
import com.sun.webkit.Disposer;
import com.sun.webkit.InputMethodClient;
import com.sun.webkit.InspectorClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.PolicyClient;
import com.sun.webkit.ThemeClient;
import com.sun.webkit.UIClient;
import com.sun.webkit.WCFrameView;
import com.sun.webkit.WCWidget;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.event.WCFocusEvent;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.event.WCKeyEvent;
import com.sun.webkit.event.WCMouseEvent;
import com.sun.webkit.event.WCMouseWheelEvent;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCPageBackBuffer;
import com.sun.webkit.graphics.WCPoint;
import com.sun.webkit.graphics.WCRectangle;
import com.sun.webkit.graphics.WCRenderQueue;
import com.sun.webkit.graphics.WCSize;
import com.sun.webkit.network.CookieManager;
import com.sun.webkit.network.URLs;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class WebPage {
    private static final Logger log = Logger.getLogger(WebPage.class.getName());
    private static final Logger paintLog = Logger.getLogger(WebPage.class.getName() + ".paint");
    private static final int MAX_FRAME_QUEUE_SIZE = 10;
    private long pPage = 0L;
    private boolean isDisposed = false;
    private int width;
    private int height;
    private int fontSmoothingType;
    private final WCFrameView hostWindow;
    private final Set<Long> frames = new HashSet<Long>();
    private final AccessControlContext accessControlContext;
    private final Map<Integer, String> requestURLs = new HashMap<Integer, String>();
    private final Set<Integer> requestStarted = new HashSet<Integer>();
    private static final ReentrantLock PAGE_LOCK = new ReentrantLock();
    private final Queue<RenderFrame> frameQueue = new LinkedList<RenderFrame>();
    private RenderFrame currentFrame = new RenderFrame();
    private int updateContentCycleID;
    private static boolean firstWebPageCreated;
    private WCPageBackBuffer backbuffer;
    private List<WCRectangle> dirtyRects = new LinkedList<WCRectangle>();
    private final WebPageClient pageClient;
    private final UIClient uiClient;
    private final PolicyClient policyClient;
    private InputMethodClient imClient;
    private final List<LoadListenerClient> loadListenerClients = new LinkedList<LoadListenerClient>();
    private final InspectorClient inspectorClient;
    private final RenderTheme renderTheme;
    private final ScrollBarTheme scrollbarTheme;
    public static final int DND_DST_ENTER = 0;
    public static final int DND_DST_OVER = 1;
    public static final int DND_DST_CHANGE = 2;
    public static final int DND_DST_EXIT = 3;
    public static final int DND_DST_DROP = 4;
    public static final int DND_SRC_ENTER = 100;
    public static final int DND_SRC_OVER = 101;
    public static final int DND_SRC_CHANGE = 102;
    public static final int DND_SRC_EXIT = 103;
    public static final int DND_SRC_DROP = 104;

    private static void collectJSCGarbages() {
        Invoker.getInvoker().checkEventThread();
        Disposer.addRecord(new Object(), WebPage::collectJSCGarbages);
        WebPage.twkDoJSCGarbageCollection();
    }

    public WebPage(WebPageClient pageClient, UIClient uiClient, PolicyClient policyClient, InspectorClient inspectorClient, ThemeClient themeClient, boolean editable) {
        Invoker.getInvoker().checkEventThread();
        this.pageClient = pageClient;
        this.uiClient = uiClient;
        this.policyClient = policyClient;
        this.inspectorClient = inspectorClient;
        if (themeClient != null) {
            this.renderTheme = themeClient.createRenderTheme();
            this.scrollbarTheme = themeClient.createScrollBarTheme();
        } else {
            this.renderTheme = null;
            this.scrollbarTheme = null;
        }
        this.accessControlContext = AccessController.getContext();
        this.hostWindow = new WCFrameView(this);
        this.pPage = this.twkCreatePage(editable);
        this.twkInit(this.pPage, false, WCGraphicsManager.getGraphicsManager().getDevicePixelScale());
        if (pageClient != null && pageClient.isBackBufferSupported()) {
            this.backbuffer = pageClient.createBackBuffer();
            this.backbuffer.ref();
        }
        if (!firstWebPageCreated) {
            Disposer.addRecord(new Object(), WebPage::collectJSCGarbages);
            firstWebPageCreated = true;
        }
    }

    long getPage() {
        return this.pPage;
    }

    private WCWidget getHostWindow() {
        return this.hostWindow;
    }

    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    static boolean lockPage() {
        return Invoker.getInvoker().lock(PAGE_LOCK);
    }

    static boolean unlockPage() {
        return Invoker.getInvoker().unlock(PAGE_LOCK);
    }

    private void addDirtyRect(WCRectangle toPaint) {
        if (toPaint.getWidth() <= 0.0f || toPaint.getHeight() <= 0.0f) {
            return;
        }
        Iterator<WCRectangle> it = this.dirtyRects.iterator();
        while (it.hasNext()) {
            WCRectangle rect = it.next();
            if (rect.contains(toPaint)) {
                return;
            }
            if (toPaint.contains(rect)) {
                it.remove();
                continue;
            }
            WCRectangle u = rect.createUnion(toPaint);
            if (u.getIntWidth() * u.getIntHeight() >= rect.getIntWidth() * rect.getIntHeight() + toPaint.getIntWidth() * toPaint.getIntHeight()) continue;
            it.remove();
            toPaint = u;
        }
        this.dirtyRects.add(toPaint);
    }

    public boolean isDirty() {
        WebPage.lockPage();
        try {
            boolean bl = !this.dirtyRects.isEmpty();
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDirty(WCRectangle clip) {
        if (paintLog.isLoggable(Level.FINEST)) {
            paintLog.log(Level.FINEST, "Entering, dirtyRects: {0}, currentFrame: {1}", new Object[]{this.dirtyRects, this.currentFrame});
        }
        if (this.isDisposed || this.width <= 0 || this.height <= 0) {
            this.dirtyRects.clear();
            return;
        }
        if (clip == null) {
            clip = new WCRectangle(0.0f, 0.0f, this.width, this.height);
        }
        List<WCRectangle> oldDirtyRects = this.dirtyRects;
        this.dirtyRects = new LinkedList<WCRectangle>();
        this.twkPrePaint(this.getPage());
        while (!oldDirtyRects.isEmpty()) {
            WCRectangle r = oldDirtyRects.remove(0).intersection(clip);
            if (r.getWidth() <= 0.0f || r.getHeight() <= 0.0f) continue;
            paintLog.log(Level.FINEST, "Updating: {0}", r);
            WCRenderQueue rq = WCGraphicsManager.getGraphicsManager().createRenderQueue(r, true);
            this.twkUpdateContent(this.getPage(), rq, r.getIntX() - 1, r.getIntY() - 1, r.getIntWidth() + 2, r.getIntHeight() + 2);
            this.currentFrame.addRenderQueue(rq);
        }
        WCRenderQueue rq = WCGraphicsManager.getGraphicsManager().createRenderQueue(clip, false);
        this.twkPostPaint(this.getPage(), rq, clip.getIntX(), clip.getIntY(), clip.getIntWidth(), clip.getIntHeight());
        this.currentFrame.addRenderQueue(rq);
        if (paintLog.isLoggable(Level.FINEST)) {
            paintLog.log(Level.FINEST, "Dirty rects processed, dirtyRects: {0}, currentFrame: {1}", new Object[]{this.dirtyRects, this.currentFrame});
        }
        if (this.currentFrame.getRQList().size() > 0) {
            Queue<RenderFrame> queue = this.frameQueue;
            synchronized (queue) {
                paintLog.log(Level.FINEST, "About to update frame queue, frameQueue: {0}", this.frameQueue);
                Iterator it = this.frameQueue.iterator();
                block4: while (it.hasNext()) {
                    RenderFrame frame = (RenderFrame)it.next();
                    for (WCRenderQueue rq2 : this.currentFrame.getRQList()) {
                        WCRectangle rqRect = rq2.getClip();
                        if (!rq2.isOpaque() || !rqRect.contains(frame.getEnclosingRect())) continue;
                        paintLog.log(Level.FINEST, "Dropping: {0}", frame);
                        frame.drop();
                        it.remove();
                        continue block4;
                    }
                }
                this.frameQueue.add(this.currentFrame);
                this.currentFrame = new RenderFrame();
                if (this.frameQueue.size() > 10) {
                    paintLog.log(Level.FINEST, "Frame queue exceeded maximum size, clearing and requesting full repaint");
                    this.dropRenderFrames();
                    this.repaintAll();
                }
                paintLog.log(Level.FINEST, "Frame queue updated, frameQueue: {0}", this.frameQueue);
            }
        }
        if (paintLog.isLoggable(Level.FINEST)) {
            paintLog.log(Level.FINEST, "Exiting, dirtyRects: {0}, currentFrame: {1}", new Object[]{this.dirtyRects, this.currentFrame});
        }
    }

    private void scroll(int x, int y, int w, int h, int dx, int dy) {
        if (paintLog.isLoggable(Level.FINEST)) {
            paintLog.finest("rect=[" + x + ", " + y + " " + w + "x" + h + "] delta=[" + dx + ", " + dy + "]");
        }
        if (Math.abs(dx += this.currentFrame.scrollDx) < w && Math.abs(dy += this.currentFrame.scrollDy) < h) {
            int cx = dx >= 0 ? x : x - dx;
            int cy = dy >= 0 ? y : y - dy;
            int cw = dx == 0 ? w : w - Math.abs(dx);
            int ch = dy == 0 ? h : h - Math.abs(dy);
            WCRenderQueue rq = WCGraphicsManager.getGraphicsManager().createRenderQueue(new WCRectangle(0.0f, 0.0f, this.width, this.height), false);
            ByteBuffer buffer = ByteBuffer.allocate(32).order(ByteOrder.nativeOrder()).putInt(40).putInt(this.backbuffer.getID()).putInt(cx).putInt(cy).putInt(cw).putInt(ch).putInt(dx).putInt(dy);
            buffer.flip();
            rq.addBuffer(buffer);
            this.currentFrame.drop();
            this.currentFrame.addRenderQueue(rq);
            this.currentFrame.scrollDx = dx;
            this.currentFrame.scrollDy = dy;
            if (!this.dirtyRects.isEmpty()) {
                WCRectangle scrollRect = new WCRectangle(x, y, w, h);
                for (WCRectangle r : this.dirtyRects) {
                    if (!scrollRect.contains(r)) continue;
                    if (paintLog.isLoggable(Level.FINEST)) {
                        paintLog.log(Level.FINEST, "translating old dirty rect by the delta: " + r);
                    }
                    r.translate(dx, dy);
                }
            }
        }
        this.addDirtyRect(new WCRectangle(x, dy >= 0 ? (float)y : (float)(y + h + dy), w, Math.abs(dy)));
        this.addDirtyRect(new WCRectangle(dx >= 0 ? (float)x : (float)(x + w + dx), y, Math.abs(dx), h - Math.abs(dy)));
    }

    public WebPageClient getPageClient() {
        return this.pageClient;
    }

    public void setInputMethodClient(InputMethodClient imClient) {
        this.imClient = imClient;
    }

    public void setInputMethodState(boolean state) {
        if (this.imClient != null) {
            this.imClient.activateInputMethods(state);
        }
    }

    public void addLoadListenerClient(LoadListenerClient l) {
        if (!this.loadListenerClients.contains(l)) {
            this.loadListenerClients.add(l);
        }
    }

    private RenderTheme getRenderTheme() {
        return this.renderTheme;
    }

    private static RenderTheme fwkGetDefaultRenderTheme() {
        return ThemeClient.getDefaultRenderTheme();
    }

    private ScrollBarTheme getScrollBarTheme() {
        return this.scrollbarTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int w, int h) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setBounds: " + x + " " + y + " " + w + " " + h);
            if (this.isDisposed) {
                log.log(Level.FINE, "setBounds() request for a disposed web page.");
                return;
            }
            this.width = w;
            this.height = h;
            this.twkSetBounds(this.getPage(), 0, 0, w, h);
            this.repaintAll();
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpaque(long frameID, boolean isOpaque) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setOpaque: " + isOpaque);
            if (this.isDisposed) {
                log.log(Level.FINE, "setOpaque() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(frameID)) {
                return;
            }
            this.twkSetTransparent(frameID, !isOpaque);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundColor(long frameID, int backgroundColor) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setBackgroundColor: " + backgroundColor);
            if (this.isDisposed) {
                log.log(Level.FINE, "setBackgroundColor() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(frameID)) {
                return;
            }
            this.twkSetBackgroundColor(frameID, backgroundColor);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundColor(int backgroundColor) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setBackgroundColor: " + backgroundColor + " for all frames");
            if (this.isDisposed) {
                log.log(Level.FINE, "setBackgroundColor() request for a disposed web page.");
                return;
            }
            for (long frameID : this.frames) {
                this.twkSetBackgroundColor(frameID, backgroundColor);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void updateContent(WCRectangle toPaint) {
        WebPage.lockPage();
        try {
            ++this.updateContentCycleID;
            paintLog.log(Level.FINEST, "toPaint: {0}", toPaint);
            if (this.isDisposed) {
                paintLog.fine("updateContent() request for a disposed web page.");
                return;
            }
            this.updateDirty(toPaint);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public int getUpdateContentCycleID() {
        return this.updateContentCycleID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepaintPending() {
        WebPage.lockPage();
        try {
            Queue<RenderFrame> queue = this.frameQueue;
            synchronized (queue) {
                boolean bl = !this.frameQueue.isEmpty();
                return bl;
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(WCGraphicsContext gc, int x, int y, int w, int h) {
        WebPage.lockPage();
        try {
            WCRenderQueue rq = WCGraphicsManager.getGraphicsManager().createRenderQueue(new WCRectangle(x, y, w, h), true);
            FutureTask<Object> f = new FutureTask<Object>(() -> this.twkUpdateContent(this.getPage(), rq, x, y, w, h), null);
            Invoker.getInvoker().invokeOnEventThread(f);
            try {
                f.get();
            }
            catch (ExecutionException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            rq.decode(gc);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(WCGraphicsContext gc, int x, int y, int w, int h) {
        block10: {
            WebPage.lockPage();
            try {
                if (this.pageClient != null && this.pageClient.isBackBufferSupported()) {
                    if (!this.backbuffer.validate(this.width, this.height)) {
                        Invoker.getInvoker().invokeOnEventThread(() -> this.repaintAll());
                        return;
                    }
                    WCGraphicsContext bgc = this.backbuffer.createGraphics();
                    try {
                        this.paint2GC(bgc);
                        bgc.flush();
                    }
                    finally {
                        this.backbuffer.disposeGraphics(bgc);
                    }
                    this.backbuffer.flush(gc, x, y, w, h);
                    break block10;
                }
                this.paint2GC(gc);
            }
            finally {
                WebPage.unlockPage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint2GC(WCGraphicsContext gc) {
        ArrayList<RenderFrame> framesToRender;
        paintLog.finest("Entering");
        gc.setFontSmoothingType(this.fontSmoothingType);
        Queue<RenderFrame> queue = this.frameQueue;
        synchronized (queue) {
            framesToRender = new ArrayList<RenderFrame>(this.frameQueue);
            this.frameQueue.clear();
        }
        paintLog.log(Level.FINEST, "Frames to render: {0}", framesToRender);
        for (RenderFrame frame : framesToRender) {
            paintLog.log(Level.FINEST, "Rendering: {0}", frame);
            for (WCRenderQueue rq : frame.getRQList()) {
                gc.saveState();
                if (rq.getClip() != null) {
                    gc.setClip(rq.getClip());
                }
                rq.decode(gc);
                gc.restoreState();
            }
        }
        paintLog.finest("Exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropRenderFrames() {
        WebPage.lockPage();
        try {
            this.currentFrame.drop();
            Queue<RenderFrame> queue = this.frameQueue;
            synchronized (queue) {
                RenderFrame frame = this.frameQueue.poll();
                while (frame != null) {
                    frame.drop();
                    frame = this.frameQueue.poll();
                }
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void dispatchFocusEvent(WCFocusEvent fe) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchFocusEvent: " + fe);
            if (this.isDisposed) {
                log.log(Level.FINE, "Focus event for a disposed web page.");
                return;
            }
            this.twkProcessFocusEvent(this.getPage(), fe.getID(), fe.getDirection());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean dispatchKeyEvent(WCKeyEvent ke) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchKeyEvent: " + ke);
            if (this.isDisposed) {
                log.log(Level.FINE, "Key event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            if (WCKeyEvent.filterEvent(ke)) {
                log.log(Level.FINEST, "filtered");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkProcessKeyEvent(this.getPage(), ke.getType(), ke.getText(), ke.getKeyIdentifier(), ke.getWindowsVirtualKeyCode(), ke.isShiftDown(), ke.isCtrlDown(), ke.isAltDown(), ke.isMetaDown(), (double)ke.getWhen() / 1000.0);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean dispatchMouseEvent(WCMouseEvent me) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchMouseEvent: " + me.getX() + "," + me.getY());
            if (this.isDisposed) {
                log.log(Level.FINE, "Mouse event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.isDragConfirmed() && this.twkProcessMouseEvent(this.getPage(), me.getID(), me.getButton(), me.getClickCount(), me.getX(), me.getY(), me.getScreenX(), me.getScreenY(), me.isShiftDown(), me.isControlDown(), me.isAltDown(), me.isMetaDown(), me.isPopupTrigger(), (double)me.getWhen() / 1000.0);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean dispatchMouseWheelEvent(WCMouseWheelEvent me) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchMouseWheelEvent: " + me);
            if (this.isDisposed) {
                log.log(Level.FINE, "MouseWheel event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkProcessMouseWheelEvent(this.getPage(), me.getX(), me.getY(), me.getScreenX(), me.getScreenY(), me.getDeltaX(), me.getDeltaY(), me.isShiftDown(), me.isControlDown(), me.isAltDown(), me.isMetaDown(), (double)me.getWhen() / 1000.0);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean dispatchInputMethodEvent(WCInputMethodEvent ie) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchInputMethodEvent: " + ie);
            if (this.isDisposed) {
                log.log(Level.FINE, "InputMethod event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            switch (ie.getID()) {
                case 0: {
                    boolean bl = this.twkProcessInputTextChange(this.getPage(), ie.getComposed(), ie.getCommitted(), ie.getAttributes(), ie.getCaretPosition());
                    return bl;
                }
                case 1: {
                    boolean bl = this.twkProcessCaretPositionChange(this.getPage(), ie.getCaretPosition());
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchDragOperation(int commandId, String[] mimeTypes, String[] values, int x, int y, int screenX, int screenY, int dndActionId) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchDragOperation: " + x + "," + y + " dndCommand:" + commandId + " dndAction" + dndActionId);
            if (this.isDisposed) {
                log.log(Level.FINE, "DnD event for a disposed web page.");
                int n = 0;
                return n;
            }
            int n = this.twkProcessDrag(this.getPage(), commandId, mimeTypes, values, x, y, screenX, screenY, dndActionId);
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void confirmStartDrag() {
        if (this.uiClient != null) {
            this.uiClient.confirmStartDrag();
        }
    }

    public boolean isDragConfirmed() {
        return this.uiClient != null ? this.uiClient.isDragConfirmed() : false;
    }

    public int[] getClientTextLocation(int index) {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientTextLocation() request for a disposed web page.");
                int[] nArray = new int[]{0, 0, 0, 0};
                return nArray;
            }
            int[] nArray = this.twkGetTextLocation(this.getPage(), index);
            return nArray;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientLocationOffset(int x, int y) {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientLocationOffset() request for a disposed web page.");
                int n = 0;
                return n;
            }
            int n = this.twkGetInsertPositionOffset(this.getPage());
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public int getClientInsertPositionOffset() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientInsertPositionOffset() request for a disposed web page.");
                int n = 0;
                return n;
            }
            int n = this.twkGetInsertPositionOffset(this.getPage());
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public int getClientCommittedTextLength() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientCommittedTextOffset() request for a disposed web page.");
                int n = 0;
                return n;
            }
            int n = this.twkGetCommittedTextLength(this.getPage());
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public String getClientCommittedText() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientCommittedText() request for a disposed web page.");
                String string = "";
                return string;
            }
            String string = this.twkGetCommittedText(this.getPage());
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public String getClientSelectedText() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientSelectedText() request for a disposed web page.");
                String string = "";
                return string;
            }
            String string = this.twkGetSelectedText(this.getPage());
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        WebPage.lockPage();
        try {
            log.log(Level.FINER, "dispose");
            this.stop();
            this.dropRenderFrames();
            this.isDisposed = true;
            this.twkDestroyPage(this.pPage);
            this.pPage = 0L;
            for (long frameID : this.frames) {
                log.log(Level.FINE, "Undestroyed frame view: " + frameID);
            }
            this.frames.clear();
            if (this.backbuffer != null) {
                this.backbuffer.deref();
                this.backbuffer = null;
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get Name: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getName() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(frameID)) {
                String string = null;
                return string;
            }
            String string = this.twkGetName(frameID);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get URL: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getURL() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(frameID)) {
                String string = null;
                return string;
            }
            String string = this.twkGetURL(frameID);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public String getEncoding() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get encoding");
            if (this.isDisposed) {
                log.log(Level.FINE, "getEncoding() request for a disposed web page.");
                String string = null;
                return string;
            }
            String string = this.twkGetEncoding(this.getPage());
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setEncoding(String encoding) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Set encoding: encoding = " + encoding);
            if (this.isDisposed) {
                log.log(Level.FINE, "setEncoding() request for a disposed web page.");
                return;
            }
            if (encoding != null && !encoding.isEmpty()) {
                this.twkSetEncoding(this.getPage(), encoding);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerText(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get inner text: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getInnerText() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(frameID)) {
                String string = null;
                return string;
            }
            String string = this.twkGetInnerText(frameID);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderTree(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get render tree: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getRenderTree() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(frameID)) {
                String string = null;
                return string;
            }
            String string = this.twkGetRenderTree(frameID);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnloadEventListenersCount(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "frame: " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "request for a disposed web page.");
                int n = 0;
                return n;
            }
            if (!this.frames.contains(frameID)) {
                int n = 0;
                return n;
            }
            int n = this.twkGetUnloadEventListenersCount(frameID);
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get content type: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getContentType() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(frameID)) {
                String string = null;
                return string;
            }
            String string = this.twkGetContentType(frameID);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get title: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getTitle() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(frameID)) {
                String string = null;
                return string;
            }
            String string = this.twkGetTitle(frameID);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCImage getIcon(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get icon: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getIcon() request for a disposed web page.");
                WCImage wCImage = null;
                return wCImage;
            }
            if (!this.frames.contains(frameID)) {
                WCImage wCImage = null;
                return wCImage;
            }
            String iconURL = this.twkGetIconURL(frameID);
            if (iconURL != null && !iconURL.isEmpty()) {
                WCImage wCImage = WCGraphicsManager.getGraphicsManager().getIconImage(iconURL);
                return wCImage;
            }
            WCImage wCImage = null;
            return wCImage;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(long frameID, String url) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Open URL: " + url);
            if (this.isDisposed) {
                log.log(Level.FINE, "open() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(frameID)) {
                return;
            }
            if (this.twkIsLoading(frameID)) {
                Invoker.getInvoker().postOnEventThread(() -> this.twkOpen(frameID, url));
            } else {
                this.twkOpen(frameID, url);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(long frameID, String text, String contentType) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Load text: " + text);
            if (text == null) {
                return;
            }
            if (this.isDisposed) {
                log.log(Level.FINE, "load() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(frameID)) {
                return;
            }
            if (this.twkIsLoading(frameID)) {
                Invoker.getInvoker().postOnEventThread(() -> this.twkLoad(frameID, text, contentType));
            } else {
                this.twkLoad(frameID, text, contentType);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Stop loading: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "cancel() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(frameID)) {
                return;
            }
            String url = this.twkGetURL(frameID);
            String contentType = this.twkGetContentType(frameID);
            this.twkStop(frameID);
            this.fireLoadEvent(frameID, 6, url, contentType, 1.0, 0);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void stop() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Stop loading sync");
            if (this.isDisposed) {
                log.log(Level.FINE, "stopAll() request for a disposed web page.");
                return;
            }
            this.twkStopAll(this.getPage());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void refresh(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Refresh: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "refresh() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(frameID)) {
                return;
            }
            this.twkRefresh(frameID);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public BackForwardList createBackForwardList() {
        return new BackForwardList(this);
    }

    public boolean goBack() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Go back");
            if (this.isDisposed) {
                log.log(Level.FINE, "goBack() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkGoBackForward(this.getPage(), -1);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean goForward() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Go forward");
            if (this.isDisposed) {
                log.log(Level.FINE, "goForward() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkGoBackForward(this.getPage(), 1);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Copy");
            if (this.isDisposed) {
                log.log(Level.FINE, "copy() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            long frameID = this.getMainFrame();
            if (!this.frames.contains(frameID)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkCopy(frameID);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean find(String stringToFind, boolean forward, boolean wrap, boolean matchCase) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Find in page: stringToFind = " + stringToFind + ", " + (forward ? "forward" : "backward") + (wrap ? ", wrap" : "") + (matchCase ? ", matchCase" : ""));
            if (this.isDisposed) {
                log.log(Level.FINE, "find() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkFindInPage(this.getPage(), stringToFind, forward, wrap, matchCase);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean find(long frameID, String stringToFind, boolean forward, boolean wrap, boolean matchCase) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Find in frame: stringToFind = " + stringToFind + ", " + (forward ? "forward" : "backward") + (wrap ? ", wrap" : "") + (matchCase ? ", matchCase" : ""));
            if (this.isDisposed) {
                log.log(Level.FINE, "find() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            if (!this.frames.contains(frameID)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkFindInFrame(frameID, stringToFind, forward, wrap, matchCase);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void overridePreference(String key, String value) {
        WebPage.lockPage();
        try {
            this.twkOverridePreference(this.getPage(), key, value);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void resetToConsistentStateBeforeTesting() {
        WebPage.lockPage();
        try {
            this.twkResetToConsistentStateBeforeTesting(this.getPage());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getZoomFactor(boolean textOnly) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get zoom factor, textOnly=" + textOnly);
            if (this.isDisposed) {
                log.log(Level.FINE, "getZoomFactor() request for a disposed web page.");
                float f = 1.0f;
                return f;
            }
            long frameID = this.getMainFrame();
            if (!this.frames.contains(frameID)) {
                float f = 1.0f;
                return f;
            }
            float f = this.twkGetZoomFactor(frameID, textOnly);
            return f;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomFactor(float zoomFactor, boolean textOnly) {
        WebPage.lockPage();
        try {
            log.fine(String.format("Set zoom factor %.2f, textOnly=%b", Float.valueOf(zoomFactor), textOnly));
            if (this.isDisposed) {
                log.log(Level.FINE, "setZoomFactor() request for a disposed web page.");
                return;
            }
            long frameID = this.getMainFrame();
            if (frameID == 0L || !this.frames.contains(frameID)) {
                return;
            }
            this.twkSetZoomFactor(frameID, zoomFactor, textOnly);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setFontSmoothingType(int fontSmoothingType) {
        this.fontSmoothingType = fontSmoothingType;
        this.repaintAll();
    }

    public void reset(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Reset: frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "reset() request for a disposed web page.");
                return;
            }
            if (frameID == 0L || !this.frames.contains(frameID)) {
                return;
            }
            this.twkReset(frameID);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(long frameID, String script) throws JSException {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "execute script: \"" + script + "\" in frame = " + frameID);
            if (this.isDisposed) {
                log.log(Level.FINE, "executeScript() request for a disposed web page.");
                Object var4_3 = null;
                return var4_3;
            }
            if (frameID == 0L || !this.frames.contains(frameID)) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = this.twkExecuteScript(frameID, script);
            return object;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMainFrame() {
        WebPage.lockPage();
        try {
            log.log(Level.FINER, "getMainFrame: page = " + this.pPage);
            if (this.isDisposed) {
                log.log(Level.FINE, "getMainFrame() request for a disposed web page.");
                long l = 0L;
                return l;
            }
            long mainFrameID = this.twkGetMainFrame(this.getPage());
            log.log(Level.FINER, "Main frame = " + mainFrameID);
            this.frames.add(mainFrameID);
            long l = mainFrameID;
            return l;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getParentFrame(long childID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getParentFrame: child = " + childID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getParentFrame() request for a disposed web page.");
                long l = 0L;
                return l;
            }
            if (!this.frames.contains(childID)) {
                long l = 0L;
                return l;
            }
            long l = this.twkGetParentFrame(childID);
            return l;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getChildFrames(long parentID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getChildFrames: parent = " + parentID);
            if (this.isDisposed) {
                log.log(Level.FINE, "getChildFrames() request for a disposed web page.");
                List<Long> list = null;
                return list;
            }
            if (!this.frames.contains(parentID)) {
                List<Long> list = null;
                return list;
            }
            long[] children = this.twkGetChildFrames(parentID);
            LinkedList<Long> childrenList = new LinkedList<Long>();
            for (long child : children) {
                childrenList.add(child);
            }
            LinkedList<Long> linkedList = childrenList;
            return linkedList;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCRectangle getVisibleRect(long frameID) {
        WebPage.lockPage();
        try {
            if (!this.frames.contains(frameID)) {
                WCRectangle wCRectangle = null;
                return wCRectangle;
            }
            int[] arr = this.twkGetVisibleRect(frameID);
            if (arr != null) {
                WCRectangle wCRectangle = new WCRectangle(arr[0], arr[1], arr[2], arr[3]);
                return wCRectangle;
            }
            WCRectangle wCRectangle = null;
            return wCRectangle;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToPosition(long frameID, WCPoint p) {
        WebPage.lockPage();
        try {
            if (!this.frames.contains(frameID)) {
                return;
            }
            this.twkScrollToPosition(frameID, p.getIntX(), p.getIntY());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCSize getContentSize(long frameID) {
        WebPage.lockPage();
        try {
            if (!this.frames.contains(frameID)) {
                WCSize wCSize = null;
                return wCSize;
            }
            int[] arr = this.twkGetContentSize(frameID);
            if (arr != null) {
                WCSize wCSize = new WCSize(arr[0], arr[1]);
                return wCSize;
            }
            WCSize wCSize = null;
            return wCSize;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getDocument");
            if (this.isDisposed) {
                log.log(Level.FINE, "getDocument() request for a disposed web page.");
                Document document = null;
                return document;
            }
            if (!this.frames.contains(frameID)) {
                Document document = null;
                return document;
            }
            Document document = WebPage.twkGetDocument(frameID);
            return document;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getOwnerElement(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getOwnerElement");
            if (this.isDisposed) {
                log.log(Level.FINE, "getOwnerElement() request for a disposed web page.");
                Element element = null;
                return element;
            }
            if (!this.frames.contains(frameID)) {
                Element element = null;
                return element;
            }
            Element element = WebPage.twkGetOwnerElement(frameID);
            return element;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(String command, String value) {
        WebPage.lockPage();
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "command: [{0}], value: [{1}]", new Object[]{command, value});
            }
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                boolean bl = false;
                return bl;
            }
            boolean result = this.twkExecuteCommand(this.getPage(), command, value);
            log.log(Level.FINE, "result: [{0}]", result);
            boolean bl = result;
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryCommandEnabled(String command) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "command: [{0}]", command);
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                boolean bl = false;
                return bl;
            }
            boolean result = this.twkQueryCommandEnabled(this.getPage(), command);
            log.log(Level.FINE, "result: [{0}]", result);
            boolean bl = result;
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryCommandState(String command) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "command: [{0}]", command);
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                boolean bl = false;
                return bl;
            }
            boolean result = this.twkQueryCommandState(this.getPage(), command);
            log.log(Level.FINE, "result: [{0}]", result);
            boolean bl = result;
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryCommandValue(String command) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "command: [{0}]", command);
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                String string = null;
                return string;
            }
            String result = this.twkQueryCommandValue(this.getPage(), command);
            log.log(Level.FINE, "result: [{0}]", result);
            String string = result;
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean isEditable() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "isEditable");
            if (this.isDisposed) {
                log.log(Level.FINE, "isEditable() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkIsEditable(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setEditable(boolean editable) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setEditable");
            if (this.isDisposed) {
                log.log(Level.FINE, "setEditable() request for a disposed web page.");
                return;
            }
            this.twkSetEditable(this.getPage(), editable);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtml(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getHtml");
            if (this.isDisposed) {
                log.log(Level.FINE, "getHtml() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(frameID)) {
                String string = null;
                return string;
            }
            String string = this.twkGetHtml(frameID);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int beginPrinting(float width, float height) {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.warning("beginPrinting() called for a disposed web page.");
                int n = 0;
                return n;
            }
            AtomicReference<Integer> retVal = new AtomicReference<Integer>(0);
            CountDownLatch l = new CountDownLatch(1);
            Invoker.getInvoker().invokeOnEventThread(() -> {
                try {
                    int nPages = this.twkBeginPrinting(this.getPage(), width, height);
                    retVal.set(nPages);
                }
                finally {
                    l.countDown();
                }
            });
            try {
                l.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            int n = retVal.get();
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void endPrinting() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.warning("endPrinting() called for a disposed web page.");
                return;
            }
            CountDownLatch l = new CountDownLatch(1);
            Invoker.getInvoker().invokeOnEventThread(() -> {
                try {
                    this.twkEndPrinting(this.getPage());
                }
                finally {
                    l.countDown();
                }
            });
            try {
                l.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(WCGraphicsContext gc, int pageNumber, float width) {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.warning("print() called for a disposed web page.");
                return;
            }
            WCRenderQueue rq = WCGraphicsManager.getGraphicsManager().createRenderQueue(null, true);
            CountDownLatch l = new CountDownLatch(1);
            Invoker.getInvoker().invokeOnEventThread(() -> {
                try {
                    this.twkPrint(this.getPage(), rq, pageNumber, width);
                }
                finally {
                    l.countDown();
                }
            });
            try {
                l.await();
            }
            catch (InterruptedException e) {
                rq.dispose();
                WebPage.unlockPage();
                return;
            }
            rq.decode(gc);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public int getPageHeight() {
        return this.getFrameHeight(this.getMainFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrameHeight(long frameID) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get page height");
            if (this.isDisposed) {
                log.log(Level.FINE, "getFrameHeight() request for a disposed web page.");
                int n = 0;
                return n;
            }
            if (!this.frames.contains(frameID)) {
                int n = 0;
                return n;
            }
            int height = this.twkGetFrameHeight(frameID);
            log.log(Level.FINE, "Height = " + height);
            int n = height;
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float adjustFrameHeight(long frameID, float oldTop, float oldBottom, float bottomLimit) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Adjust page height");
            if (this.isDisposed) {
                log.log(Level.FINE, "adjustFrameHeight() request for a disposed web page.");
                float f = 0.0f;
                return f;
            }
            if (!this.frames.contains(frameID)) {
                float f = 0.0f;
                return f;
            }
            float f = this.twkAdjustFrameHeight(frameID, oldTop, oldBottom, bottomLimit);
            return f;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean getUsePageCache() {
        WebPage.lockPage();
        try {
            boolean bl = this.twkGetUsePageCache(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setUsePageCache(boolean usePageCache) {
        WebPage.lockPage();
        try {
            this.twkSetUsePageCache(this.getPage(), usePageCache);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean getDeveloperExtrasEnabled() {
        WebPage.lockPage();
        try {
            boolean result = this.twkGetDeveloperExtrasEnabled(this.getPage());
            log.log(Level.FINE, "Getting developerExtrasEnabled, result: [{0}]", result);
            boolean bl = result;
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setDeveloperExtrasEnabled(boolean enabled) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Setting developerExtrasEnabled, value: [{0}]", enabled);
            this.twkSetDeveloperExtrasEnabled(this.getPage(), enabled);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean isJavaScriptEnabled() {
        WebPage.lockPage();
        try {
            boolean bl = this.twkIsJavaScriptEnabled(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setJavaScriptEnabled(boolean enable) {
        WebPage.lockPage();
        try {
            this.twkSetJavaScriptEnabled(this.getPage(), enable);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public boolean isContextMenuEnabled() {
        WebPage.lockPage();
        try {
            boolean bl = this.twkIsContextMenuEnabled(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setContextMenuEnabled(boolean enable) {
        WebPage.lockPage();
        try {
            this.twkSetContextMenuEnabled(this.getPage(), enable);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setUserStyleSheetLocation(String url) {
        WebPage.lockPage();
        try {
            this.twkSetUserStyleSheetLocation(this.getPage(), url);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public String getUserAgent() {
        WebPage.lockPage();
        try {
            String string = this.twkGetUserAgent(this.getPage());
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setUserAgent(String userAgent) {
        WebPage.lockPage();
        try {
            this.twkSetUserAgent(this.getPage(), userAgent);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setLocalStorageDatabasePath(String path) {
        WebPage.lockPage();
        try {
            this.twkSetLocalStorageDatabasePath(this.getPage(), path);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setLocalStorageEnabled(boolean enabled) {
        WebPage.lockPage();
        try {
            this.twkSetLocalStorageEnabled(this.getPage(), enabled);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void connectInspectorFrontend() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Connecting inspector frontend");
            this.twkConnectInspectorFrontend(this.getPage());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void disconnectInspectorFrontend() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Disconnecting inspector frontend");
            this.twkDisconnectInspectorFrontend(this.getPage());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void dispatchInspectorMessageFromFrontend(String message) {
        WebPage.lockPage();
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Dispatching inspector message from frontend, message: [{0}]", message);
            }
            this.twkDispatchInspectorMessageFromFrontend(this.getPage(), message);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    private void fwkFrameCreated(long frameID) {
        log.log(Level.FINE, "Frame created: frame = " + frameID);
        if (this.frames.contains(frameID)) {
            log.log(Level.FINE, "Error in fwkFrameCreated: frame is already in frames");
            return;
        }
        this.frames.add(frameID);
    }

    private void fwkFrameDestroyed(long frameID) {
        log.log(Level.FINE, "Frame destroyed: frame = " + frameID);
        if (!this.frames.contains(frameID)) {
            log.log(Level.FINE, "Error in fwkFrameDestroyed: frame is not found in frames");
            return;
        }
        this.frames.remove(frameID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwkRepaint(int x, int y, int w, int h) {
        WebPage.lockPage();
        try {
            if (paintLog.isLoggable(Level.FINEST)) {
                paintLog.log(Level.FINEST, "x: {0}, y: {1}, w: {2}, h: {3}", new Object[]{x, y, w, h});
            }
            this.addDirtyRect(new WCRectangle(x, y, w, h));
        }
        finally {
            WebPage.unlockPage();
        }
    }

    private void fwkScroll(int x, int y, int w, int h, int deltaX, int deltaY) {
        if (paintLog.isLoggable(Level.FINEST)) {
            paintLog.finest("Scroll: " + x + " " + y + " " + w + " " + h + "  " + deltaX + " " + deltaY);
        }
        if (this.pageClient == null || !this.pageClient.isBackBufferSupported()) {
            paintLog.finest("blit scrolling is switched off");
            return;
        }
        this.scroll(x, y, w, h, deltaX, deltaY);
    }

    private void fwkTransferFocus(boolean forward) {
        log.log(Level.FINER, "Transfer focus " + (forward ? "forward" : "backward"));
        if (this.pageClient != null) {
            this.pageClient.transferFocus(forward);
        }
    }

    private void fwkSetCursor(long id) {
        log.log(Level.FINER, "Set cursor: " + id);
        if (this.pageClient != null) {
            this.pageClient.setCursor(id);
        }
    }

    private void fwkSetFocus(boolean focus) {
        log.log(Level.FINER, "Set focus: " + (focus ? "true" : "false"));
        if (this.pageClient != null) {
            this.pageClient.setFocus(focus);
        }
    }

    private void fwkSetTooltip(String tooltip) {
        log.log(Level.FINER, "Set tooltip: " + tooltip);
        if (this.pageClient != null) {
            this.pageClient.setTooltip(tooltip);
        }
    }

    private void fwkPrint() {
        log.log(Level.FINER, "Print");
        if (this.uiClient != null) {
            this.uiClient.print();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwkSetRequestURL(long pFrame, int id, String url) {
        log.log(Level.FINER, "Set request URL: id = " + id + ", url = " + url);
        Map<Integer, String> map = this.requestURLs;
        synchronized (map) {
            this.requestURLs.put(id, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwkRemoveRequestURL(long pFrame, int id) {
        log.log(Level.FINER, "Set request URL: id = " + id);
        Map<Integer, String> map = this.requestURLs;
        synchronized (map) {
            this.requestURLs.remove(id);
            this.requestStarted.remove(id);
        }
    }

    private WebPage fwkCreateWindow(boolean menu, boolean status, boolean toolbar, boolean resizable) {
        log.log(Level.FINER, "Create window");
        if (this.uiClient != null) {
            return this.uiClient.createPage(menu, status, toolbar, resizable);
        }
        return null;
    }

    private void fwkShowWindow() {
        log.log(Level.FINER, "Show window");
        if (this.uiClient != null) {
            this.uiClient.showView();
        }
    }

    private void fwkCloseWindow() {
        log.log(Level.FINER, "Close window");
        if (this.permitCloseWindowAction() && this.uiClient != null) {
            this.uiClient.closePage();
        }
    }

    private WCRectangle fwkGetWindowBounds() {
        WCRectangle bounds;
        log.log(Level.FINE, "Get window bounds");
        if (this.uiClient != null && (bounds = this.uiClient.getViewBounds()) != null) {
            return bounds;
        }
        return this.fwkGetPageBounds();
    }

    private void fwkSetWindowBounds(int x, int y, int w, int h) {
        log.log(Level.FINER, "Set window bounds: " + x + " " + y + " " + w + " " + h);
        if (this.uiClient != null) {
            this.uiClient.setViewBounds(new WCRectangle(x, y, w, h));
        }
    }

    private WCRectangle fwkGetPageBounds() {
        log.log(Level.FINER, "Get page bounds");
        return new WCRectangle(0.0f, 0.0f, this.width, this.height);
    }

    private void fwkSetScrollbarsVisible(boolean visible) {
    }

    private void fwkSetStatusbarText(String text) {
        log.log(Level.FINER, "Set statusbar text: " + text);
        if (this.uiClient != null) {
            this.uiClient.setStatusbarText(text);
        }
    }

    private String[] fwkChooseFile(String initialFileName, boolean multiple, String mimeFilters) {
        log.log(Level.FINER, "Choose file, initial=" + initialFileName);
        return this.uiClient != null ? this.uiClient.chooseFile(initialFileName, multiple, mimeFilters) : null;
    }

    private void fwkStartDrag(Object image, int imageOffsetX, int imageOffsetY, int eventPosX, int eventPosY, String[] mimeTypes, Object[] values) {
        log.log(Level.FINER, "Start drag: ");
        if (this.uiClient != null) {
            this.uiClient.startDrag(WCImage.getImage(image), imageOffsetX, imageOffsetY, eventPosX, eventPosY, mimeTypes, values);
        }
    }

    private WCPoint fwkScreenToWindow(WCPoint ptScreen) {
        log.log(Level.FINER, "fwkScreenToWindow");
        if (this.pageClient != null) {
            return this.pageClient.screenToWindow(ptScreen);
        }
        return ptScreen;
    }

    private WCPoint fwkWindowToScreen(WCPoint ptWindow) {
        log.log(Level.FINER, "fwkWindowToScreen");
        if (this.pageClient != null) {
            return this.pageClient.windowToScreen(ptWindow);
        }
        return ptWindow;
    }

    private void fwkAlert(String text) {
        log.log(Level.FINE, "JavaScript alert(): text = " + text);
        if (this.uiClient != null) {
            this.uiClient.alert(text);
        }
    }

    private boolean fwkConfirm(String text) {
        log.log(Level.FINE, "JavaScript confirm(): text = " + text);
        if (this.uiClient != null) {
            return this.uiClient.confirm(text);
        }
        return false;
    }

    private String fwkPrompt(String text, String defaultValue) {
        log.log(Level.FINE, "JavaScript prompt(): text = " + text + ", default = " + defaultValue);
        if (this.uiClient != null) {
            return this.uiClient.prompt(text, defaultValue);
        }
        return null;
    }

    private void fwkAddMessageToConsole(String message, int lineNumber, String sourceId) {
        log.log(Level.FINE, "fwkAddMessageToConsole(): message = " + message + ", lineNumber = " + lineNumber + ", sourceId = " + sourceId);
        if (this.pageClient != null) {
            this.pageClient.addMessageToConsole(message, lineNumber, sourceId);
        }
    }

    private void fwkFireLoadEvent(long frameID, int state, String url, String contentType, double progress, int errorCode) {
        log.log(Level.FINER, "Load event: pFrame = " + frameID + ", state = " + state + ", url = " + url + ", contenttype=" + contentType + ", progress = " + progress + ", error = " + errorCode);
        this.fireLoadEvent(frameID, state, url, contentType, progress, errorCode);
    }

    private void fwkFireResourceLoadEvent(long frameID, int state, int id, String contentType, double progress, int errorCode) {
        log.log(Level.FINER, "Resource load event: pFrame = " + frameID + ", state = " + state + ", id = " + id + ", contenttype=" + contentType + ", progress = " + progress + ", error = " + errorCode);
        String url = this.requestURLs.get(id);
        if (url == null) {
            log.log(Level.FINE, "Error in fwkFireResourceLoadEvent: unknown request id " + id);
            return;
        }
        int eventState = state;
        if (state == 20) {
            if (this.requestStarted.contains(id)) {
                eventState = 21;
            } else {
                this.requestStarted.add(id);
            }
        }
        this.fireResourceLoadEvent(frameID, eventState, url, contentType, progress, errorCode);
    }

    private boolean fwkPermitNavigateAction(long pFrame, String url) {
        log.log(Level.FINE, "Policy: permit NAVIGATE: pFrame = " + pFrame + ", url = " + url);
        if (this.policyClient != null) {
            return this.policyClient.permitNavigateAction(pFrame, this.str2url(url));
        }
        return true;
    }

    private boolean fwkPermitRedirectAction(long pFrame, String url) {
        log.log(Level.FINE, "Policy: permit REDIRECT: pFrame = " + pFrame + ", url = " + url);
        if (this.policyClient != null) {
            return this.policyClient.permitRedirectAction(pFrame, this.str2url(url));
        }
        return true;
    }

    private boolean fwkPermitAcceptResourceAction(long pFrame, String url) {
        log.log(Level.FINE, "Policy: permit ACCEPT_RESOURCE: pFrame + " + pFrame + ", url = " + url);
        if (this.policyClient != null) {
            return this.policyClient.permitAcceptResourceAction(pFrame, this.str2url(url));
        }
        return true;
    }

    private boolean fwkPermitSubmitDataAction(long pFrame, String url, String httpMethod, boolean isSubmit) {
        log.log(Level.FINE, "Policy: permit " + (isSubmit ? "" : "RE") + "SUBMIT_DATA: pFrame = " + pFrame + ", url = " + url + ", httpMethod = " + httpMethod);
        if (this.policyClient != null) {
            if (isSubmit) {
                return this.policyClient.permitSubmitDataAction(pFrame, this.str2url(url), httpMethod);
            }
            return this.policyClient.permitResubmitDataAction(pFrame, this.str2url(url), httpMethod);
        }
        return true;
    }

    private boolean fwkPermitEnableScriptsAction(long pFrame, String url) {
        log.log(Level.FINE, "Policy: permit ENABLE_SCRIPTS: pFrame + " + pFrame + ", url = " + url);
        if (this.policyClient != null) {
            return this.policyClient.permitEnableScriptsAction(pFrame, this.str2url(url));
        }
        return true;
    }

    private boolean fwkPermitNewWindowAction(long pFrame, String url) {
        log.log(Level.FINE, "Policy: permit NEW_PAGE: pFrame = " + pFrame + ", url = " + url);
        if (this.policyClient != null) {
            return this.policyClient.permitNewPageAction(pFrame, this.str2url(url));
        }
        return true;
    }

    private boolean permitCloseWindowAction() {
        log.log(Level.FINE, "Policy: permit CLOSE_PAGE");
        if (this.policyClient != null) {
            return this.policyClient.permitClosePageAction(this.getMainFrame());
        }
        return true;
    }

    private void fwkRepaintAll() {
        log.log(Level.FINE, "Repainting the entire page");
        this.repaintAll();
    }

    private boolean fwkSendInspectorMessageToFrontend(String message) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Sending inspector message to frontend, message: [{0}]", message);
        }
        boolean result = false;
        if (this.inspectorClient != null) {
            log.log(Level.FINE, "Invoking inspector client");
            result = this.inspectorClient.sendMessageToFrontend(message);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Result: [{0}]", result);
        }
        return result;
    }

    public static int getWorkerThreadCount() {
        return WebPage.twkWorkerThreadCount();
    }

    private static native int twkWorkerThreadCount();

    private void fwkDidClearWindowObject(long pContext, long pWindowObject) {
        if (this.pageClient != null) {
            this.pageClient.didClearWindowObject(pContext, pWindowObject);
        }
    }

    private URL str2url(String url) {
        try {
            return URLs.newURL(url);
        }
        catch (MalformedURLException ex) {
            log.log(Level.FINE, "Exception while converting \"" + url + "\" to URL", ex);
            return null;
        }
    }

    private void fireLoadEvent(long frameID, int state, String url, String contentType, double progress, int errorCode) {
        for (LoadListenerClient l : this.loadListenerClients) {
            l.dispatchLoadEvent(frameID, state, url, contentType, progress, errorCode);
        }
    }

    private void fireResourceLoadEvent(long frameID, int state, String url, String contentType, double progress, int errorCode) {
        for (LoadListenerClient l : this.loadListenerClients) {
            l.dispatchResourceLoadEvent(frameID, state, url, contentType, progress, errorCode);
        }
    }

    private void repaintAll() {
        this.dirtyRects.clear();
        this.addDirtyRect(new WCRectangle(0.0f, 0.0f, this.width, this.height));
    }

    private static native void twkInitWebCore(boolean var0, boolean var1);

    private native long twkCreatePage(boolean var1);

    private native void twkInit(long var1, boolean var3, float var4);

    private native void twkDestroyPage(long var1);

    private native long twkGetMainFrame(long var1);

    private native long twkGetParentFrame(long var1);

    private native long[] twkGetChildFrames(long var1);

    private native String twkGetName(long var1);

    private native String twkGetURL(long var1);

    private native String twkGetInnerText(long var1);

    private native String twkGetRenderTree(long var1);

    private native String twkGetContentType(long var1);

    private native String twkGetTitle(long var1);

    private native String twkGetIconURL(long var1);

    private static native Document twkGetDocument(long var0);

    private static native Element twkGetOwnerElement(long var0);

    private native void twkOpen(long var1, String var3);

    private native void twkOverridePreference(long var1, String var3, String var4);

    private native void twkResetToConsistentStateBeforeTesting(long var1);

    private native void twkLoad(long var1, String var3, String var4);

    private native boolean twkIsLoading(long var1);

    private native void twkStop(long var1);

    private native void twkStopAll(long var1);

    private native void twkRefresh(long var1);

    private native boolean twkGoBackForward(long var1, int var3);

    private native boolean twkCopy(long var1);

    private native boolean twkFindInPage(long var1, String var3, boolean var4, boolean var5, boolean var6);

    private native boolean twkFindInFrame(long var1, String var3, boolean var4, boolean var5, boolean var6);

    private native float twkGetZoomFactor(long var1, boolean var3);

    private native void twkSetZoomFactor(long var1, float var3, boolean var4);

    private native Object twkExecuteScript(long var1, String var3);

    private native void twkReset(long var1);

    private native int twkGetFrameHeight(long var1);

    private native int twkBeginPrinting(long var1, float var3, float var4);

    private native void twkEndPrinting(long var1);

    private native void twkPrint(long var1, WCRenderQueue var3, int var4, float var5);

    private native float twkAdjustFrameHeight(long var1, float var3, float var4, float var5);

    private native int[] twkGetVisibleRect(long var1);

    private native void twkScrollToPosition(long var1, int var3, int var4);

    private native int[] twkGetContentSize(long var1);

    private native void twkSetTransparent(long var1, boolean var3);

    private native void twkSetBackgroundColor(long var1, int var3);

    private native void twkSetBounds(long var1, int var3, int var4, int var5, int var6);

    private native void twkPrePaint(long var1);

    private native void twkUpdateContent(long var1, WCRenderQueue var3, int var4, int var5, int var6, int var7);

    private native void twkPostPaint(long var1, WCRenderQueue var3, int var4, int var5, int var6, int var7);

    private native String twkGetEncoding(long var1);

    private native void twkSetEncoding(long var1, String var3);

    private native void twkProcessFocusEvent(long var1, int var3, int var4);

    private native boolean twkProcessKeyEvent(long var1, int var3, String var4, String var5, int var6, boolean var7, boolean var8, boolean var9, boolean var10, double var11);

    private native boolean twkProcessMouseEvent(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, double var15);

    private native boolean twkProcessMouseWheelEvent(long var1, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, boolean var10, boolean var11, boolean var12, double var13);

    private native boolean twkProcessInputTextChange(long var1, String var3, String var4, int[] var5, int var6);

    private native boolean twkProcessCaretPositionChange(long var1, int var3);

    private native int[] twkGetTextLocation(long var1, int var3);

    private native int twkGetInsertPositionOffset(long var1);

    private native int twkGetCommittedTextLength(long var1);

    private native String twkGetCommittedText(long var1);

    private native String twkGetSelectedText(long var1);

    private native int twkProcessDrag(long var1, int var3, String[] var4, String[] var5, int var6, int var7, int var8, int var9, int var10);

    private native boolean twkExecuteCommand(long var1, String var3, String var4);

    private native boolean twkQueryCommandEnabled(long var1, String var3);

    private native boolean twkQueryCommandState(long var1, String var3);

    private native String twkQueryCommandValue(long var1, String var3);

    private native boolean twkIsEditable(long var1);

    private native void twkSetEditable(long var1, boolean var3);

    private native String twkGetHtml(long var1);

    private native boolean twkGetUsePageCache(long var1);

    private native void twkSetUsePageCache(long var1, boolean var3);

    private native boolean twkGetDeveloperExtrasEnabled(long var1);

    private native void twkSetDeveloperExtrasEnabled(long var1, boolean var3);

    private native boolean twkIsJavaScriptEnabled(long var1);

    private native void twkSetJavaScriptEnabled(long var1, boolean var3);

    private native boolean twkIsContextMenuEnabled(long var1);

    private native void twkSetContextMenuEnabled(long var1, boolean var3);

    private native void twkSetUserStyleSheetLocation(long var1, String var3);

    private native String twkGetUserAgent(long var1);

    private native void twkSetUserAgent(long var1, String var3);

    private native void twkSetLocalStorageDatabasePath(long var1, String var3);

    private native void twkSetLocalStorageEnabled(long var1, boolean var3);

    private native int twkGetUnloadEventListenersCount(long var1);

    private native void twkConnectInspectorFrontend(long var1);

    private native void twkDisconnectInspectorFrontend(long var1);

    private native void twkDispatchInspectorMessageFromFrontend(long var1, String var3);

    private static native void twkDoJSCGarbageCollection();

    static {
        AccessController.doPrivileged(() -> {
            boolean setDefault;
            NativeLibLoader.loadLibrary("jfxwebkit");
            log.finer("jfxwebkit loaded");
            if (CookieHandler.getDefault() == null && (setDefault = Boolean.valueOf(System.getProperty("com.sun.webkit.setDefaultCookieHandler", "true")).booleanValue())) {
                CookieHandler.setDefault(new CookieManager());
            }
            boolean useJIT = Boolean.valueOf(System.getProperty("com.sun.webkit.useJIT", "true"));
            boolean useDFGJIT = Boolean.valueOf(System.getProperty("com.sun.webkit.useDFGJIT", "true"));
            WebPage.twkInitWebCore(useJIT, useDFGJIT);
            return null;
        });
        firstWebPageCreated = false;
    }

    private static final class RenderFrame {
        private final List<WCRenderQueue> rqList = new LinkedList<WCRenderQueue>();
        private int scrollDx;
        private int scrollDy;
        private final WCRectangle enclosingRect = new WCRectangle();

        private RenderFrame() {
        }

        private void addRenderQueue(WCRenderQueue rq) {
            if (rq.isEmpty()) {
                return;
            }
            this.rqList.add(rq);
            WCRectangle rqRect = rq.getClip();
            if (this.enclosingRect.isEmpty()) {
                this.enclosingRect.setFrame(rqRect.getX(), rqRect.getY(), rqRect.getWidth(), rqRect.getHeight());
            } else if (!rqRect.isEmpty()) {
                WCRectangle.union(this.enclosingRect, rqRect, this.enclosingRect);
            }
        }

        private List<WCRenderQueue> getRQList() {
            return this.rqList;
        }

        private WCRectangle getEnclosingRect() {
            return this.enclosingRect;
        }

        private void drop() {
            for (WCRenderQueue rq : this.rqList) {
                rq.dispose();
            }
            this.rqList.clear();
            this.enclosingRect.setFrame(0.0f, 0.0f, 0.0f, 0.0f);
            this.scrollDx = 0;
            this.scrollDy = 0;
        }

        public String toString() {
            return "RenderFrame{rqList=" + this.rqList + ", enclosingRect=" + this.enclosingRect + "}";
        }
    }
}

