/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.java;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.PhongLighting;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.RenderState;
import com.sun.scenario.effect.impl.sw.java.JSWEffectPeer;
import com.sun.scenario.effect.light.PointLight;
import com.sun.scenario.effect.light.SpotLight;
import java.nio.FloatBuffer;

public class JSWPhongLighting_POINTPeer
extends JSWEffectPeer {
    private FloatBuffer kvals;

    public JSWPhongLighting_POINTPeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    @Override
    protected final PhongLighting getEffect() {
        return (PhongLighting)super.getEffect();
    }

    private float getSurfaceScale() {
        return this.getEffect().getSurfaceScale();
    }

    private float getDiffuseConstant() {
        return this.getEffect().getDiffuseConstant();
    }

    private float getSpecularConstant() {
        return this.getEffect().getSpecularConstant();
    }

    private float getSpecularExponent() {
        return this.getEffect().getSpecularExponent();
    }

    private float[] getNormalizedLightPosition() {
        return this.getEffect().getLight().getNormalizedLightPosition();
    }

    private float[] getLightPosition() {
        PointLight plight = (PointLight)this.getEffect().getLight();
        return new float[]{plight.getX(), plight.getY(), plight.getZ()};
    }

    private float[] getLightColor() {
        return this.getEffect().getLight().getColor().getPremultipliedRGBComponents();
    }

    private float getLightSpecularExponent() {
        return ((SpotLight)this.getEffect().getLight()).getSpecularExponent();
    }

    private float[] getNormalizedLightDirection() {
        return ((SpotLight)this.getEffect().getLight()).getNormalizedLightDirection();
    }

    private FloatBuffer getKvals() {
        Rectangle bumpImgBounds = this.getInputNativeBounds(0);
        float xoff = 1.0f / (float)bumpImgBounds.width;
        float yoff = 1.0f / (float)bumpImgBounds.height;
        float[] kx = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] ky = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer(32);
        }
        this.kvals.clear();
        int kidx = 0;
        float factor = -this.getSurfaceScale() * 0.25f;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i != 0 || j != 0) {
                    this.kvals.put((float)j * xoff);
                    this.kvals.put((float)i * yoff);
                    this.kvals.put(kx[kidx] * factor);
                    this.kvals.put(ky[kidx] * factor);
                }
                ++kidx;
            }
        }
        this.kvals.rewind();
        return this.kvals;
    }

    private int getKvalsArrayLength() {
        return 8;
    }

    @Override
    public ImageData filter(Effect effect, RenderState rstate, BaseTransform transform, Rectangle outputClip, ImageData ... inputs) {
        this.setEffect(effect);
        Rectangle dstBounds = this.getResultBounds(transform, outputClip, inputs);
        this.setDestBounds(dstBounds);
        HeapImage src0 = (HeapImage)inputs[0].getTransformedImage(dstBounds);
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getPhysicalWidth();
        int src0h = src0.getPhysicalHeight();
        int src0scan = src0.getScanlineStride();
        int[] bumpImg = src0.getPixelArray();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        Rectangle src0InputBounds = inputs[0].getTransformedBounds(dstBounds);
        BaseTransform src0Transform = BaseTransform.IDENTITY_TRANSFORM;
        this.setInputBounds(0, src0InputBounds);
        this.setInputNativeBounds(0, src0Bounds);
        HeapImage src1 = (HeapImage)inputs[1].getTransformedImage(dstBounds);
        int src1x = 0;
        int src1y = 0;
        int src1w = src1.getPhysicalWidth();
        int src1h = src1.getPhysicalHeight();
        int src1scan = src1.getScanlineStride();
        int[] origImg = src1.getPixelArray();
        Rectangle src1Bounds = new Rectangle(src1x, src1y, src1w, src1h);
        Rectangle src1InputBounds = inputs[1].getTransformedBounds(dstBounds);
        BaseTransform src1Transform = BaseTransform.IDENTITY_TRANSFORM;
        this.setInputBounds(1, src1InputBounds);
        this.setInputNativeBounds(1, src1Bounds);
        float[] src0Rect = new float[4];
        this.getTextureCoordinates(0, src0Rect, src0InputBounds.x, src0InputBounds.y, src0w, src0h, dstBounds, src0Transform);
        float[] src1Rect = new float[4];
        this.getTextureCoordinates(1, src1Rect, src1InputBounds.x, src1InputBounds.y, src1w, src1h, dstBounds, src1Transform);
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        HeapImage dst = (HeapImage)((Object)this.getRenderer().getCompatibleImage(dstw, dsth));
        this.setDestNativeBounds(dst.getPhysicalWidth(), dst.getPhysicalHeight());
        int dstscan = dst.getScanlineStride();
        int[] dstPixels = dst.getPixelArray();
        float[] lightPosition_arr = this.getLightPosition();
        float lightPosition_x = lightPosition_arr[0];
        float lightPosition_y = lightPosition_arr[1];
        float lightPosition_z = lightPosition_arr[2];
        float specularExponent = this.getSpecularExponent();
        FloatBuffer kvals_buf = this.getKvals();
        float[] kvals_arr = new float[kvals_buf.capacity()];
        kvals_buf.get(kvals_arr);
        float diffuseConstant = this.getDiffuseConstant();
        float[] lightColor_arr = this.getLightColor();
        float lightColor_x = lightColor_arr[0];
        float lightColor_y = lightColor_arr[1];
        float lightColor_z = lightColor_arr[2];
        float specularConstant = this.getSpecularConstant();
        float surfaceScale = this.getSurfaceScale();
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float inc1_x = (src1Rect[2] - src1Rect[0]) / (float)dstw;
        float inc1_y = (src1Rect[3] - src1Rect[1]) / (float)dsth;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        float pos1_y = src1Rect[1] + inc1_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            float pos1_x = src1Rect[0] + inc1_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                float max_res;
                float S_w;
                float NdotH;
                float clamp_res_y;
                float clamp_res_x;
                int bumpImg_tmp;
                int origImg_tmp;
                float pixcoord_x = dx;
                float loc_tmp_x = pos1_x;
                float loc_tmp_y = pos1_y;
                if (loc_tmp_x >= 0.0f && loc_tmp_y >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x * (float)src1w);
                    int iloc_tmp_y = (int)(loc_tmp_y * (float)src1h);
                    boolean out = iloc_tmp_x >= src1w || iloc_tmp_y >= src1h;
                    origImg_tmp = out ? 0 : origImg[iloc_tmp_y * src1scan + iloc_tmp_x];
                } else {
                    origImg_tmp = 0;
                }
                float sample_res_x = (float)(origImg_tmp >> 16 & 0xFF) / 255.0f;
                float sample_res_y = (float)(origImg_tmp >> 8 & 0xFF) / 255.0f;
                float sample_res_z = (float)(origImg_tmp & 0xFF) / 255.0f;
                float sample_res_w = (float)(origImg_tmp >>> 24) / 255.0f;
                float orig_x = sample_res_x;
                float orig_y = sample_res_y;
                float orig_z = sample_res_z;
                float orig_w = sample_res_w;
                float sum_x = 0.0f;
                float sum_y = 0.0f;
                float sum_z = 1.0f;
                for (int i = 0; i < 8; ++i) {
                    int bumpImg_tmp2;
                    float loc_tmp_x2 = pos0_x + kvals_arr[i * 4 + 0];
                    float loc_tmp_y2 = pos0_y + kvals_arr[i * 4 + 1];
                    if (loc_tmp_x2 >= 0.0f && loc_tmp_y2 >= 0.0f) {
                        int iloc_tmp_x = (int)(loc_tmp_x2 * (float)src0w);
                        int iloc_tmp_y = (int)(loc_tmp_y2 * (float)src0h);
                        boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                        bumpImg_tmp2 = out ? 0 : bumpImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                    } else {
                        bumpImg_tmp2 = 0;
                    }
                    sample_res_w = (float)(bumpImg_tmp2 >>> 24) / 255.0f;
                    sum_x += kvals_arr[i * 4 + 2] * sample_res_w;
                    sum_y += kvals_arr[i * 4 + 3] * sample_res_w;
                }
                float x_tmp_x = sum_x;
                float x_tmp_y = sum_y;
                float x_tmp_z = sum_z;
                float denom = (float)Math.sqrt(x_tmp_x * x_tmp_x + x_tmp_y * x_tmp_y + x_tmp_z * x_tmp_z);
                float normalize_res_x = x_tmp_x / denom;
                float normalize_res_y = x_tmp_y / denom;
                float normalize_res_z = x_tmp_z / denom;
                float N_x = normalize_res_x;
                float N_y = normalize_res_y;
                float N_z = normalize_res_z;
                float loc_tmp_x3 = pos0_x;
                float loc_tmp_y3 = pos0_y;
                if (loc_tmp_x3 >= 0.0f && loc_tmp_y3 >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x3 * (float)src0w);
                    int iloc_tmp_y = (int)(loc_tmp_y3 * (float)src0h);
                    boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                    bumpImg_tmp = out ? 0 : bumpImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                } else {
                    bumpImg_tmp = 0;
                }
                float bumpA = sample_res_w = (float)(bumpImg_tmp >>> 24) / 255.0f;
                float tmp_x = pixcoord_x;
                float tmp_y = pixcoord_y;
                float tmp_z = surfaceScale * bumpA;
                float x_tmp_x2 = lightPosition_x - tmp_x;
                float x_tmp_y2 = lightPosition_y - tmp_y;
                float x_tmp_z2 = lightPosition_z - tmp_z;
                float denom2 = (float)Math.sqrt(x_tmp_x2 * x_tmp_x2 + x_tmp_y2 * x_tmp_y2 + x_tmp_z2 * x_tmp_z2);
                normalize_res_x = x_tmp_x2 / denom2;
                normalize_res_y = x_tmp_y2 / denom2;
                normalize_res_z = x_tmp_z2 / denom2;
                float Lxyz_x = normalize_res_x;
                float Lxyz_y = normalize_res_y;
                float Lxyz_z = normalize_res_z;
                float Lrgb_x = lightColor_x;
                float Lrgb_y = lightColor_y;
                float Lrgb_z = lightColor_z;
                float E_x = 0.0f;
                float E_y = 0.0f;
                float E_z = 1.0f;
                float x_tmp_x3 = Lxyz_x + E_x;
                float x_tmp_y3 = Lxyz_y + E_y;
                float x_tmp_z3 = Lxyz_z + E_z;
                float denom3 = (float)Math.sqrt(x_tmp_x3 * x_tmp_x3 + x_tmp_y3 * x_tmp_y3 + x_tmp_z3 * x_tmp_z3);
                normalize_res_x = x_tmp_x3 / denom3;
                normalize_res_y = x_tmp_y3 / denom3;
                normalize_res_z = x_tmp_z3 / denom3;
                float H_x = normalize_res_x;
                float H_y = normalize_res_y;
                float H_z = normalize_res_z;
                float x_tmp_x4 = N_x;
                float x_tmp_y4 = N_y;
                float x_tmp_z4 = N_z;
                float y_tmp_x = Lxyz_x;
                float y_tmp_y = Lxyz_y;
                float y_tmp_z = Lxyz_z;
                float dot_res = x_tmp_x4 * y_tmp_x + x_tmp_y4 * y_tmp_y + x_tmp_z4 * y_tmp_z;
                float D_x = diffuseConstant * dot_res * Lrgb_x;
                float D_y = diffuseConstant * dot_res * Lrgb_y;
                float D_z = diffuseConstant * dot_res * Lrgb_z;
                float val_tmp_x = D_x;
                float val_tmp_y = D_y;
                float val_tmp_z = D_z;
                float min_tmp = 0.0f;
                float max_tmp = 1.0f;
                float f = val_tmp_x < min_tmp ? min_tmp : (clamp_res_x = val_tmp_x > max_tmp ? max_tmp : val_tmp_x);
                float f2 = val_tmp_y < min_tmp ? min_tmp : (clamp_res_y = val_tmp_y > max_tmp ? max_tmp : val_tmp_y);
                float clamp_res_z = val_tmp_z < min_tmp ? min_tmp : (val_tmp_z > max_tmp ? max_tmp : val_tmp_z);
                D_x = clamp_res_x;
                D_y = clamp_res_y;
                D_z = clamp_res_z;
                float D_w = 1.0f;
                float x_tmp_x5 = N_x;
                float x_tmp_y5 = N_y;
                float x_tmp_z5 = N_z;
                float y_tmp_x2 = H_x;
                float y_tmp_y2 = H_y;
                float y_tmp_z2 = H_z;
                float x_tmp = NdotH = (dot_res = x_tmp_x5 * y_tmp_x2 + x_tmp_y5 * y_tmp_y2 + x_tmp_z5 * y_tmp_z2);
                float y_tmp = specularExponent;
                float pow_res = (float)Math.pow(x_tmp, y_tmp);
                float S_x = specularConstant * pow_res * Lrgb_x;
                float S_y = specularConstant * pow_res * Lrgb_y;
                float S_z = specularConstant * pow_res * Lrgb_z;
                float x_tmp2 = S_x;
                float y_tmp2 = S_y;
                x_tmp2 = S_w = (max_res = x_tmp2 > y_tmp2 ? x_tmp2 : y_tmp2);
                y_tmp2 = S_z;
                S_w = max_res = x_tmp2 > y_tmp2 ? x_tmp2 : y_tmp2;
                float color_x = (S_x *= (orig_w *= D_w)) + (orig_x *= D_x) * (1.0f - (S_w *= orig_w));
                float color_y = (S_y *= orig_w) + (orig_y *= D_y) * (1.0f - S_w);
                float color_z = (S_z *= orig_w) + (orig_z *= D_z) * (1.0f - S_w);
                float color_w = S_w + orig_w * (1.0f - S_w);
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > color_w) {
                    color_x = color_w;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > color_w) {
                    color_y = color_w;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > color_w) {
                    color_z = color_w;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f) << 24;
                pos0_x += inc0_x;
                pos1_x += inc1_x;
            }
            pos0_y += inc0_y;
            pos1_y += inc1_y;
        }
        inputs[0].releaseTransformedImage(src0);
        inputs[1].releaseTransformedImage(src1);
        return new ImageData(this.getFilterContext(), dst, dstBounds);
    }
}

