/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.j2d.J2DFontFactory;
import com.sun.prism.j2d.J2DPresentable;
import com.sun.prism.j2d.J2DRTTexture;
import com.sun.prism.j2d.J2DTexture;
import com.sun.prism.j2d.paint.MultipleGradientPaint;
import com.sun.prism.j2d.paint.RadialGradientPaint;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class J2DPrismGraphics
implements ReadbackGraphics,
MaskTextureGraphics {
    static final MultipleGradientPaint.CycleMethod[] LGP_CYCLE_METHODS = new MultipleGradientPaint.CycleMethod[]{MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.CycleMethod.REFLECT, MultipleGradientPaint.CycleMethod.REPEAT};
    static final MultipleGradientPaint.CycleMethod[] RGP_CYCLE_METHODS = new MultipleGradientPaint.CycleMethod[]{MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.CycleMethod.REFLECT, MultipleGradientPaint.CycleMethod.REPEAT};
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f);
    private static final Paint DEFAULT_PAINT = com.sun.prism.paint.Color.WHITE;
    static AffineTransform J2D_IDENTITY = new AffineTransform();
    private int clipRectIndex;
    private boolean hasPreCullingBits = false;
    private float pixelScale = 1.0f;
    private static ConcurrentHashMap<Font, WeakReference<Font>> fontMap = new ConcurrentHashMap();
    private static volatile int cleared = 0;
    private static AffineTransform tmpAT = new AffineTransform();
    private static Path2D tmpQuadShape = new Path2D.Float();
    private static Rectangle2D.Float tmpRect = new Rectangle2D.Float();
    private static Ellipse2D tmpEllipse = new Ellipse2D.Float();
    private static RoundRectangle2D tmpRRect = new RoundRectangle2D.Float();
    private static Line2D tmpLine = new Line2D.Float();
    private static AdaptorShape tmpAdaptor = new AdaptorShape();
    private boolean antialiasedShape = true;
    J2DPresentable target;
    Graphics2D g2d;
    Affine2D transform;
    Rectangle clipRect;
    RectBounds devClipRect;
    RectBounds finalClipRect;
    Paint paint;
    boolean paintWasProportional;
    BasicStroke stroke;
    boolean cull;
    Rectangle2D nodeBounds = null;
    private NodePath renderRoot;

    static Color toJ2DColor(com.sun.prism.paint.Color c) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    static int fixFractions(float[] fractions, Color[] colors) {
        float fprev = fractions[0];
        int i = 1;
        int n = 1;
        while (i < fractions.length) {
            float f = fractions[i];
            Color c = colors[i++];
            if (f <= fprev) {
                if (f >= 1.0f) break;
                f = fprev + Math.ulp(fprev);
                while (i < fractions.length && !(fractions[i] > f)) {
                    c = colors[i++];
                }
            }
            fractions[n] = fprev = f;
            colors[n++] = c;
        }
        return n;
    }

    java.awt.Paint toJ2DPaint(Paint p, Rectangle2D b) {
        if (p instanceof com.sun.prism.paint.Color) {
            return J2DPrismGraphics.toJ2DColor((com.sun.prism.paint.Color)p);
        }
        if (p instanceof Gradient) {
            Gradient g = (Gradient)p;
            if (g.isProportional() && b == null) {
                return null;
            }
            List<Stop> stops = g.getStops();
            int n = stops.size();
            float[] fractions = new float[n];
            Color[] colors = new Color[n];
            float prevf = -1.0f;
            boolean needsFix = false;
            for (int i = 0; i < n; ++i) {
                Stop stop = stops.get(i);
                float f = stop.getOffset();
                needsFix = needsFix || f <= prevf;
                fractions[i] = prevf = f;
                colors[i] = J2DPrismGraphics.toJ2DColor(stop.getColor());
            }
            if (needsFix && (n = J2DPrismGraphics.fixFractions(fractions, colors)) < fractions.length) {
                float[] newf = new float[n];
                System.arraycopy(fractions, 0, newf, 0, n);
                fractions = newf;
                Color[] newc = new Color[n];
                System.arraycopy(colors, 0, newc, 0, n);
                colors = newc;
            }
            if (g instanceof LinearGradient) {
                LinearGradient lg = (LinearGradient)p;
                float x1 = lg.getX1();
                float y1 = lg.getY1();
                float x2 = lg.getX2();
                float y2 = lg.getY2();
                if (g.isProportional()) {
                    float x = (float)b.getX();
                    float y = (float)b.getY();
                    float w = (float)b.getWidth();
                    float h = (float)b.getHeight();
                    x1 = x + w * x1;
                    y1 = y + h * y1;
                    x2 = x + w * x2;
                    y2 = y + h * y2;
                }
                if (x1 == x2 && y1 == y1) {
                    return colors[0];
                }
                Point2D.Float p1 = new Point2D.Float(x1, y1);
                Point2D.Float p2 = new Point2D.Float(x2, y2);
                MultipleGradientPaint.CycleMethod method = LGP_CYCLE_METHODS[g.getSpreadMethod()];
                return new LinearGradientPaint(p1, p2, fractions, colors, method);
            }
            if (g instanceof RadialGradient) {
                RadialGradient rg = (RadialGradient)g;
                float cx = rg.getCenterX();
                float cy = rg.getCenterY();
                float r = rg.getRadius();
                double fa = Math.toRadians(rg.getFocusAngle());
                float fd = rg.getFocusDistance();
                AffineTransform at = J2D_IDENTITY;
                if (g.isProportional()) {
                    float x = (float)b.getX();
                    float y = (float)b.getY();
                    float w = (float)b.getWidth();
                    float h = (float)b.getHeight();
                    float dim = Math.min(w, h);
                    float bcx = x + w * 0.5f;
                    float bcy = y + h * 0.5f;
                    cx = bcx + (cx - 0.5f) * dim;
                    cy = bcy + (cy - 0.5f) * dim;
                    r *= dim;
                    if (w != h && (double)w != 0.0 && (double)h != 0.0) {
                        at = AffineTransform.getTranslateInstance(bcx, bcy);
                        at.scale(w / dim, h / dim);
                        at.translate(-bcx, -bcy);
                    }
                }
                Point2D.Float center = new Point2D.Float(cx, cy);
                float fx = (float)((double)cx + (double)(fd * r) * Math.cos(fa));
                float fy = (float)((double)cy + (double)(fd * r) * Math.sin(fa));
                Point2D.Float focus = new Point2D.Float(fx, fy);
                MultipleGradientPaint.CycleMethod method = RGP_CYCLE_METHODS[g.getSpreadMethod()];
                return new RadialGradientPaint(center, r, focus, fractions, colors, method, MultipleGradientPaint.ColorSpaceType.SRGB, at);
            }
        } else if (p instanceof ImagePattern) {
            ImagePattern imgpat = (ImagePattern)p;
            float x = imgpat.getX();
            float y = imgpat.getY();
            float w = imgpat.getWidth();
            float h = imgpat.getHeight();
            if (p.isProportional()) {
                if (b == null) {
                    return null;
                }
                float bx = (float)b.getX();
                float by = (float)b.getY();
                float bw = (float)b.getWidth();
                float bh = (float)b.getHeight();
                w += x;
                h += y;
                x = bx + x * bw;
                y = by + y * bh;
                w = bx + w * bw;
                h = by + h * bh;
                w -= x;
                h -= y;
            }
            Texture tex = this.getResourceFactory().getCachedTexture(imgpat.getImage(), Texture.WrapMode.REPEAT);
            BufferedImage bimg = ((J2DTexture)tex).getBufferedImage();
            tex.unlock();
            return new TexturePaint(bimg, J2DPrismGraphics.tmpRect(x, y, w, h));
        }
        throw new UnsupportedOperationException("Paint " + p + " not supported yet.");
    }

    static Stroke toJ2DStroke(BasicStroke stroke) {
        float lineWidth = stroke.getLineWidth();
        int type = stroke.getType();
        if (type != 0) {
            lineWidth *= 2.0f;
        }
        java.awt.BasicStroke bs = new java.awt.BasicStroke(lineWidth, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase());
        if (type == 1) {
            return new InnerStroke(bs);
        }
        if (type == 2) {
            return new OuterStroke(bs);
        }
        return bs;
    }

    private static Font toJ2DFont(FontStrike strike) {
        Font j2dfont;
        FontResource fr = strike.getFontResource();
        Object peer = fr.getPeer();
        if (peer == null && fr.isEmbeddedFont()) {
            J2DFontFactory.registerFont(fr);
            peer = fr.getPeer();
        }
        if (peer != null && peer instanceof Font) {
            j2dfont = (Font)peer;
        } else {
            if (PlatformUtil.isMac()) {
                String psName = fr.getPSName();
                j2dfont = new Font(psName, 0, 12);
                if (!j2dfont.getPSName().equals(psName)) {
                    int style = fr.isBold() ? 1 : 0;
                    j2dfont = new Font(fr.getFamilyName(), style |= fr.isItalic() ? 2 : 0, 12);
                    if (!j2dfont.getPSName().equals(psName)) {
                        Font[] allj2dFonts;
                        for (Font f : allj2dFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                            if (!f.getPSName().equals(psName)) continue;
                            j2dfont = f;
                            break;
                        }
                    }
                }
            } else {
                j2dfont = new Font(fr.getFullName(), 0, 12);
            }
            fr.setPeer(j2dfont);
        }
        j2dfont = j2dfont.deriveFont(strike.getSize());
        Font compFont = null;
        WeakReference<Font> ref = fontMap.get(j2dfont);
        if (ref != null && (compFont = (Font)ref.get()) == null) {
            ++cleared;
        }
        if (compFont == null) {
            if (fontMap.size() > 100 && cleared > 10) {
                for (Font key : fontMap.keySet()) {
                    ref = fontMap.get(key);
                    if (ref != null && ref.get() != null) continue;
                    fontMap.remove(key);
                }
                cleared = 0;
            }
            compFont = J2DFontFactory.getCompositeFont(j2dfont);
            ref = new WeakReference<Font>(compFont);
            fontMap.put(j2dfont, ref);
        }
        return compFont;
    }

    public static AffineTransform toJ2DTransform(BaseTransform t) {
        return new AffineTransform(t.getMxx(), t.getMyx(), t.getMxy(), t.getMyy(), t.getMxt(), t.getMyt());
    }

    static AffineTransform tmpJ2DTransform(BaseTransform t) {
        tmpAT.setTransform(t.getMxx(), t.getMyx(), t.getMxy(), t.getMyy(), t.getMxt(), t.getMyt());
        return tmpAT;
    }

    static BaseTransform toPrTransform(AffineTransform t) {
        return BaseTransform.getInstance(t.getScaleX(), t.getShearY(), t.getShearX(), t.getScaleY(), t.getTranslateX(), t.getTranslateY());
    }

    static Rectangle toPrRect(java.awt.Rectangle r) {
        return new Rectangle(r.x, r.y, r.width, r.height);
    }

    private static Shape tmpQuad(float x1, float y1, float x2, float y2) {
        tmpQuadShape.reset();
        tmpQuadShape.moveTo(x1, y1);
        tmpQuadShape.lineTo(x2, y1);
        tmpQuadShape.lineTo(x2, y2);
        tmpQuadShape.lineTo(x1, y2);
        tmpQuadShape.closePath();
        return tmpQuadShape;
    }

    private static Rectangle2D tmpRect(float x, float y, float w, float h) {
        tmpRect.setRect(x, y, w, h);
        return tmpRect;
    }

    private static Shape tmpEllipse(float x, float y, float w, float h) {
        tmpEllipse.setFrame(x, y, w, h);
        return tmpEllipse;
    }

    private static Shape tmpRRect(float x, float y, float w, float h, float aw, float ah) {
        tmpRRect.setRoundRect(x, y, w, h, aw, ah);
        return tmpRRect;
    }

    private static Shape tmpLine(float x1, float y1, float x2, float y2) {
        tmpLine.setLine(x1, y1, x2, y2);
        return tmpLine;
    }

    private static Shape tmpShape(com.sun.javafx.geom.Shape s) {
        tmpAdaptor.setShape(s);
        return tmpAdaptor;
    }

    J2DPrismGraphics(J2DPresentable target, Graphics2D g2d) {
        this(g2d, target.getContentWidth(), target.getContentHeight());
        this.target = target;
    }

    J2DPrismGraphics(Graphics2D g2d, int width, int height) {
        this.g2d = g2d;
        this.captureTransform(g2d);
        this.transform = new Affine2D();
        this.devClipRect = new RectBounds(0.0f, 0.0f, width, height);
        this.finalClipRect = new RectBounds(0.0f, 0.0f, width, height);
        this.cull = true;
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        this.setPaint(DEFAULT_PAINT);
        this.setStroke(DEFAULT_STROKE);
    }

    @Override
    public RenderTarget getRenderTarget() {
        return this.target;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.target.getAssociatedScreen();
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.target.getResourceFactory();
    }

    public void reset() {
    }

    @Override
    public Rectangle getClipRect() {
        return this.clipRect == null ? null : new Rectangle(this.clipRect);
    }

    @Override
    public Rectangle getClipRectNoClone() {
        return this.clipRect;
    }

    @Override
    public RectBounds getFinalClipNoClone() {
        return this.finalClipRect;
    }

    @Override
    public void setClipRect(Rectangle clipRect) {
        this.finalClipRect.setBounds(this.devClipRect);
        if (clipRect == null) {
            this.clipRect = null;
            this.g2d.setClip(null);
        } else {
            this.clipRect = new Rectangle(clipRect);
            this.finalClipRect.intersectWith(clipRect);
            this.setTransformG2D(J2D_IDENTITY);
            this.g2d.setClip(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            this.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(this.transform));
        }
    }

    private AlphaComposite getAWTComposite() {
        return (AlphaComposite)this.g2d.getComposite();
    }

    @Override
    public float getExtraAlpha() {
        return this.getAWTComposite().getAlpha();
    }

    @Override
    public void setExtraAlpha(float extraAlpha) {
        this.g2d.setComposite(this.getAWTComposite().derive(extraAlpha));
    }

    @Override
    public CompositeMode getCompositeMode() {
        int rule = this.getAWTComposite().getRule();
        switch (rule) {
            case 1: {
                return CompositeMode.CLEAR;
            }
            case 2: {
                return CompositeMode.SRC;
            }
            case 3: {
                return CompositeMode.SRC_OVER;
            }
        }
        throw new InternalError("Unrecognized AlphaCompsite rule: " + rule);
    }

    @Override
    public void setCompositeMode(CompositeMode mode) {
        AlphaComposite awtComp = this.getAWTComposite();
        switch (mode) {
            case CLEAR: {
                awtComp = awtComp.derive(1);
                break;
            }
            case SRC: {
                awtComp = awtComp.derive(2);
                break;
            }
            case SRC_OVER: {
                awtComp = awtComp.derive(3);
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + (Object)((Object)mode));
            }
        }
        this.g2d.setComposite(awtComp);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        java.awt.Paint j2dpaint = this.toJ2DPaint(paint, null);
        if (j2dpaint == null) {
            this.paintWasProportional = true;
        } else {
            this.paintWasProportional = false;
            this.g2d.setPaint(j2dpaint);
        }
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        this.g2d.setStroke(J2DPrismGraphics.toJ2DStroke(stroke));
    }

    @Override
    public BaseTransform getTransformNoClone() {
        return this.transform;
    }

    @Override
    public void translate(float tx, float ty) {
        this.transform.translate(tx, ty);
        this.g2d.translate(tx, ty);
    }

    @Override
    public void scale(float sx, float sy) {
        this.transform.scale(sx, sy);
        this.g2d.scale(sx, sy);
    }

    @Override
    public void transform(BaseTransform xform) {
        if (!xform.is2D()) {
            return;
        }
        this.transform.concatenate(xform);
        this.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(this.transform));
    }

    @Override
    public void setTransform(BaseTransform xform) {
        if (xform == null) {
            xform = BaseTransform.IDENTITY_TRANSFORM;
        }
        this.transform.setTransform(xform);
        this.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(this.transform));
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.transform.setTransform(m00, m10, m01, m11, m02, m12);
        this.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(this.transform));
    }

    @Override
    public void clear() {
        this.clear(com.sun.prism.paint.Color.TRANSPARENT);
    }

    @Override
    public void clear(com.sun.prism.paint.Color color) {
        this.getRenderTarget().setOpaque(color.isOpaque());
        this.clear(J2DPrismGraphics.toJ2DColor(color));
    }

    void clear(Color c) {
        Graphics2D gtmp = (Graphics2D)this.g2d.create();
        gtmp.setTransform(J2D_IDENTITY);
        gtmp.setComposite(AlphaComposite.Src);
        gtmp.setColor(c);
        gtmp.fillRect(0, 0, this.target.getContentWidth(), this.target.getContentHeight());
        gtmp.dispose();
    }

    @Override
    public void clearQuad(float x1, float y1, float x2, float y2) {
        this.g2d.setComposite(AlphaComposite.Clear);
        this.g2d.fill(J2DPrismGraphics.tmpQuad(x1, y1, x2, y2));
    }

    void fill(Shape shape) {
        if (this.paintWasProportional) {
            if (this.nodeBounds != null) {
                this.g2d.setPaint(this.toJ2DPaint(this.paint, this.nodeBounds));
            } else {
                this.g2d.setPaint(this.toJ2DPaint(this.paint, shape.getBounds2D()));
            }
        }
        this.g2d.fill(shape);
    }

    @Override
    public void fill(com.sun.javafx.geom.Shape shape) {
        this.fill(J2DPrismGraphics.tmpShape(shape));
    }

    @Override
    public void fillRect(float x, float y, float width, float height) {
        this.fill(J2DPrismGraphics.tmpRect(x, y, width, height));
    }

    @Override
    public void fillRoundRect(float x, float y, float width, float height, float arcw, float arch) {
        this.fill(J2DPrismGraphics.tmpRRect(x, y, width, height, arcw, arch));
    }

    @Override
    public void fillEllipse(float x, float y, float width, float height) {
        this.fill(J2DPrismGraphics.tmpEllipse(x, y, width, height));
    }

    @Override
    public void fillQuad(float x1, float y1, float x2, float y2) {
        this.fill(J2DPrismGraphics.tmpQuad(x1, y1, x2, y2));
    }

    void draw(Shape shape) {
        if (this.paintWasProportional) {
            if (this.nodeBounds != null) {
                this.g2d.setPaint(this.toJ2DPaint(this.paint, this.nodeBounds));
            } else {
                this.g2d.setPaint(this.toJ2DPaint(this.paint, shape.getBounds2D()));
            }
        }
        try {
            this.g2d.draw(shape);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void draw(com.sun.javafx.geom.Shape shape) {
        this.draw(J2DPrismGraphics.tmpShape(shape));
    }

    @Override
    public void drawLine(float x1, float y1, float x2, float y2) {
        this.draw(J2DPrismGraphics.tmpLine(x1, y1, x2, y2));
    }

    @Override
    public void drawRect(float x, float y, float width, float height) {
        this.draw(J2DPrismGraphics.tmpRect(x, y, width, height));
    }

    @Override
    public void drawRoundRect(float x, float y, float width, float height, float arcw, float arch) {
        this.draw(J2DPrismGraphics.tmpRRect(x, y, width, height, arcw, arch));
    }

    @Override
    public void drawEllipse(float x, float y, float width, float height) {
        this.draw(J2DPrismGraphics.tmpEllipse(x, y, width, height));
    }

    @Override
    public void setNodeBounds(RectBounds bounds) {
        this.nodeBounds = bounds != null ? new Rectangle2D.Float(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight()) : null;
    }

    private void drawString(GlyphList gl, int start, int end, FontStrike strike, float x, float y) {
        if (start == end) {
            return;
        }
        int count = end - start;
        int[] glyphs = new int[count];
        for (int i = 0; i < count; ++i) {
            glyphs[i] = gl.getGlyphCode(start + i) & 0xFFFFFF;
        }
        Font j2dfont = J2DPrismGraphics.toJ2DFont(strike);
        GlyphVector gv = j2dfont.createGlyphVector(this.g2d.getFontRenderContext(), glyphs);
        Point2D.Float pt = new Point2D.Float();
        for (int i = 0; i < count; ++i) {
            ((Point2D)pt).setLocation(gl.getPosX(start + i), gl.getPosY(start + i));
            gv.setGlyphPosition(i, pt);
        }
        this.g2d.drawGlyphVector(gv, x, y);
    }

    @Override
    public void drawString(GlyphList gl, FontStrike strike, float x, float y, com.sun.prism.paint.Color selectColor, int start, int end) {
        int count = gl.getGlyphCount();
        if (count == 0) {
            return;
        }
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (strike.getAAMode() == 1) {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
        if (this.paintWasProportional) {
            Rectangle2D rectBounds = this.nodeBounds;
            if (rectBounds == null) {
                Metrics m = strike.getMetrics();
                rectBounds = new Rectangle2D.Float(0.0f, m.getAscent(), gl.getWidth(), m.getLineHeight());
            }
            this.g2d.setPaint(this.toJ2DPaint(this.paint, rectBounds));
        }
        CompositeStrike cStrike = null;
        int slot = 0;
        if (strike instanceof CompositeStrike) {
            cStrike = (CompositeStrike)strike;
            int glyphCode = gl.getGlyphCode(0);
            slot = cStrike.getStrikeSlotForGlyph(glyphCode);
        }
        Color sColor = null;
        Color tColor = null;
        boolean selected = false;
        if (selectColor != null) {
            sColor = J2DPrismGraphics.toJ2DColor(selectColor);
            tColor = this.g2d.getColor();
            int offset = gl.getCharOffset(0);
            selected = start <= offset && offset < end;
        }
        int index = 0;
        if (sColor != null || cStrike != null) {
            for (int i = 1; i < count; ++i) {
                int glyphCode;
                int glyphSlot;
                if (sColor != null) {
                    boolean glyphSelected;
                    int offset = gl.getCharOffset(i);
                    boolean bl = glyphSelected = start <= offset && offset < end;
                    if (selected != glyphSelected) {
                        if (cStrike != null) {
                            strike = cStrike.getStrikeSlot(slot);
                        }
                        this.g2d.setColor(selected ? sColor : tColor);
                        this.drawString(gl, index, i, strike, x, y);
                        index = i;
                        selected = glyphSelected;
                    }
                }
                if (cStrike == null || slot == (glyphSlot = cStrike.getStrikeSlotForGlyph(glyphCode = gl.getGlyphCode(i)))) continue;
                strike = cStrike.getStrikeSlot(slot);
                if (sColor != null) {
                    this.g2d.setColor(selected ? sColor : tColor);
                }
                this.drawString(gl, index, i, strike, x, y);
                index = i;
                slot = glyphSlot;
            }
            if (cStrike != null) {
                strike = cStrike.getStrikeSlot(slot);
            }
            if (sColor != null) {
                this.g2d.setColor(selected ? sColor : tColor);
            }
        }
        this.drawString(gl, index, count, strike, x, y);
        if (selectColor != null) {
            this.g2d.setColor(tColor);
        }
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void setTransformG2D(AffineTransform tx) {
        this.g2d.setTransform(tx);
    }

    protected void captureTransform(Graphics2D g2d) {
    }

    @Override
    public void drawMappedTextureRaw(Texture tex, float dx1, float dy1, float dx2, float dy2, float tx11, float ty11, float tx21, float ty21, float tx12, float ty12, float tx22, float ty22) {
        BufferedImage img = ((J2DTexture)tex).getBufferedImage();
        float mxx = tx21 - tx11;
        float myx = ty21 - ty11;
        float mxy = tx12 - tx11;
        float myy = ty12 - ty11;
        this.setTransformG2D(J2D_IDENTITY);
        tmpAT.setTransform(mxx, myx, mxy, myy, tx11, ty11);
        try {
            tmpAT.invert();
            this.g2d.translate(dx1, dy1);
            this.g2d.scale(dx2 - dx1, dy2 - dy1);
            this.g2d.transform(tmpAT);
            this.g2d.drawImage(img, 0, 0, 1, 1, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.setTransform(this.transform);
    }

    @Override
    public void drawTexture(Texture tex, float x, float y, float w, float h) {
        BufferedImage img = ((J2DTexture)tex).getBufferedImage();
        this.g2d.drawImage(img, (int)x, (int)y, (int)(x + w), (int)(y + h), 0, 0, (int)w, (int)h, null);
    }

    @Override
    public void drawTexture(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        BufferedImage img = ((J2DTexture)tex).getBufferedImage();
        this.g2d.drawImage(img, (int)dx1, (int)dy1, (int)dx2, (int)dy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2, null);
    }

    @Override
    public void drawTexture3SliceH(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dh2, float sh1, float sh2) {
        if (sh1 + 0.1f > sh2) {
            sh2 += 1.0f;
        }
        this.drawTexture(tex, dx1, dy1, dh1, dy2, sx1, sy1, sh1, sy2);
        this.drawTexture(tex, dh1, dy1, dh2, dy2, sh1, sy1, sh2, sy2);
        this.drawTexture(tex, dh2, dy1, dx2, dy2, sh2, sy1, sx2, sy2);
    }

    @Override
    public void drawTexture3SliceV(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dv1, float dv2, float sv1, float sv2) {
        if (sv1 + 0.1f > sv2) {
            sv2 += 1.0f;
        }
        this.drawTexture(tex, dx1, dy1, dx2, dv1, sx1, sy1, sx2, sv1);
        this.drawTexture(tex, dx1, dv1, dx2, dv2, sx1, sv1, sx2, sv2);
        this.drawTexture(tex, dx1, dv2, dx2, dy2, sx1, sv2, sx2, sy2);
    }

    @Override
    public void drawTexture9Slice(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dv1, float dh2, float dv2, float sh1, float sv1, float sh2, float sv2) {
        if (sh1 + 0.1f > sh2) {
            sh2 += 1.0f;
        }
        if (sv1 + 0.1f > sv2) {
            sv2 += 1.0f;
        }
        this.drawTexture(tex, dx1, dy1, dh1, dv1, sx1, sy1, sh1, sv1);
        this.drawTexture(tex, dh1, dy1, dh2, dv1, sh1, sy1, sh2, sv1);
        this.drawTexture(tex, dh2, dy1, dx2, dv1, sh2, sy1, sx2, sv1);
        this.drawTexture(tex, dx1, dv1, dh1, dv2, sx1, sv1, sh1, sv2);
        this.drawTexture(tex, dh1, dv1, dh2, dv2, sh1, sv1, sh2, sv2);
        this.drawTexture(tex, dh2, dv1, dx2, dv2, sh2, sv1, sx2, sv2);
        this.drawTexture(tex, dx1, dv2, dh1, dy2, sx1, sv2, sh1, sy2);
        this.drawTexture(tex, dh1, dv2, dh2, dy2, sh1, sv2, sh2, sy2);
        this.drawTexture(tex, dh2, dv2, dx2, dy2, sh2, sv2, sx2, sy2);
    }

    @Override
    public void drawTextureRaw(Texture tex, float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2) {
        int w = tex.getContentWidth();
        int h = tex.getContentHeight();
        this.drawTexture(tex, dx1, dy1, dx2, dy2, tx1 *= (float)w, ty1 *= (float)h, tx2 *= (float)w, ty2 *= (float)h);
    }

    @Override
    public void drawTextureVO(Texture tex, float topopacity, float botopacity, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        java.awt.Paint savepaint = this.g2d.getPaint();
        Composite savecomp = this.g2d.getComposite();
        Color c1 = new Color(1.0f, 1.0f, 1.0f, topopacity);
        Color c2 = new Color(1.0f, 1.0f, 1.0f, botopacity);
        this.g2d.setPaint(new GradientPaint(0.0f, dy1, c1, 0.0f, dy2, c2, true));
        this.g2d.setComposite(AlphaComposite.Src);
        int x = (int)Math.floor(Math.min(dx1, dx2));
        int y = (int)Math.floor(Math.min(dy1, dy2));
        int w = (int)Math.ceil(Math.max(dx1, dx2)) - x;
        int h = (int)Math.ceil(Math.max(dy1, dy2)) - y;
        this.g2d.fillRect(x, y, w, h);
        this.g2d.setComposite(AlphaComposite.SrcIn);
        this.drawTexture(tex, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        this.g2d.setComposite(savecomp);
        this.g2d.setPaint(savepaint);
    }

    @Override
    public void drawPixelsMasked(RTTexture imgtex, RTTexture masktex, int dx, int dy, int dw, int dh, int ix, int iy, int mx, int my) {
        this.doDrawMaskTexture((J2DRTTexture)imgtex, (J2DRTTexture)masktex, dx, dy, dw, dh, ix, iy, mx, my, true);
    }

    @Override
    public void maskInterpolatePixels(RTTexture imgtex, RTTexture masktex, int dx, int dy, int dw, int dh, int ix, int iy, int mx, int my) {
        this.doDrawMaskTexture((J2DRTTexture)imgtex, (J2DRTTexture)masktex, dx, dy, dw, dh, ix, iy, mx, my, false);
    }

    private void doDrawMaskTexture(J2DRTTexture imgtex, J2DRTTexture masktex, int dx, int dy, int dw, int dh, int ix, int iy, int mx, int my, boolean srcover) {
        int bump;
        int cx0 = this.clipRect.x;
        int cy0 = this.clipRect.y;
        int cx1 = cx0 + this.clipRect.width;
        int cy1 = cy0 + this.clipRect.height;
        if (dw <= 0 || dh <= 0) {
            return;
        }
        if (dx < cx0) {
            bump = cx0 - dx;
            if ((dw -= bump) <= 0) {
                return;
            }
            ix += bump;
            mx += bump;
            dx = cx0;
        }
        if (dy < cy0) {
            bump = cy0 - dy;
            if ((dh -= bump) <= 0) {
                return;
            }
            iy += bump;
            my += bump;
            dy = cy0;
        }
        if (dx + dw > cx1 && (dw = cx1 - dx) <= 0) {
            return;
        }
        if (dy + dh > cy1 && (dh = cy1 - dy) <= 0) {
            return;
        }
        int iw = imgtex.getContentWidth();
        int ih = imgtex.getContentHeight();
        if (ix < 0) {
            if ((dw += ix) <= 0) {
                return;
            }
            dx -= ix;
            mx -= ix;
            ix = 0;
        }
        if (iy < 0) {
            if ((dh += iy) <= 0) {
                return;
            }
            dy -= iy;
            my -= iy;
            iy = 0;
        }
        if (ix + dw > iw && (dw = iw - ix) <= 0) {
            return;
        }
        if (iy + dh > ih && (dh = ih - iy) <= 0) {
            return;
        }
        int mw = masktex.getContentWidth();
        int mh = masktex.getContentHeight();
        if (mx < 0) {
            if ((dw += mx) <= 0) {
                return;
            }
            dx -= mx;
            ix -= mx;
            mx = 0;
        }
        if (my < 0) {
            if ((dh += my) <= 0) {
                return;
            }
            dy -= my;
            iy -= my;
            my = 0;
        }
        if (mx + dw > mw && (dw = mw - mx) <= 0) {
            return;
        }
        if (my + dh > mh && (dh = mh - my) <= 0) {
            return;
        }
        int[] imgbuf = imgtex.getPixels();
        int[] maskbuf = masktex.getPixels();
        DataBuffer db = this.target.getBackBuffer().getRaster().getDataBuffer();
        int[] dstbuf = ((DataBufferInt)db).getData();
        int iscan = imgtex.getBufferedImage().getWidth();
        int mscan = masktex.getBufferedImage().getWidth();
        int dscan = this.target.getBackBuffer().getWidth();
        int ioff = iy * iscan + ix;
        int moff = my * mscan + mx;
        int doff = dy * dscan + dx;
        if (srcover) {
            for (int y = 0; y < dh; ++y) {
                for (int x = 0; x < dw; ++x) {
                    int b;
                    int g;
                    int r;
                    int imgpix;
                    int a;
                    int maskalpha = maskbuf[moff + x] >>> 24;
                    if (maskalpha == 0 || (a = (imgpix = imgbuf[ioff + x]) >>> 24) == 0) continue;
                    if (maskalpha < 255) {
                        maskalpha += maskalpha >> 7;
                        a *= maskalpha;
                        r = (imgpix >> 16 & 0xFF) * maskalpha;
                        g = (imgpix >> 8 & 0xFF) * maskalpha;
                        b = (imgpix & 0xFF) * maskalpha;
                    } else if (a < 255) {
                        a <<= 8;
                        r = (imgpix >> 16 & 0xFF) << 8;
                        g = (imgpix >> 8 & 0xFF) << 8;
                        b = (imgpix & 0xFF) << 8;
                    } else {
                        dstbuf[doff + x] = imgpix;
                        continue;
                    }
                    maskalpha = a + 128 >> 8;
                    maskalpha += maskalpha >> 7;
                    maskalpha = 256 - maskalpha;
                    imgpix = dstbuf[doff + x];
                    a += (imgpix >>> 24) * maskalpha + 128;
                    r += (imgpix >> 16 & 0xFF) * maskalpha + 128;
                    g += (imgpix >> 8 & 0xFF) * maskalpha + 128;
                    b += (imgpix & 0xFF) * maskalpha + 128;
                    dstbuf[doff + x] = imgpix = (a >> 8 << 24) + (r >> 8 << 16) + (g >> 8 << 8) + (b >> 8);
                }
                ioff += iscan;
                moff += mscan;
                doff += dscan;
            }
        } else {
            for (int y = 0; y < dh; ++y) {
                for (int x = 0; x < dw; ++x) {
                    int maskalpha = maskbuf[moff + x] >>> 24;
                    if (maskalpha == 0) continue;
                    int imgpix = imgbuf[ioff + x];
                    if (maskalpha < 255) {
                        maskalpha += maskalpha >> 7;
                        int a = (imgpix >>> 24) * maskalpha;
                        int r = (imgpix >> 16 & 0xFF) * maskalpha;
                        int g = (imgpix >> 8 & 0xFF) * maskalpha;
                        int b = (imgpix & 0xFF) * maskalpha;
                        maskalpha = 256 - maskalpha;
                        imgpix = dstbuf[doff + x];
                        a += (imgpix >>> 24) * maskalpha + 128;
                        r += (imgpix >> 16 & 0xFF) * maskalpha + 128;
                        g += (imgpix >> 8 & 0xFF) * maskalpha + 128;
                        b += (imgpix & 0xFF) * maskalpha + 128;
                        imgpix = (a >> 8 << 24) + (r >> 8 << 16) + (g >> 8 << 8) + (b >> 8);
                    }
                    dstbuf[doff + x] = imgpix;
                }
                ioff += iscan;
                moff += mscan;
                doff += dscan;
            }
        }
    }

    @Override
    public boolean canReadBack() {
        return true;
    }

    @Override
    public RTTexture readBack(Rectangle view) {
        J2DRTTexture rtt = this.target.getReadbackBuffer();
        Graphics2D rttg2d = rtt.createAWTGraphics2D();
        rttg2d.setComposite(AlphaComposite.Src);
        int x0 = view.x;
        int y0 = view.y;
        int w = view.width;
        int h = view.height;
        int x1 = x0 + w;
        int y1 = y0 + h;
        rttg2d.drawImage(this.target.getBackBuffer(), 0, 0, w, h, x0, y0, x1, y1, null);
        rttg2d.dispose();
        return rtt;
    }

    @Override
    public void releaseReadBackBuffer(RTTexture view) {
    }

    @Override
    public NGCamera getCameraNoClone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isDepthBuffer() {
        return false;
    }

    @Override
    public boolean isDepthTest() {
        return false;
    }

    @Override
    public boolean isAlphaTestShader() {
        if (PrismSettings.verbose && PrismSettings.forceAlphaTestShader) {
            System.out.println("J2D pipe doesn't support shader with alpha testing");
        }
        return false;
    }

    @Override
    public void setAntialiasedShape(boolean aa) {
        this.antialiasedShape = aa;
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasedShape ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public boolean isAntialiasedShape() {
        return this.antialiasedShape;
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTransform3D(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxz != 0.0 || myz != 0.0 || mzx != 0.0 || mzy != 0.0 || mzz != 1.0 || mzt != 0.0) {
            throw new UnsupportedOperationException("3D transforms not supported.");
        }
        this.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    @Override
    public void setCamera(NGCamera camera) {
    }

    @Override
    public void setDepthBuffer(boolean depthBuffer) {
    }

    @Override
    public void setDepthTest(boolean depthTest) {
    }

    @Override
    public void sync() {
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCulling(boolean cull) {
        this.cull = cull;
    }

    public boolean isCulling() {
        return this.cull;
    }

    @Override
    public void setClipRectIndex(int index) {
        this.clipRectIndex = index;
    }

    @Override
    public int getClipRectIndex() {
        return this.clipRectIndex;
    }

    @Override
    public void setHasPreCullingBits(boolean hasBits) {
        this.hasPreCullingBits = hasBits;
    }

    @Override
    public boolean hasPreCullingBits() {
        return this.hasPreCullingBits;
    }

    @Override
    public void setRenderRoot(NodePath root) {
        this.renderRoot = root;
    }

    @Override
    public NodePath getRenderRoot() {
        return this.renderRoot;
    }

    @Override
    public void setState3D(boolean flag) {
    }

    @Override
    public boolean isState3D() {
        return false;
    }

    @Override
    public void setup3DRendering() {
    }

    @Override
    public void setPixelScaleFactor(float pixelScale) {
        this.pixelScale = pixelScale;
    }

    @Override
    public float getPixelScaleFactor() {
        return this.pixelScale;
    }

    @Override
    public void blit(RTTexture srcTex, RTTexture dstTex, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLights(NGLightBase[] lights) {
    }

    @Override
    public NGLightBase[] getLights() {
        return null;
    }

    static class OuterStroke
    extends FilterStroke {
        static double SQRT_2 = Math.sqrt(2.0);

        OuterStroke(java.awt.BasicStroke stroke) {
            super(stroke);
        }

        @Override
        protected Shape makeStrokedRect(Rectangle2D r) {
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float pad = this.stroke.getLineWidth() / 2.0f;
            float rx0 = (float)r.getX();
            float ry0 = (float)r.getY();
            float rx1 = rx0 + (float)r.getWidth();
            float ry1 = ry0 + (float)r.getHeight();
            GeneralPath gp = new GeneralPath();
            gp.moveTo(rx0, ry0);
            gp.lineTo(rx1, ry0);
            gp.lineTo(rx1, ry1);
            gp.lineTo(rx0, ry1);
            gp.closePath();
            float ox0 = rx0 - pad;
            float oy0 = ry0 - pad;
            float ox1 = rx1 + pad;
            float oy1 = ry1 + pad;
            switch (this.stroke.getLineJoin()) {
                case 0: {
                    if ((double)this.stroke.getMiterLimit() >= SQRT_2) {
                        gp.moveTo(ox0, oy0);
                        gp.lineTo(ox0, oy1);
                        gp.lineTo(ox1, oy1);
                        gp.lineTo(ox1, oy0);
                        gp.closePath();
                        break;
                    }
                }
                case 2: {
                    gp.moveTo(ox0, ry0);
                    gp.lineTo(ox0, ry1);
                    gp.lineTo(rx0, oy1);
                    gp.lineTo(rx1, oy1);
                    gp.lineTo(ox1, ry1);
                    gp.lineTo(ox1, ry0);
                    gp.lineTo(rx1, oy0);
                    gp.lineTo(rx0, oy0);
                    gp.closePath();
                    break;
                }
                case 1: {
                    gp.moveTo(ox0, ry0);
                    gp.lineTo(ox0, ry1);
                    OuterStroke.cornerArc(gp, ox0, ry1, ox0, oy1, rx0, oy1);
                    gp.lineTo(rx1, oy1);
                    OuterStroke.cornerArc(gp, rx1, oy1, ox1, oy1, ox1, ry1);
                    gp.lineTo(ox1, ry0);
                    OuterStroke.cornerArc(gp, ox1, ry0, ox1, oy0, rx1, oy0);
                    gp.lineTo(rx0, oy0);
                    OuterStroke.cornerArc(gp, rx0, oy0, ox0, oy0, ox0, ry0);
                    gp.closePath();
                    break;
                }
                default: {
                    throw new InternalError("Unrecognized line join style");
                }
            }
            return gp;
        }

        protected Shape makeStrokedEllipse(Ellipse2D e) {
            float h;
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float pad = this.stroke.getLineWidth() / 2.0f;
            float w = (float)e.getWidth();
            if (w > (h = (float)e.getHeight()) * 2.0f || h > w * 2.0f) {
                return null;
            }
            float x0 = (float)e.getX();
            float y0 = (float)e.getY();
            float xc = x0 + w / 2.0f;
            float yc = y0 + h / 2.0f;
            float x1 = x0 + w;
            float y1 = y0 + h;
            GeneralPath gp = new GeneralPath();
            gp.moveTo(xc, y0);
            OuterStroke.cornerArc(gp, xc, y0, x1, y0, x1, yc);
            OuterStroke.cornerArc(gp, x1, yc, x1, y1, xc, y1);
            OuterStroke.cornerArc(gp, xc, y1, x0, y1, x0, yc);
            OuterStroke.cornerArc(gp, x0, yc, x0, y0, xc, y0);
            gp.closePath();
            x1 += pad;
            gp.moveTo(xc, y0 -= pad);
            OuterStroke.cornerArc(gp, xc, y0, x0 -= pad, y0, x0, yc);
            OuterStroke.cornerArc(gp, x0, yc, x0, y1 += pad, xc, y1);
            OuterStroke.cornerArc(gp, xc, y1, x1, y1, x1, yc);
            OuterStroke.cornerArc(gp, x1, yc, x1, y0, xc, y0);
            gp.closePath();
            return gp;
        }

        @Override
        protected Shape makeStrokedShape(Shape s) {
            Shape ss = this.stroke.createStrokedShape(s);
            Area b = new Area(ss);
            b.subtract(new Area(s));
            return b;
        }
    }

    static class InnerStroke
    extends FilterStroke {
        InnerStroke(java.awt.BasicStroke stroke) {
            super(stroke);
        }

        @Override
        protected Shape makeStrokedRect(Rectangle2D r) {
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float pad = this.stroke.getLineWidth() / 2.0f;
            if ((double)pad >= r.getWidth() || (double)pad >= r.getHeight()) {
                return r;
            }
            float rx0 = (float)r.getX();
            float ry0 = (float)r.getY();
            float rx1 = rx0 + (float)r.getWidth();
            float ry1 = ry0 + (float)r.getHeight();
            GeneralPath gp = new GeneralPath();
            gp.moveTo(rx0, ry0);
            gp.lineTo(rx1, ry0);
            gp.lineTo(rx1, ry1);
            gp.lineTo(rx0, ry1);
            gp.closePath();
            gp.moveTo(rx0 += pad, ry0 += pad);
            gp.lineTo(rx0, ry1 -= pad);
            gp.lineTo(rx1 -= pad, ry1);
            gp.lineTo(rx1, ry0);
            gp.closePath();
            return gp;
        }

        protected Shape makeStrokedEllipse(Ellipse2D e) {
            float h;
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float pad = this.stroke.getLineWidth() / 2.0f;
            float w = (float)e.getWidth();
            if (w - 2.0f * pad > (h = (float)e.getHeight()) * 2.0f || h - 2.0f * pad > w * 2.0f) {
                return null;
            }
            if (pad >= w || pad >= h) {
                return e;
            }
            float x0 = (float)e.getX();
            float y0 = (float)e.getY();
            float xc = x0 + w / 2.0f;
            float yc = y0 + h / 2.0f;
            float x1 = x0 + w;
            float y1 = y0 + h;
            GeneralPath gp = new GeneralPath();
            gp.moveTo(xc, y0);
            InnerStroke.cornerArc(gp, xc, y0, x1, y0, x1, yc);
            InnerStroke.cornerArc(gp, x1, yc, x1, y1, xc, y1);
            InnerStroke.cornerArc(gp, xc, y1, x0, y1, x0, yc);
            InnerStroke.cornerArc(gp, x0, yc, x0, y0, xc, y0);
            gp.closePath();
            x1 -= pad;
            gp.moveTo(xc, y0 += pad);
            InnerStroke.cornerArc(gp, xc, y0, x0 += pad, y0, x0, yc);
            InnerStroke.cornerArc(gp, x0, yc, x0, y1 -= pad, xc, y1);
            InnerStroke.cornerArc(gp, xc, y1, x1, y1, x1, yc);
            InnerStroke.cornerArc(gp, x1, yc, x1, y0, xc, y0);
            gp.closePath();
            return gp;
        }

        @Override
        protected Shape makeStrokedShape(Shape s) {
            Shape ss = this.stroke.createStrokedShape(s);
            Area b = new Area(ss);
            b.intersect(new Area(s));
            return b;
        }
    }

    static abstract class FilterStroke
    implements Stroke {
        protected java.awt.BasicStroke stroke;
        static final double CtrlVal = 0.5522847498307933;

        FilterStroke(java.awt.BasicStroke stroke) {
            this.stroke = stroke;
        }

        protected abstract Shape makeStrokedRect(Rectangle2D var1);

        protected abstract Shape makeStrokedShape(Shape var1);

        @Override
        public Shape createStrokedShape(Shape p) {
            Shape s;
            if (p instanceof Rectangle2D && (s = this.makeStrokedRect((Rectangle2D)p)) != null) {
                return s;
            }
            return this.makeStrokedShape(p);
        }

        static Point2D cornerArc(GeneralPath gp, float x0, float y0, float xc, float yc, float x1, float y1) {
            return FilterStroke.cornerArc(gp, x0, y0, xc, yc, x1, y1, 0.5f);
        }

        static Point2D cornerArc(GeneralPath gp, float x0, float y0, float xc, float yc, float x1, float y1, float t) {
            float xc0 = (float)((double)x0 + 0.5522847498307933 * (double)(xc - x0));
            float yc0 = (float)((double)y0 + 0.5522847498307933 * (double)(yc - y0));
            float xc1 = (float)((double)x1 + 0.5522847498307933 * (double)(xc - x1));
            float yc1 = (float)((double)y1 + 0.5522847498307933 * (double)(yc - y1));
            gp.curveTo(xc0, yc0, xc1, yc1, x1, y1);
            return new Point2D.Float(FilterStroke.eval(x0, xc0, xc1, x1, t), FilterStroke.eval(y0, yc0, yc1, y1, t));
        }

        static float eval(float c0, float c1, float c2, float c3, float t) {
            c0 += (c1 - c0) * t;
            c1 += (c2 - c1) * t;
            c2 += (c3 - c2) * t;
            c0 += (c1 - c0) * t;
            c1 += (c2 - c1) * t;
            return c0 + (c1 - c0) * t;
        }
    }

    private static class AdaptorPathIterator
    implements PathIterator {
        private static int[] NUM_COORDS = new int[]{2, 2, 4, 6, 0};
        com.sun.javafx.geom.PathIterator priterator;
        float[] tmpcoords;

        private AdaptorPathIterator() {
        }

        public void setIterator(com.sun.javafx.geom.PathIterator priterator) {
            this.priterator = priterator;
        }

        @Override
        public int currentSegment(float[] coords) {
            return this.priterator.currentSegment(coords);
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.tmpcoords == null) {
                this.tmpcoords = new float[6];
            }
            int ret = this.priterator.currentSegment(this.tmpcoords);
            for (int i = 0; i < NUM_COORDS[ret]; ++i) {
                coords[i] = this.tmpcoords[i];
            }
            return ret;
        }

        @Override
        public int getWindingRule() {
            return this.priterator.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.priterator.isDone();
        }

        @Override
        public void next() {
            this.priterator.next();
        }
    }

    private static class AdaptorShape
    implements Shape {
        private com.sun.javafx.geom.Shape prshape;
        private static AdaptorPathIterator tmpAdaptor = new AdaptorPathIterator();

        private AdaptorShape() {
        }

        public void setShape(com.sun.javafx.geom.Shape prshape) {
            this.prshape = prshape;
        }

        @Override
        public boolean contains(double x, double y) {
            return this.prshape.contains((float)x, (float)y);
        }

        @Override
        public boolean contains(Point2D p) {
            return this.contains(p.getX(), p.getY());
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            return this.prshape.contains((float)x, (float)y, (float)w, (float)h);
        }

        @Override
        public boolean contains(Rectangle2D r) {
            return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return this.prshape.intersects((float)x, (float)y, (float)w, (float)h);
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        @Override
        public java.awt.Rectangle getBounds() {
            return this.getBounds2D().getBounds();
        }

        @Override
        public Rectangle2D getBounds2D() {
            RectBounds b = this.prshape.getBounds();
            Rectangle2D.Float r2d = new Rectangle2D.Float();
            r2d.setFrameFromDiagonal(b.getMinX(), b.getMinY(), b.getMaxX(), b.getMaxY());
            return r2d;
        }

        private static PathIterator tmpAdaptor(com.sun.javafx.geom.PathIterator pi) {
            tmpAdaptor.setIterator(pi);
            return tmpAdaptor;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            BaseTransform tx = at == null ? null : J2DPrismGraphics.toPrTransform(at);
            return AdaptorShape.tmpAdaptor(this.prshape.getPathIterator(tx));
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            BaseTransform tx = at == null ? null : J2DPrismGraphics.toPrTransform(at);
            return AdaptorShape.tmpAdaptor(this.prshape.getPathIterator(tx, (float)flatness));
        }
    }
}

