/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.GLContext;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.es2.GLFactory;
import com.sun.prism.es2.GLGPUInfo;
import com.sun.prism.es2.GLPixelFormat;
import com.sun.prism.es2.MacGLContext;
import com.sun.prism.es2.MacGLDrawable;
import com.sun.prism.es2.MacGLPixelFormat;
import java.util.HashMap;

class MacGLFactory
extends GLFactory {
    private GLGPUInfo[] preQualificationFilter = null;
    private GLGPUInfo[] blackList = new GLGPUInfo[]{new GLGPUInfo("ati", "radeon x1600 opengl engine"), new GLGPUInfo("ati", "radeon x1900 opengl engine"), new GLGPUInfo("intel", "gma x3100 opengl engine")};

    MacGLFactory() {
    }

    private static native long nInitialize(int[] var0);

    private static native int nGetAdapterOrdinal(long var0);

    private static native int nGetAdapterCount();

    private static native boolean nGetIsGL2(long var0);

    @Override
    GLGPUInfo[] getPreQualificationFilter() {
        return this.preQualificationFilter;
    }

    @Override
    GLGPUInfo[] getBlackList() {
        return this.blackList;
    }

    @Override
    GLContext createGLContext(long nativeCtxInfo) {
        return new MacGLContext(nativeCtxInfo);
    }

    @Override
    GLContext createGLContext(GLDrawable drawable, GLPixelFormat pixelFormat, GLContext shareCtx, boolean vSyncRequest) {
        MacGLContext glassCtx = new MacGLContext(drawable, pixelFormat, shareCtx, vSyncRequest);
        MacGLContext prismCtx = new MacGLContext(drawable, pixelFormat, shareCtx, vSyncRequest);
        HashMap devDetails = (HashMap)ES2Pipeline.getInstance().getDeviceDetails();
        devDetails.put("contextPtr", ((GLContext)glassCtx).getNativeHandle());
        return prismCtx;
    }

    @Override
    GLDrawable createDummyGLDrawable(GLPixelFormat pixelFormat) {
        return new MacGLDrawable(pixelFormat);
    }

    @Override
    GLDrawable createGLDrawable(long nativeWindow, GLPixelFormat pixelFormat) {
        return new MacGLDrawable(nativeWindow, pixelFormat);
    }

    @Override
    GLPixelFormat createGLPixelFormat(long nativeScreen, GLPixelFormat.Attributes attributes) {
        return new MacGLPixelFormat(nativeScreen, attributes);
    }

    @Override
    boolean initialize(Class psClass, GLPixelFormat.Attributes attrs) {
        int[] attrArr = new int[]{attrs.getRedSize(), attrs.getGreenSize(), attrs.getBlueSize(), attrs.getAlphaSize(), attrs.getDepthSize(), attrs.isDoubleBuffer() ? 1 : 0, attrs.isOnScreen() ? 1 : 0};
        this.nativeCtxInfo = MacGLFactory.nInitialize(attrArr);
        if (this.nativeCtxInfo == 0L) {
            return false;
        }
        this.gl2 = MacGLFactory.nGetIsGL2(this.nativeCtxInfo);
        return true;
    }

    @Override
    int getAdapterCount() {
        return MacGLFactory.nGetAdapterCount();
    }

    @Override
    int getAdapterOrdinal(long nativeScreen) {
        return MacGLFactory.nGetAdapterOrdinal(nativeScreen);
    }

    @Override
    void updateDeviceDetails(HashMap deviceDetails) {
        deviceDetails.put("shareContextPtr", this.getShareContext().getNativeHandle());
    }
}

