/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.ColorPickerSkin;
import com.sun.javafx.scene.control.skin.CustomColorDialog;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;

public class ColorPalette
extends Region {
    private static final int SQUARE_SIZE = 15;
    ColorPickerGrid colorPickerGrid;
    final Hyperlink customColorLink = new Hyperlink(ColorPickerSkin.getString("customColorLink"));
    CustomColorDialog customColorDialog = null;
    private ColorPicker colorPicker;
    private final GridPane customColorGrid = new GridPane();
    private final Separator separator = new Separator();
    private final Label customColorLabel = new Label(ColorPickerSkin.getString("customColorLabel"));
    private PopupControl popupControl;
    private ColorSquare focusedSquare;
    private ContextMenu contextMenu = null;
    private Color mouseDragColor = null;
    private boolean dragDetected = false;
    private int customColorNumber = 0;
    private int customColorRows = 0;
    private int customColorLastRowLength = 0;
    private final ColorSquare hoverSquare = new ColorSquare();
    private static final int NUM_OF_COLUMNS = 12;
    private static double[] RAW_VALUES = new double[]{255.0, 255.0, 255.0, 242.0, 242.0, 242.0, 230.0, 230.0, 230.0, 204.0, 204.0, 204.0, 179.0, 179.0, 179.0, 153.0, 153.0, 153.0, 128.0, 128.0, 128.0, 102.0, 102.0, 102.0, 77.0, 77.0, 77.0, 51.0, 51.0, 51.0, 26.0, 26.0, 26.0, 0.0, 0.0, 0.0, 0.0, 51.0, 51.0, 0.0, 26.0, 128.0, 26.0, 0.0, 104.0, 51.0, 0.0, 51.0, 77.0, 0.0, 26.0, 153.0, 0.0, 0.0, 153.0, 51.0, 0.0, 153.0, 77.0, 0.0, 153.0, 102.0, 0.0, 153.0, 153.0, 0.0, 102.0, 102.0, 0.0, 0.0, 51.0, 0.0, 26.0, 77.0, 77.0, 26.0, 51.0, 153.0, 51.0, 26.0, 128.0, 77.0, 26.0, 77.0, 102.0, 26.0, 51.0, 179.0, 26.0, 26.0, 179.0, 77.0, 26.0, 179.0, 102.0, 26.0, 179.0, 128.0, 26.0, 179.0, 179.0, 26.0, 128.0, 128.0, 26.0, 26.0, 77.0, 26.0, 51.0, 102.0, 102.0, 51.0, 77.0, 179.0, 77.0, 51.0, 153.0, 102.0, 51.0, 102.0, 128.0, 51.0, 77.0, 204.0, 51.0, 51.0, 204.0, 102.0, 51.0, 204.0, 128.0, 51.0, 204.0, 153.0, 51.0, 204.0, 204.0, 51.0, 153.0, 153.0, 51.0, 51.0, 102.0, 51.0, 77.0, 128.0, 128.0, 77.0, 102.0, 204.0, 102.0, 77.0, 179.0, 128.0, 77.0, 128.0, 153.0, 77.0, 102.0, 230.0, 77.0, 77.0, 230.0, 128.0, 77.0, 230.0, 153.0, 77.0, 230.0, 179.0, 77.0, 230.0, 230.0, 77.0, 179.0, 179.0, 77.0, 77.0, 128.0, 77.0, 102.0, 153.0, 153.0, 102.0, 128.0, 230.0, 128.0, 102.0, 204.0, 153.0, 102.0, 153.0, 179.0, 102.0, 128.0, 255.0, 102.0, 102.0, 255.0, 153.0, 102.0, 255.0, 179.0, 102.0, 255.0, 204.0, 102.0, 255.0, 255.0, 77.0, 204.0, 204.0, 102.0, 102.0, 153.0, 102.0, 128.0, 179.0, 179.0, 128.0, 153.0, 255.0, 153.0, 128.0, 230.0, 179.0, 128.0, 179.0, 204.0, 128.0, 153.0, 255.0, 128.0, 128.0, 255.0, 153.0, 128.0, 255.0, 204.0, 128.0, 255.0, 230.0, 102.0, 255.0, 255.0, 102.0, 230.0, 230.0, 128.0, 128.0, 179.0, 128.0, 153.0, 204.0, 204.0, 153.0, 179.0, 255.0, 179.0, 153.0, 255.0, 204.0, 153.0, 204.0, 230.0, 153.0, 179.0, 255.0, 153.0, 153.0, 255.0, 179.0, 128.0, 255.0, 204.0, 153.0, 255.0, 230.0, 128.0, 255.0, 255.0, 128.0, 230.0, 230.0, 153.0, 153.0, 204.0, 153.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 179.0, 179.0, 255.0, 179.0, 153.0, 255.0, 230.0, 179.0, 255.0, 230.0, 153.0, 255.0, 255.0, 153.0, 230.0, 230.0, 179.0, 179.0, 230.0, 179.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 230.0, 204.0, 255.0, 255.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 204.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 204.0, 255.0, 255.0, 179.0, 255.0, 255.0, 204.0, 230.0, 230.0, 204.0, 204.0, 255.0, 204.0};
    private static final int NUM_OF_COLORS = RAW_VALUES.length / 3;
    private static final int NUM_OF_ROWS = NUM_OF_COLORS / 12;

    public ColorPalette(final ColorPicker colorPicker) {
        this.getStyleClass().add("color-palette-region");
        this.colorPicker = colorPicker;
        this.colorPickerGrid = new ColorPickerGrid();
        ((Node)this.colorPickerGrid.getChildren().get(0)).requestFocus();
        this.customColorLabel.setAlignment(Pos.CENTER_LEFT);
        this.customColorLink.setPrefWidth(this.colorPickerGrid.prefWidth(-1.0));
        this.customColorLink.setAlignment(Pos.CENTER);
        this.customColorLink.setFocusTraversable(true);
        this.customColorLink.setVisited(true);
        this.customColorLink.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent t) {
                if (ColorPalette.this.customColorDialog == null) {
                    ColorPalette.this.customColorDialog = new CustomColorDialog(ColorPalette.this.popupControl);
                    ColorPalette.this.customColorDialog.customColorProperty().addListener((ov, t1, t2) -> colorPicker.setValue(ColorPalette.this.customColorDialog.customColorProperty().get()));
                    ColorPalette.this.customColorDialog.setOnSave(() -> {
                        Color customColor = (Color)ColorPalette.this.customColorDialog.customColorProperty().get();
                        ColorPalette.this.buildCustomColors();
                        colorPicker.getCustomColors().add(customColor);
                        ColorPalette.this.updateSelection(customColor);
                        Event.fireEvent(colorPicker, new ActionEvent());
                        colorPicker.hide();
                    });
                    ColorPalette.this.customColorDialog.setOnUse(() -> {
                        Event.fireEvent(colorPicker, new ActionEvent());
                        colorPicker.hide();
                    });
                }
                ColorPalette.this.customColorDialog.setCurrentColor((Color)colorPicker.valueProperty().get());
                if (ColorPalette.this.popupControl != null) {
                    ColorPalette.this.popupControl.setAutoHide(false);
                }
                ColorPalette.this.customColorDialog.show();
                ColorPalette.this.customColorDialog.setOnHidden(event -> {
                    if (ColorPalette.this.popupControl != null) {
                        ColorPalette.this.popupControl.setAutoHide(true);
                    }
                });
            }
        });
        this.initNavigation();
        this.customColorGrid.getStyleClass().add("color-picker-grid");
        this.customColorGrid.setVisible(false);
        this.buildCustomColors();
        colorPicker.getCustomColors().addListener(new ListChangeListener<Color>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Color> change) {
                ColorPalette.this.buildCustomColors();
            }
        });
        VBox paletteBox = new VBox();
        paletteBox.getStyleClass().add("color-palette");
        paletteBox.getChildren().addAll((Node[])new Node[]{this.colorPickerGrid, this.customColorLabel, this.customColorGrid, this.separator, this.customColorLink});
        this.hoverSquare.setMouseTransparent(true);
        this.hoverSquare.getStyleClass().addAll((String[])new String[]{"hover-square"});
        this.setFocusedSquare(null);
        this.getChildren().addAll((Node[])new Node[]{paletteBox, this.hoverSquare});
    }

    private void setFocusedSquare(ColorSquare square) {
        double xAdjust;
        double scaleAdjust;
        if (square == this.focusedSquare) {
            return;
        }
        this.focusedSquare = square;
        this.hoverSquare.setVisible(this.focusedSquare != null);
        if (this.focusedSquare == null) {
            return;
        }
        if (!this.focusedSquare.isFocused()) {
            this.focusedSquare.requestFocus();
        }
        this.hoverSquare.rectangle.setFill(this.focusedSquare.rectangle.getFill());
        Bounds b = square.localToScene(square.getLayoutBounds());
        double x = b.getMinX();
        double y = b.getMinY();
        double d = scaleAdjust = this.hoverSquare.getScaleX() == 1.0 ? 0.0 : this.hoverSquare.getWidth() / 4.0;
        if (this.colorPicker.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            x = this.focusedSquare.getLayoutX();
            xAdjust = -this.focusedSquare.getWidth() + scaleAdjust;
        } else {
            xAdjust = this.focusedSquare.getWidth() / 2.0 + scaleAdjust;
        }
        this.hoverSquare.setLayoutX(this.snapPosition(x) - xAdjust);
        this.hoverSquare.setLayoutY(this.snapPosition(y) - this.focusedSquare.getHeight() / 2.0 + (this.hoverSquare.getScaleY() == 1.0 ? 0.0 : this.focusedSquare.getHeight() / 4.0));
    }

    private void buildCustomColors() {
        int i;
        ObservableList<Color> customColors = this.colorPicker.getCustomColors();
        this.customColorNumber = customColors.size();
        this.customColorGrid.getChildren().clear();
        if (customColors.isEmpty()) {
            this.customColorLabel.setVisible(false);
            this.customColorLabel.setManaged(false);
            this.customColorGrid.setVisible(false);
            this.customColorGrid.setManaged(false);
            return;
        }
        this.customColorLabel.setVisible(true);
        this.customColorLabel.setManaged(true);
        this.customColorGrid.setVisible(true);
        this.customColorGrid.setManaged(true);
        if (this.contextMenu == null) {
            MenuItem item = new MenuItem(ColorPickerSkin.getString("removeColor"));
            item.setOnAction(e -> {
                ColorSquare square = (ColorSquare)this.contextMenu.getOwnerNode();
                customColors.remove(square.rectangle.getFill());
                this.buildCustomColors();
            });
            this.contextMenu = new ContextMenu(item);
        }
        int customColumnIndex = 0;
        int customRowIndex = 0;
        int remainingSquares = customColors.size() % 12;
        int numEmpty = remainingSquares == 0 ? 0 : 12 - remainingSquares;
        this.customColorLastRowLength = remainingSquares == 0 ? 12 : remainingSquares;
        for (i = 0; i < customColors.size(); ++i) {
            Color c = (Color)customColors.get(i);
            ColorSquare square = new ColorSquare(c, i, true);
            square.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    customColors.remove(square.rectangle.getFill());
                    this.buildCustomColors();
                }
            });
            this.customColorGrid.add(square, customColumnIndex, customRowIndex);
            if (++customColumnIndex != 12) continue;
            customColumnIndex = 0;
            ++customRowIndex;
        }
        for (i = 0; i < numEmpty; ++i) {
            ColorSquare emptySquare = new ColorSquare();
            this.customColorGrid.add(emptySquare, customColumnIndex, customRowIndex);
            ++customColumnIndex;
        }
        this.customColorRows = customRowIndex + 1;
        this.requestLayout();
    }

    private void initNavigation() {
        this.setOnKeyPressed(ke -> {
            switch (ke.getCode()) {
                case SPACE: 
                case ENTER: {
                    this.processSelectKey((KeyEvent)ke);
                    ke.consume();
                    break;
                }
            }
        });
        this.setImpl_traversalEngine(new ParentTraversalEngine(this, new Algorithm(){

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                Node subsequentNode = context.selectInSubtree(context.getRoot(), owner, dir);
                switch (dir) {
                    case NEXT: 
                    case NEXT_IN_LINE: 
                    case PREVIOUS: {
                        return subsequentNode;
                    }
                    case LEFT: 
                    case RIGHT: 
                    case UP: 
                    case DOWN: {
                        if (owner instanceof ColorSquare) {
                            Node result = this.processArrow((ColorSquare)owner, dir);
                            return result != null ? result : subsequentNode;
                        }
                        return subsequentNode;
                    }
                }
                return null;
            }

            private Node processArrow(ColorSquare owner, Direction dir) {
                int row = owner.index / 12;
                int column = owner.index % 12;
                if (this.isAtBorder(dir = dir.getDirectionForNodeOrientation(ColorPalette.this.colorPicker.getEffectiveNodeOrientation()), row, column, owner.isCustom)) {
                    int subsequentRow = row;
                    int subsequentColumn = column;
                    boolean subSequentSquareCustom = owner.isCustom;
                    switch (dir) {
                        case LEFT: 
                        case RIGHT: {
                            if (owner.isCustom) {
                                subsequentRow = Math.floorMod(dir == Direction.LEFT ? row - 1 : row + 1, ColorPalette.this.customColorRows);
                                subsequentColumn = dir == Direction.LEFT ? (subsequentRow == ColorPalette.this.customColorRows - 1 ? ColorPalette.this.customColorLastRowLength - 1 : 11) : 0;
                                break;
                            }
                            subsequentRow = Math.floorMod(dir == Direction.LEFT ? row - 1 : row + 1, NUM_OF_ROWS);
                            subsequentColumn = dir == Direction.LEFT ? 11 : 0;
                            break;
                        }
                        case UP: {
                            subsequentRow = NUM_OF_ROWS - 1;
                            break;
                        }
                        case DOWN: {
                            if (ColorPalette.this.customColorNumber > 0) {
                                subSequentSquareCustom = true;
                                subsequentRow = 0;
                                subsequentColumn = ColorPalette.this.customColorRows > 1 ? column : Math.min(ColorPalette.this.customColorLastRowLength - 1, column);
                                break;
                            }
                            return null;
                        }
                    }
                    if (subSequentSquareCustom) {
                        return (Node)ColorPalette.this.customColorGrid.getChildren().get(subsequentRow * 12 + subsequentColumn);
                    }
                    return (Node)ColorPalette.this.colorPickerGrid.getChildren().get(subsequentRow * 12 + subsequentColumn);
                }
                return null;
            }

            private boolean isAtBorder(Direction dir, int row, int column, boolean custom) {
                switch (dir) {
                    case LEFT: {
                        return column == 0;
                    }
                    case RIGHT: {
                        return custom && row == ColorPalette.this.customColorRows - 1 ? column == ColorPalette.this.customColorLastRowLength - 1 : column == 11;
                    }
                    case UP: {
                        return !custom && row == 0;
                    }
                    case DOWN: {
                        return !custom && row == NUM_OF_ROWS - 1;
                    }
                }
                return false;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                return (Node)ColorPalette.this.colorPickerGrid.getChildren().get(0);
            }

            @Override
            public Node selectLast(TraversalContext context) {
                return ColorPalette.this.customColorLink;
            }
        }));
    }

    private void processSelectKey(KeyEvent ke) {
        if (this.focusedSquare != null) {
            this.focusedSquare.selectColor(ke);
        }
    }

    public void setPopupControl(PopupControl pc) {
        this.popupControl = pc;
    }

    public ColorPickerGrid getColorGrid() {
        return this.colorPickerGrid;
    }

    public boolean isCustomColorDialogShowing() {
        if (this.customColorDialog != null) {
            return this.customColorDialog.isVisible();
        }
        return false;
    }

    public void updateSelection(Color color) {
        this.setFocusedSquare(null);
        for (ColorSquare c : this.colorPickerGrid.getSquares()) {
            if (!c.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(c);
            return;
        }
        for (Node n : this.customColorGrid.getChildren()) {
            ColorSquare c = (ColorSquare)n;
            if (!c.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(c);
            return;
        }
    }

    class ColorPickerGrid
    extends GridPane {
        private final List<ColorSquare> squares;

        public ColorPickerGrid() {
            this.getStyleClass().add("color-picker-grid");
            this.setId("ColorCustomizerColorGrid");
            int columnIndex = 0;
            int rowIndex = 0;
            this.squares = FXCollections.observableArrayList();
            int numColors = RAW_VALUES.length / 3;
            Color[] colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                colors[i] = new Color(RAW_VALUES[i * 3] / 255.0, RAW_VALUES[i * 3 + 1] / 255.0, RAW_VALUES[i * 3 + 2] / 255.0, 1.0);
                ColorSquare cs = new ColorSquare(colors[i], i);
                this.squares.add(cs);
            }
            for (ColorSquare square : this.squares) {
                this.add(square, columnIndex, rowIndex);
                if (++columnIndex != 12) continue;
                columnIndex = 0;
                ++rowIndex;
            }
            this.setOnMouseDragged(t -> {
                if (!ColorPalette.this.dragDetected) {
                    ColorPalette.this.dragDetected = true;
                    ColorPalette.this.mouseDragColor = (Color)ColorPalette.this.colorPicker.getValue();
                }
                int xIndex = com.sun.javafx.util.Utils.clamp(0, (int)t.getX() / 16, 11);
                int yIndex = com.sun.javafx.util.Utils.clamp(0, (int)t.getY() / 16, NUM_OF_ROWS - 1);
                int index = xIndex + yIndex * 12;
                ColorPalette.this.colorPicker.setValue((Color)this.squares.get((int)index).rectangle.getFill());
                ColorPalette.this.updateSelection((Color)ColorPalette.this.colorPicker.getValue());
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, t -> {
                if (ColorPalette.this.colorPickerGrid.getBoundsInLocal().contains(t.getX(), t.getY())) {
                    ColorPalette.this.updateSelection((Color)ColorPalette.this.colorPicker.getValue());
                    ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                    ColorPalette.this.colorPicker.hide();
                } else if (ColorPalette.this.mouseDragColor != null) {
                    ColorPalette.this.colorPicker.setValue(ColorPalette.this.mouseDragColor);
                    ColorPalette.this.updateSelection(ColorPalette.this.mouseDragColor);
                }
                ColorPalette.this.dragDetected = false;
            });
        }

        public List<ColorSquare> getSquares() {
            return this.squares;
        }

        @Override
        protected double computePrefWidth(double height) {
            return 192.0;
        }

        @Override
        protected double computePrefHeight(double width) {
            return 16 * NUM_OF_ROWS;
        }
    }

    class ColorSquare
    extends StackPane {
        Rectangle rectangle;
        int index;
        boolean isEmpty;
        boolean isCustom;

        public ColorSquare() {
            this(null, -1, false);
        }

        public ColorSquare(Color color, int index) {
            this(color, index, false);
        }

        public ColorSquare(Color color, int index, boolean isCustom) {
            this.getStyleClass().add("color-square");
            if (color != null) {
                this.setFocusTraversable(true);
                this.focusedProperty().addListener((s, ov, nv) -> ColorPalette.this.setFocusedSquare(nv != false ? this : null));
                this.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> ColorPalette.this.setFocusedSquare(this));
                this.addEventHandler(MouseEvent.MOUSE_EXITED, event -> ColorPalette.this.setFocusedSquare(null));
                this.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
                    if (!ColorPalette.this.dragDetected && event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 1) {
                        if (!this.isEmpty) {
                            Color fill = (Color)this.rectangle.getFill();
                            ColorPalette.this.colorPicker.setValue(fill);
                            ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                            ColorPalette.this.updateSelection(fill);
                            event.consume();
                        }
                        ColorPalette.this.colorPicker.hide();
                    } else if ((event.getButton() == MouseButton.SECONDARY || event.getButton() == MouseButton.MIDDLE) && isCustom && ColorPalette.this.contextMenu != null) {
                        if (!ColorPalette.this.contextMenu.isShowing()) {
                            ColorPalette.this.contextMenu.show(this, Side.RIGHT, 0.0, 0.0);
                            Utils.addMnemonics(ColorPalette.this.contextMenu, this.getScene(), ColorPalette.this.colorPicker.impl_isShowMnemonics());
                        } else {
                            ColorPalette.this.contextMenu.hide();
                            Utils.removeMnemonics(ColorPalette.this.contextMenu, this.getScene());
                        }
                    }
                });
            }
            this.index = index;
            this.isCustom = isCustom;
            this.rectangle = new Rectangle(15.0, 15.0);
            if (color == null) {
                this.rectangle.setFill(Color.WHITE);
                this.isEmpty = true;
            } else {
                this.rectangle.setFill(color);
            }
            this.rectangle.setStrokeType(StrokeType.INSIDE);
            String tooltipStr = ColorPickerSkin.tooltipString(color);
            Tooltip.install(this, new Tooltip(tooltipStr == null ? "" : tooltipStr));
            this.rectangle.getStyleClass().add("color-rect");
            this.getChildren().add(this.rectangle);
        }

        public void selectColor(KeyEvent event) {
            if (this.rectangle.getFill() != null) {
                if (this.rectangle.getFill() instanceof Color) {
                    ColorPalette.this.colorPicker.setValue((Color)this.rectangle.getFill());
                    ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                }
                event.consume();
            }
            ColorPalette.this.colorPicker.hide();
        }
    }
}

