/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;

public class TableViewBehavior<T>
extends TableViewBehaviorBase<TableView<T>, T, TableColumn<T, ?>> {
    private final ChangeListener<TableView.TableViewSelectionModel<T>> selectionModelListener = (observable, oldValue, newValue) -> {
        if (oldValue != null) {
            oldValue.getSelectedCells().removeListener(this.weakSelectedCellsListener);
        }
        if (newValue != null) {
            newValue.getSelectedCells().addListener(this.weakSelectedCellsListener);
        }
    };
    private final WeakChangeListener<TableView.TableViewSelectionModel<T>> weakSelectionModelListener = new WeakChangeListener<TableView.TableViewSelectionModel<TableView.TableViewSelectionModel<T>>>(this.selectionModelListener);
    private TwoLevelFocusBehavior tlFocus;

    public TableViewBehavior(TableView<T> control) {
        super(control);
        control.selectionModelProperty().addListener(this.weakSelectionModelListener);
        TableView.TableViewSelectionModel<T> sm = control.getSelectionModel();
        if (sm != null) {
            sm.getSelectedCells().addListener(this.selectedCellsListener);
        }
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusBehavior(control);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    @Override
    protected int getItemCount() {
        return ((TableView)this.getControl()).getItems() == null ? 0 : ((TableView)this.getControl()).getItems().size();
    }

    @Override
    protected TableFocusModel getFocusModel() {
        return ((TableView)this.getControl()).getFocusModel();
    }

    @Override
    protected TableSelectionModel<T> getSelectionModel() {
        return ((TableView)this.getControl()).getSelectionModel();
    }

    @Override
    protected ObservableList<TablePosition> getSelectedCells() {
        return ((TableView)this.getControl()).getSelectionModel().getSelectedCells();
    }

    @Override
    protected TablePositionBase getFocusedCell() {
        return ((TableView)this.getControl()).getFocusModel().getFocusedCell();
    }

    @Override
    protected int getVisibleLeafIndex(TableColumnBase tc) {
        return ((TableView)this.getControl()).getVisibleLeafIndex((TableColumn)tc);
    }

    @Override
    protected TableColumn<T, ?> getVisibleLeafColumn(int index) {
        return ((TableView)this.getControl()).getVisibleLeafColumn(index);
    }

    @Override
    protected void editCell(int row, TableColumnBase tc) {
        ((TableView)this.getControl()).edit(row, (TableColumn)tc);
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getVisibleLeafColumns() {
        return ((TableView)this.getControl()).getVisibleLeafColumns();
    }

    @Override
    protected TablePositionBase<TableColumn<T, ?>> getTablePosition(int row, TableColumnBase<T, ?> tc) {
        return new TablePosition((TableView)this.getControl(), row, (TableColumn)tc);
    }

    @Override
    protected void selectAllToFocus(boolean setAnchorToFocusIndex) {
        if (((TableView)this.getControl()).getEditingCell() != null) {
            return;
        }
        super.selectAllToFocus(setAnchorToFocusIndex);
    }
}

