/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.swt.SWTApplication;
import com.sun.glass.ui.swt.SWTClipboard;
import java.nio.IntBuffer;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

final class SWTView
extends View {
    Canvas canvas;
    DropTarget dropTarget;
    static Shell hiddenShell;
    long layerID = 0L;

    @Override
    protected void _enableInputMethodEvents(long ptr, boolean enable) {
    }

    @Override
    protected int _getNativeFrameBuffer(long ptr) {
        return 0;
    }

    @Override
    protected long _create(Map caps) {
        if (hiddenShell == null) {
            hiddenShell = new Shell(Display.getDefault(), 1264);
            Display.getDefault().disposeExec(() -> {
                hiddenShell.dispose();
                hiddenShell = null;
            });
        }
        int bits = 34865152;
        this.canvas = SWT.getPlatform().equals("cocoa") ? SWTApplication.createGLCanvas(hiddenShell, bits, caps) : new Canvas((Composite)hiddenShell, bits);
        this.canvas.setData((Object)this);
        Listener keyListener = event -> this.sendKeyEvent(event);
        int[] keyEvents = new int[]{1, 2};
        for (int i = 0; i < keyEvents.length; ++i) {
            this.canvas.addListener(keyEvents[i], keyListener);
        }
        Listener mouseListener = event -> this.sendMouseEvent(event);
        int[] mouseEvents = new int[]{3, 4, 5, 6, 7, 38, 37, 35};
        for (int i = 0; i < mouseEvents.length; ++i) {
            this.canvas.addListener(mouseEvents[i], mouseListener);
        }
        this.canvas.addListener(9, event -> this.notifyRepaint(event.x, event.y, event.width, event.height));
        this.canvas.addListener(11, event -> {
            Rectangle rect = this.canvas.getClientArea();
            this.notifyResize(rect.width, rect.height);
        });
        this.dropTarget = SWTClipboard.createDropTarget((Control)this.canvas);
        return SWTApplication.getHandle((Control)this.canvas);
    }

    @Override
    public int getNativeRemoteLayerId(String serverName) {
        if (this.layerID != 0L) {
            return (int)this.layerID;
        }
        return (int)this.layerID;
    }

    @Override
    protected long _getNativeView(long ptr) {
        return ptr;
    }

    @Override
    protected int _getX(long ptr) {
        return 0;
    }

    @Override
    protected int _getY(long ptr) {
        return 0;
    }

    @Override
    protected boolean _close(long ptr) {
        return false;
    }

    @Override
    protected void _scheduleRepaint(long ptr) {
        this.canvas.redraw();
    }

    @Override
    protected void _begin(long ptr) {
        SWTApplication.lockFocus((Control)this.canvas);
    }

    @Override
    protected void _end(long ptr) {
        SWTApplication.unlockFocus((Control)this.canvas);
    }

    @Override
    protected boolean _enterFullscreen(long ptr, boolean animate, boolean keepRatio, boolean hideCursor) {
        this.canvas.getShell().setFullScreen(true);
        if (this.canvas.getShell().getFullScreen()) {
            this.notifyView(431);
            return true;
        }
        return false;
    }

    @Override
    protected void _exitFullscreen(long ptr, boolean animate) {
        this.canvas.getShell().setFullScreen(false);
        if (!this.canvas.getShell().getFullScreen()) {
            this.notifyView(432);
        }
    }

    @Override
    protected void _setParent(long ptr, long parentPtr) {
    }

    @Override
    protected void _uploadPixels(long ptr, Pixels pixels) {
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        int[] bytes = ((IntBuffer)pixels.getPixels()).array();
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(width, height, 32, palette);
        imageData.setPixels(0, 0, width * height, bytes, 0);
        Image image = new Image((Device)this.canvas.getDisplay(), imageData);
        GC gc = new GC((Drawable)this.canvas);
        gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    void sendKeyEvent(Event event) {
        View.EventHandler eventHandler = this.getEventHandler();
        if (eventHandler == null) {
            return;
        }
        long time = System.nanoTime();
        int keyCode = SWTApplication.getKeyCode(event);
        int modifiers = SWTApplication.getModifiers(event);
        int action = event.type == 1 ? 111 : 112;
        char[] chars = new char[]{event.character};
        eventHandler.handleKeyEvent(this, time, action, keyCode, chars, modifiers);
        if (event.character != '\u0000' && event.type == 1) {
            eventHandler.handleKeyEvent(this, time, 113, keyCode, chars, modifiers);
        }
    }

    void sendMouseEvent(Event event) {
        View.EventHandler eventHandler = this.getEventHandler();
        if (eventHandler == null) {
            return;
        }
        long time = System.nanoTime();
        int type = 0;
        switch (event.type) {
            case 3: {
                type = 221;
                if ((this.canvas.getShell().getStyle() & 0x80000) == 0) break;
                this.canvas.forceFocus();
                break;
            }
            case 4: {
                type = 222;
                break;
            }
            case 5: {
                if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
                    type = 223;
                    break;
                }
                type = 224;
                break;
            }
            case 6: {
                type = 225;
                break;
            }
            case 7: {
                type = 226;
                break;
            }
            case 38: {
                type = 228;
                break;
            }
            case 37: {
                type = 228;
                break;
            }
        }
        int button = SWTApplication.getButton(event);
        int modifiers = SWTApplication.getModifiers(event);
        switch (event.type) {
            case 38: {
                break;
            }
            case 37: {
                Point point = this.canvas.toDisplay(event.x, event.y);
                eventHandler.handleScrollEvent(this, time, event.x, event.y, point.x, point.y, 0.0, event.count, modifiers, 1, 1, 1, 1, 1.0, 1.0);
                break;
            }
            case 35: {
                boolean isKeyboardTrigger = false;
                Point point = this.canvas.toControl(event.x, event.y);
                eventHandler.handleMenuEvent(this, point.x, point.y, event.x, event.y, isKeyboardTrigger);
                break;
            }
            default: {
                boolean isPopupTrigger = false;
                Point point = this.canvas.toDisplay(event.x, event.y);
                eventHandler.handleMouseEvent(this, time, type, button, event.x, event.y, point.x, point.y, modifiers, isPopupTrigger, false);
            }
        }
    }

    @Override
    public void notifyDragStart(int button, int x, int y, int xAbs, int yAbs) {
        super.notifyDragStart(button, x, y, xAbs, yAbs);
    }

    @Override
    public void notifyDragEnd(int performedAction) {
        super.notifyDragEnd(performedAction);
    }

    @Override
    public int notifyDragEnter(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        return super.notifyDragEnter(x, y, xAbs, yAbs, recommendedDropAction);
    }

    @Override
    public int notifyDragOver(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        return super.notifyDragOver(x, y, xAbs, yAbs, recommendedDropAction);
    }

    @Override
    public void notifyDragLeave() {
        super.notifyDragLeave();
    }

    @Override
    public int notifyDragDrop(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        return super.notifyDragDrop(x, y, xAbs, yAbs, recommendedDropAction);
    }
}

