/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.skin.TitledPaneSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;

@DefaultProperty(value="content")
public class TitledPane
extends Labeled {
    private ObjectProperty<Node> content;
    private BooleanProperty expanded = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            boolean active = this.get();
            TitledPane.this.pseudoClassStateChanged(PSEUDO_CLASS_EXPANDED, active);
            TitledPane.this.pseudoClassStateChanged(PSEUDO_CLASS_COLLAPSED, !active);
            TitledPane.this.notifyAccessibleAttributeChanged(AccessibleAttribute.EXPANDED);
        }

        @Override
        public Object getBean() {
            return TitledPane.this;
        }

        @Override
        public String getName() {
            return "expanded";
        }
    };
    private BooleanProperty animated = new StyleableBooleanProperty(true){

        @Override
        public Object getBean() {
            return TitledPane.this;
        }

        @Override
        public String getName() {
            return "animated";
        }

        @Override
        public CssMetaData<TitledPane, Boolean> getCssMetaData() {
            return StyleableProperties.ANIMATED;
        }
    };
    private BooleanProperty collapsible = new StyleableBooleanProperty(true){

        @Override
        public Object getBean() {
            return TitledPane.this;
        }

        @Override
        public String getName() {
            return "collapsible";
        }

        @Override
        public CssMetaData<TitledPane, Boolean> getCssMetaData() {
            return StyleableProperties.COLLAPSIBLE;
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "titled-pane";
    private static final PseudoClass PSEUDO_CLASS_EXPANDED = PseudoClass.getPseudoClass("expanded");
    private static final PseudoClass PSEUDO_CLASS_COLLAPSED = PseudoClass.getPseudoClass("collapsed");

    public TitledPane() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TITLED_PANE);
        this.pseudoClassStateChanged(PSEUDO_CLASS_EXPANDED, true);
    }

    public TitledPane(String title, Node content) {
        this();
        this.setText(title);
        this.setContent(content);
    }

    public final void setContent(Node value) {
        this.contentProperty().set(value);
    }

    public final Node getContent() {
        return this.content == null ? null : (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setExpanded(boolean value) {
        this.expandedProperty().set(value);
    }

    public final boolean isExpanded() {
        return this.expanded.get();
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setAnimated(boolean value) {
        this.animatedProperty().set(value);
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final void setCollapsible(boolean value) {
        this.collapsibleProperty().set(value);
    }

    public final boolean isCollapsible() {
        return this.collapsible.get();
    }

    public final BooleanProperty collapsibleProperty() {
        return this.collapsible;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TitledPaneSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TitledPane.getClassCssMetaData();
    }

    @Override
    public Orientation getContentBias() {
        Node c = this.getContent();
        return c == null ? super.getContentBias() : c.getContentBias();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                return this.getText();
            }
            case EXPANDED: {
                return this.isExpanded();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case EXPAND: {
                this.setExpanded(true);
                break;
            }
            case COLLAPSE: {
                this.setExpanded(false);
                break;
            }
            default: {
                super.executeAccessibleAction(action, new Object[0]);
            }
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TitledPane, Boolean> COLLAPSIBLE = new CssMetaData<TitledPane, Boolean>("-fx-collapsible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(TitledPane n) {
                return n.collapsible == null || !n.collapsible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(TitledPane n) {
                return (StyleableProperty)((Object)n.collapsibleProperty());
            }
        };
        private static final CssMetaData<TitledPane, Boolean> ANIMATED = new CssMetaData<TitledPane, Boolean>("-fx-animated", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(TitledPane n) {
                return n.animated == null || !n.animated.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(TitledPane n) {
                return (StyleableProperty)((Object)n.animatedProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Labeled.getClassCssMetaData());
            styleables.add(COLLAPSIBLE);
            styleables.add(ANIMATED);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

