/*
 * Decompiled with CFR 0.152.
 */
package javafx.concurrent;

import java.util.Timer;
import java.util.TimerTask;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.util.Callback;
import javafx.util.Duration;

public abstract class ScheduledService<V>
extends Service<V> {
    public static final Callback<ScheduledService<?>, Duration> EXPONENTIAL_BACKOFF_STRATEGY = new Callback<ScheduledService<?>, Duration>(){

        @Override
        public Duration call(ScheduledService<?> service) {
            if (service == null) {
                return Duration.ZERO;
            }
            double period = service.getPeriod() == null ? 0.0 : service.getPeriod().toMillis();
            double x = service.getCurrentFailureCount();
            return Duration.millis(period == 0.0 ? Math.exp(x) : period + period * Math.exp(x));
        }
    };
    public static final Callback<ScheduledService<?>, Duration> LOGARITHMIC_BACKOFF_STRATEGY = new Callback<ScheduledService<?>, Duration>(){

        @Override
        public Duration call(ScheduledService<?> service) {
            if (service == null) {
                return Duration.ZERO;
            }
            double period = service.getPeriod() == null ? 0.0 : service.getPeriod().toMillis();
            double x = service.getCurrentFailureCount();
            return Duration.millis(period == 0.0 ? Math.log1p(x) : period + period * Math.log1p(x));
        }
    };
    public static final Callback<ScheduledService<?>, Duration> LINEAR_BACKOFF_STRATEGY = new Callback<ScheduledService<?>, Duration>(){

        @Override
        public Duration call(ScheduledService<?> service) {
            if (service == null) {
                return Duration.ZERO;
            }
            double period = service.getPeriod() == null ? 0.0 : service.getPeriod().toMillis();
            double x = service.getCurrentFailureCount();
            return Duration.millis(period == 0.0 ? x : period + period * x);
        }
    };
    private static final Timer DELAY_TIMER = new Timer("ScheduledService Delay Timer", true);
    private ObjectProperty<Duration> delay = new SimpleObjectProperty<Duration>(this, "delay", Duration.ZERO);
    private ObjectProperty<Duration> period = new SimpleObjectProperty<Duration>(this, "period", Duration.ZERO);
    private ObjectProperty<Callback<ScheduledService<?>, Duration>> backoffStrategy = new SimpleObjectProperty(this, "backoffStrategy", LOGARITHMIC_BACKOFF_STRATEGY);
    private BooleanProperty restartOnFailure = new SimpleBooleanProperty(this, "restartOnFailure", true);
    private IntegerProperty maximumFailureCount = new SimpleIntegerProperty(this, "maximumFailureCount", Integer.MAX_VALUE);
    private ReadOnlyIntegerWrapper currentFailureCount = new ReadOnlyIntegerWrapper(this, "currentFailureCount", 0);
    private ReadOnlyObjectWrapper<Duration> cumulativePeriod = new ReadOnlyObjectWrapper<Duration>(this, "cumulativePeriod", Duration.ZERO);
    private ObjectProperty<Duration> maximumCumulativePeriod = new SimpleObjectProperty<Duration>(this, "maximumCumulativePeriod", Duration.INDEFINITE);
    private ReadOnlyObjectWrapper<V> lastValue = new ReadOnlyObjectWrapper<Object>(this, "lastValue", null);
    private long lastRunTime = 0L;
    private boolean freshStart = true;
    private TimerTask delayTask = null;
    private boolean stop = false;

    public final Duration getDelay() {
        return (Duration)this.delay.get();
    }

    public final void setDelay(Duration value) {
        this.delay.set(value);
    }

    public final ObjectProperty<Duration> delayProperty() {
        return this.delay;
    }

    public final Duration getPeriod() {
        return (Duration)this.period.get();
    }

    public final void setPeriod(Duration value) {
        this.period.set(value);
    }

    public final ObjectProperty<Duration> periodProperty() {
        return this.period;
    }

    public final Callback<ScheduledService<?>, Duration> getBackoffStrategy() {
        return (Callback)this.backoffStrategy.get();
    }

    public final void setBackoffStrategy(Callback<ScheduledService<?>, Duration> value) {
        this.backoffStrategy.set(value);
    }

    public final ObjectProperty<Callback<ScheduledService<?>, Duration>> backoffStrategyProperty() {
        return this.backoffStrategy;
    }

    public final boolean getRestartOnFailure() {
        return this.restartOnFailure.get();
    }

    public final void setRestartOnFailure(boolean value) {
        this.restartOnFailure.set(value);
    }

    public final BooleanProperty restartOnFailureProperty() {
        return this.restartOnFailure;
    }

    public final int getMaximumFailureCount() {
        return this.maximumFailureCount.get();
    }

    public final void setMaximumFailureCount(int value) {
        this.maximumFailureCount.set(value);
    }

    public final IntegerProperty maximumFailureCountProperty() {
        return this.maximumFailureCount;
    }

    public final int getCurrentFailureCount() {
        return this.currentFailureCount.get();
    }

    public final ReadOnlyIntegerProperty currentFailureCountProperty() {
        return this.currentFailureCount.getReadOnlyProperty();
    }

    private void setCurrentFailureCount(int value) {
        this.currentFailureCount.set(value);
    }

    public final Duration getCumulativePeriod() {
        return (Duration)this.cumulativePeriod.get();
    }

    public final ReadOnlyObjectProperty<Duration> cumulativePeriodProperty() {
        return this.cumulativePeriod.getReadOnlyProperty();
    }

    void setCumulativePeriod(Duration value) {
        Duration newValue = value == null || value.toMillis() < 0.0 ? Duration.ZERO : value;
        Duration maxPeriod = (Duration)this.maximumCumulativePeriod.get();
        if (maxPeriod != null && !maxPeriod.isUnknown() && !newValue.isUnknown()) {
            if (maxPeriod.toMillis() < 0.0) {
                newValue = Duration.ZERO;
            } else if (!maxPeriod.isIndefinite() && newValue.greaterThan(maxPeriod)) {
                newValue = maxPeriod;
            }
        }
        this.cumulativePeriod.set(newValue);
    }

    public final Duration getMaximumCumulativePeriod() {
        return (Duration)this.maximumCumulativePeriod.get();
    }

    public final void setMaximumCumulativePeriod(Duration value) {
        this.maximumCumulativePeriod.set(value);
    }

    public final ObjectProperty<Duration> maximumCumulativePeriodProperty() {
        return this.maximumCumulativePeriod;
    }

    public final V getLastValue() {
        return (V)this.lastValue.get();
    }

    public final ReadOnlyObjectProperty<V> lastValueProperty() {
        return this.lastValue.getReadOnlyProperty();
    }

    @Override
    protected void executeTask(Task<V> task) {
        assert (task != null);
        this.checkThread();
        if (this.freshStart) {
            assert (this.delayTask == null);
            this.setCumulativePeriod(this.getPeriod());
            long d = (long)ScheduledService.normalize(this.getDelay());
            if (d == 0L) {
                this.executeTaskNow(task);
            } else {
                this.delayTask = this.createTimerTask(task);
                this.schedule(this.delayTask, d);
            }
        } else {
            double cumulative = ScheduledService.normalize(this.getCumulativePeriod());
            double runPeriod = this.clock() - this.lastRunTime;
            if (runPeriod < cumulative) {
                assert (this.delayTask == null);
                this.delayTask = this.createTimerTask(task);
                this.schedule(this.delayTask, (long)(cumulative - runPeriod));
            } else {
                this.executeTaskNow(task);
            }
        }
    }

    @Override
    protected void succeeded() {
        super.succeeded();
        this.lastValue.set(this.getValue());
        Duration d = this.getPeriod();
        this.setCumulativePeriod(d);
        boolean wasCancelled = this.stop;
        this.superReset();
        assert (!this.freshStart);
        if (wasCancelled) {
            this.cancelFromReadyState();
        } else {
            this.start();
        }
    }

    @Override
    protected void failed() {
        super.failed();
        assert (this.delayTask == null);
        this.setCurrentFailureCount(this.getCurrentFailureCount() + 1);
        if (this.getRestartOnFailure() && this.getMaximumFailureCount() > this.getCurrentFailureCount()) {
            Callback<ScheduledService<?>, Duration> func = this.getBackoffStrategy();
            if (func != null) {
                Duration d = func.call(this);
                this.setCumulativePeriod(d);
            }
            this.superReset();
            assert (!this.freshStart);
            this.start();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.stop = false;
        this.setCumulativePeriod(this.getPeriod());
        this.lastValue.set(null);
        this.setCurrentFailureCount(0);
        this.lastRunTime = 0L;
        this.freshStart = true;
    }

    @Override
    public boolean cancel() {
        boolean ret = super.cancel();
        this.stop = true;
        if (this.delayTask != null) {
            this.delayTask.cancel();
            this.delayTask = null;
        }
        return ret;
    }

    void schedule(TimerTask task, long delay) {
        DELAY_TIMER.schedule(task, delay);
    }

    boolean isFreshStart() {
        return this.freshStart;
    }

    long clock() {
        return System.currentTimeMillis();
    }

    private void superReset() {
        super.reset();
    }

    private TimerTask createTimerTask(final Task<V> task) {
        assert (task != null);
        return new TimerTask(){

            @Override
            public void run() {
                Runnable r = () -> {
                    ScheduledService.this.executeTaskNow(task);
                    ScheduledService.this.delayTask = null;
                };
                if (ScheduledService.this.isFxApplicationThread()) {
                    r.run();
                } else {
                    ScheduledService.this.runLater(r);
                }
            }
        };
    }

    private void executeTaskNow(Task<V> task) {
        assert (task != null);
        this.lastRunTime = this.clock();
        this.freshStart = false;
        super.executeTask(task);
    }

    private static double normalize(Duration d) {
        if (d == null || d.isUnknown()) {
            return 0.0;
        }
        if (d.isIndefinite()) {
            return Double.MAX_VALUE;
        }
        return d.toMillis();
    }
}

