/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.dom.ElementImpl;
import com.sun.webkit.dom.HTMLOptionsCollectionImpl;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLCollection;

public class HTMLCollectionImpl
implements HTMLCollection {
    private final long peer;
    private static final int TYPE_HTMLOptionsCollection = 1;

    HTMLCollectionImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static HTMLCollection create(long peer) {
        if (peer == 0L) {
            return null;
        }
        switch (HTMLCollectionImpl.getCPPTypeImpl(peer)) {
            case 1: {
                return new HTMLOptionsCollectionImpl(peer);
            }
        }
        return new HTMLCollectionImpl(peer);
    }

    long getPeer() {
        return this.peer;
    }

    public boolean equals(Object that) {
        return that instanceof HTMLCollectionImpl && this.peer == ((HTMLCollectionImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    static long getPeer(HTMLCollection arg) {
        return arg == null ? 0L : ((HTMLCollectionImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    private static native int getCPPTypeImpl(long var0);

    static HTMLCollection getImpl(long peer) {
        return HTMLCollectionImpl.create(peer);
    }

    @Override
    public int getLength() {
        return HTMLCollectionImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    @Override
    public Element item(int index) {
        return ElementImpl.getImpl(HTMLCollectionImpl.itemImpl(this.getPeer(), index));
    }

    static native long itemImpl(long var0, int var2);

    @Override
    public Element namedItem(String name) {
        return ElementImpl.getImpl(HTMLCollectionImpl.namedItemImpl(this.getPeer(), name));
    }

    static native long namedItemImpl(long var0, String var2);

    private static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            HTMLCollectionImpl.dispose(this.peer);
        }
    }
}

