/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d.print;

import com.sun.glass.ui.Application;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.print.PrintHelper;
import com.sun.javafx.print.PrinterImpl;
import com.sun.javafx.print.PrinterJobImpl;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.j2d.PrismPrintGraphics;
import com.sun.prism.j2d.print.J2DPrinter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javafx.collections.ObservableSet;
import javafx.print.Collation;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.PageRange;
import javafx.print.PaperSource;
import javafx.print.PrintColor;
import javafx.print.PrintQuality;
import javafx.print.PrintResolution;
import javafx.print.PrintSides;
import javafx.print.Printer;
import javafx.print.PrinterAttributes;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Window;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public class J2DPrinterJob
implements PrinterJobImpl {
    javafx.print.PrinterJob fxPrinterJob;
    PrinterJob pJob2D;
    Printer fxPrinter;
    J2DPrinter j2dPrinter;
    private JobSettings settings;
    private PrintRequestAttributeSet printReqAttrSet;
    private volatile Object elo = null;
    private boolean jobRunning = false;
    private boolean jobError = false;
    private boolean jobDone = false;
    private J2DPageable j2dPageable = null;
    private Object monitor = new Object();

    public J2DPrinterJob(javafx.print.PrinterJob fxJob) {
        this.fxPrinterJob = fxJob;
        this.fxPrinter = this.fxPrinterJob.getPrinter();
        this.j2dPrinter = this.getJ2DPrinter(this.fxPrinter);
        this.settings = this.fxPrinterJob.getJobSettings();
        this.pJob2D = PrinterJob.getPrinterJob();
        try {
            this.pJob2D.setPrintService(this.j2dPrinter.getService());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        this.printReqAttrSet = new HashPrintRequestAttributeSet();
        if (!PlatformUtil.isLinux()) {
            this.printReqAttrSet.add(DialogTypeSelection.NATIVE);
        }
        this.j2dPageable = new J2DPageable();
        this.pJob2D.setPageable(this.j2dPageable);
    }

    @Override
    public boolean showPrintDialog(Window owner) {
        if (this.jobRunning || this.jobDone) {
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        boolean rv = false;
        this.syncSettingsToAttributes();
        if (!Toolkit.getToolkit().isFxUserThread()) {
            rv = this.pJob2D.printDialog(this.printReqAttrSet);
        } else {
            if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
                throw new IllegalStateException("Printing is not allowed during animation or layout processing");
            }
            rv = this.showPrintDialogWithNestedLoop(owner);
        }
        if (rv) {
            this.updateSettingsFromDialog();
        }
        return rv;
    }

    private boolean showPrintDialogWithNestedLoop(Window owner) {
        PrintDialogRunnable dr = new PrintDialogRunnable();
        Thread prtThread = new Thread((Runnable)dr, "FX Print Dialog Thread");
        prtThread.start();
        Object rv = Toolkit.getToolkit().enterNestedEventLoop(dr);
        boolean rvbool = false;
        try {
            rvbool = (Boolean)rv;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rvbool;
    }

    @Override
    public boolean showPageDialog(Window owner) {
        if (this.jobRunning || this.jobDone) {
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        boolean rv = false;
        this.syncSettingsToAttributes();
        if (!Toolkit.getToolkit().isFxUserThread()) {
            PageFormat pf = this.pJob2D.pageDialog(this.printReqAttrSet);
            rv = pf != null;
        } else {
            if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
                throw new IllegalStateException("Printing is not allowed during animation or layout processing");
            }
            rv = this.showPageDialogFromNestedLoop(owner);
        }
        if (rv) {
            this.updateSettingsFromDialog();
        }
        return rv;
    }

    private boolean showPageDialogFromNestedLoop(Window owner) {
        PageDialogRunnable dr = new PageDialogRunnable();
        Thread prtThread = new Thread((Runnable)dr, "FX Page Setup Dialog Thread");
        prtThread.start();
        Object rv = Toolkit.getToolkit().enterNestedEventLoop(dr);
        boolean rvbool = false;
        try {
            rvbool = (Boolean)rv;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rvbool;
    }

    private void updateJobName() {
        String name = this.pJob2D.getJobName();
        if (!name.equals(this.settings.getJobName())) {
            this.settings.setJobName(name);
        }
    }

    private void updateCopies() {
        int nCopies = this.pJob2D.getCopies();
        if (this.settings.getCopies() != nCopies) {
            this.settings.setCopies(nCopies);
        }
    }

    private void updatePageRanges() {
        PageRanges ranges = (PageRanges)this.printReqAttrSet.get(PageRanges.class);
        if (ranges != null) {
            int[][] members = ranges.getMembers();
            if (members.length == 1) {
                PageRange range = new PageRange(members[0][0], members[0][1]);
                this.settings.setPageRanges(range);
            } else if (members.length > 0) {
                try {
                    ArrayList<PageRange> prList = new ArrayList<PageRange>();
                    int last = 0;
                    for (int i = 0; i < members.length; ++i) {
                        int s = members[i][0];
                        int e = members[i][1];
                        if (s <= last || e < s) {
                            return;
                        }
                        last = e;
                        prList.add(new PageRange(s, e));
                    }
                    this.settings.setPageRanges(prList.toArray(new PageRange[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void updateSides() {
        Sides sides = (Sides)this.printReqAttrSet.get(Sides.class);
        if (sides == null) {
            sides = (Sides)this.j2dPrinter.getService().getDefaultAttributeValue(Sides.class);
        }
        if (sides == Sides.ONE_SIDED) {
            this.settings.setPrintSides(PrintSides.ONE_SIDED);
        } else if (sides == Sides.DUPLEX) {
            this.settings.setPrintSides(PrintSides.DUPLEX);
        } else if (sides == Sides.TUMBLE) {
            this.settings.setPrintSides(PrintSides.TUMBLE);
        }
    }

    private void updateCollation() {
        SheetCollate collate = (SheetCollate)this.printReqAttrSet.get(SheetCollate.class);
        if (collate == null) {
            collate = this.j2dPrinter.getDefaultSheetCollate();
        }
        if (collate == SheetCollate.UNCOLLATED) {
            this.settings.setCollation(Collation.UNCOLLATED);
        } else {
            this.settings.setCollation(Collation.COLLATED);
        }
    }

    private void updateColor() {
        Chromaticity color = (Chromaticity)this.printReqAttrSet.get(Chromaticity.class);
        if (color == null) {
            color = this.j2dPrinter.getDefaultChromaticity();
        }
        if (color == Chromaticity.COLOR) {
            this.settings.setPrintColor(PrintColor.COLOR);
        } else {
            this.settings.setPrintColor(PrintColor.MONOCHROME);
        }
    }

    private void updatePrintQuality() {
        javax.print.attribute.standard.PrintQuality quality = (javax.print.attribute.standard.PrintQuality)this.printReqAttrSet.get(javax.print.attribute.standard.PrintQuality.class);
        if (quality == null) {
            quality = this.j2dPrinter.getDefaultPrintQuality();
        }
        if (quality == javax.print.attribute.standard.PrintQuality.DRAFT) {
            this.settings.setPrintQuality(PrintQuality.DRAFT);
        } else if (quality == javax.print.attribute.standard.PrintQuality.HIGH) {
            this.settings.setPrintQuality(PrintQuality.HIGH);
        } else {
            this.settings.setPrintQuality(PrintQuality.NORMAL);
        }
    }

    private void updatePrintResolution() {
        PrinterResolution res = (PrinterResolution)this.printReqAttrSet.get(PrinterResolution.class);
        if (res == null) {
            res = this.j2dPrinter.getDefaultPrinterResolution();
        }
        int cfr = res.getCrossFeedResolution(100);
        int fr = res.getFeedResolution(100);
        this.settings.setPrintResolution(PrintHelper.createPrintResolution(cfr, fr));
    }

    private void updatePageLayout() {
        PageLayout newLayout;
        Media media = (Media)this.printReqAttrSet.get(Media.class);
        javafx.print.Paper paper = this.j2dPrinter.getPaperForMedia(media);
        OrientationRequested o = (OrientationRequested)this.printReqAttrSet.get(OrientationRequested.class);
        PageOrientation orient = J2DPrinter.reverseMapOrientation(o);
        MediaPrintableArea mpa = (MediaPrintableArea)this.printReqAttrSet.get(MediaPrintableArea.class);
        if (mpa == null) {
            newLayout = this.fxPrinter.createPageLayout(paper, orient, Printer.MarginType.DEFAULT);
        } else {
            double pWid = paper.getWidth();
            double pHgt = paper.getHeight();
            int INCH = 25400;
            double mpaX = mpa.getX(INCH) * 72.0f;
            double mpaY = mpa.getY(INCH) * 72.0f;
            double mpaW = mpa.getWidth(INCH) * 72.0f;
            double mpaH = mpa.getHeight(INCH) * 72.0f;
            double lm = 0.0;
            double rm = 0.0;
            double tm = 0.0;
            double bm = 0.0;
            switch (orient) {
                case PORTRAIT: {
                    lm = mpaX;
                    rm = pWid - mpaX - mpaW;
                    tm = mpaY;
                    bm = pHgt - mpaY - mpaH;
                    break;
                }
                case REVERSE_PORTRAIT: {
                    lm = pWid - mpaX - mpaW;
                    rm = mpaX;
                    tm = pHgt - mpaY - mpaH;
                    bm = mpaY;
                    break;
                }
                case LANDSCAPE: {
                    lm = mpaY;
                    rm = pHgt - mpaY - mpaH;
                    tm = pWid - mpaX - mpaW;
                    bm = mpaX;
                    break;
                }
                case REVERSE_LANDSCAPE: {
                    lm = pHgt - mpaY - mpaH;
                    tm = mpaX;
                    rm = mpaY;
                    bm = pWid - mpaX - mpaW;
                }
            }
            if (Math.abs(lm) < 0.01) {
                lm = 0.0;
            }
            if (Math.abs(rm) < 0.01) {
                rm = 0.0;
            }
            if (Math.abs(tm) < 0.01) {
                tm = 0.0;
            }
            if (Math.abs(bm) < 0.01) {
                bm = 0.0;
            }
            newLayout = this.fxPrinter.createPageLayout(paper, orient, lm, rm, tm, bm);
        }
        this.settings.setPageLayout(newLayout);
    }

    private void updatePaperSource() {
        PaperSource s;
        Media m = (Media)this.printReqAttrSet.get(Media.class);
        if (m instanceof MediaTray && (s = this.j2dPrinter.getPaperSource((MediaTray)m)) != null) {
            this.settings.setPaperSource(s);
        }
    }

    private Printer getFXPrinterForService(PrintService service) {
        ObservableSet<Printer> printerSet = Printer.getAllPrinters();
        for (Printer p : printerSet) {
            J2DPrinter p2d = (J2DPrinter)PrintHelper.getPrinterImpl(p);
            PrintService s = p2d.getService();
            if (!s.equals(service)) continue;
            return p;
        }
        return this.fxPrinter;
    }

    @Override
    public void setPrinterImpl(PrinterImpl impl) {
        this.j2dPrinter = (J2DPrinter)impl;
        this.fxPrinter = this.j2dPrinter.getPrinter();
        try {
            this.pJob2D.setPrintService(this.j2dPrinter.getService());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    @Override
    public PrinterImpl getPrinterImpl() {
        return this.j2dPrinter;
    }

    private J2DPrinter getJ2DPrinter(Printer printer) {
        return (J2DPrinter)PrintHelper.getPrinterImpl(printer);
    }

    public Printer getPrinter() {
        return this.fxPrinter;
    }

    public void setPrinter(Printer printer) {
        this.fxPrinter = printer;
        this.j2dPrinter = this.getJ2DPrinter(printer);
        try {
            this.pJob2D.setPrintService(this.j2dPrinter.getService());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    private void updatePrinter() {
        PrintService jobService;
        PrintService currService = this.j2dPrinter.getService();
        if (currService.equals(jobService = this.pJob2D.getPrintService())) {
            return;
        }
        Printer newFXPrinter = this.getFXPrinterForService(jobService);
        this.fxPrinterJob.setPrinter(newFXPrinter);
    }

    private void updateSettingsFromDialog() {
        this.updatePrinter();
        this.updateJobName();
        this.updateCopies();
        this.updatePageRanges();
        this.updateSides();
        this.updateCollation();
        this.updatePageLayout();
        this.updatePaperSource();
        this.updateColor();
        this.updatePrintQuality();
        this.updatePrintResolution();
    }

    private void syncSettingsToAttributes() {
        this.syncJobName();
        this.syncCopies();
        this.syncPageRanges();
        this.syncSides();
        this.syncCollation();
        this.syncPageLayout();
        this.syncPaperSource();
        this.syncColor();
        this.syncPrintQuality();
        this.syncPrintResolution();
    }

    private void syncJobName() {
        this.pJob2D.setJobName(this.settings.getJobName());
    }

    private void syncCopies() {
        this.pJob2D.setCopies(this.settings.getCopies());
        this.printReqAttrSet.add(new Copies(this.settings.getCopies()));
    }

    private void syncPageRanges() {
        this.printReqAttrSet.remove(PageRanges.class);
        PageRange[] prArr = this.settings.getPageRanges();
        if (prArr != null && prArr.length > 0) {
            int len = prArr.length;
            int[][] ranges = new int[len][2];
            for (int i = 0; i < len; ++i) {
                ranges[i][0] = prArr[i].getStartPage();
                ranges[i][1] = prArr[i].getEndPage();
            }
            this.printReqAttrSet.add(new PageRanges(ranges));
        }
    }

    private void syncSides() {
        Sides j2dSides = Sides.ONE_SIDED;
        PrintSides sides = this.settings.getPrintSides();
        if (sides == PrintSides.DUPLEX) {
            j2dSides = Sides.DUPLEX;
        } else if (sides == PrintSides.TUMBLE) {
            j2dSides = Sides.TUMBLE;
        }
        this.printReqAttrSet.add(j2dSides);
    }

    private void syncCollation() {
        if (this.settings.getCollation() == Collation.UNCOLLATED) {
            this.printReqAttrSet.add(SheetCollate.UNCOLLATED);
        } else {
            this.printReqAttrSet.add(SheetCollate.COLLATED);
        }
    }

    private void syncPageLayout() {
        PageLayout layout = this.settings.getPageLayout();
        PageOrientation orient = layout.getPageOrientation();
        this.printReqAttrSet.add(J2DPrinter.mapOrientation(orient));
        double pWid = layout.getPaper().getWidth();
        double pHgt = layout.getPaper().getHeight();
        float widthInInches = (float)(pWid / 72.0);
        float heightInInches = (float)(pHgt / 72.0);
        MediaSizeName media = MediaSize.findMedia(widthInInches, heightInInches, 25400);
        if (media == null) {
            media = MediaSizeName.NA_LETTER;
        }
        this.printReqAttrSet.add(media);
        double ix = 0.0;
        double iy = 0.0;
        double iw = pWid;
        double ih = pHgt;
        switch (orient) {
            case PORTRAIT: {
                ix = layout.getLeftMargin();
                iy = layout.getTopMargin();
                iw = pWid - ix - layout.getRightMargin();
                ih = pHgt - iy - layout.getBottomMargin();
                break;
            }
            case REVERSE_PORTRAIT: {
                ix = layout.getRightMargin();
                iy = layout.getBottomMargin();
                iw = pWid - ix - layout.getLeftMargin();
                ih = pHgt - iy - layout.getTopMargin();
                break;
            }
            case LANDSCAPE: {
                ix = layout.getBottomMargin();
                iy = layout.getLeftMargin();
                iw = pWid - ix - layout.getTopMargin();
                ih = pHgt - iy - layout.getRightMargin();
                break;
            }
            case REVERSE_LANDSCAPE: {
                ix = layout.getTopMargin();
                iy = layout.getRightMargin();
                iw = pWid - ix - layout.getBottomMargin();
                ih = pHgt - iy - layout.getLeftMargin();
            }
        }
        MediaPrintableArea mpa = new MediaPrintableArea((float)(ix /= 72.0), (float)(iy /= 72.0), (float)(iw /= 72.0), (float)(ih /= 72.0), 25400);
        this.printReqAttrSet.add(mpa);
    }

    private void syncPaperSource() {
        MediaTray tray;
        PaperSource source;
        Media m = (Media)this.printReqAttrSet.get(Media.class);
        if (m != null && m instanceof MediaTray) {
            this.printReqAttrSet.remove(Media.class);
        }
        if (!(source = this.settings.getPaperSource()).equals(this.j2dPrinter.defaultPaperSource()) && (tray = this.j2dPrinter.getTrayForPaperSource(source)) != null) {
            this.printReqAttrSet.add(tray);
        }
    }

    private void syncColor() {
        if (this.settings.getPrintColor() == PrintColor.MONOCHROME) {
            this.printReqAttrSet.add(Chromaticity.MONOCHROME);
        } else {
            this.printReqAttrSet.add(Chromaticity.COLOR);
        }
    }

    private void syncPrintQuality() {
        PrintQuality quality = this.settings.getPrintQuality();
        javax.print.attribute.standard.PrintQuality j2DQuality = quality == PrintQuality.DRAFT ? javax.print.attribute.standard.PrintQuality.DRAFT : (quality == PrintQuality.HIGH ? javax.print.attribute.standard.PrintQuality.HIGH : javax.print.attribute.standard.PrintQuality.NORMAL);
        this.printReqAttrSet.add(j2DQuality);
    }

    private void syncPrintResolution() {
        int fRes;
        PrintResolution res;
        PrintService ps = this.pJob2D.getPrintService();
        if (!ps.isAttributeCategorySupported(PrinterResolution.class)) {
            this.printReqAttrSet.remove(PrinterResolution.class);
            return;
        }
        PrinterResolution pres = (PrinterResolution)this.printReqAttrSet.get(PrinterResolution.class);
        if (pres != null && !ps.isAttributeValueSupported(pres, null, null)) {
            this.printReqAttrSet.remove(PrinterResolution.class);
        }
        if ((res = this.settings.getPrintResolution()) == null) {
            return;
        }
        int cfRes = res.getCrossFeedResolution();
        pres = new PrinterResolution(cfRes, fRes = res.getFeedResolution(), 100);
        if (!ps.isAttributeValueSupported(pres, null, null)) {
            return;
        }
        this.printReqAttrSet.add(pres);
    }

    @Override
    public PageLayout validatePageLayout(PageLayout pageLayout) {
        boolean needsNewLayout = false;
        PrinterAttributes caps = this.fxPrinter.getPrinterAttributes();
        javafx.print.Paper p = pageLayout.getPaper();
        if (!caps.getSupportedPapers().contains(p)) {
            needsNewLayout = true;
            p = caps.getDefaultPaper();
        }
        PageOrientation o = pageLayout.getPageOrientation();
        if (!caps.getSupportedPageOrientations().contains((Object)o)) {
            needsNewLayout = true;
            o = caps.getDefaultPageOrientation();
        }
        if (needsNewLayout) {
            pageLayout = this.fxPrinter.createPageLayout(p, o, Printer.MarginType.DEFAULT);
        }
        return pageLayout;
    }

    private void checkPermissions() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
    }

    @Override
    public boolean print(PageLayout pageLayout, Node node) {
        if (Toolkit.getToolkit().isFxUserThread() && !Toolkit.getToolkit().canStartNestedEventLoop()) {
            throw new IllegalStateException("Printing is not allowed during animation or layout processing");
        }
        if (this.jobError || this.jobDone) {
            return false;
        }
        if (!this.jobRunning) {
            this.checkPermissions();
            this.syncSettingsToAttributes();
            PrintJobRunnable runnable = new PrintJobRunnable();
            Thread prtThread = new Thread((Runnable)runnable, "Print Job Thread");
            prtThread.start();
            this.jobRunning = true;
        }
        try {
            this.j2dPageable.implPrintPage(pageLayout, node);
        }
        catch (Throwable t) {
            if (PrismSettings.debug) {
                System.err.println("printPage caught exception.");
                t.printStackTrace();
            }
            this.jobError = true;
            this.jobDone = true;
        }
        return !this.jobError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean endJob() {
        if (!this.jobRunning || this.jobDone || this.jobError) return false;
        this.jobDone = true;
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
                return this.jobDone;
            }
        }
        catch (IllegalStateException e) {
            if (!PrismSettings.debug) return this.jobDone;
            System.err.println("Internal Error " + e);
            return this.jobDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelJob() {
        block7: {
            if (!this.pJob2D.isCancelled()) {
                this.pJob2D.cancel();
            }
            this.jobDone = true;
            if (this.jobRunning) {
                this.jobRunning = false;
                try {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.monitor.notify();
                    }
                }
                catch (IllegalStateException e) {
                    if (!PrismSettings.debug) break block7;
                    System.err.println("Internal Error " + e);
                }
            }
        }
    }

    private class J2DPageable
    implements Pageable,
    Printable {
        private volatile boolean pageDone;
        private int currPageIndex = -1;
        private volatile PageInfo newPageInfo = null;
        private PageInfo currPageInfo;
        private PageFormat currPageFormat;

        private J2DPageable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForNextPage(int pageIndex) {
            if (J2DPrinterJob.this.elo != null && this.currPageInfo != null) {
                Application.invokeLater(new ExitLoopRunnable(J2DPrinterJob.this.elo, null));
            }
            if (this.currPageInfo != null) {
                if (Toolkit.getToolkit().isFxUserThread()) {
                    this.currPageInfo.clearScene();
                } else {
                    Application.invokeAndWait(new ClearSceneRunnable(this.currPageInfo));
                }
            }
            this.currPageInfo = null;
            this.pageDone = true;
            Object object = J2DPrinterJob.this.monitor;
            synchronized (object) {
                if (this.newPageInfo == null) {
                    J2DPrinterJob.this.monitor.notify();
                }
                while (this.newPageInfo == null && !J2DPrinterJob.this.jobDone && !J2DPrinterJob.this.jobError) {
                    try {
                        J2DPrinterJob.this.monitor.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (J2DPrinterJob.this.jobDone || J2DPrinterJob.this.jobError) {
                return false;
            }
            this.currPageInfo = this.newPageInfo;
            this.newPageInfo = null;
            this.currPageIndex = pageIndex;
            this.currPageFormat = this.getPageFormatFromLayout(this.currPageInfo.getPageLayout());
            return true;
        }

        private PageFormat getPageFormatFromLayout(PageLayout layout) {
            Paper paper = new Paper();
            double pWid = layout.getPaper().getWidth();
            double pHgt = layout.getPaper().getHeight();
            double ix = 0.0;
            double iy = 0.0;
            double iw = pWid;
            double ih = pHgt;
            PageOrientation orient = layout.getPageOrientation();
            switch (orient) {
                case PORTRAIT: {
                    ix = layout.getLeftMargin();
                    iy = layout.getTopMargin();
                    iw = pWid - ix - layout.getRightMargin();
                    ih = pHgt - iy - layout.getBottomMargin();
                    break;
                }
                case REVERSE_PORTRAIT: {
                    ix = layout.getRightMargin();
                    iy = layout.getBottomMargin();
                    iw = pWid - ix - layout.getLeftMargin();
                    ih = pHgt - iy - layout.getTopMargin();
                    break;
                }
                case LANDSCAPE: {
                    ix = layout.getBottomMargin();
                    iy = layout.getLeftMargin();
                    iw = pWid - ix - layout.getTopMargin();
                    ih = pHgt - iy - layout.getRightMargin();
                    break;
                }
                case REVERSE_LANDSCAPE: {
                    ix = layout.getTopMargin();
                    iy = layout.getRightMargin();
                    iw = pWid - ix - layout.getBottomMargin();
                    ih = pHgt - iy - layout.getLeftMargin();
                }
            }
            paper.setSize(pWid, pHgt);
            paper.setImageableArea(ix, iy, iw, ih);
            PageFormat format = new PageFormat();
            format.setOrientation(J2DPrinter.getOrientID(orient));
            format.setPaper(paper);
            return format;
        }

        private boolean getPage(int pageIndex) {
            if (pageIndex == this.currPageIndex) {
                return true;
            }
            boolean nextPage = false;
            if (pageIndex > this.currPageIndex) {
                nextPage = this.waitForNextPage(pageIndex);
            }
            return nextPage;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) {
            if (J2DPrinterJob.this.jobError || J2DPrinterJob.this.jobDone || !this.getPage(pageIndex)) {
                return 1;
            }
            int x = (int)pf.getImageableX();
            int y = (int)pf.getImageableY();
            int w = (int)pf.getImageableWidth();
            int h = (int)pf.getImageableHeight();
            Node appNode = this.currPageInfo.getNode();
            g.translate(x, y);
            this.printNode(appNode, g, w, h);
            return 0;
        }

        private void printNode(Node node, Graphics g, int w, int h) {
            PrismPrintGraphics ppg = new PrismPrintGraphics((Graphics2D)g, w, h);
            Object pgNode = node.impl_getPeer();
            boolean errored = false;
            try {
                ((NGNode)pgNode).render(ppg);
            }
            catch (Throwable t) {
                if (PrismSettings.debug) {
                    System.err.println("printNode caught exception.");
                    t.printStackTrace();
                }
                errored = true;
            }
            ppg.getResourceFactory().getTextureResourcePool().freeDisposalRequestedAndCheckResources(errored);
        }

        @Override
        public Printable getPrintable(int pageIndex) {
            this.getPage(pageIndex);
            return this;
        }

        @Override
        public PageFormat getPageFormat(int pageIndex) {
            this.getPage(pageIndex);
            return this.currPageFormat;
        }

        @Override
        public int getNumberOfPages() {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implPrintPage(PageLayout pageLayout, Node node) {
            this.pageDone = false;
            Object object = J2DPrinterJob.this.monitor;
            synchronized (object) {
                this.newPageInfo = new PageInfo(pageLayout, node);
                J2DPrinterJob.this.monitor.notify();
            }
            if (Toolkit.getToolkit().isFxUserThread()) {
                J2DPrinterJob.this.elo = new Object();
                Toolkit.getToolkit().enterNestedEventLoop(J2DPrinterJob.this.elo);
                J2DPrinterJob.this.elo = null;
            } else {
                while (!(this.pageDone || J2DPrinterJob.this.jobDone || J2DPrinterJob.this.jobError)) {
                    object = J2DPrinterJob.this.monitor;
                    synchronized (object) {
                        try {
                            if (!this.pageDone) {
                                J2DPrinterJob.this.monitor.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    static class ExitLoopRunnable
    implements Runnable {
        Object elo;
        Object rv;

        ExitLoopRunnable(Object elo, Object rv) {
            this.elo = elo;
            this.rv = rv;
        }

        @Override
        public void run() {
            Toolkit.getToolkit().exitNestedEventLoop(this.elo, this.rv);
        }
    }

    private static class PageInfo {
        private PageLayout pageLayout;
        private Node node;
        private Parent root;
        private Node topNode;
        private Group group;
        private boolean tempGroup;
        private boolean tempScene;
        private boolean sceneInited;

        PageInfo(PageLayout pageLayout, Node node) {
            this.pageLayout = pageLayout;
            this.node = node;
        }

        Node getNode() {
            this.initScene();
            return this.node;
        }

        PageLayout getPageLayout() {
            return this.pageLayout;
        }

        void initScene() {
            if (this.sceneInited) {
                return;
            }
            if (this.node.getScene() == null) {
                this.tempScene = true;
                Node topNode = this.node;
                while (topNode.getParent() != null) {
                    topNode = topNode.getParent();
                }
                if (topNode instanceof Group) {
                    this.group = (Group)topNode;
                } else {
                    this.tempGroup = true;
                    this.group = new Group();
                    this.group.getChildren().add(topNode);
                }
                this.root = this.group;
            } else {
                this.root = this.node.getScene().getRoot();
            }
            if (Toolkit.getToolkit().isFxUserThread()) {
                if (this.tempScene && this.root.getScene() == null) {
                    new Scene(this.root);
                }
                NodeHelper.layoutNodeForPrinting(this.root);
            } else {
                Application.invokeAndWait(new LayoutRunnable(this));
            }
            this.sceneInited = true;
        }

        private void clearScene() {
            if (this.tempGroup) {
                this.group.getChildren().removeAll((Node[])new Node[]{this.root});
            }
            this.tempGroup = false;
            this.tempScene = false;
            this.root = null;
            this.group = null;
            this.topNode = null;
            this.sceneInited = false;
        }
    }

    static class ClearSceneRunnable
    implements Runnable {
        PageInfo pageInfo;

        ClearSceneRunnable(PageInfo info) {
            this.pageInfo = info;
        }

        @Override
        public void run() {
            this.pageInfo.clearScene();
        }
    }

    static class LayoutRunnable
    implements Runnable {
        PageInfo pageInfo;

        LayoutRunnable(PageInfo info) {
            this.pageInfo = info;
        }

        @Override
        public void run() {
            if (this.pageInfo.tempScene && this.pageInfo.root.getScene() == null) {
                new Scene(this.pageInfo.root);
            }
            NodeHelper.layoutNodeForPrinting(this.pageInfo.root);
        }
    }

    private class PrintJobRunnable
    implements Runnable {
        private PrintJobRunnable() {
        }

        @Override
        public void run() {
            try {
                J2DPrinterJob.this.pJob2D.print(J2DPrinterJob.this.printReqAttrSet);
                J2DPrinterJob.this.jobDone = true;
            }
            catch (Throwable t) {
                if (PrismSettings.debug) {
                    System.err.println("print caught exception.");
                    t.printStackTrace();
                }
                J2DPrinterJob.this.jobError = true;
                J2DPrinterJob.this.jobDone = true;
            }
            if (J2DPrinterJob.this.elo != null) {
                Application.invokeLater(new ExitLoopRunnable(J2DPrinterJob.this.elo, null));
            }
        }
    }

    private class PageDialogRunnable
    implements Runnable {
        private PageDialogRunnable() {
        }

        @Override
        public void run() {
            Boolean rv2;
            PageFormat pf = null;
            try {
                pf = J2DPrinterJob.this.pJob2D.pageDialog(J2DPrinterJob.this.printReqAttrSet);
                rv2 = pf != null;
            }
            catch (Exception rv2) {
                Boolean rv3 = pf != null;
                Application.invokeLater(new ExitLoopRunnable(this, rv3));
            }
            catch (Throwable throwable) {
                Boolean rv4 = pf != null;
                Application.invokeLater(new ExitLoopRunnable(this, rv4));
                throw throwable;
            }
            Application.invokeLater(new ExitLoopRunnable(this, rv2));
        }
    }

    private class PrintDialogRunnable
    implements Runnable {
        private PrintDialogRunnable() {
        }

        @Override
        public void run() {
            boolean rv = false;
            try {
                rv = J2DPrinterJob.this.pJob2D.printDialog(J2DPrinterJob.this.printReqAttrSet);
            }
            catch (Exception exception) {
            }
            finally {
                Application.invokeLater(new ExitLoopRunnable(this, rv));
            }
        }
    }
}

