/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Clipboard;
import com.sun.glass.ui.ClipboardAssistance;
import java.util.HashMap;

public abstract class SystemClipboard
extends Clipboard {
    protected SystemClipboard(String name) {
        super(name);
        Application.checkEventThread();
    }

    protected abstract boolean isOwner();

    protected abstract void pushToSystem(HashMap<String, Object> var1, int var2);

    protected abstract void pushTargetActionToSystem(int var1);

    protected abstract Object popFromSystem(String var1);

    protected abstract int supportedSourceActionsFromSystem();

    protected abstract String[] mimesFromSystem();

    @Override
    public void flush(ClipboardAssistance dataSource, HashMap<String, Object> cacheData, int supportedActions) {
        Application.checkEventThread();
        this.setSharedData(dataSource, cacheData, supportedActions);
        this.pushToSystem(cacheData, supportedActions);
    }

    @Override
    public int getSupportedSourceActions() {
        Application.checkEventThread();
        if (this.isOwner()) {
            return super.getSupportedSourceActions();
        }
        return this.supportedSourceActionsFromSystem();
    }

    @Override
    public void setTargetAction(int actionDone) {
        Application.checkEventThread();
        this.pushTargetActionToSystem(actionDone);
    }

    public Object getLocalData(String mimeType) {
        return super.getData(mimeType);
    }

    @Override
    public Object getData(String mimeType) {
        Application.checkEventThread();
        if (this.isOwner()) {
            return this.getLocalData(mimeType);
        }
        return this.popFromSystem(mimeType);
    }

    @Override
    public String[] getMimeTypes() {
        Application.checkEventThread();
        if (this.isOwner()) {
            return super.getMimeTypes();
        }
        return this.mimesFromSystem();
    }

    @Override
    public String toString() {
        Application.checkEventThread();
        return "System Clipboard";
    }
}

