/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Mappings
implements Serializable {
    private static final long serialVersionUID = 4649790259460259026L;
    protected Map<String, ClassMapping> m_classesByObf = Maps.newHashMap();
    protected Map<String, ClassMapping> m_classesByDeobf = Maps.newHashMap();

    public Mappings() {
    }

    public Mappings(Iterable<ClassMapping> classes) {
        this();
        for (ClassMapping classMapping : classes) {
            this.m_classesByObf.put(classMapping.getObfFullName(), classMapping);
            if (classMapping.getDeobfName() == null) continue;
            this.m_classesByDeobf.put(classMapping.getDeobfName(), classMapping);
        }
    }

    public Collection<ClassMapping> classes() {
        assert (this.m_classesByObf.size() >= this.m_classesByDeobf.size());
        return this.m_classesByObf.values();
    }

    public void addClassMapping(ClassMapping classMapping) {
        boolean obfWasAdded;
        if (this.m_classesByObf.containsKey(classMapping.getObfFullName())) {
            throw new Error("Already have mapping for " + classMapping.getObfFullName());
        }
        boolean bl = obfWasAdded = this.m_classesByObf.put(classMapping.getObfFullName(), classMapping) == null;
        assert (obfWasAdded);
        if (classMapping.getDeobfName() != null) {
            boolean deobfWasAdded;
            if (this.m_classesByDeobf.containsKey(classMapping.getDeobfName())) {
                throw new Error("Already have mapping for " + classMapping.getDeobfName());
            }
            boolean bl2 = deobfWasAdded = this.m_classesByDeobf.put(classMapping.getDeobfName(), classMapping) == null;
            assert (deobfWasAdded);
        }
    }

    public void removeClassMapping(ClassMapping classMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.m_classesByObf.remove(classMapping.getObfFullName()) != null;
        assert (obfWasRemoved);
        if (classMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.m_classesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (deobfWasRemoved);
        }
    }

    public ClassMapping getClassByObf(ClassEntry entry) {
        return this.getClassByObf(entry.getName());
    }

    public ClassMapping getClassByObf(String obfName) {
        return this.m_classesByObf.get(obfName);
    }

    public ClassMapping getClassByDeobf(ClassEntry entry) {
        return this.getClassByDeobf(entry.getName());
    }

    public ClassMapping getClassByDeobf(String deobfName) {
        return this.m_classesByDeobf.get(deobfName);
    }

    public Translator getTranslator(TranslationDirection direction, TranslationIndex index) {
        switch (direction) {
            case Deobfuscating: {
                return new Translator(direction, this.m_classesByObf, index);
            }
            case Obfuscating: {
                HashMap classes = Maps.newHashMap();
                for (ClassMapping classMapping : this.classes()) {
                    if (classMapping.getDeobfName() != null) {
                        classes.put(classMapping.getDeobfName(), classMapping);
                        continue;
                    }
                    classes.put(classMapping.getObfFullName(), classMapping);
                }
                TranslationIndex deobfIndex = new TranslationIndex(index, this.getTranslator(TranslationDirection.Deobfuscating, index));
                return new Translator(direction, classes, deobfIndex);
            }
        }
        throw new Error("Invalid translation direction!");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (ClassMapping classMapping : this.m_classesByObf.values()) {
            buf.append(classMapping.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public void renameObfClass(String oldObfName, String newObfName) {
        for (ClassMapping classMapping : new ArrayList<ClassMapping>(this.classes())) {
            boolean wasAdded;
            boolean wasRemoved;
            if (!classMapping.renameObfClass(oldObfName, newObfName)) continue;
            boolean bl = wasRemoved = this.m_classesByObf.remove(oldObfName) != null;
            assert (wasRemoved);
            boolean bl2 = wasAdded = this.m_classesByObf.put(newObfName, classMapping) == null;
            assert (wasAdded);
        }
    }

    public Set<String> getAllObfClassNames() {
        HashSet classNames = Sets.newHashSet();
        for (ClassMapping classMapping : this.classes()) {
            classNames.add(classMapping.getObfFullName());
            for (MethodMapping methodMapping : classMapping.methods()) {
                for (Type type : methodMapping.getObfSignature().types()) {
                    if (!type.hasClass()) continue;
                    classNames.add(type.getClassEntry().getClassName());
                }
            }
        }
        return classNames;
    }

    public boolean containsDeobfClass(String deobfName) {
        return this.m_classesByDeobf.containsKey(deobfName);
    }

    public boolean containsDeobfField(ClassEntry obfClassEntry, String deobfName, Type obfType) {
        ClassMapping classMapping = this.m_classesByObf.get(obfClassEntry.getName());
        if (classMapping != null) {
            return classMapping.containsDeobfField(deobfName, obfType);
        }
        return false;
    }

    public boolean containsDeobfMethod(ClassEntry obfClassEntry, String deobfName, Signature deobfSignature) {
        ClassMapping classMapping = this.m_classesByObf.get(obfClassEntry.getName());
        if (classMapping != null) {
            return classMapping.containsDeobfMethod(deobfName, deobfSignature);
        }
        return false;
    }

    public boolean containsArgument(BehaviorEntry obfBehaviorEntry, String name) {
        ClassMapping classMapping = this.m_classesByObf.get(obfBehaviorEntry.getClassName());
        if (classMapping != null) {
            return classMapping.containsArgument(obfBehaviorEntry, name);
        }
        return false;
    }
}

