/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cuchaz.enigma.convert.ClassIdentity;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassMatching {
    private Multimap<ClassIdentity, ClassIdentity> m_sourceClasses = ArrayListMultimap.create();
    private Multimap<ClassIdentity, ClassIdentity> m_matchedDestClasses = ArrayListMultimap.create();
    private List<ClassIdentity> m_unmatchedDestClasses = Lists.newArrayList();

    public void addSource(ClassIdentity c) {
        this.m_sourceClasses.put((Object)c, (Object)c);
    }

    public void matchDestClass(ClassIdentity destClass) {
        Collection matchedSourceClasses = this.m_sourceClasses.get((Object)destClass);
        if (matchedSourceClasses.isEmpty()) {
            this.m_unmatchedDestClasses.add(destClass);
        } else {
            this.m_matchedDestClasses.put((Object)destClass, (Object)destClass);
            ClassIdentity sourceClass = (ClassIdentity)matchedSourceClasses.iterator().next();
            assert (sourceClass.hashCode() == destClass.hashCode());
            assert (sourceClass.equals(destClass));
        }
    }

    public void removeSource(ClassIdentity sourceClass) {
        this.m_sourceClasses.remove((Object)sourceClass, (Object)sourceClass);
    }

    public void removeDest(ClassIdentity destClass) {
        this.m_matchedDestClasses.remove((Object)destClass, (Object)destClass);
        this.m_unmatchedDestClasses.remove(destClass);
    }

    public List<ClassIdentity> getSourceClasses() {
        return new ArrayList<ClassIdentity>(this.m_sourceClasses.values());
    }

    public List<ClassIdentity> getDestClasses() {
        ArrayList classes = Lists.newArrayList();
        classes.addAll(this.m_matchedDestClasses.values());
        classes.addAll(this.m_unmatchedDestClasses);
        return classes;
    }

    public BiMap<ClassIdentity, ClassIdentity> getUniqueMatches() {
        HashBiMap uniqueMatches = HashBiMap.create();
        for (ClassIdentity sourceClass : this.m_sourceClasses.keySet()) {
            Collection matchedSourceClasses = this.m_sourceClasses.get((Object)sourceClass);
            Collection matchedDestClasses = this.m_matchedDestClasses.get((Object)sourceClass);
            if (matchedSourceClasses.size() != 1 || matchedDestClasses.size() != 1) continue;
            ClassIdentity matchedSourceClass = (ClassIdentity)matchedSourceClasses.iterator().next();
            ClassIdentity matchedDestClass = (ClassIdentity)matchedDestClasses.iterator().next();
            uniqueMatches.put((Object)matchedSourceClass, (Object)matchedDestClass);
        }
        return uniqueMatches;
    }

    public BiMap<List<ClassIdentity>, List<ClassIdentity>> getAmbiguousMatches() {
        HashBiMap ambiguousMatches = HashBiMap.create();
        for (ClassIdentity sourceClass : this.m_sourceClasses.keySet()) {
            Collection matchedSourceClasses = this.m_sourceClasses.get((Object)sourceClass);
            Collection matchedDestClasses = this.m_matchedDestClasses.get((Object)sourceClass);
            if (matchedSourceClasses.size() <= 1 || matchedDestClasses.size() <= 1) continue;
            ambiguousMatches.put(new ArrayList(matchedSourceClasses), new ArrayList(matchedDestClasses));
        }
        return ambiguousMatches;
    }

    public int getNumAmbiguousSourceMatches() {
        int num = 0;
        for (Map.Entry entry : this.getAmbiguousMatches().entrySet()) {
            num += ((List)entry.getKey()).size();
        }
        return num;
    }

    public int getNumAmbiguousDestMatches() {
        int num = 0;
        for (Map.Entry entry : this.getAmbiguousMatches().entrySet()) {
            num += ((List)entry.getValue()).size();
        }
        return num;
    }

    public List<ClassIdentity> getUnmatchedSourceClasses() {
        ArrayList classes = Lists.newArrayList();
        for (ClassIdentity sourceClass : this.getSourceClasses()) {
            if (!this.m_matchedDestClasses.get((Object)sourceClass).isEmpty()) continue;
            classes.add(sourceClass);
        }
        return classes;
    }

    public List<ClassIdentity> getUnmatchedDestClasses() {
        return new ArrayList<ClassIdentity>(this.m_unmatchedDestClasses);
    }

    public Map<String, Map.Entry<ClassIdentity, List<ClassIdentity>>> getIndex() {
        HashMap conversion = Maps.newHashMap();
        for (Map.Entry entry : this.getUniqueMatches().entrySet()) {
            conversion.put(((ClassIdentity)entry.getKey()).getClassEntry().getName(), new AbstractMap.SimpleEntry<ClassIdentity, List<ClassIdentity>>((ClassIdentity)entry.getKey(), Arrays.asList((ClassIdentity)entry.getValue())));
        }
        for (Map.Entry entry : this.getAmbiguousMatches().entrySet()) {
            for (ClassIdentity sourceClass : (List)entry.getKey()) {
                conversion.put(sourceClass.getClassEntry().getName(), new AbstractMap.SimpleEntry<ClassIdentity, List>(sourceClass, (List)entry.getValue()));
            }
        }
        for (ClassIdentity sourceClass : this.getUnmatchedSourceClasses()) {
            conversion.put(sourceClass.getClassEntry().getName(), new AbstractMap.SimpleEntry<ClassIdentity, List<ClassIdentity>>(sourceClass, this.getUnmatchedDestClasses()));
        }
        return conversion;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%12s%8s%8s\n", "", "Source", "Dest"));
        buf.append(String.format("%12s%8d%8d\n", "Classes", this.getSourceClasses().size(), this.getDestClasses().size()));
        buf.append(String.format("%12s%8d%8d\n", "Unique", this.getUniqueMatches().size(), this.getUniqueMatches().size()));
        buf.append(String.format("%12s%8d%8d\n", "Ambiguous", this.getNumAmbiguousSourceMatches(), this.getNumAmbiguousDestMatches()));
        buf.append(String.format("%12s%8d%8d\n", "Unmatched", this.getUnmatchedSourceClasses().size(), this.getUnmatchedDestClasses().size()));
        return buf.toString();
    }
}

