/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import cuchaz.enigma.Util;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.bytecode.InfoType;
import cuchaz.enigma.bytecode.accessors.ConstInfoAccessor;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Signature;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import javax.swing.tree.TreeNode;

public class ClassIdentity {
    private ClassEntry m_classEntry;
    private ClassNamer.SidedClassNamer m_namer;
    private Multiset<String> m_fields;
    private Multiset<String> m_methods;
    private Multiset<String> m_constructors;
    private String m_staticInitializer;
    private String m_extends;
    private Multiset<String> m_implements;
    private Multiset<String> m_implementations;
    private Multiset<String> m_references;

    public ClassIdentity(CtClass c, ClassNamer.SidedClassNamer namer, JarIndex index, boolean useReferences) {
        this.m_namer = namer;
        this.m_classEntry = new ClassEntry(Descriptor.toJvmName((String)c.getName()));
        this.m_fields = HashMultiset.create();
        Object[] objectArray = c.getDeclaredFields();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtField field = objectArray[n2];
            this.m_fields.add((Object)this.scrubSignature(field.getSignature()));
            ++n2;
        }
        this.m_methods = HashMultiset.create();
        objectArray = c.getDeclaredMethods();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            CtField method = objectArray[n2];
            this.m_methods.add((Object)(String.valueOf(this.scrubSignature(method.getSignature())) + "0x" + this.getBehaviorSignature((CtBehavior)method)));
            ++n2;
        }
        this.m_constructors = HashMultiset.create();
        objectArray = c.getDeclaredConstructors();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            CtField constructor = objectArray[n2];
            this.m_constructors.add((Object)(String.valueOf(this.scrubSignature(constructor.getSignature())) + "0x" + this.getBehaviorSignature((CtBehavior)constructor)));
            ++n2;
        }
        this.m_staticInitializer = "";
        if (c.getClassInitializer() != null) {
            this.m_staticInitializer = this.getBehaviorSignature((CtBehavior)c.getClassInitializer());
        }
        this.m_extends = "";
        if (c.getClassFile().getSuperclass() != null) {
            this.m_extends = this.scrubClassName(c.getClassFile().getSuperclass());
        }
        this.m_implements = HashMultiset.create();
        objectArray = c.getClassFile().getInterfaces();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            CtField interfaceName = objectArray[n2];
            this.m_implements.add((Object)this.scrubClassName((String)interfaceName));
            ++n2;
        }
        this.m_implementations = HashMultiset.create();
        ClassImplementationsTreeNode implementationsNode = index.getClassImplementations(null, this.m_classEntry);
        if (implementationsNode != null) {
            Enumeration<TreeNode> implementations = implementationsNode.children();
            while (implementations.hasMoreElements()) {
                ClassImplementationsTreeNode node = (ClassImplementationsTreeNode)implementations.nextElement();
                this.m_implementations.add((Object)this.scrubClassName(node.getClassEntry().getName()));
            }
        }
        this.m_references = HashMultiset.create();
        if (useReferences) {
            CtField[] ctFieldArray = c.getDeclaredFields();
            int n3 = ctFieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CtField field = ctFieldArray[n4];
                FieldEntry fieldEntry = EntryFactory.getFieldEntry(field);
                for (EntryReference<FieldEntry, BehaviorEntry> entryReference : index.getFieldReferences(fieldEntry)) {
                    this.addReference(entryReference);
                }
                ++n4;
            }
            ctFieldArray = c.getDeclaredBehaviors();
            n3 = ctFieldArray.length;
            n4 = 0;
            while (n4 < n3) {
                CtField behavior = ctFieldArray[n4];
                BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
                for (EntryReference<Entry, BehaviorEntry> entryReference : index.getBehaviorReferences(behaviorEntry)) {
                    this.addReference(entryReference);
                }
                ++n4;
            }
        }
    }

    private void addReference(EntryReference<? extends Entry, BehaviorEntry> reference) {
        if (((BehaviorEntry)reference.context).getSignature() != null) {
            this.m_references.add((Object)String.format("%s_%s", this.scrubClassName(((BehaviorEntry)reference.context).getClassName()), this.scrubSignature(((BehaviorEntry)reference.context).getSignature())));
        } else {
            this.m_references.add((Object)String.format("%s_<clinit>", this.scrubClassName(((BehaviorEntry)reference.context).getClassName())));
        }
    }

    public ClassEntry getClassEntry() {
        return this.m_classEntry;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("class: ");
        buf.append(this.m_classEntry.getName());
        buf.append(" ");
        buf.append(this.hashCode());
        buf.append("\n");
        for (String field : this.m_fields) {
            buf.append("\tfield ");
            buf.append(field);
            buf.append("\n");
        }
        for (String method : this.m_methods) {
            buf.append("\tmethod ");
            buf.append(method);
            buf.append("\n");
        }
        for (String constructor : this.m_constructors) {
            buf.append("\tconstructor ");
            buf.append(constructor);
            buf.append("\n");
        }
        if (this.m_staticInitializer.length() > 0) {
            buf.append("\tinitializer ");
            buf.append(this.m_staticInitializer);
            buf.append("\n");
        }
        if (this.m_extends.length() > 0) {
            buf.append("\textends ");
            buf.append(this.m_extends);
            buf.append("\n");
        }
        for (String interfaceName : this.m_implements) {
            buf.append("\timplements ");
            buf.append(interfaceName);
            buf.append("\n");
        }
        for (String implementation : this.m_implementations) {
            buf.append("\timplemented by ");
            buf.append(implementation);
            buf.append("\n");
        }
        for (String reference : this.m_references) {
            buf.append("\treference ");
            buf.append(reference);
            buf.append("\n");
        }
        return buf.toString();
    }

    private String scrubClassName(String className) {
        return this.scrubSignature("L" + Descriptor.toJvmName((String)className) + ";");
    }

    private String scrubSignature(String signature) {
        return this.scrubSignature(new Signature(signature));
    }

    private String scrubSignature(Signature signature) {
        return new Signature(signature, new ClassNameReplacer(){
            private Map<String, String> m_classNames = Maps.newHashMap();

            @Override
            public String replace(String className) {
                String newName;
                ClassEntry classEntry = new ClassEntry(className);
                if (!classEntry.getPackageName().equals("none")) {
                    return className;
                }
                if (className.equals(ClassIdentity.this.m_classEntry.getName())) {
                    return "CSelf";
                }
                if (ClassIdentity.this.m_namer != null && (newName = ClassIdentity.this.m_namer.getName(className)) != null) {
                    return newName;
                }
                if (!this.m_classNames.containsKey(className)) {
                    this.m_classNames.put(className, this.getNewClassName());
                }
                return this.m_classNames.get(className);
            }

            private String getNewClassName() {
                return String.format("C%03d", this.m_classNames.size());
            }
        }).toString();
    }

    private boolean isClassMatchedUniquely(String className) {
        return this.m_namer != null && this.m_namer.getName(Descriptor.toJvmName((String)className)) != null;
    }

    private String getBehaviorSignature(CtBehavior behavior) {
        block8: {
            if (behavior.getMethodInfo().getCodeAttribute() != null) break block8;
            return "(none)";
        }
        try {
            ConstPool constants = behavior.getMethodInfo().getConstPool();
            final MessageDigest digest = MessageDigest.getInstance("MD5");
            CodeIterator iter = behavior.getMethodInfo().getCodeAttribute().iterator();
            while (iter.hasNext()) {
                int pos = iter.next();
                int opcode = iter.byteAt(pos);
                digest.update((byte)opcode);
                switch (opcode) {
                    case 18: {
                        int constIndex = iter.byteAt(pos + 1);
                        this.updateHashWithConstant(digest, constants, constIndex);
                        break;
                    }
                    case 19: 
                    case 20: {
                        int constIndex = iter.byteAt(pos + 1) << 8 | iter.byteAt(pos + 2);
                        this.updateHashWithConstant(digest, constants, constIndex);
                    }
                }
            }
            behavior.instrument(new ExprEditor(){

                public void edit(MethodCall call) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(call.getClassName()));
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubSignature(call.getSignature()));
                    if (ClassIdentity.this.isClassMatchedUniquely(call.getClassName())) {
                        ClassIdentity.this.updateHashWithString(digest, call.getMethodName());
                    }
                }

                public void edit(FieldAccess access) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(access.getClassName()));
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubSignature(access.getSignature()));
                    if (ClassIdentity.this.isClassMatchedUniquely(access.getClassName())) {
                        ClassIdentity.this.updateHashWithString(digest, access.getFieldName());
                    }
                }

                public void edit(ConstructorCall call) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(call.getClassName()));
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubSignature(call.getSignature()));
                }

                public void edit(NewExpr expr) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(expr.getClassName()));
                }
            });
            return this.toHex(digest.digest());
        }
        catch (NoSuchAlgorithmException | CannotCompileException | BadBytecode ex) {
            throw new Error(ex);
        }
    }

    private void updateHashWithConstant(MessageDigest digest, ConstPool constants, int index) {
        ConstPoolEditor editor = new ConstPoolEditor(constants);
        ConstInfoAccessor item = editor.getItem(index);
        if (item.getType() == InfoType.StringInfo) {
            this.updateHashWithString(digest, constants.getStringInfo(index));
        }
    }

    private void updateHashWithString(MessageDigest digest, String val) {
        try {
            digest.update(val.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    private String toHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public boolean equals(Object other) {
        if (other instanceof ClassIdentity) {
            return this.equals((ClassIdentity)other);
        }
        return false;
    }

    public boolean equals(ClassIdentity other) {
        return this.m_fields.equals(other.m_fields) && this.m_methods.equals(other.m_methods) && this.m_constructors.equals(other.m_constructors) && this.m_staticInitializer.equals(other.m_staticInitializer) && this.m_extends.equals(other.m_extends) && this.m_implements.equals(other.m_implements) && this.m_implementations.equals(other.m_implementations) && this.m_references.equals(other.m_references);
    }

    public int hashCode() {
        ArrayList objs = Lists.newArrayList();
        objs.addAll(this.m_fields);
        objs.addAll(this.m_methods);
        objs.addAll(this.m_constructors);
        objs.add(this.m_staticInitializer);
        objs.add(this.m_extends);
        objs.addAll(this.m_implements);
        objs.addAll(this.m_implementations);
        objs.addAll(this.m_references);
        return Util.combineHashesOrdered(objs);
    }

    public int getMatchScore(ClassIdentity other) {
        return this.getNumMatches(this.m_fields, other.m_fields) + this.getNumMatches(this.m_methods, other.m_methods) + this.getNumMatches(this.m_constructors, other.m_constructors);
    }

    public int getMaxMatchScore() {
        return this.m_fields.size() + this.m_methods.size() + this.m_constructors.size();
    }

    public boolean matches(CtClass c) {
        return this.m_fields.size() == c.getDeclaredFields().length && this.m_methods.size() == c.getDeclaredMethods().length && this.m_constructors.size() == c.getDeclaredConstructors().length;
    }

    private int getNumMatches(Multiset<String> a, Multiset<String> b) {
        int numMatches = 0;
        for (String val : a) {
            if (!b.contains((Object)val)) continue;
            ++numMatches;
        }
        return numMatches;
    }
}

