/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import com.google.common.collect.Maps;
import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.Type;
import java.util.HashMap;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.SourceFileAttribute;

public class ClassTranslator {
    private Translator m_translator;

    public ClassTranslator(Translator translator) {
        this.m_translator = translator;
    }

    public void translate(CtClass c) {
        Object translatedType;
        ConstPool constants = c.getClassFile().getConstPool();
        ConstPoolEditor editor = new ConstPoolEditor(constants);
        int i = 1;
        while (i < constants.getSize()) {
            switch (constants.getTag(i)) {
                case 9: {
                    Entry entry = new FieldEntry(new ClassEntry(Descriptor.toJvmName((String)constants.getFieldrefClassName(i))), constants.getFieldrefName(i), new Type(constants.getFieldrefType(i)));
                    Entry translatedEntry = this.m_translator.translateEntry((FieldEntry)entry);
                    Type type = new Type(constants.getFieldrefType(i));
                    translatedType = this.m_translator.translateType(type);
                    if (((FieldEntry)entry).equals((FieldEntry)translatedEntry) && type.equals((Type)translatedType)) break;
                    editor.changeMemberrefNameAndType(i, ((FieldEntry)translatedEntry).getName(), ((Type)translatedType).toString());
                    break;
                }
                case 10: 
                case 11: {
                    Entry entry = EntryFactory.getBehaviorEntry(Descriptor.toJvmName((String)editor.getMemberrefClassname(i)), editor.getMemberrefName(i), editor.getMemberrefType(i));
                    Entry translatedEntry = this.m_translator.translateEntry((BehaviorEntry)entry);
                    if (entry.getName().equals(translatedEntry.getName()) && entry.getSignature().equals(translatedEntry.getSignature())) break;
                    editor.changeMemberrefNameAndType(i, translatedEntry.getName(), translatedEntry.getSignature().toString());
                }
            }
            ++i;
        }
        ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName((String)c.getName()));
        translatedType = c.getDeclaredFields();
        int type = ((CtField[])translatedType).length;
        int translatedEntry = 0;
        while (translatedEntry < type) {
            CtField field = translatedType[translatedEntry];
            FieldEntry entry = EntryFactory.getFieldEntry(field);
            String translatedName = this.m_translator.translate(entry);
            if (translatedName != null) {
                field.setName(translatedName);
            }
            Type translatedType2 = this.m_translator.translateType(new Type(field.getFieldInfo().getDescriptor()));
            field.getFieldInfo().setDescriptor(translatedType2.toString());
            ++translatedEntry;
        }
        translatedType = c.getDeclaredBehaviors();
        type = ((CtBehavior[])translatedType).length;
        translatedEntry = 0;
        while (translatedEntry < type) {
            CtMethod method;
            MethodEntry entry;
            String translatedName;
            CtField behavior = translatedType[translatedEntry];
            if (behavior instanceof CtMethod && (translatedName = this.m_translator.translate(entry = EntryFactory.getMethodEntry(method = (CtMethod)behavior))) != null) {
                method.setName(translatedName);
            }
            Signature translatedSignature = this.m_translator.translateSignature(new Signature(behavior.getMethodInfo().getDescriptor()));
            behavior.getMethodInfo().setDescriptor(translatedSignature.toString());
            ++translatedEntry;
        }
        HashMap map = Maps.newHashMap();
        for (ClassEntry obfClassEntry : ClassRenamer.getAllClassEntries(c)) {
            ClassEntry deobfClassEntry;
            if (obfClassEntry.equals(deobfClassEntry = this.m_translator.translateEntry(obfClassEntry))) continue;
            map.put(obfClassEntry, deobfClassEntry);
        }
        ClassRenamer.renameClasses(c, map);
        ClassEntry deobfClassEntry = (ClassEntry)map.get(classEntry);
        if (deobfClassEntry != null) {
            String sourceFile = String.valueOf(Descriptor.toJvmName((String)deobfClassEntry.getOuterClassName())) + ".java";
            c.getClassFile().addAttribute((AttributeInfo)new SourceFileAttribute(constants, sourceFile));
        }
    }
}

