/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.ClassMap;
import javassist.CtClass;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.InnerClassesAttribute;

public class ClassRenamer {
    public static void renameClasses(CtClass c, Map<ClassEntry, ClassEntry> map) {
        ClassMap nameMap = new ClassMap();
        for (Map.Entry<ClassEntry, ClassEntry> entry : map.entrySet()) {
            nameMap.put(entry.getKey().getName(), entry.getValue().getName());
        }
        c.replaceClassName(nameMap);
        ConstPool constants = c.getClassFile().getConstPool();
        InnerClassesAttribute attr = (InnerClassesAttribute)c.getClassFile().getAttribute("InnerClasses");
        if (attr != null) {
            int i = 0;
            while (i < attr.tableLength()) {
                ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName((String)attr.innerClass(i)));
                if (attr.innerNameIndex(i) != 0) {
                    attr.setInnerNameIndex(i, constants.addUtf8Info(classEntry.getInnerClassName()));
                }
                ++i;
            }
        }
    }

    public static Set<ClassEntry> getAllClassEntries(CtClass c) {
        final HashSet entries = Sets.newHashSet();
        ClassMap map = new ClassMap(){
            private static final long serialVersionUID = -202160293602070641L;

            public Object get(Object obj) {
                if (obj instanceof String) {
                    String str = (String)obj;
                    if (str.indexOf(60) >= 0 || str.indexOf(62) >= 0 || str.indexOf(59) >= 0) {
                        return null;
                    }
                    str = str.replace('.', '$');
                    entries.add(new ClassEntry(str));
                }
                return null;
            }
        };
        c.replaceClassName(map);
        return entries;
    }

    public static void moveAllClassesOutOfDefaultPackage(CtClass c, String newPackageName) {
        HashMap map = Maps.newHashMap();
        for (ClassEntry classEntry : ClassRenamer.getAllClassEntries(c)) {
            if (!classEntry.isInDefaultPackage()) continue;
            map.put(classEntry, new ClassEntry(String.valueOf(newPackageName) + "/" + classEntry.getName()));
        }
        ClassRenamer.renameClasses(c, map);
    }

    public static void moveAllClassesIntoDefaultPackage(CtClass c, String oldPackageName) {
        HashMap map = Maps.newHashMap();
        for (ClassEntry classEntry : ClassRenamer.getAllClassEntries(c)) {
            if (!classEntry.getPackageName().equals(oldPackageName)) continue;
            map.put(classEntry, new ClassEntry(classEntry.getSimpleName()));
        }
        ClassRenamer.renameClasses(c, map);
    }
}

