/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.EntryRenamer;
import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.InnerClassesAttribute;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;

public class JarIndex {
    private Set<ClassEntry> m_obfClassEntries = Sets.newHashSet();
    private TranslationIndex m_translationIndex = new TranslationIndex();
    private Multimap<String, String> m_interfaces = HashMultimap.create();
    private Map<Entry, Access> m_access = Maps.newHashMap();
    private Multimap<String, MethodEntry> m_methodImplementations = HashMultimap.create();
    private Multimap<BehaviorEntry, EntryReference<BehaviorEntry, BehaviorEntry>> m_behaviorReferences = HashMultimap.create();
    private Multimap<FieldEntry, EntryReference<FieldEntry, BehaviorEntry>> m_fieldReferences = HashMultimap.create();
    private Multimap<ClassEntry, ClassEntry> m_innerClassesByOuter = HashMultimap.create();
    private Map<ClassEntry, ClassEntry> m_outerClassesByInner = Maps.newHashMap();
    private Map<ClassEntry, BehaviorEntry> m_anonymousClasses = Maps.newHashMap();
    private Map<MethodEntry, MethodEntry> m_bridgedMethods = Maps.newHashMap();

    public void indexJar(JarFile jar, boolean buildInnerClasses) {
        CtField behavior;
        int n;
        for (ClassEntry classEntry : JarClassIterator.getClassEntries(jar)) {
            if (classEntry.isInDefaultPackage()) {
                classEntry = new ClassEntry("none/" + classEntry.getName());
            }
            this.m_obfClassEntries.add(classEntry);
        }
        for (CtClass c : JarClassIterator.classes(jar)) {
            ClassRenamer.moveAllClassesOutOfDefaultPackage(c, "none");
            CtField[] ctFieldArray = c.getDeclaredFields();
            n = ctFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                CtField field = ctFieldArray[n2];
                this.m_access.put(EntryFactory.getFieldEntry(field), Access.get(field));
                ++n2;
            }
            ctFieldArray = c.getDeclaredBehaviors();
            n = ctFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                behavior = ctFieldArray[n2];
                this.m_access.put(EntryFactory.getBehaviorEntry((CtBehavior)behavior), Access.get((CtBehavior)behavior));
                ++n2;
            }
        }
        for (CtClass c : JarClassIterator.classes(jar)) {
            ClassRenamer.moveAllClassesOutOfDefaultPackage(c, "none");
            this.m_translationIndex.indexClass(c);
            String className = Descriptor.toJvmName((String)c.getName());
            String[] stringArray = c.getClassFile().getInterfaces();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String interfaceName = stringArray[n];
                if ((className = Descriptor.toJvmName((String)className)).equals(interfaceName = Descriptor.toJvmName((String)interfaceName))) {
                    throw new IllegalArgumentException("Class cannot be its own interface! " + className);
                }
                this.m_interfaces.put((Object)className, (Object)interfaceName);
                ++n;
            }
            stringArray = c.getDeclaredBehaviors();
            n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String behavior2 = stringArray[n];
                this.indexBehavior((CtBehavior)behavior2);
                ++n;
            }
        }
        for (CtClass c : JarClassIterator.classes(jar)) {
            ClassRenamer.moveAllClassesOutOfDefaultPackage(c, "none");
            CtBehavior[] ctBehaviorArray = c.getDeclaredBehaviors();
            n = ctBehaviorArray.length;
            int behavior2 = 0;
            while (behavior2 < n) {
                behavior = ctBehaviorArray[behavior2];
                this.indexBehaviorReferences((CtBehavior)behavior);
                ++behavior2;
            }
        }
        if (buildInnerClasses) {
            for (CtClass c : JarClassIterator.classes(jar)) {
                boolean innerWasAdded;
                ClassRenamer.moveAllClassesOutOfDefaultPackage(c, "none");
                ClassEntry innerClassEntry = EntryFactory.getClassEntry(c);
                ClassEntry outerClassEntry = this.findOuterClass(c);
                if (outerClassEntry == null) continue;
                this.m_innerClassesByOuter.put((Object)outerClassEntry, (Object)innerClassEntry);
                boolean bl = innerWasAdded = this.m_outerClassesByInner.put(innerClassEntry, outerClassEntry) == null;
                assert (innerWasAdded);
                BehaviorEntry enclosingBehavior = this.isAnonymousClass(c, outerClassEntry);
                if (enclosingBehavior == null) continue;
                this.m_anonymousClasses.put(innerClassEntry, enclosingBehavior);
            }
            HashMap renames = Maps.newHashMap();
            for (ClassEntry innerClassEntry : this.m_innerClassesByOuter.values()) {
                String newName = innerClassEntry.buildClassEntry(this.getObfClassChain(innerClassEntry)).getName();
                if (innerClassEntry.getName().equals(newName)) continue;
                renames.put(innerClassEntry.getName(), newName);
            }
            EntryRenamer.renameClassesInSet(renames, this.m_obfClassEntries);
            this.m_translationIndex.renameClasses(renames);
            EntryRenamer.renameClassesInMultimap(renames, this.m_interfaces);
            EntryRenamer.renameClassesInMultimap(renames, this.m_methodImplementations);
            EntryRenamer.renameClassesInMultimap(renames, this.m_behaviorReferences);
            EntryRenamer.renameClassesInMultimap(renames, this.m_fieldReferences);
            EntryRenamer.renameClassesInMap(renames, this.m_access);
        }
    }

    private void indexBehavior(CtBehavior behavior) {
        BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(behavior);
        if (behaviorEntry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)behaviorEntry;
            this.m_methodImplementations.put((Object)behaviorEntry.getClassName(), (Object)methodEntry);
            CtMethod bridgedMethod = this.getBridgedMethod((CtMethod)behavior);
            if (bridgedMethod != null) {
                this.m_bridgedMethods.put(methodEntry, EntryFactory.getMethodEntry(bridgedMethod));
            }
        }
    }

    private void indexBehaviorReferences(CtBehavior behavior) {
        final BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(behavior);
        try {
            behavior.instrument(new ExprEditor(){

                public void edit(MethodCall call) {
                    MethodEntry calledMethodEntry = EntryFactory.getMethodEntry(call);
                    ClassEntry resolvedClassEntry = JarIndex.this.m_translationIndex.resolveEntryClass(calledMethodEntry);
                    if (resolvedClassEntry != null && !resolvedClassEntry.equals(calledMethodEntry.getClassEntry())) {
                        calledMethodEntry = new MethodEntry(resolvedClassEntry, calledMethodEntry.getName(), calledMethodEntry.getSignature());
                    }
                    EntryReference<MethodEntry, BehaviorEntry> reference = new EntryReference<MethodEntry, BehaviorEntry>(calledMethodEntry, call.getMethodName(), behaviorEntry);
                    JarIndex.this.m_behaviorReferences.put((Object)calledMethodEntry, reference);
                }

                public void edit(FieldAccess call) {
                    FieldEntry calledFieldEntry = EntryFactory.getFieldEntry(call);
                    ClassEntry resolvedClassEntry = JarIndex.this.m_translationIndex.resolveEntryClass(calledFieldEntry);
                    if (resolvedClassEntry != null && !resolvedClassEntry.equals(calledFieldEntry.getClassEntry())) {
                        calledFieldEntry = new FieldEntry(calledFieldEntry, resolvedClassEntry);
                    }
                    EntryReference<FieldEntry, BehaviorEntry> reference = new EntryReference<FieldEntry, BehaviorEntry>(calledFieldEntry, call.getFieldName(), behaviorEntry);
                    JarIndex.this.m_fieldReferences.put((Object)calledFieldEntry, reference);
                }

                public void edit(ConstructorCall call) {
                    ConstructorEntry calledConstructorEntry = EntryFactory.getConstructorEntry(call);
                    EntryReference<ConstructorEntry, BehaviorEntry> reference = new EntryReference<ConstructorEntry, BehaviorEntry>(calledConstructorEntry, call.getMethodName(), behaviorEntry);
                    JarIndex.this.m_behaviorReferences.put((Object)calledConstructorEntry, reference);
                }

                public void edit(NewExpr call) {
                    ConstructorEntry calledConstructorEntry = EntryFactory.getConstructorEntry(call);
                    EntryReference<ConstructorEntry, BehaviorEntry> reference = new EntryReference<ConstructorEntry, BehaviorEntry>(calledConstructorEntry, call.getClassName(), behaviorEntry);
                    JarIndex.this.m_behaviorReferences.put((Object)calledConstructorEntry, reference);
                }
            });
        }
        catch (CannotCompileException ex) {
            throw new Error(ex);
        }
    }

    private CtMethod getBridgedMethod(CtMethod method) {
        if ((method.getModifiers() & 0x1000) == 0) {
            return null;
        }
        final ArrayList methodCalls = Lists.newArrayList();
        try {
            method.instrument(new ExprEditor(){

                public void edit(MethodCall call) {
                    methodCalls.add(call);
                }
            });
        }
        catch (CannotCompileException ex) {
            throw new Error(ex);
        }
        if (methodCalls.size() != 1) {
            return null;
        }
        MethodCall call = (MethodCall)methodCalls.get(0);
        try {
            return call.getMethod();
        }
        catch (NotFoundException ex) {
            return null;
        }
    }

    private ClassEntry findOuterClass(CtClass c) {
        ClassEntry classEntry = EntryFactory.getClassEntry(c);
        if (classEntry.isInnerClass()) {
            return classEntry.getOuterClassEntry();
        }
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)c.getClassFile().getAttribute("InnerClasses");
        if (innerClassesAttribute != null) {
            int i = 0;
            while (i < innerClassesAttribute.tableLength()) {
                ClassEntry innerClassEntry = new ClassEntry(Descriptor.toJvmName((String)innerClassesAttribute.innerClass(i)));
                if (classEntry.equals(innerClassEntry)) {
                    return new ClassEntry(Descriptor.toJvmName((String)innerClassesAttribute.outerClass(i)));
                }
                ++i;
            }
        }
        CtConstructor[] ctConstructorArray = c.getDeclaredConstructors();
        int n = ctConstructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtConstructor constructor = ctConstructorArray[n2];
            HashSet syntheticFieldTypes = Sets.newHashSet();
            if (this.isIllegalConstructor(syntheticFieldTypes, constructor)) {
                ConstructorEntry constructorEntry = EntryFactory.getConstructorEntry(constructor);
                HashSet illegallySetClasses = Sets.newHashSet();
                for (String type : syntheticFieldTypes) {
                    ClassEntry outerClassEntry;
                    if (!type.startsWith("L") || !this.isSaneOuterClass(outerClassEntry = new ClassEntry(type.substring(1, type.length() - 1)), classEntry)) continue;
                    illegallySetClasses.add(outerClassEntry);
                }
                HashSet callerClasses = Sets.newHashSet();
                for (EntryReference<BehaviorEntry, BehaviorEntry> reference : this.getBehaviorReferences(constructorEntry)) {
                    if (reference.entry instanceof ConstructorEntry && reference.context instanceof ConstructorEntry) {
                        ClassEntry calledClassEntry = ((BehaviorEntry)reference.entry).getClassEntry();
                        ClassEntry superclassEntry = this.m_translationIndex.getSuperclass(((BehaviorEntry)reference.context).getClassEntry());
                        if (superclassEntry != null && superclassEntry.equals(calledClassEntry)) continue;
                    }
                    if (!this.isSaneOuterClass(((BehaviorEntry)reference.context).getClassEntry(), classEntry)) continue;
                    callerClasses.add(((BehaviorEntry)reference.context).getClassEntry());
                }
                if (callerClasses.isEmpty()) {
                    if (illegallySetClasses.size() == 1) {
                        return (ClassEntry)illegallySetClasses.iterator().next();
                    }
                    System.out.println(String.format("WARNING: Unable to find outer class for %s. No caller and no illegally set field classes.", classEntry));
                } else {
                    if (callerClasses.size() == 1) {
                        return (ClassEntry)callerClasses.iterator().next();
                    }
                    HashSet intersection = Sets.newHashSet((Iterable)callerClasses);
                    intersection.retainAll(illegallySetClasses);
                    if (intersection.size() == 1) {
                        return (ClassEntry)intersection.iterator().next();
                    }
                    System.out.println(String.format("WARNING: Unable to choose outer class for %s among options: %s", classEntry, callerClasses));
                }
            }
            ++n2;
        }
        return null;
    }

    private boolean isSaneOuterClass(ClassEntry outerClassEntry, ClassEntry innerClassEntry) {
        if (outerClassEntry.equals(innerClassEntry)) {
            return false;
        }
        return this.m_obfClassEntries.contains(outerClassEntry);
    }

    private boolean isIllegalConstructor(Set<String> syntheticFieldTypes, CtConstructor constructor) {
        String className = constructor.getDeclaringClass().getName();
        final ArrayList illegalFieldWrites = Lists.newArrayList();
        final ArrayList constructorCalls = Lists.newArrayList();
        try {
            constructor.instrument(new ExprEditor(){

                public void edit(FieldAccess fieldAccess) {
                    if (fieldAccess.isWriter() && constructorCalls.isEmpty()) {
                        illegalFieldWrites.add(fieldAccess);
                    }
                }

                public void edit(ConstructorCall constructorCall) {
                    constructorCalls.add(constructorCall);
                }
            });
        }
        catch (CannotCompileException ex) {
            throw new Error(ex);
        }
        if (illegalFieldWrites.isEmpty()) {
            return false;
        }
        for (FieldAccess fieldWrite : illegalFieldWrites) {
            boolean isSynthetic;
            if (!fieldWrite.getClassName().equals(className)) {
                System.err.println(String.format("WARNING: illegal write to non-member field %s.%s", fieldWrite.getClassName(), fieldWrite.getFieldName()));
                return false;
            }
            FieldInfo fieldInfo = null;
            for (FieldInfo info : constructor.getDeclaringClass().getClassFile().getFields()) {
                if (!info.getName().equals(fieldWrite.getFieldName()) || !info.getDescriptor().equals(fieldWrite.getSignature())) continue;
                fieldInfo = info;
                break;
            }
            if (fieldInfo == null) {
                return false;
            }
            boolean bl = isSynthetic = (fieldInfo.getAccessFlags() & 0x1000) != 0;
            if (isSynthetic) {
                syntheticFieldTypes.add(fieldInfo.getDescriptor());
                continue;
            }
            System.err.println(String.format("WARNING: illegal write to non synthetic field %s %s.%s", fieldInfo.getDescriptor(), className, fieldInfo.getName()));
            return false;
        }
        return true;
    }

    private BehaviorEntry isAnonymousClass(CtClass c, ClassEntry outerClassEntry) {
        ClassEntry innerClassEntry = new ClassEntry(Descriptor.toJvmName((String)c.getName()));
        if (Modifier.isAbstract(c.getModifiers())) {
            return null;
        }
        if (c.getDeclaredConstructors().length != 1) {
            return null;
        }
        CtConstructor constructor = c.getDeclaredConstructors()[0];
        ConstructorEntry constructorEntry = EntryFactory.getConstructorEntry(constructor);
        Collection<EntryReference<BehaviorEntry, BehaviorEntry>> references = this.getBehaviorReferences(constructorEntry);
        if (references.size() != 1) {
            return null;
        }
        BehaviorEntry caller = (BehaviorEntry)references.iterator().next().context;
        for (FieldEntry fieldEntry : this.getReferencedFields(caller)) {
            if (!fieldEntry.getType().hasClass() || !fieldEntry.getType().getClassEntry().equals(innerClassEntry)) continue;
            return null;
        }
        for (BehaviorEntry behaviorEntry : this.getReferencedBehaviors(caller)) {
            if (!behaviorEntry.getSignature().hasClass(innerClassEntry)) continue;
            return null;
        }
        return caller;
    }

    public Set<ClassEntry> getObfClassEntries() {
        return this.m_obfClassEntries;
    }

    public TranslationIndex getTranslationIndex() {
        return this.m_translationIndex;
    }

    public Access getAccess(Entry entry) {
        return this.m_access.get(entry);
    }

    public ClassInheritanceTreeNode getClassInheritance(Translator deobfuscatingTranslator, ClassEntry obfClassEntry) {
        ArrayList ancestry = Lists.newArrayList();
        ancestry.add(obfClassEntry.getName());
        for (ClassEntry classEntry : this.m_translationIndex.getAncestry(obfClassEntry)) {
            ancestry.add(classEntry.getName());
        }
        ClassInheritanceTreeNode rootNode = new ClassInheritanceTreeNode(deobfuscatingTranslator, (String)ancestry.get(ancestry.size() - 1));
        rootNode.load(this.m_translationIndex, true);
        return rootNode;
    }

    public ClassImplementationsTreeNode getClassImplementations(Translator deobfuscatingTranslator, ClassEntry obfClassEntry) {
        if (this.isInterface(obfClassEntry.getClassName())) {
            ClassImplementationsTreeNode node = new ClassImplementationsTreeNode(deobfuscatingTranslator, obfClassEntry);
            node.load(this);
            return node;
        }
        return null;
    }

    public MethodInheritanceTreeNode getMethodInheritance(Translator deobfuscatingTranslator, MethodEntry obfMethodEntry) {
        ClassEntry baseImplementationClassEntry = obfMethodEntry.getClassEntry();
        for (ClassEntry ancestorClassEntry : this.m_translationIndex.getAncestry(obfMethodEntry.getClassEntry())) {
            MethodEntry ancestorMethodEntry = new MethodEntry(new ClassEntry(ancestorClassEntry), obfMethodEntry.getName(), obfMethodEntry.getSignature());
            if (!this.containsObfBehavior(ancestorMethodEntry)) continue;
            baseImplementationClassEntry = ancestorClassEntry;
        }
        MethodEntry methodEntry = new MethodEntry(baseImplementationClassEntry, obfMethodEntry.getName(), obfMethodEntry.getSignature());
        MethodInheritanceTreeNode rootNode = new MethodInheritanceTreeNode(deobfuscatingTranslator, methodEntry, this.containsObfBehavior(methodEntry));
        rootNode.load(this, true);
        return rootNode;
    }

    public List<MethodImplementationsTreeNode> getMethodImplementations(Translator deobfuscatingTranslator, MethodEntry obfMethodEntry) {
        ArrayList interfaceMethodEntries = Lists.newArrayList();
        if (this.isInterface(obfMethodEntry.getClassName())) {
            interfaceMethodEntries.add(obfMethodEntry);
        } else {
            for (String interfaceName : this.getInterfaces(obfMethodEntry.getClassName())) {
                MethodEntry methodInterface = new MethodEntry(new ClassEntry(interfaceName), obfMethodEntry.getName(), obfMethodEntry.getSignature());
                if (!this.containsObfBehavior(methodInterface)) continue;
                interfaceMethodEntries.add(methodInterface);
            }
        }
        ArrayList nodes = Lists.newArrayList();
        if (!interfaceMethodEntries.isEmpty()) {
            for (MethodEntry interfaceMethodEntry : interfaceMethodEntries) {
                MethodImplementationsTreeNode node = new MethodImplementationsTreeNode(deobfuscatingTranslator, interfaceMethodEntry);
                node.load(this);
                nodes.add(node);
            }
        }
        return nodes;
    }

    public Set<MethodEntry> getRelatedMethodImplementations(MethodEntry obfMethodEntry) {
        HashSet methodEntries = Sets.newHashSet();
        this.getRelatedMethodImplementations((Set<MethodEntry>)methodEntries, this.getMethodInheritance(null, obfMethodEntry));
        return methodEntries;
    }

    private void getRelatedMethodImplementations(Set<MethodEntry> methodEntries, MethodInheritanceTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        if (this.containsObfBehavior(methodEntry)) {
            methodEntries.add(methodEntry);
        }
        for (MethodImplementationsTreeNode implementationsNode : this.getMethodImplementations(null, methodEntry)) {
            this.getRelatedMethodImplementations(methodEntries, implementationsNode);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.getRelatedMethodImplementations(methodEntries, (MethodInheritanceTreeNode)node.getChildAt(i));
            ++i;
        }
    }

    private void getRelatedMethodImplementations(Set<MethodEntry> methodEntries, MethodImplementationsTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        if (this.containsObfBehavior(methodEntry)) {
            methodEntries.add(methodEntry);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.getRelatedMethodImplementations(methodEntries, (MethodImplementationsTreeNode)node.getChildAt(i));
            ++i;
        }
    }

    public Collection<EntryReference<FieldEntry, BehaviorEntry>> getFieldReferences(FieldEntry fieldEntry) {
        return this.m_fieldReferences.get((Object)fieldEntry);
    }

    public Collection<FieldEntry> getReferencedFields(BehaviorEntry behaviorEntry) {
        HashSet fieldEntries = Sets.newHashSet();
        for (EntryReference reference : this.m_fieldReferences.values()) {
            if (reference.context != behaviorEntry) continue;
            fieldEntries.add((FieldEntry)reference.entry);
        }
        return fieldEntries;
    }

    public Collection<EntryReference<BehaviorEntry, BehaviorEntry>> getBehaviorReferences(BehaviorEntry behaviorEntry) {
        return this.m_behaviorReferences.get((Object)behaviorEntry);
    }

    public Collection<BehaviorEntry> getReferencedBehaviors(BehaviorEntry behaviorEntry) {
        HashSet behaviorEntries = Sets.newHashSet();
        for (EntryReference reference : this.m_behaviorReferences.values()) {
            if (reference.context != behaviorEntry) continue;
            behaviorEntries.add((BehaviorEntry)reference.entry);
        }
        return behaviorEntries;
    }

    public Collection<ClassEntry> getInnerClasses(ClassEntry obfOuterClassEntry) {
        return this.m_innerClassesByOuter.get((Object)obfOuterClassEntry);
    }

    public ClassEntry getOuterClass(ClassEntry obfInnerClassEntry) {
        return this.m_outerClassesByInner.get(obfInnerClassEntry);
    }

    public boolean isAnonymousClass(ClassEntry obfInnerClassEntry) {
        return this.m_anonymousClasses.containsKey(obfInnerClassEntry);
    }

    public BehaviorEntry getAnonymousClassCaller(ClassEntry obfInnerClassName) {
        return this.m_anonymousClasses.get(obfInnerClassName);
    }

    public Set<String> getInterfaces(String className) {
        HashSet<String> interfaceNames = new HashSet<String>();
        interfaceNames.addAll(this.m_interfaces.get((Object)className));
        for (ClassEntry ancestor : this.m_translationIndex.getAncestry(new ClassEntry(className))) {
            interfaceNames.addAll(this.m_interfaces.get((Object)ancestor.getName()));
        }
        return interfaceNames;
    }

    public Set<String> getImplementingClasses(String targetInterfaceName) {
        HashSet classNames = Sets.newHashSet();
        for (Map.Entry entry : this.m_interfaces.entries()) {
            String className = (String)entry.getKey();
            String interfaceName = (String)entry.getValue();
            if (!interfaceName.equals(targetInterfaceName)) continue;
            classNames.add(className);
            this.m_translationIndex.getSubclassNamesRecursively(classNames, new ClassEntry(className));
        }
        return classNames;
    }

    public boolean isInterface(String className) {
        return this.m_interfaces.containsValue((Object)className);
    }

    public boolean containsObfClass(ClassEntry obfClassEntry) {
        return this.m_obfClassEntries.contains(obfClassEntry);
    }

    public boolean containsObfField(FieldEntry obfFieldEntry) {
        return this.m_access.containsKey(obfFieldEntry);
    }

    public boolean containsObfBehavior(BehaviorEntry obfBehaviorEntry) {
        return this.m_access.containsKey(obfBehaviorEntry);
    }

    public boolean containsObfArgument(ArgumentEntry obfArgumentEntry) {
        if (!this.containsObfBehavior(obfArgumentEntry.getBehaviorEntry())) {
            return false;
        }
        return obfArgumentEntry.getIndex() < obfArgumentEntry.getBehaviorEntry().getSignature().getArgumentTypes().size();
    }

    public boolean containsObfEntry(Entry obfEntry) {
        if (obfEntry instanceof ClassEntry) {
            return this.containsObfClass((ClassEntry)obfEntry);
        }
        if (obfEntry instanceof FieldEntry) {
            return this.containsObfField((FieldEntry)obfEntry);
        }
        if (obfEntry instanceof BehaviorEntry) {
            return this.containsObfBehavior((BehaviorEntry)obfEntry);
        }
        if (obfEntry instanceof ArgumentEntry) {
            return this.containsObfArgument((ArgumentEntry)obfEntry);
        }
        throw new Error("Entry type not supported: " + obfEntry.getClass().getName());
    }

    public MethodEntry getBridgedMethod(MethodEntry bridgeMethodEntry) {
        return this.m_bridgedMethods.get(bridgeMethodEntry);
    }

    public List<ClassEntry> getObfClassChain(ClassEntry obfClassEntry) {
        ClassEntry obfOuterClassEntry;
        ArrayList obfClassChain = Lists.newArrayList((Object[])new ClassEntry[]{obfClassEntry});
        ClassEntry checkClassEntry = obfClassEntry;
        while ((obfOuterClassEntry = this.getOuterClass(checkClassEntry)) != null) {
            obfClassChain.add(obfOuterClassEntry);
            checkClassEntry = obfOuterClassEntry;
        }
        Collections.reverse(obfClassChain);
        return obfClassChain;
    }
}

