/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.Sets;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.HashSet;
import java.util.jar.JarFile;
import org.junit.Test;

public class TestSourceIndex {
    @Test
    public void indexEverything() throws Exception {
        Deobfuscator deobfuscator = new Deobfuscator(new JarFile("input/1.8.jar"));
        HashSet classEntries = Sets.newHashSet();
        for (ClassEntry obfClassEntry : deobfuscator.getJarIndex().getObfClassEntries()) {
            if (obfClassEntry.isInnerClass()) continue;
            classEntries.add(obfClassEntry);
        }
        for (ClassEntry obfClassEntry : classEntries) {
            try {
                CompilationUnit tree = deobfuscator.getSourceTree(obfClassEntry.getName());
                String source = deobfuscator.getSource(tree);
                deobfuscator.getSourceIndex(tree, source);
            }
            catch (Throwable t) {
                throw new Error("Unable to index " + obfClassEntry, t);
            }
        }
    }
}

