/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.TestEntryFactory;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.Collection;
import java.util.Set;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestJarIndexLoneClass {
    private JarIndex m_index = new JarIndex();

    public TestJarIndexLoneClass() throws Exception {
        this.m_index.indexJar(new JarFile("build/testLoneClass.obf.jar"), false);
    }

    @Test
    public void obfEntries() {
        MatcherAssert.assertThat(this.m_index.getObfClassEntries(), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{TestEntryFactory.newClass("cuchaz/enigma/inputs/Keep"), TestEntryFactory.newClass("none/a")}));
    }

    @Test
    public void translationIndex() {
        MatcherAssert.assertThat((Object)this.m_index.getTranslationIndex().getSuperclass(new ClassEntry("none/a")), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.m_index.getTranslationIndex().getSuperclass(new ClassEntry("cuchaz/enigma/inputs/Keep")), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(this.m_index.getTranslationIndex().getAncestry(new ClassEntry("none/a")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.m_index.getTranslationIndex().getAncestry(new ClassEntry("cuchaz/enigma/inputs/Keep")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.m_index.getTranslationIndex().getSubclass(new ClassEntry("none/a")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.m_index.getTranslationIndex().getSubclass(new ClassEntry("cuchaz/enigma/inputs/Keep")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void access() {
        MatcherAssert.assertThat((Object)((Object)this.m_index.getAccess(TestEntryFactory.newField("none/a", "a", "Ljava/lang/String;"))), (Matcher)Matchers.is((Object)((Object)Access.Private)));
        MatcherAssert.assertThat((Object)((Object)this.m_index.getAccess(TestEntryFactory.newMethod("none/a", "a", "()Ljava/lang/String;"))), (Matcher)Matchers.is((Object)((Object)Access.Public)));
        MatcherAssert.assertThat((Object)((Object)this.m_index.getAccess(TestEntryFactory.newField("none/a", "b", "Ljava/lang/String;"))), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((Object)this.m_index.getAccess(TestEntryFactory.newField("none/a", "a", "LFoo;"))), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void classInheritance() {
        ClassInheritanceTreeNode node = this.m_index.getClassInheritance(new Translator(), TestEntryFactory.newClass("none/a"));
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)node.getObfClassName(), (Matcher)Matchers.is((Object)"none/a"));
        MatcherAssert.assertThat((Object)node.getChildCount(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void methodInheritance() {
        MethodEntry source = TestEntryFactory.newMethod("none/a", "a", "()Ljava/lang/String;");
        MethodInheritanceTreeNode node = this.m_index.getMethodInheritance(new Translator(), source);
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)node.getMethodEntry(), (Matcher)Matchers.is((Object)source));
        MatcherAssert.assertThat((Object)node.getChildCount(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void classImplementations() {
        ClassImplementationsTreeNode node = this.m_index.getClassImplementations(new Translator(), TestEntryFactory.newClass("none/a"));
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void methodImplementations() {
        MethodEntry source = TestEntryFactory.newMethod("none/a", "a", "()Ljava/lang/String;");
        MatcherAssert.assertThat(this.m_index.getMethodImplementations(new Translator(), source), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void relatedMethodImplementations() {
        Set<MethodEntry> entries = this.m_index.getRelatedMethodImplementations(TestEntryFactory.newMethod("none/a", "a", "()Ljava/lang/String;"));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.containsInAnyOrder((Object[])new MethodEntry[]{TestEntryFactory.newMethod("none/a", "a", "()Ljava/lang/String;")}));
    }

    @Test
    public void fieldReferences() {
        FieldEntry source = TestEntryFactory.newField("none/a", "a", "Ljava/lang/String;");
        Collection<EntryReference<FieldEntry, BehaviorEntry>> references = this.m_index.getFieldReferences(source);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newFieldReferenceByConstructor(source, "none/a", "(Ljava/lang/String;)V"), TestEntryFactory.newFieldReferenceByMethod(source, "none/a", "a", "()Ljava/lang/String;")}));
    }

    @Test
    public void behaviorReferences() {
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(TestEntryFactory.newMethod("none/a", "a", "()Ljava/lang/String;")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void innerClasses() {
        MatcherAssert.assertThat(this.m_index.getInnerClasses(TestEntryFactory.newClass("none/a")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void outerClass() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(TestEntryFactory.newClass("a")), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void isAnonymousClass() {
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(TestEntryFactory.newClass("none/a")), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void interfaces() {
        MatcherAssert.assertThat(this.m_index.getInterfaces("none/a"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void implementingClasses() {
        MatcherAssert.assertThat(this.m_index.getImplementingClasses("none/a"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void isInterface() {
        MatcherAssert.assertThat((Object)this.m_index.isInterface("none/a"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void contains() {
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(TestEntryFactory.newClass("none/a")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(TestEntryFactory.newClass("none/b")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfField(TestEntryFactory.newField("none/a", "a", "Ljava/lang/String;")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfField(TestEntryFactory.newField("none/a", "b", "Ljava/lang/String;")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfField(TestEntryFactory.newField("none/a", "a", "LFoo;")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod("none/a", "a", "()Ljava/lang/String;")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod("none/a", "b", "()Ljava/lang/String;")), (Matcher)Matchers.is((Object)false));
    }
}

