/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.java.JavaOutputVisitor;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.InsertParenthesesVisitor;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.RelatedMethodChecker;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsRenamer;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javassist.CtClass;
import javassist.bytecode.Descriptor;

public class Deobfuscator {
    private JarFile m_jar;
    private DecompilerSettings m_settings;
    private JarIndex m_jarIndex;
    private Mappings m_mappings;
    private MappingsRenamer m_renamer;
    private Map<TranslationDirection, Translator> m_translatorCache;

    public Deobfuscator(JarFile jar) throws IOException {
        this.m_jar = jar;
        this.m_jarIndex = new JarIndex();
        this.m_jarIndex.indexJar(this.m_jar, true);
        this.m_settings = DecompilerSettings.javaDefaults();
        this.m_settings.setMergeVariables(true);
        this.m_settings.setForceExplicitImports(true);
        this.m_settings.setForceExplicitTypeArguments(true);
        this.m_translatorCache = Maps.newTreeMap();
        this.setMappings(new Mappings());
    }

    public String getJarName() {
        return this.m_jar.getName();
    }

    public JarIndex getJarIndex() {
        return this.m_jarIndex;
    }

    public Mappings getMappings() {
        return this.m_mappings;
    }

    public void setMappings(Mappings val) {
        if (val == null) {
            val = new Mappings();
        }
        RelatedMethodChecker relatedMethodChecker = new RelatedMethodChecker(this.m_jarIndex);
        for (ClassMapping classMapping : Lists.newArrayList(val.classes())) {
            if (this.checkClassMapping(relatedMethodChecker, classMapping)) continue;
            val.removeClassMapping(classMapping);
        }
        if (relatedMethodChecker.hasProblems()) {
            throw new Error("Related methods are inconsistent! Need to fix the mappings manually.\n" + relatedMethodChecker.getReport());
        }
        this.m_mappings = val;
        this.m_renamer = new MappingsRenamer(this.m_jarIndex, val);
        this.m_translatorCache.clear();
    }

    private boolean checkClassMapping(RelatedMethodChecker relatedMethodChecker, ClassMapping classMapping) {
        ClassEntry classEntry = EntryFactory.getObfClassEntry(this.m_jarIndex, classMapping);
        if (!this.m_jarIndex.getObfClassEntries().contains(classEntry)) {
            return false;
        }
        for (FieldMapping fieldMapping : Lists.newArrayList(classMapping.fields())) {
            FieldEntry fieldEntry = new FieldEntry(classEntry, fieldMapping.getObfName(), fieldMapping.getObfType());
            if (this.m_jarIndex.containsObfField(fieldEntry)) continue;
            System.err.println("WARNING: unable to find field " + fieldEntry + ". dropping mapping.");
            classMapping.removeFieldMapping(fieldMapping);
        }
        for (MethodMapping methodMapping : Lists.newArrayList(classMapping.methods())) {
            BehaviorEntry obfBehaviorEntry = EntryFactory.getObfBehaviorEntry(classEntry, methodMapping);
            if (!this.m_jarIndex.containsObfBehavior(obfBehaviorEntry)) {
                System.err.println("WARNING: unable to find behavior " + obfBehaviorEntry + ". dropping mapping.");
                classMapping.removeMethodMapping(methodMapping);
            }
            relatedMethodChecker.checkMethod(classEntry, methodMapping);
        }
        for (ClassMapping innerClassMapping : Lists.newArrayList(classMapping.innerClasses())) {
            if (this.checkClassMapping(relatedMethodChecker, innerClassMapping)) continue;
            System.err.println("WARNING: unable to find inner class " + EntryFactory.getObfClassEntry(this.m_jarIndex, classMapping) + ". dropping mapping.");
            classMapping.removeInnerClassMapping(innerClassMapping);
        }
        return true;
    }

    public Translator getTranslator(TranslationDirection direction) {
        Translator translator = this.m_translatorCache.get((Object)direction);
        if (translator == null) {
            translator = this.m_mappings.getTranslator(direction, this.m_jarIndex.getTranslationIndex());
            this.m_translatorCache.put(direction, translator);
        }
        return translator;
    }

    public void getSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        for (ClassEntry obfClassEntry : this.m_jarIndex.getObfClassEntries()) {
            if (obfClassEntry.isInnerClass()) continue;
            ClassEntry deobfClassEntry = this.deobfuscateEntry(obfClassEntry);
            if (!deobfClassEntry.equals(obfClassEntry)) {
                deobfClasses.add(deobfClassEntry);
                continue;
            }
            if (!obfClassEntry.getPackageName().equals("none")) {
                deobfClasses.add(obfClassEntry);
                continue;
            }
            obfClasses.add(obfClassEntry);
        }
    }

    public CompilationUnit getSourceTree(String className) {
        String deobfClassName = className;
        ClassMapping classMapping = this.m_mappings.getClassByObf(className);
        if (classMapping != null && classMapping.getDeobfName() != null) {
            deobfClassName = classMapping.getDeobfName();
        }
        TranslatingTypeLoader loader = new TranslatingTypeLoader(this.m_jar, this.m_jarIndex, this.getTranslator(TranslationDirection.Obfuscating), this.getTranslator(TranslationDirection.Deobfuscating));
        this.m_settings.setTypeLoader((ITypeLoader)loader);
        TypeReference type = new MetadataSystem((ITypeLoader)loader).lookupType(deobfClassName);
        if (type == null) {
            throw new Error(String.format("Unable to find type: %s (deobf: %s)\nTried class names: %s", className, deobfClassName, loader.getClassNamesToTry(deobfClassName)));
        }
        TypeDefinition resolvedType = type.resolve();
        DecompilerContext context = new DecompilerContext();
        context.setCurrentType(resolvedType);
        context.setSettings(this.m_settings);
        AstBuilder builder = new AstBuilder(context);
        builder.addType(resolvedType);
        builder.runTransformations(null);
        return builder.getCompilationUnit();
    }

    public SourceIndex getSourceIndex(CompilationUnit sourceTree, String source) {
        SourceIndex index = new SourceIndex(source);
        sourceTree.acceptVisitor((IAstVisitor)new SourceIndexVisitor(), (Object)index);
        for (Token token : index.referenceTokens()) {
            EntryReference<Entry, Entry> deobfReference = index.getDeobfReference(token);
            Object obfEntry = this.obfuscateEntry((Entry)deobfReference.entry);
            ClassEntry resolvedObfClassEntry = this.m_jarIndex.getTranslationIndex().resolveEntryClass((Entry)obfEntry);
            if (resolvedObfClassEntry == null || resolvedObfClassEntry.equals(obfEntry.getClassEntry())) continue;
            obfEntry = obfEntry.cloneToNewClass(resolvedObfClassEntry);
            deobfReference.entry = this.deobfuscateEntry((Entry)obfEntry);
            index.replaceDeobfReference(token, deobfReference);
        }
        return index;
    }

    public String getSource(CompilationUnit sourceTree) {
        StringWriter buf = new StringWriter();
        sourceTree.acceptVisitor((IAstVisitor)new InsertParenthesesVisitor(), null);
        sourceTree.acceptVisitor((IAstVisitor)new JavaOutputVisitor((ITextOutput)new PlainTextOutput((Writer)buf), this.m_settings), null);
        return buf.toString();
    }

    public void writeSources(File dirOut, ProgressListener progress) throws IOException {
        HashSet classEntries = Sets.newHashSet();
        for (ClassEntry obfClassEntry : this.m_jarIndex.getObfClassEntries()) {
            if (obfClassEntry.isInnerClass()) continue;
            classEntries.add(obfClassEntry);
        }
        if (progress != null) {
            progress.init(classEntries.size(), "Decompiling classes...");
        }
        int i = 0;
        for (ClassEntry obfClassEntry : classEntries) {
            ClassEntry deobfClassEntry = this.deobfuscateEntry(new ClassEntry(obfClassEntry));
            if (progress != null) {
                progress.onProgress(i++, deobfClassEntry.toString());
            }
            try {
                String source = this.getSource(this.getSourceTree(obfClassEntry.getName()));
                File file = new File(dirOut, String.valueOf(deobfClassEntry.getName().replace('.', '/')) + ".java");
                file.getParentFile().mkdirs();
                Throwable throwable = null;
                Object var11_14 = null;
                try (FileWriter out = new FileWriter(file);){
                    out.write(source);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                throw new Error("Unable to deobfuscate class " + deobfClassEntry.toString() + " (" + obfClassEntry.toString() + ")", t);
            }
        }
        if (progress != null) {
            progress.onProgress(i, "Done!");
        }
    }

    public void writeJar(File out, ProgressListener progress) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JarOutputStream outJar = new JarOutputStream(new FileOutputStream(out));){
                if (progress != null) {
                    progress.init(JarClassIterator.getClassEntries(this.m_jar).size(), "Translating classes...");
                }
                TranslatingTypeLoader loader = new TranslatingTypeLoader(this.m_jar, this.m_jarIndex, this.getTranslator(TranslationDirection.Obfuscating), this.getTranslator(TranslationDirection.Deobfuscating));
                int i = 0;
                for (CtClass c : JarClassIterator.classes(this.m_jar)) {
                    if (progress != null) {
                        progress.onProgress(i++, c.getName());
                    }
                    try {
                        c = loader.transformClass(c);
                        outJar.putNextEntry(new JarEntry(String.valueOf(c.getName().replace('.', '/')) + ".class"));
                        outJar.write(c.toBytecode());
                        outJar.closeEntry();
                    }
                    catch (Throwable t) {
                        throw new Error("Unable to deobfuscate class " + c.getName(), t);
                    }
                }
                if (progress != null) {
                    progress.onProgress(i, "Done!");
                }
                outJar.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new Error("Unable to write to Jar file!");
        }
    }

    public <T extends Entry> T obfuscateEntry(T deobfEntry) {
        if (deobfEntry == null) {
            return null;
        }
        return this.getTranslator(TranslationDirection.Obfuscating).translateEntry(deobfEntry);
    }

    public <T extends Entry> T deobfuscateEntry(T obfEntry) {
        if (obfEntry == null) {
            return null;
        }
        return this.getTranslator(TranslationDirection.Deobfuscating).translateEntry(obfEntry);
    }

    public <E extends Entry, C extends Entry> EntryReference<E, C> obfuscateReference(EntryReference<E, C> deobfReference) {
        if (deobfReference == null) {
            return null;
        }
        return new EntryReference(this.obfuscateEntry((Entry)deobfReference.entry), this.obfuscateEntry((Entry)deobfReference.context), deobfReference);
    }

    public <E extends Entry, C extends Entry> EntryReference<E, C> deobfuscateReference(EntryReference<E, C> obfReference) {
        if (obfReference == null) {
            return null;
        }
        return new EntryReference(this.deobfuscateEntry((Entry)obfReference.entry), this.deobfuscateEntry((Entry)obfReference.context), obfReference);
    }

    public boolean isObfuscatedIdentifier(Entry obfEntry) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getSignature().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
        }
        return this.m_jarIndex.containsObfEntry(obfEntry);
    }

    public boolean isRenameable(EntryReference<Entry, Entry> obfReference) {
        return obfReference.isNamed() && this.isObfuscatedIdentifier(obfReference.getNameableEntry());
    }

    public boolean hasDeobfuscatedName(Entry obfEntry) {
        Translator translator = this.getTranslator(TranslationDirection.Deobfuscating);
        if (obfEntry instanceof ClassEntry) {
            return translator.translate((ClassEntry)obfEntry) != null;
        }
        if (obfEntry instanceof FieldEntry) {
            return translator.translate((FieldEntry)obfEntry) != null;
        }
        if (obfEntry instanceof MethodEntry) {
            return translator.translate((MethodEntry)obfEntry) != null;
        }
        if (obfEntry instanceof ConstructorEntry) {
            return false;
        }
        if (obfEntry instanceof ArgumentEntry) {
            return translator.translate((ArgumentEntry)obfEntry) != null;
        }
        throw new Error("Unknown entry type: " + obfEntry.getClass().getName());
    }

    public void rename(Entry obfEntry, String newName) {
        if (obfEntry instanceof ClassEntry) {
            this.m_renamer.setClassName((ClassEntry)obfEntry, Descriptor.toJvmName((String)newName));
        } else if (obfEntry instanceof FieldEntry) {
            this.m_renamer.setFieldName((FieldEntry)obfEntry, newName);
        } else if (obfEntry instanceof MethodEntry) {
            this.m_renamer.setMethodTreeName((MethodEntry)obfEntry, newName);
        } else {
            if (obfEntry instanceof ConstructorEntry) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            if (obfEntry instanceof ArgumentEntry) {
                this.m_renamer.setArgumentName((ArgumentEntry)obfEntry, newName);
            } else {
                throw new Error("Unknown entry type: " + obfEntry.getClass().getName());
            }
        }
        this.m_translatorCache.clear();
    }

    public void removeMapping(Entry obfEntry) {
        if (obfEntry instanceof ClassEntry) {
            this.m_renamer.removeClassMapping((ClassEntry)obfEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.m_renamer.removeFieldMapping((FieldEntry)obfEntry);
        } else if (obfEntry instanceof MethodEntry) {
            this.m_renamer.removeMethodTreeMapping((MethodEntry)obfEntry);
        } else {
            if (obfEntry instanceof ConstructorEntry) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            if (obfEntry instanceof ArgumentEntry) {
                this.m_renamer.removeArgumentMapping((ArgumentEntry)obfEntry);
            } else {
                throw new Error("Unknown entry type: " + obfEntry);
            }
        }
        this.m_translatorCache.clear();
    }

    public void markAsDeobfuscated(Entry obfEntry) {
        if (obfEntry instanceof ClassEntry) {
            this.m_renamer.markClassAsDeobfuscated((ClassEntry)obfEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.m_renamer.markFieldAsDeobfuscated((FieldEntry)obfEntry);
        } else if (obfEntry instanceof MethodEntry) {
            this.m_renamer.markMethodTreeAsDeobfuscated((MethodEntry)obfEntry);
        } else {
            if (obfEntry instanceof ConstructorEntry) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            if (obfEntry instanceof ArgumentEntry) {
                this.m_renamer.markArgumentAsDeobfuscated((ArgumentEntry)obfEntry);
            } else {
                throw new Error("Unknown entry type: " + obfEntry);
            }
        }
        this.m_translatorCache.clear();
    }

    public static interface ProgressListener {
        public void init(int var1, String var2);

        public void onProgress(int var1, String var2);
    }
}

