/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Maps;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Type;
import java.util.Map;

public class Translator {
    private TranslationDirection m_direction;
    private Map<String, ClassMapping> m_classes;
    private TranslationIndex m_index;

    public Translator() {
        this.m_direction = null;
        this.m_classes = Maps.newHashMap();
    }

    public Translator(TranslationDirection direction, Map<String, ClassMapping> classes, TranslationIndex index) {
        this.m_direction = direction;
        this.m_classes = classes;
        this.m_index = index;
    }

    public <T extends Entry> T translateEntry(T entry) {
        if (entry instanceof ClassEntry) {
            return (T)this.translateEntry((ClassEntry)entry);
        }
        if (entry instanceof FieldEntry) {
            return (T)this.translateEntry((FieldEntry)entry);
        }
        if (entry instanceof MethodEntry) {
            return (T)this.translateEntry((MethodEntry)entry);
        }
        if (entry instanceof ConstructorEntry) {
            return (T)this.translateEntry((ConstructorEntry)entry);
        }
        if (entry instanceof ArgumentEntry) {
            return (T)this.translateEntry((ArgumentEntry)entry);
        }
        throw new Error("Unknown entry type: " + entry.getClass().getName());
    }

    public String translateClass(String className) {
        return this.translate(new ClassEntry(className));
    }

    public String translate(ClassEntry in) {
        ClassMapping classMapping = this.m_classes.get(in.getOuterClassName());
        if (classMapping != null) {
            if (in.isInnerClass()) {
                String translatedInnerClassName = this.m_direction.choose(classMapping.getDeobfInnerClassName(in.getInnerClassName()), classMapping.getObfInnerClassName(in.getInnerClassName()));
                if (translatedInnerClassName != null) {
                    String translatedOuterClassName = this.m_direction.choose(classMapping.getDeobfName(), classMapping.getObfName());
                    if (translatedOuterClassName != null) {
                        return String.valueOf(translatedOuterClassName) + "$" + translatedInnerClassName;
                    }
                    return String.valueOf(in.getOuterClassName()) + "$" + translatedInnerClassName;
                }
            } else {
                return this.m_direction.choose(classMapping.getDeobfName(), classMapping.getObfName());
            }
        }
        return null;
    }

    public ClassEntry translateEntry(ClassEntry in) {
        String outerClassName;
        String name = this.translate(in);
        if (name != null) {
            return new ClassEntry(name);
        }
        if (in.isInnerClass() && (outerClassName = this.translate(in.getOuterClassEntry())) != null) {
            return new ClassEntry(String.valueOf(outerClassName) + "$" + in.getInnerClassName());
        }
        return in;
    }

    public String translate(FieldEntry in) {
        String translatedName;
        ClassMapping classMapping;
        ClassEntry resolvedClassEntry = this.m_index.resolveEntryClass(in);
        if (resolvedClassEntry != null && (classMapping = this.findClassMapping(resolvedClassEntry)) != null && (translatedName = this.m_direction.choose(classMapping.getDeobfFieldName(in.getName(), in.getType()), classMapping.getObfFieldName(in.getName(), this.translateType(in.getType())))) != null) {
            return translatedName;
        }
        return null;
    }

    public FieldEntry translateEntry(FieldEntry in) {
        String name = this.translate(in);
        if (name == null) {
            name = in.getName();
        }
        return new FieldEntry(this.translateEntry(in.getClassEntry()), name, this.translateType(in.getType()));
    }

    public String translate(MethodEntry in) {
        MethodMapping methodMapping;
        ClassMapping classMapping;
        ClassEntry resolvedClassEntry = this.m_index.resolveEntryClass(in);
        if (resolvedClassEntry != null && (classMapping = this.findClassMapping(resolvedClassEntry)) != null && (methodMapping = this.m_direction.choose(classMapping.getMethodByObf(in.getName(), in.getSignature()), classMapping.getMethodByDeobf(in.getName(), this.translateSignature(in.getSignature())))) != null) {
            return this.m_direction.choose(methodMapping.getDeobfName(), methodMapping.getObfName());
        }
        return null;
    }

    public MethodEntry translateEntry(MethodEntry in) {
        String name = this.translate(in);
        if (name == null) {
            name = in.getName();
        }
        return new MethodEntry(this.translateEntry(in.getClassEntry()), name, this.translateSignature(in.getSignature()));
    }

    public ConstructorEntry translateEntry(ConstructorEntry in) {
        if (in.isStatic()) {
            return new ConstructorEntry(this.translateEntry(in.getClassEntry()));
        }
        return new ConstructorEntry(this.translateEntry(in.getClassEntry()), this.translateSignature(in.getSignature()));
    }

    public BehaviorEntry translateEntry(BehaviorEntry in) {
        if (in instanceof MethodEntry) {
            return this.translateEntry((MethodEntry)in);
        }
        if (in instanceof ConstructorEntry) {
            return this.translateEntry((ConstructorEntry)in);
        }
        throw new Error("Wrong entry type!");
    }

    public String translate(ArgumentEntry in) {
        MethodMapping methodMapping;
        ClassMapping classMapping = this.findClassMapping(in.getClassEntry());
        if (classMapping != null && (methodMapping = this.m_direction.choose(classMapping.getMethodByObf(in.getMethodName(), in.getMethodSignature()), classMapping.getMethodByDeobf(in.getMethodName(), this.translateSignature(in.getMethodSignature())))) != null) {
            return this.m_direction.choose(methodMapping.getDeobfArgumentName(in.getIndex()), methodMapping.getObfArgumentName(in.getIndex()));
        }
        return null;
    }

    public ArgumentEntry translateEntry(ArgumentEntry in) {
        String name = this.translate(in);
        if (name == null) {
            name = in.getName();
        }
        return new ArgumentEntry(this.translateEntry(in.getBehaviorEntry()), in.getIndex(), name);
    }

    public Type translateType(Type type) {
        return new Type(type, new ClassNameReplacer(){

            @Override
            public String replace(String className) {
                return Translator.this.translateClass(className);
            }
        });
    }

    public Signature translateSignature(Signature signature) {
        return new Signature(signature, new ClassNameReplacer(){

            @Override
            public String replace(String className) {
                return Translator.this.translateClass(className);
            }
        });
    }

    private ClassMapping findClassMapping(ClassEntry classEntry) {
        ClassMapping classMapping = this.m_classes.get(classEntry.getOuterClassName());
        if (classMapping != null && classEntry.isInnerClass()) {
            classMapping = this.m_direction.choose(classMapping.getInnerClassByObf(classEntry.getInnerClassName()), classMapping.getInnerClassByDeobfThenObf(classEntry.getInnerClassName()));
        }
        return classMapping;
    }
}

