/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Queues;
import cuchaz.enigma.mapping.ArgumentMapping;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.MappingParseException;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;

public class MappingsReader {
    public Mappings read(Reader in) throws IOException, MappingParseException {
        return this.read(new BufferedReader(in));
    }

    public Mappings read(BufferedReader in) throws IOException, MappingParseException {
        Mappings mappings = new Mappings();
        ArrayDeque mappingStack = Queues.newArrayDeque();
        int lineNumber = 0;
        String line = null;
        while ((line = in.readLine()) != null) {
            ++lineNumber;
            int commentPos = line.indexOf(35);
            if (commentPos >= 0) {
                line = line.substring(0, commentPos);
            }
            if (line.trim().length() <= 0) continue;
            int indent = 0;
            int i = 0;
            while (i < line.length()) {
                if (line.charAt(i) != '\t') break;
                ++indent;
                ++i;
            }
            while (indent < mappingStack.size()) {
                mappingStack.pop();
            }
            String[] parts = line.trim().split("\\s");
            try {
                String token = parts[0];
                if (token.equalsIgnoreCase("CLASS")) {
                    ClassMapping classMapping;
                    if (indent <= 0) {
                        classMapping = this.readClass(parts, false);
                        mappings.addClassMapping(classMapping);
                    } else {
                        if (!(mappingStack.peek() instanceof ClassMapping)) {
                            throw new MappingParseException(lineNumber, "Unexpected CLASS entry here!");
                        }
                        classMapping = this.readClass(parts, true);
                        ((ClassMapping)mappingStack.peek()).addInnerClassMapping(classMapping);
                    }
                    mappingStack.push(classMapping);
                    continue;
                }
                if (token.equalsIgnoreCase("FIELD")) {
                    if (mappingStack.isEmpty() || !(mappingStack.peek() instanceof ClassMapping)) {
                        throw new MappingParseException(lineNumber, "Unexpected FIELD entry here!");
                    }
                    ((ClassMapping)mappingStack.peek()).addFieldMapping(this.readField(parts));
                    continue;
                }
                if (token.equalsIgnoreCase("METHOD")) {
                    if (mappingStack.isEmpty() || !(mappingStack.peek() instanceof ClassMapping)) {
                        throw new MappingParseException(lineNumber, "Unexpected METHOD entry here!");
                    }
                    MethodMapping methodMapping = this.readMethod(parts);
                    ((ClassMapping)mappingStack.peek()).addMethodMapping(methodMapping);
                    mappingStack.push(methodMapping);
                    continue;
                }
                if (!token.equalsIgnoreCase("ARG")) continue;
                if (mappingStack.isEmpty() || !(mappingStack.peek() instanceof MethodMapping)) {
                    throw new MappingParseException(lineNumber, "Unexpected ARG entry here!");
                }
                ((MethodMapping)mappingStack.peek()).addArgumentMapping(this.readArgument(parts));
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                throw new MappingParseException(lineNumber, "Malformed line:\n" + line);
            }
        }
        return mappings;
    }

    private ArgumentMapping readArgument(String[] parts) {
        return new ArgumentMapping(Integer.parseInt(parts[1]), parts[2]);
    }

    private ClassMapping readClass(String[] parts, boolean makeSimple) {
        if (parts.length == 2) {
            return new ClassMapping(parts[1]);
        }
        return new ClassMapping(parts[1], parts[2]);
    }

    protected FieldMapping readField(String[] parts) {
        return new FieldMapping(parts[1], new Type(parts[3]), parts[2]);
    }

    private MethodMapping readMethod(String[] parts) {
        if (parts.length == 3) {
            return new MethodMapping(parts[1], new Signature(parts[2]));
        }
        return new MethodMapping(parts[1], new Signature(parts[3]), parts[2]);
    }
}

