/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

public class ClassMapping
implements Serializable,
Comparable<ClassMapping> {
    private static final long serialVersionUID = -5148491146902340107L;
    private String m_obfName;
    private String m_deobfName;
    private Map<String, ClassMapping> m_innerClassesByObf;
    private Map<String, ClassMapping> m_innerClassesByDeobf;
    private Map<String, FieldMapping> m_fieldsByObf;
    private Map<String, FieldMapping> m_fieldsByDeobf;
    private Map<String, MethodMapping> m_methodsByObf;
    private Map<String, MethodMapping> m_methodsByDeobf;

    public ClassMapping(String obfName) {
        this(obfName, null);
    }

    public ClassMapping(String obfName, String deobfName) {
        this.m_obfName = obfName;
        this.m_deobfName = NameValidator.validateClassName(deobfName, false);
        this.m_innerClassesByObf = Maps.newHashMap();
        this.m_innerClassesByDeobf = Maps.newHashMap();
        this.m_fieldsByObf = Maps.newHashMap();
        this.m_fieldsByDeobf = Maps.newHashMap();
        this.m_methodsByObf = Maps.newHashMap();
        this.m_methodsByDeobf = Maps.newHashMap();
    }

    public String getObfName() {
        return this.m_obfName;
    }

    public String getDeobfName() {
        return this.m_deobfName;
    }

    public void setDeobfName(String val) {
        this.m_deobfName = NameValidator.validateClassName(val, false);
    }

    public Iterable<ClassMapping> innerClasses() {
        assert (this.m_innerClassesByObf.size() >= this.m_innerClassesByDeobf.size());
        return this.m_innerClassesByObf.values();
    }

    public void addInnerClassMapping(ClassMapping classMapping) {
        boolean obfWasAdded;
        assert (ClassMapping.isSimpleClassName(classMapping.getObfName()));
        boolean bl = obfWasAdded = this.m_innerClassesByObf.put(classMapping.getObfName(), classMapping) == null;
        assert (obfWasAdded);
        if (classMapping.getDeobfName() != null) {
            boolean deobfWasAdded;
            assert (ClassMapping.isSimpleClassName(classMapping.getDeobfName()));
            boolean bl2 = deobfWasAdded = this.m_innerClassesByDeobf.put(classMapping.getDeobfName(), classMapping) == null;
            assert (deobfWasAdded);
        }
    }

    public void removeInnerClassMapping(ClassMapping classMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.m_innerClassesByObf.remove(classMapping.getObfName()) != null;
        assert (obfWasRemoved);
        if (classMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.m_innerClassesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (deobfWasRemoved);
        }
    }

    public ClassMapping getOrCreateInnerClass(String obfName) {
        assert (ClassMapping.isSimpleClassName(obfName));
        ClassMapping classMapping = this.m_innerClassesByObf.get(obfName);
        if (classMapping == null) {
            boolean wasAdded;
            classMapping = new ClassMapping(obfName);
            boolean bl = wasAdded = this.m_innerClassesByObf.put(obfName, classMapping) == null;
            assert (wasAdded);
        }
        return classMapping;
    }

    public ClassMapping getInnerClassByObf(String obfName) {
        assert (ClassMapping.isSimpleClassName(obfName));
        return this.m_innerClassesByObf.get(obfName);
    }

    public ClassMapping getInnerClassByDeobf(String deobfName) {
        assert (ClassMapping.isSimpleClassName(deobfName));
        return this.m_innerClassesByDeobf.get(deobfName);
    }

    public ClassMapping getInnerClassByDeobfThenObf(String name) {
        ClassMapping classMapping = this.getInnerClassByDeobf(name);
        if (classMapping == null) {
            classMapping = this.getInnerClassByObf(name);
        }
        return classMapping;
    }

    public String getObfInnerClassName(String deobfName) {
        assert (ClassMapping.isSimpleClassName(deobfName));
        ClassMapping classMapping = this.m_innerClassesByDeobf.get(deobfName);
        if (classMapping != null) {
            return classMapping.getObfName();
        }
        return null;
    }

    public String getDeobfInnerClassName(String obfName) {
        assert (ClassMapping.isSimpleClassName(obfName));
        ClassMapping classMapping = this.m_innerClassesByObf.get(obfName);
        if (classMapping != null) {
            return classMapping.getDeobfName();
        }
        return null;
    }

    public void setInnerClassName(String obfName, String deobfName) {
        assert (ClassMapping.isSimpleClassName(obfName));
        ClassMapping classMapping = this.getOrCreateInnerClass(obfName);
        if (classMapping.getDeobfName() != null) {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.m_innerClassesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (wasRemoved);
        }
        classMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            assert (ClassMapping.isSimpleClassName(deobfName));
            boolean bl = wasAdded = this.m_innerClassesByDeobf.put(deobfName, classMapping) == null;
            assert (wasAdded);
        }
    }

    public Iterable<FieldMapping> fields() {
        assert (this.m_fieldsByObf.size() == this.m_fieldsByDeobf.size());
        return this.m_fieldsByObf.values();
    }

    public boolean containsObfField(String obfName, Type obfType) {
        return this.m_fieldsByObf.containsKey(this.getFieldKey(obfName, obfType));
    }

    public boolean containsDeobfField(String deobfName, Type deobfType) {
        return this.m_fieldsByDeobf.containsKey(this.getFieldKey(deobfName, deobfType));
    }

    public void addFieldMapping(FieldMapping fieldMapping) {
        boolean deobfWasAdded;
        boolean obfWasAdded;
        String obfKey = this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfType());
        if (this.m_fieldsByObf.containsKey(obfKey)) {
            throw new Error("Already have mapping for " + this.m_obfName + "." + obfKey);
        }
        String deobfKey = this.getFieldKey(fieldMapping.getDeobfName(), fieldMapping.getObfType());
        if (this.m_fieldsByDeobf.containsKey(deobfKey)) {
            throw new Error("Already have mapping for " + this.m_deobfName + "." + deobfKey);
        }
        boolean bl = obfWasAdded = this.m_fieldsByObf.put(obfKey, fieldMapping) == null;
        assert (obfWasAdded);
        boolean bl2 = deobfWasAdded = this.m_fieldsByDeobf.put(deobfKey, fieldMapping) == null;
        assert (deobfWasAdded);
        assert (this.m_fieldsByObf.size() == this.m_fieldsByDeobf.size());
    }

    public void removeFieldMapping(FieldMapping fieldMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.m_fieldsByObf.remove(this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfType())) != null;
        assert (obfWasRemoved);
        if (fieldMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.m_fieldsByDeobf.remove(this.getFieldKey(fieldMapping.getDeobfName(), fieldMapping.getObfType())) != null;
            assert (deobfWasRemoved);
        }
    }

    public FieldMapping getFieldByObf(String obfName, Type obfType) {
        return this.m_fieldsByObf.get(this.getFieldKey(obfName, obfType));
    }

    public FieldMapping getFieldByDeobf(String deobfName, Type obfType) {
        return this.m_fieldsByDeobf.get(this.getFieldKey(deobfName, obfType));
    }

    public String getObfFieldName(String deobfName, Type obfType) {
        FieldMapping fieldMapping = this.m_fieldsByDeobf.get(this.getFieldKey(deobfName, obfType));
        if (fieldMapping != null) {
            return fieldMapping.getObfName();
        }
        return null;
    }

    public String getDeobfFieldName(String obfName, Type obfType) {
        FieldMapping fieldMapping = this.m_fieldsByObf.get(this.getFieldKey(obfName, obfType));
        if (fieldMapping != null) {
            return fieldMapping.getDeobfName();
        }
        return null;
    }

    private String getFieldKey(String name, Type type) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null!");
        }
        return String.valueOf(name) + ":" + type;
    }

    public void setFieldName(String obfName, Type obfType, String deobfName) {
        assert (deobfName != null);
        FieldMapping fieldMapping = this.m_fieldsByObf.get(this.getFieldKey(obfName, obfType));
        if (fieldMapping == null) {
            boolean obfWasAdded;
            fieldMapping = new FieldMapping(obfName, obfType, deobfName);
            boolean bl = obfWasAdded = this.m_fieldsByObf.put(this.getFieldKey(obfName, obfType), fieldMapping) == null;
            assert (obfWasAdded);
        } else {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.m_fieldsByDeobf.remove(this.getFieldKey(fieldMapping.getDeobfName(), obfType)) != null;
            assert (wasRemoved);
        }
        fieldMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            boolean bl = wasAdded = this.m_fieldsByDeobf.put(this.getFieldKey(deobfName, obfType), fieldMapping) == null;
            assert (wasAdded);
        }
    }

    public Iterable<MethodMapping> methods() {
        assert (this.m_methodsByObf.size() >= this.m_methodsByDeobf.size());
        return this.m_methodsByObf.values();
    }

    public boolean containsObfMethod(String obfName, Signature obfSignature) {
        return this.m_methodsByObf.containsKey(this.getMethodKey(obfName, obfSignature));
    }

    public boolean containsDeobfMethod(String deobfName, Signature obfSignature) {
        return this.m_methodsByDeobf.containsKey(this.getMethodKey(deobfName, obfSignature));
    }

    public void addMethodMapping(MethodMapping methodMapping) {
        boolean wasAdded;
        String obfKey = this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature());
        if (this.m_methodsByObf.containsKey(obfKey)) {
            throw new Error("Already have mapping for " + this.m_obfName + "." + obfKey);
        }
        boolean bl = wasAdded = this.m_methodsByObf.put(obfKey, methodMapping) == null;
        assert (wasAdded);
        if (methodMapping.getDeobfName() != null) {
            boolean deobfWasAdded;
            String deobfKey = this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfSignature());
            if (this.m_methodsByDeobf.containsKey(deobfKey)) {
                throw new Error("Already have mapping for " + this.m_deobfName + "." + deobfKey);
            }
            boolean bl2 = deobfWasAdded = this.m_methodsByDeobf.put(deobfKey, methodMapping) == null;
            assert (deobfWasAdded);
        }
        assert (this.m_methodsByObf.size() >= this.m_methodsByDeobf.size());
    }

    public void removeMethodMapping(MethodMapping methodMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.m_methodsByObf.remove(this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature())) != null;
        assert (obfWasRemoved);
        if (methodMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.m_methodsByDeobf.remove(this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfSignature())) != null;
            assert (deobfWasRemoved);
        }
    }

    public MethodMapping getMethodByObf(String obfName, Signature obfSignature) {
        return this.m_methodsByObf.get(this.getMethodKey(obfName, obfSignature));
    }

    public MethodMapping getMethodByDeobf(String deobfName, Signature obfSignature) {
        return this.m_methodsByDeobf.get(this.getMethodKey(deobfName, obfSignature));
    }

    private String getMethodKey(String name, Signature signature) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        if (signature == null) {
            throw new IllegalArgumentException("signature cannot be null!");
        }
        return String.valueOf(name) + signature;
    }

    public void setMethodName(String obfName, Signature obfSignature, String deobfName) {
        MethodMapping methodMapping = this.m_methodsByObf.get(this.getMethodKey(obfName, obfSignature));
        if (methodMapping == null) {
            methodMapping = this.createMethodMapping(obfName, obfSignature);
        } else if (methodMapping.getDeobfName() != null) {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.m_methodsByDeobf.remove(this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfSignature())) != null;
            assert (wasRemoved);
        }
        methodMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            boolean bl = wasAdded = this.m_methodsByDeobf.put(this.getMethodKey(deobfName, obfSignature), methodMapping) == null;
            assert (wasAdded);
        }
    }

    public void setArgumentName(String obfMethodName, Signature obfMethodSignature, int argumentIndex, String argumentName) {
        assert (argumentName != null);
        MethodMapping methodMapping = this.m_methodsByObf.get(this.getMethodKey(obfMethodName, obfMethodSignature));
        if (methodMapping == null) {
            methodMapping = this.createMethodMapping(obfMethodName, obfMethodSignature);
        }
        methodMapping.setArgumentName(argumentIndex, argumentName);
    }

    public void removeArgumentName(String obfMethodName, Signature obfMethodSignature, int argumentIndex) {
        this.m_methodsByObf.get(this.getMethodKey(obfMethodName, obfMethodSignature)).removeArgumentName(argumentIndex);
    }

    private MethodMapping createMethodMapping(String obfName, Signature obfSignature) {
        boolean wasAdded;
        MethodMapping methodMapping = new MethodMapping(obfName, obfSignature);
        boolean bl = wasAdded = this.m_methodsByObf.put(this.getMethodKey(obfName, obfSignature), methodMapping) == null;
        assert (wasAdded);
        return methodMapping;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.m_obfName);
        buf.append(" <-> ");
        buf.append(this.m_deobfName);
        buf.append("\n");
        buf.append("Fields:\n");
        for (FieldMapping fieldMapping : this.fields()) {
            buf.append("\t");
            buf.append(fieldMapping.getObfName());
            buf.append(" <-> ");
            buf.append(fieldMapping.getDeobfName());
            buf.append("\n");
        }
        buf.append("Methods:\n");
        for (MethodMapping methodMapping : this.m_methodsByObf.values()) {
            buf.append(methodMapping.toString());
            buf.append("\n");
        }
        buf.append("Inner Classes:\n");
        for (ClassMapping classMapping : this.m_innerClassesByObf.values()) {
            buf.append("\t");
            buf.append(classMapping.getObfName());
            buf.append(" <-> ");
            buf.append(classMapping.getDeobfName());
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(ClassMapping other) {
        if (this.m_obfName.length() != other.m_obfName.length()) {
            return this.m_obfName.length() - other.m_obfName.length();
        }
        return this.m_obfName.compareTo(other.m_obfName);
    }

    public boolean renameObfClass(String oldObfClassName, String newObfClassName) {
        for (ClassMapping innerClassMapping : new ArrayList<ClassMapping>(this.m_innerClassesByObf.values())) {
            boolean wasAdded;
            boolean wasRemoved;
            if (!innerClassMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved = this.m_innerClassesByObf.remove(oldObfClassName) != null;
            assert (wasRemoved);
            boolean bl2 = wasAdded = this.m_innerClassesByObf.put(newObfClassName, innerClassMapping) == null;
            assert (wasAdded);
        }
        for (MethodMapping methodMapping : new ArrayList<MethodMapping>(this.m_methodsByObf.values())) {
            boolean wasAdded;
            boolean wasRemoved;
            String oldMethodKey = this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature());
            if (!methodMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved = this.m_methodsByObf.remove(oldMethodKey) != null;
            assert (wasRemoved);
            boolean bl3 = wasAdded = this.m_methodsByObf.put(this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature()), methodMapping) == null;
            assert (wasAdded);
        }
        if (this.m_obfName.equals(oldObfClassName)) {
            this.m_obfName = newObfClassName;
            return true;
        }
        return false;
    }

    public boolean containsArgument(BehaviorEntry obfBehaviorEntry, String name) {
        MethodMapping methodMapping = this.m_methodsByObf.get(this.getMethodKey(obfBehaviorEntry.getName(), obfBehaviorEntry.getSignature()));
        if (methodMapping != null) {
            return methodMapping.containsArgument(name);
        }
        return false;
    }

    public static boolean isSimpleClassName(String name) {
        return name.indexOf(47) < 0 && name.indexOf(36) < 0;
    }
}

