/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.Entry;
import java.io.Serializable;

public class ClassEntry
implements Entry,
Serializable {
    private static final long serialVersionUID = 4235460580973955811L;
    private String m_name;

    public ClassEntry(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name cannot be null!");
        }
        if (className.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Class name must be in JVM format. ie, path/to/package/class$inner : " + className);
        }
        this.m_name = className;
        if (this.isInnerClass() && this.getInnerClassName().indexOf(47) >= 0) {
            throw new IllegalArgumentException("Inner class must not have a package: " + className);
        }
    }

    public ClassEntry(ClassEntry other) {
        this.m_name = other.m_name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getClassName() {
        return this.m_name;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this;
    }

    @Override
    public ClassEntry cloneToNewClass(ClassEntry classEntry) {
        return classEntry;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ClassEntry) {
            return this.equals((ClassEntry)other);
        }
        return false;
    }

    public boolean equals(ClassEntry other) {
        return this.m_name.equals(other.m_name);
    }

    public String toString() {
        return this.m_name;
    }

    public boolean isInnerClass() {
        return this.m_name.lastIndexOf(36) >= 0;
    }

    public String getOuterClassName() {
        if (this.isInnerClass()) {
            return this.m_name.substring(0, this.m_name.lastIndexOf(36));
        }
        return this.m_name;
    }

    public String getInnerClassName() {
        if (!this.isInnerClass()) {
            throw new Error("This is not an inner class!");
        }
        return this.m_name.substring(this.m_name.lastIndexOf(36) + 1);
    }

    public ClassEntry getOuterClassEntry() {
        return new ClassEntry(this.getOuterClassName());
    }

    public boolean isInDefaultPackage() {
        return this.m_name.indexOf(47) < 0;
    }

    public String getPackageName() {
        int pos = this.m_name.lastIndexOf(47);
        if (pos > 0) {
            return this.m_name.substring(0, pos);
        }
        return null;
    }

    public String getSimpleName() {
        int pos = this.m_name.lastIndexOf(47);
        if (pos > 0) {
            return this.m_name.substring(pos + 1);
        }
        return this.m_name;
    }
}

