/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.Util;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.Signature;
import java.io.Serializable;

public class ArgumentEntry
implements Entry,
Serializable {
    private static final long serialVersionUID = 4472172468162696006L;
    private BehaviorEntry m_behaviorEntry;
    private int m_index;
    private String m_name;

    public ArgumentEntry(BehaviorEntry behaviorEntry, int index, String name) {
        if (behaviorEntry == null) {
            throw new IllegalArgumentException("Behavior cannot be null!");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Index must be non-negative!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name cannot be null!");
        }
        this.m_behaviorEntry = behaviorEntry;
        this.m_index = index;
        this.m_name = name;
    }

    public ArgumentEntry(ArgumentEntry other) {
        this.m_behaviorEntry = (BehaviorEntry)this.m_behaviorEntry.cloneToNewClass(this.getClassEntry());
        this.m_index = other.m_index;
        this.m_name = other.m_name;
    }

    public ArgumentEntry(ArgumentEntry other, String newClassName) {
        this.m_behaviorEntry = (BehaviorEntry)other.m_behaviorEntry.cloneToNewClass(new ClassEntry(newClassName));
        this.m_index = other.m_index;
        this.m_name = other.m_name;
    }

    public BehaviorEntry getBehaviorEntry() {
        return this.m_behaviorEntry;
    }

    public int getIndex() {
        return this.m_index;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this.m_behaviorEntry.getClassEntry();
    }

    @Override
    public String getClassName() {
        return this.m_behaviorEntry.getClassName();
    }

    @Override
    public ArgumentEntry cloneToNewClass(ClassEntry classEntry) {
        return new ArgumentEntry(this, classEntry.getName());
    }

    public String getMethodName() {
        return this.m_behaviorEntry.getName();
    }

    public Signature getMethodSignature() {
        return this.m_behaviorEntry.getSignature();
    }

    public int hashCode() {
        return Util.combineHashesOrdered(this.m_behaviorEntry, Integer.valueOf(this.m_index).hashCode(), this.m_name.hashCode());
    }

    public boolean equals(Object other) {
        if (other instanceof ArgumentEntry) {
            return this.equals((ArgumentEntry)other);
        }
        return false;
    }

    public boolean equals(ArgumentEntry other) {
        return this.m_behaviorEntry.equals(other.m_behaviorEntry) && this.m_index == other.m_index && this.m_name.equals(other.m_name);
    }

    public String toString() {
        return String.valueOf(this.m_behaviorEntry.toString()) + "(" + this.m_index + ":" + this.m_name + ")";
    }
}

