/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.gui.GuiTricks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
implements Deobfuscator.ProgressListener,
AutoCloseable {
    private JFrame m_frame = new JFrame("Enigma - Operation in progress");
    private JLabel m_title;
    private JLabel m_text;
    private JProgressBar m_progress;

    public ProgressDialog(JFrame parent) {
        Container pane = this.m_frame.getContentPane();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        pane.setLayout(layout);
        this.m_title = new JLabel();
        pane.add(this.m_title);
        JPanel panel = new JPanel();
        pane.add(panel);
        panel.setLayout(new BorderLayout());
        this.m_text = GuiTricks.unboldLabel(new JLabel());
        this.m_progress = new JProgressBar();
        this.m_text.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        panel.add((Component)this.m_text, "North");
        panel.add((Component)this.m_progress, "Center");
        panel.setPreferredSize(new Dimension(360, 50));
        pane.doLayout();
        this.m_frame.setSize(400, 120);
        this.m_frame.setResizable(false);
        this.m_frame.setLocationRelativeTo(parent);
        this.m_frame.setVisible(true);
        this.m_frame.setDefaultCloseOperation(0);
    }

    @Override
    public void close() {
        this.m_frame.dispose();
    }

    @Override
    public void init(int totalWork, String title) {
        this.m_title.setText(title);
        this.m_progress.setMinimum(0);
        this.m_progress.setMaximum(totalWork);
        this.m_progress.setValue(0);
    }

    @Override
    public void onProgress(int numDone, String message) {
        this.m_text.setText(message);
        this.m_progress.setValue(numDone);
        this.m_frame.validate();
        this.m_frame.repaint();
    }

    public static void runInThread(final JFrame parent, final ProgressRunnable runnable) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (ProgressDialog progress = new ProgressDialog(parent);){
                        runnable.run(progress);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new Error(ex);
                }
            }
        }.start();
    }

    public static interface ProgressRunnable {
        public void run(Deobfuscator.ProgressListener var1) throws Exception;
    }
}

