/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.gui.ClassSelectorClassNode;
import cuchaz.enigma.gui.ClassSelectorPackageNode;
import cuchaz.enigma.mapping.ClassEntry;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ClassSelector
extends JTree {
    private static final long serialVersionUID = -7632046902384775977L;
    public static Comparator<ClassEntry> ObfuscatedClassEntryComparator = new Comparator<ClassEntry>(){

        @Override
        public int compare(ClassEntry a, ClassEntry b) {
            if (a.getName().length() != b.getName().length()) {
                return a.getName().length() - b.getName().length();
            }
            return a.getName().compareTo(b.getName());
        }
    };
    public static Comparator<ClassEntry> DeobfuscatedClassEntryComparator = new Comparator<ClassEntry>(){

        @Override
        public int compare(ClassEntry a, ClassEntry b) {
            return a.getName().compareTo(b.getName());
        }
    };
    private ClassSelectionListener m_listener;
    private Comparator<ClassEntry> m_comparator;

    public ClassSelector(Comparator<ClassEntry> comparator) {
        this.m_comparator = comparator;
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setModel(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath path;
                if (ClassSelector.this.m_listener != null && event.getClickCount() == 2 && (path = ClassSelector.this.getSelectionPath()) != null && path.getLastPathComponent() instanceof ClassSelectorClassNode) {
                    ClassSelectorClassNode node = (ClassSelectorClassNode)path.getLastPathComponent();
                    ClassSelector.this.m_listener.onSelectClass(node.getClassEntry());
                }
            }
        });
        this.m_listener = null;
    }

    public void setListener(ClassSelectionListener val) {
        this.m_listener = val;
    }

    public void setClasses(Collection<ClassEntry> classEntries) {
        if (classEntries == null) {
            this.setModel(null);
            return;
        }
        HashMap packages = Maps.newHashMap();
        for (ClassEntry classEntry : classEntries) {
            packages.put(classEntry.getPackageName(), null);
        }
        ArrayList sortedPackageNames = Lists.newArrayList(packages.keySet());
        Collections.sort(sortedPackageNames, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                String[] aparts = a.split("/");
                String[] bparts = b.split("/");
                int i = 0;
                while (i < aparts.length) {
                    if (i >= bparts.length) {
                        return 1;
                    }
                    int result = aparts[i].compareTo(bparts[i]);
                    if (result != 0) {
                        return result;
                    }
                    ++i;
                }
                return -1;
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (String packageName : sortedPackageNames) {
            ClassSelectorPackageNode node = new ClassSelectorPackageNode(packageName);
            packages.put(packageName, node);
            root.add(node);
        }
        ArrayListMultimap packagedClassEntries = ArrayListMultimap.create();
        for (ClassEntry classEntry : classEntries) {
            packagedClassEntries.put((Object)classEntry.getPackageName(), (Object)classEntry);
        }
        for (String packageName : packagedClassEntries.keySet()) {
            ArrayList classEntriesInPackage = Lists.newArrayList((Iterable)packagedClassEntries.get((Object)packageName));
            Collections.sort(classEntriesInPackage, this.m_comparator);
            for (ClassEntry classEntry : classEntriesInPackage) {
                ClassSelectorPackageNode node = (ClassSelectorPackageNode)packages.get(packageName);
                node.add(new ClassSelectorClassNode(classEntry));
            }
        }
        this.setModel(new DefaultTreeModel(root));
    }

    public static interface ClassSelectionListener {
        public void onSelectClass(ClassEntry var1);
    }
}

