/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.convert.ClassMatching;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.MappingParseException;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsReader;
import cuchaz.enigma.mapping.MappingsWriter;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javassist.CtBehavior;
import javassist.CtClass;

public class ClassMatcher {
    public static void main(String[] args) throws IOException, MappingParseException {
        JarFile sourceJar = new JarFile(new File("input/1.8-pre3.jar"));
        JarFile destJar = new JarFile(new File("input/1.8.jar"));
        File inMappingsFile = new File("../Enigma Mappings/1.8-pre3.mappings");
        File outMappingsFile = new File("../Enigma Mappings/1.8.mappings");
        HashMap fallbackMatching = Maps.newHashMap();
        fallbackMatching.put("none/ayb", "none/ayf");
        fallbackMatching.put("none/ayd", "none/ayd");
        fallbackMatching.put("none/bgk", "unknown/bgk");
        Mappings mappings = new MappingsReader().read(new FileReader(inMappingsFile));
        ClassMatcher.convertMappings(sourceJar, destJar, mappings, fallbackMatching);
        FileWriter writer = new FileWriter(outMappingsFile);
        new MappingsWriter().write(writer, mappings);
        writer.close();
        System.out.println("Wrote converted mappings to:\n\t" + outMappingsFile.getAbsolutePath());
    }

    private static void convertMappings(JarFile sourceJar, JarFile destJar, Mappings mappings, Map<String, String> fallbackMatching) {
        System.out.println("Indexing source jar...");
        JarIndex sourceIndex = new JarIndex();
        sourceIndex.indexJar(sourceJar, false);
        System.out.println("Indexing dest jar...");
        JarIndex destIndex = new JarIndex();
        destIndex.indexJar(destJar, false);
        TranslatingTypeLoader sourceLoader = new TranslatingTypeLoader(sourceJar, sourceIndex);
        TranslatingTypeLoader destLoader = new TranslatingTypeLoader(destJar, destIndex);
        ClassMatching matching = ClassMatcher.computeMatching(sourceIndex, sourceLoader, destIndex, destLoader);
        Map<String, Map.Entry<ClassIdentity, List<ClassIdentity>>> matchingIndex = matching.getIndex();
        Set<String> usedClassNames = mappings.getAllObfClassNames();
        HashSet allClassNames = Sets.newHashSet();
        for (ClassEntry classEntry : sourceIndex.getObfClassEntries()) {
            allClassNames.add(classEntry.getName());
        }
        usedClassNames.retainAll(allClassNames);
        System.out.println("Used " + usedClassNames.size() + " classes in the mappings");
        for (Map.Entry entry : matchingIndex.values()) {
            ClassIdentity bestMatch;
            ClassIdentity sourceClass = (ClassIdentity)entry.getKey();
            List destClasses = (List)entry.getValue();
            if (destClasses.size() == 1 || !usedClassNames.contains(sourceClass.getClassEntry().getName())) continue;
            System.out.println("No exact match for source class " + sourceClass.getClassEntry());
            ArrayListMultimap scoredMatches = ArrayListMultimap.create();
            Iterator iterator = destClasses.iterator();
            while (iterator.hasNext()) {
                ClassIdentity c = (ClassIdentity)iterator.next();
                scoredMatches.put((Object)sourceClass.getMatchScore(c), (Object)c);
            }
            ArrayList<Integer> scores = new ArrayList<Integer>(scoredMatches.keySet());
            Collections.sort(scores, Collections.reverseOrder());
            ClassMatcher.printScoredMatches(sourceClass.getMaxMatchScore(), scores, (Multimap<Integer, ClassIdentity>)scoredMatches);
            int bestScore = (Integer)scores.get(0);
            Collection bestMatches = scoredMatches.get((Object)bestScore);
            if (bestScore <= 0 || bestMatches.size() != 1 || !(bestMatch = (ClassIdentity)bestMatches.iterator().next()).getClassEntry().equals(sourceClass.getClassEntry())) continue;
            System.out.println("\tAutomatically choosing likely match: " + bestMatch.getClassEntry().getName());
            destClasses.clear();
            destClasses.add((ClassIdentity)bestMatch);
        }
        HashBiMap hashBiMap = HashBiMap.create();
        HashSet unmatchedSourceClassNames = Sets.newHashSet();
        for (String className : usedClassNames) {
            Map.Entry<ClassIdentity, List<ClassIdentity>> entry = matchingIndex.get(className);
            ClassIdentity sourceClass = (ClassIdentity)entry.getKey();
            List matches = (List)entry.getValue();
            if (matches.size() == 1) {
                hashBiMap.put((Object)sourceClass.getClassEntry().getName(), (Object)((ClassIdentity)matches.get(0)).getClassEntry().getName());
                continue;
            }
            String fallbackMatch = fallbackMatching.get(className);
            if (fallbackMatch != null) {
                hashBiMap.put((Object)sourceClass.getClassEntry().getName(), (Object)fallbackMatch);
                continue;
            }
            unmatchedSourceClassNames.add(className);
        }
        if (!unmatchedSourceClassNames.isEmpty()) {
            System.err.println("ERROR: there were unmatched classes!");
            for (String className : unmatchedSourceClassNames) {
                System.err.println("\t" + className);
            }
            return;
        }
        HashMap classChanges = Maps.newHashMap();
        for (Map.Entry entry : hashBiMap.entrySet()) {
            if (((String)entry.getKey()).equals(entry.getValue())) continue;
            classChanges.put((String)entry.getKey(), (String)entry.getValue());
            System.out.println(String.format("Class change: %s -> %s", entry.getKey(), entry.getValue()));
        }
        LinkedHashMap orderedClassChanges = Maps.newLinkedHashMap();
        int numChangesLeft = classChanges.size();
        while (!classChanges.isEmpty()) {
            Iterator iter = classChanges.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (classChanges.get(entry.getValue()) != null) continue;
                orderedClassChanges.put((String)entry.getKey(), (String)entry.getValue());
                iter.remove();
            }
            if (numChangesLeft - classChanges.size() <= 0) break;
            numChangesLeft = classChanges.size();
        }
        if (classChanges.size() > 0) {
            throw new Error(String.format("Unable to sort %d/%d class changes!", classChanges.size(), hashBiMap.size()));
        }
        for (Map.Entry entry : orderedClassChanges.entrySet()) {
            mappings.renameObfClass((String)entry.getKey(), (String)entry.getValue());
        }
        System.out.println("Checking methods...");
        for (ClassMapping classMapping : mappings.classes()) {
            ClassEntry classEntry = new ClassEntry(classMapping.getObfName());
            for (MethodMapping methodMapping : classMapping.methods()) {
                CtBehavior behavior;
                MethodEntry methodEntry;
                if (methodMapping.getObfName().equals("<init>") || destIndex.containsObfBehavior(methodEntry = new MethodEntry(classEntry, methodMapping.getObfName(), methodMapping.getObfSignature()))) continue;
                System.err.println("WARNING: method doesn't match: " + methodEntry);
                System.err.println("\tAvailable dest methods:");
                CtClass c = destLoader.loadClass(classMapping.getObfName());
                CtBehavior[] ctBehaviorArray = c.getDeclaredBehaviors();
                int n = ctBehaviorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    behavior = ctBehaviorArray[n2];
                    System.err.println("\t\t" + EntryFactory.getBehaviorEntry(behavior));
                    ++n2;
                }
                System.err.println("\tAvailable source methods:");
                c = sourceLoader.loadClass((String)hashBiMap.inverse().get((Object)classMapping.getObfName()));
                ctBehaviorArray = c.getDeclaredBehaviors();
                n = ctBehaviorArray.length;
                n2 = 0;
                while (n2 < n) {
                    behavior = ctBehaviorArray[n2];
                    System.err.println("\t\t" + EntryFactory.getBehaviorEntry(behavior));
                    ++n2;
                }
            }
        }
        System.out.println("Done!");
    }

    public static ClassMatching computeMatching(JarIndex sourceIndex, TranslatingTypeLoader sourceLoader, JarIndex destIndex, TranslatingTypeLoader destLoader) {
        System.out.println("Matching classes...");
        ClassMatching matching = null;
        for (boolean useReferences : Arrays.asList(false, true)) {
            int numMatches = 0;
            do {
                ClassIdentity c2;
                ClassNamer.SidedClassNamer sourceNamer = null;
                Object destNamer = null;
                if (matching != null) {
                    ClassNamer namer = new ClassNamer(matching.getUniqueMatches());
                    sourceNamer = namer.getSourceNamer();
                    destNamer = namer.getDestNamer();
                    numMatches = matching.getUniqueMatches().size();
                }
                HashSet sourceClassEntries = Sets.newHashSet();
                HashSet destClassEntries = Sets.newHashSet();
                if (matching == null) {
                    sourceClassEntries.addAll(sourceIndex.getObfClassEntries());
                    destClassEntries.addAll(destIndex.getObfClassEntries());
                    matching = new ClassMatching();
                } else {
                    for (Map.Entry entry : matching.getAmbiguousMatches().entrySet()) {
                        for (ClassIdentity c2 : (List)entry.getKey()) {
                            sourceClassEntries.add(c2.getClassEntry());
                            matching.removeSource(c2);
                        }
                        for (ClassIdentity c2 : (List)entry.getValue()) {
                            destClassEntries.add(c2.getClassEntry());
                            matching.removeDest(c2);
                        }
                    }
                    for (ClassIdentity c3 : matching.getUnmatchedSourceClasses()) {
                        sourceClassEntries.add(c3.getClassEntry());
                        matching.removeSource(c3);
                    }
                    for (ClassIdentity c3 : matching.getUnmatchedDestClasses()) {
                        destClassEntries.add(c3.getClassEntry());
                        matching.removeDest(c3);
                    }
                }
                for (ClassEntry classEntry : sourceClassEntries) {
                    c2 = sourceLoader.loadClass(classEntry.getName());
                    ClassIdentity sourceClass = new ClassIdentity((CtClass)c2, sourceNamer, sourceIndex, useReferences);
                    matching.addSource(sourceClass);
                }
                for (ClassEntry classEntry : destClassEntries) {
                    c2 = destLoader.loadClass(classEntry.getName());
                    ClassIdentity destClass = new ClassIdentity((CtClass)c2, (ClassNamer.SidedClassNamer)destNamer, destIndex, useReferences);
                    matching.matchDestClass(destClass);
                }
                System.out.println(matching);
            } while (matching.getUniqueMatches().size() - numMatches > 0);
        }
        System.out.println("Checking class matches...");
        ClassNamer namer = new ClassNamer(matching.getUniqueMatches());
        ClassNamer.SidedClassNamer sourceNamer = namer.getSourceNamer();
        ClassNamer.SidedClassNamer destNamer = namer.getDestNamer();
        for (Map.Entry entry : matching.getUniqueMatches().entrySet()) {
            ClassIdentity sourceClass = (ClassIdentity)entry.getKey();
            CtClass sourceC = sourceLoader.loadClass(sourceClass.getClassEntry().getName());
            assert (sourceC != null) : "Unable to load source class " + sourceClass.getClassEntry();
            assert (sourceClass.matches(sourceC)) : "Source " + sourceClass + " doesn't match " + new ClassIdentity(sourceC, sourceNamer, sourceIndex, false);
            ClassIdentity destClass = (ClassIdentity)entry.getValue();
            CtClass destC = destLoader.loadClass(destClass.getClassEntry().getName());
            assert (destC != null) : "Unable to load dest class " + destClass.getClassEntry();
            assert (destClass.matches(destC)) : "Dest " + destClass + " doesn't match " + new ClassIdentity(destC, destNamer, destIndex, false);
        }
        ArrayList ambiguousMatches = new ArrayList(matching.getAmbiguousMatches().entrySet());
        Collections.sort(ambiguousMatches, new Comparator<Map.Entry<List<ClassIdentity>, List<ClassIdentity>>>(){

            @Override
            public int compare(Map.Entry<List<ClassIdentity>, List<ClassIdentity>> a, Map.Entry<List<ClassIdentity>, List<ClassIdentity>> b) {
                String aName = a.getKey().get(0).getClassEntry().getName();
                String bName = b.getKey().get(0).getClassEntry().getName();
                return aName.compareTo(bName);
            }
        });
        for (Map.Entry entry : ambiguousMatches) {
            System.out.println("Ambiguous matching:");
            System.out.println("\tSource: " + ClassMatcher.getClassNames((Collection)entry.getKey()));
            System.out.println("\tDest:   " + ClassMatcher.getClassNames((Collection)entry.getValue()));
        }
        return matching;
    }

    private static void printScoredMatches(int maxScore, List<Integer> scores, Multimap<Integer, ClassIdentity> scoredMatches) {
        int numScoredMatchesShown = 0;
        for (int score : scores) {
            for (ClassIdentity scoredMatch : scoredMatches.get((Object)score)) {
                System.out.println(String.format("\tScore: %3d %3.0f%%   %s", score, 100.0 * (double)score / (double)maxScore, scoredMatch.getClassEntry().getName()));
                if (numScoredMatchesShown++ <= 10) continue;
                return;
            }
        }
    }

    private static List<String> getClassNames(Collection<ClassIdentity> classes) {
        ArrayList out = Lists.newArrayList();
        for (ClassIdentity c : classes) {
            out.add(c.getClassEntry().getName());
        }
        Collections.sort(out);
        return out;
    }
}

