/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.Collection;
import javassist.CtClass;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.InnerClassesAttribute;

public class InnerClassWriter {
    private JarIndex m_jarIndex;

    public InnerClassWriter(JarIndex jarIndex) {
        this.m_jarIndex = jarIndex;
    }

    public void write(CtClass c) {
        String obfInnerClassName = new ClassEntry(Descriptor.toJvmName((String)c.getName())).getSimpleName();
        String obfOuterClassName = this.m_jarIndex.getOuterClass(obfInnerClassName);
        if (obfOuterClassName == null) {
            obfOuterClassName = Descriptor.toJvmName((String)c.getName());
        } else {
            ClassEntry obfClassEntry = new ClassEntry(String.valueOf(obfOuterClassName) + "$" + obfInnerClassName);
            c.setName(obfClassEntry.getName());
            BehaviorEntry caller = this.m_jarIndex.getAnonymousClassCaller(obfInnerClassName);
            if (caller != null) {
                if (caller.getName().equals("<clinit>")) {
                    c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(c.getClassFile().getConstPool(), caller.getClassName()));
                } else {
                    c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(c.getClassFile().getConstPool(), caller.getClassName(), caller.getName(), caller.getSignature().toString()));
                }
            }
        }
        Collection<String> obfInnerClassNames = this.m_jarIndex.getInnerClasses(obfOuterClassName);
        if (obfInnerClassNames != null && !obfInnerClassNames.isEmpty()) {
            this.writeInnerClasses(c, obfOuterClassName, obfInnerClassNames);
        }
    }

    private void writeInnerClasses(CtClass c, String obfOuterClassName, Collection<String> obfInnerClassNames) {
        InnerClassesAttribute attr = new InnerClassesAttribute(c.getClassFile().getConstPool());
        c.getClassFile().addAttribute((AttributeInfo)attr);
        for (String obfInnerClassName : obfInnerClassNames) {
            ClassEntry obfClassEntry = new ClassEntry(String.valueOf(obfOuterClassName) + "$" + obfInnerClassName);
            ConstPool constPool = c.getClassFile().getConstPool();
            int innerClassIndex = constPool.addClassInfo(obfClassEntry.getName());
            int outerClassIndex = 0;
            int innerClassSimpleNameIndex = 0;
            int accessFlags = 0;
            if (!this.m_jarIndex.isAnonymousClass(obfInnerClassName)) {
                outerClassIndex = constPool.addClassInfo(obfClassEntry.getOuterClassName());
                innerClassSimpleNameIndex = constPool.addUtf8Info(obfClassEntry.getInnerClassName());
            }
            attr.append(innerClassIndex, outerClassIndex, innerClassSimpleNameIndex, accessFlags);
            c.replaceClassName("none/" + obfInnerClassName, obfClassEntry.getName());
        }
    }
}

