/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import java.util.Iterator;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;

public class CheckCastIterator
implements Iterator<CheckCast> {
    private ConstPool m_constants;
    private CodeAttribute m_attribute;
    private CodeIterator m_iter;
    private CheckCast m_next;

    public CheckCastIterator(CodeAttribute codeAttribute) throws BadBytecode {
        this.m_constants = codeAttribute.getConstPool();
        this.m_attribute = codeAttribute;
        this.m_iter = this.m_attribute.iterator();
        this.m_next = this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public CheckCast next() {
        CheckCast out = this.m_next;
        try {
            this.m_next = this.getNext();
        }
        catch (BadBytecode ex) {
            throw new Error(ex);
        }
        return out;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private CheckCast getNext() throws BadBytecode {
        int prevPos = 0;
        while (this.m_iter.hasNext()) {
            int pos = this.m_iter.next();
            int opcode = this.m_iter.byteAt(pos);
            switch (opcode) {
                case 192: {
                    MethodEntry prevMethodEntry = this.getMethodEntry(prevPos);
                    if (prevMethodEntry == null) break;
                    return new CheckCast(this.m_constants.getClassInfo(this.m_iter.s16bitAt(pos + 1)), prevMethodEntry);
                }
            }
            prevPos = pos;
        }
        return null;
    }

    private MethodEntry getMethodEntry(int pos) {
        switch (this.m_iter.byteAt(pos)) {
            case 182: 
            case 183: 
            case 184: 
            case 186: {
                int index = this.m_iter.s16bitAt(pos + 1);
                return new MethodEntry(new ClassEntry(Descriptor.toJvmName((String)this.m_constants.getMethodrefClassName(index))), this.m_constants.getMethodrefName(index), new Signature(this.m_constants.getMethodrefType(index)));
            }
            case 185: {
                int index = this.m_iter.s16bitAt(pos + 1);
                return new MethodEntry(new ClassEntry(Descriptor.toJvmName((String)this.m_constants.getInterfaceMethodrefClassName(index))), this.m_constants.getInterfaceMethodrefName(index), new Signature(this.m_constants.getInterfaceMethodrefType(index)));
            }
        }
        return null;
    }

    public Iterable<CheckCast> casts() {
        return new Iterable<CheckCast>(){

            @Override
            public Iterator<CheckCast> iterator() {
                return CheckCastIterator.this;
            }
        };
    }

    public static class CheckCast {
        public String className;
        public MethodEntry prevMethodEntry;

        public CheckCast(String className, MethodEntry prevMethodEntry) {
            this.className = className;
            this.prevMethodEntry = prevMethodEntry;
        }
    }
}

