/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.EntryRenamer;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Translator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;

public class TranslationIndex
implements Serializable {
    private static final long serialVersionUID = 738687982126844179L;
    private Map<ClassEntry, ClassEntry> m_superclasses = Maps.newHashMap();
    private Multimap<ClassEntry, FieldEntry> m_fieldEntries;
    private Multimap<ClassEntry, BehaviorEntry> m_behaviorEntries;

    public TranslationIndex() {
        this.m_fieldEntries = HashMultimap.create();
        this.m_behaviorEntries = HashMultimap.create();
    }

    public TranslationIndex(TranslationIndex other, Translator translator) {
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.m_superclasses.entrySet()) {
            this.m_superclasses.put(translator.translateEntry(mapEntry.getKey()), translator.translateEntry(mapEntry.getValue()));
        }
        this.m_fieldEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.m_fieldEntries.entries()) {
            this.m_fieldEntries.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry((FieldEntry)((Object)mapEntry.getValue())));
        }
        this.m_behaviorEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.m_behaviorEntries.entries()) {
            this.m_behaviorEntries.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry((BehaviorEntry)((Object)mapEntry.getValue())));
        }
    }

    public void indexClass(CtClass c) {
        ClassEntry classEntry = EntryFactory.getClassEntry(c);
        ClassEntry superclassEntry = EntryFactory.getSuperclassEntry(c);
        if (!this.isJre(classEntry) && superclassEntry != null && !this.isJre(superclassEntry)) {
            this.m_superclasses.put(classEntry, superclassEntry);
        }
        CtField[] ctFieldArray = c.getDeclaredFields();
        int n = ctFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtField field = ctFieldArray[n2];
            FieldEntry fieldEntry = EntryFactory.getFieldEntry(field);
            this.m_fieldEntries.put((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
            ++n2;
        }
        ctFieldArray = c.getDeclaredBehaviors();
        n = ctFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            CtField behavior = ctFieldArray[n2];
            BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
            this.m_behaviorEntries.put((Object)behaviorEntry.getClassEntry(), (Object)behaviorEntry);
            ++n2;
        }
    }

    public void renameClasses(Map<String, String> renames) {
        EntryRenamer.renameClassesInMap(renames, this.m_superclasses);
        EntryRenamer.renameClassesInMultimap(renames, this.m_fieldEntries);
        EntryRenamer.renameClassesInMultimap(renames, this.m_behaviorEntries);
    }

    public ClassEntry getSuperclass(ClassEntry classEntry) {
        return this.m_superclasses.get(classEntry);
    }

    public List<ClassEntry> getAncestry(ClassEntry classEntry) {
        ArrayList ancestors = Lists.newArrayList();
        while (classEntry != null) {
            if ((classEntry = this.getSuperclass(classEntry)) == null) continue;
            ancestors.add(classEntry);
        }
        return ancestors;
    }

    public List<ClassEntry> getSubclass(ClassEntry classEntry) {
        ArrayList subclasses = Lists.newArrayList();
        for (Map.Entry<ClassEntry, ClassEntry> entry : this.m_superclasses.entrySet()) {
            ClassEntry subclass = entry.getKey();
            ClassEntry superclass = entry.getValue();
            if (!classEntry.equals(superclass)) continue;
            subclasses.add(subclass);
        }
        return subclasses;
    }

    public void getSubclassesRecursively(Set<ClassEntry> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry);
            this.getSubclassesRecursively(out, subclassEntry);
        }
    }

    public void getSubclassNamesRecursively(Set<String> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry.getName());
            this.getSubclassNamesRecursively(out, subclassEntry);
        }
    }

    public boolean entryExists(Entry entry) {
        if (entry instanceof FieldEntry) {
            return this.fieldExists((FieldEntry)entry);
        }
        if (entry instanceof BehaviorEntry) {
            return this.behaviorExists((BehaviorEntry)entry);
        }
        if (entry instanceof ArgumentEntry) {
            return this.behaviorExists(((ArgumentEntry)entry).getBehaviorEntry());
        }
        throw new IllegalArgumentException("Cannot check existence for " + entry.getClass());
    }

    public boolean fieldExists(FieldEntry fieldEntry) {
        return this.m_fieldEntries.containsEntry((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
    }

    public boolean behaviorExists(BehaviorEntry behaviorEntry) {
        return this.m_behaviorEntries.containsEntry((Object)behaviorEntry.getClassEntry(), (Object)behaviorEntry);
    }

    /*
     * Unable to fully structure code
     */
    public ClassEntry resolveEntryClass(Entry entry) {
        if (!(entry instanceof ClassEntry)) ** GOTO lbl7
        return (ClassEntry)entry;
lbl-1000:
        // 1 sources

        {
            superclassEntry = this.getSuperclass(entry.getClassEntry());
            if (superclassEntry == null) {
                return null;
            }
            entry = entry.cloneToNewClass(superclassEntry);
lbl7:
            // 2 sources

            ** while (!this.entryExists((Entry)entry))
        }
lbl8:
        // 1 sources

        return entry.getClassEntry();
    }

    private boolean isJre(ClassEntry classEntry) {
        String packageName = classEntry.getPackageName();
        return packageName != null && (packageName.startsWith("java") || packageName.startsWith("javax"));
    }

    public void write(OutputStream out) throws IOException {
        GZIPOutputStream gzipout = new GZIPOutputStream(out);
        ObjectOutputStream oout = new ObjectOutputStream(gzipout);
        oout.writeObject(this.m_superclasses);
        oout.writeObject(this.m_fieldEntries);
        oout.writeObject(this.m_behaviorEntries);
        gzipout.finish();
    }

    public void read(InputStream in) throws IOException {
        try {
            ObjectInputStream oin = new ObjectInputStream(new GZIPInputStream(in));
            this.m_superclasses = (HashMap)oin.readObject();
            this.m_fieldEntries = (HashMultimap)oin.readObject();
            this.m_behaviorEntries = (HashMultimap)oin.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }
}

