/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class MethodInheritanceTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1096677030991810007L;
    private Translator m_deobfuscatingTranslator;
    private MethodEntry m_entry;
    private boolean m_isImplemented;

    public MethodInheritanceTreeNode(Translator deobfuscatingTranslator, MethodEntry entry, boolean isImplemented) {
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_entry = entry;
        this.m_isImplemented = isImplemented;
    }

    public MethodEntry getMethodEntry() {
        return this.m_entry;
    }

    public String getDeobfClassName() {
        return this.m_deobfuscatingTranslator.translateClass(this.m_entry.getClassName());
    }

    public String getDeobfMethodName() {
        return this.m_deobfuscatingTranslator.translate(this.m_entry);
    }

    public boolean isImplemented() {
        return this.m_isImplemented;
    }

    @Override
    public String toString() {
        String className = this.getDeobfClassName();
        if (className == null) {
            className = this.m_entry.getClassName();
        }
        if (!this.m_isImplemented) {
            return className;
        }
        String methodName = this.getDeobfMethodName();
        if (methodName == null) {
            methodName = this.m_entry.getName();
        }
        return String.valueOf(className) + "." + methodName + "()";
    }

    public void load(JarIndex index, boolean recurse) {
        ArrayList nodes = Lists.newArrayList();
        for (ClassEntry subclassEntry : index.getTranslationIndex().getSubclass(this.m_entry.getClassEntry())) {
            MethodEntry methodEntry = new MethodEntry(subclassEntry, this.m_entry.getName(), this.m_entry.getSignature());
            nodes.add(new MethodInheritanceTreeNode(this.m_deobfuscatingTranslator, methodEntry, index.containsObfBehavior(methodEntry)));
        }
        for (MethodInheritanceTreeNode node : nodes) {
            this.add(node);
        }
        if (recurse) {
            for (MethodInheritanceTreeNode node : nodes) {
                node.load(index, true);
            }
        }
    }

    public static MethodInheritanceTreeNode findNode(MethodInheritanceTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            MethodInheritanceTreeNode foundNode = MethodInheritanceTreeNode.findNode((MethodInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode != null) {
                return foundNode;
            }
            ++i;
        }
        return null;
    }
}

