/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.BehaviorReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Translator;
import javax.swing.tree.DefaultMutableTreeNode;

public class FieldReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<FieldEntry, BehaviorEntry> {
    private static final long serialVersionUID = -7934108091928699835L;
    private Translator m_deobfuscatingTranslator;
    private FieldEntry m_entry;
    private EntryReference<FieldEntry, BehaviorEntry> m_reference;
    private Access m_access;

    public FieldReferenceTreeNode(Translator deobfuscatingTranslator, FieldEntry entry) {
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_entry = entry;
        this.m_reference = null;
    }

    private FieldReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<FieldEntry, BehaviorEntry> reference, Access access) {
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_entry = (FieldEntry)reference.entry;
        this.m_reference = reference;
        this.m_access = access;
    }

    @Override
    public FieldEntry getEntry() {
        return this.m_entry;
    }

    @Override
    public EntryReference<FieldEntry, BehaviorEntry> getReference() {
        return this.m_reference;
    }

    @Override
    public String toString() {
        if (this.m_reference != null) {
            return String.format("%s (%s)", new Object[]{this.m_deobfuscatingTranslator.translateEntry((BehaviorEntry)this.m_reference.context), this.m_access});
        }
        return this.m_deobfuscatingTranslator.translateEntry(this.m_entry).toString();
    }

    public void load(JarIndex index, boolean recurse) {
        if (this.m_reference == null) {
            for (EntryReference<Entry, BehaviorEntry> entryReference : index.getFieldReferences(this.m_entry)) {
                this.add(new FieldReferenceTreeNode(this.m_deobfuscatingTranslator, entryReference, index.getAccess(this.m_entry)));
            }
        } else {
            for (EntryReference<Entry, BehaviorEntry> entryReference : index.getBehaviorReferences((BehaviorEntry)this.m_reference.context)) {
                this.add(new BehaviorReferenceTreeNode(this.m_deobfuscatingTranslator, entryReference, index.getAccess((Entry)this.m_reference.context)));
            }
        }
        if (recurse && this.children != null) {
            for (EntryReference<Entry, BehaviorEntry> entryReference : this.children) {
                if (entryReference instanceof BehaviorReferenceTreeNode) {
                    ((BehaviorReferenceTreeNode)((Object)entryReference)).load(index, true);
                    continue;
                }
                if (!(entryReference instanceof FieldReferenceTreeNode)) continue;
                ((FieldReferenceTreeNode)((Object)entryReference)).load(index, true);
            }
        }
    }
}

